"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.KubernetesManifest = void 0;
const core_1 = require("@aws-cdk/core");
/**
 * Represents a manifest within the Kubernetes system.
 *
 * Alternatively, you can use `cluster.addManifest(resource[, resource, ...])`
 * to define resources on this cluster.
 *
 * Applies/deletes the manifest using `kubectl`.
 */
class KubernetesManifest extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const stack = core_1.Stack.of(this);
        const provider = props.cluster._attachKubectlResourceScope(this);
        new core_1.CustomResource(this, 'Resource', {
            serviceToken: provider.serviceToken,
            resourceType: KubernetesManifest.RESOURCE_TYPE,
            properties: {
                // `toJsonString` enables embedding CDK tokens in the manifest and will
                // render a CloudFormation-compatible JSON string (similar to
                // StepFunctions, CloudWatch Dashboards etc).
                Manifest: stack.toJsonString(props.manifest),
                ClusterName: props.cluster.clusterName,
                RoleArn: props.cluster._kubectlCreationRole.roleArn,
            },
        });
    }
}
exports.KubernetesManifest = KubernetesManifest;
/**
 * The CloudFormation reosurce type.
 */
KubernetesManifest.RESOURCE_TYPE = 'Custom::AWSCDK-EKS-KubernetesResource';
//# sourceMappingURL=data:application/json;base64,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