"""
    Audit Log API

    The Audit Logs API lets you read audit log entries and track API calls or activities in the Bare Metal Cloud Portal.<br> <br> <span class='pnap-api-knowledge-base-link'> Knowledge base articles to help you can be found <a href='https://phoenixnap.com/kb/bmc-server-management-via-api#audit-log-api' target='_blank'>here</a> </span><br> <br> <b>All URLs are relative to (https://api.phoenixnap.com/audit/v1/)</b>   # noqa: E501

    The version of the OpenAPI document: 1.0
    Contact: support@phoenixnap.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from pnap_audit_api.api_client import ApiClient, Endpoint as _Endpoint
from pnap_audit_api.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from pnap_audit_api.model.event import Event


class EventsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.events_get_endpoint = _Endpoint(
            settings={
                'response_type': ([Event],),
                'auth': [
                    'OAuth2'
                ],
                'endpoint_path': '/events',
                'operation_id': 'events_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    '_from',
                    'to',
                    'limit',
                    'order',
                    'username',
                    'verb',
                    'uri',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'order',
                    'verb',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('order',): {

                        "ASC": "ASC",
                        "DESC": "DESC"
                    },
                    ('verb',): {

                        "POST": "POST",
                        "PUT": "PUT",
                        "PATCH": "PATCH",
                        "DELETE": "DELETE"
                    },
                },
                'openapi_types': {
                    '_from':
                        (datetime,),
                    'to':
                        (datetime,),
                    'limit':
                        (int,),
                    'order':
                        (str,),
                    'username':
                        (str,),
                    'verb':
                        (str,),
                    'uri':
                        (str,),
                },
                'attribute_map': {
                    '_from': 'from',
                    'to': 'to',
                    'limit': 'limit',
                    'order': 'order',
                    'username': 'username',
                    'verb': 'verb',
                    'uri': 'uri',
                },
                'location_map': {
                    '_from': 'query',
                    'to': 'query',
                    'limit': 'query',
                    'order': 'query',
                    'username': 'query',
                    'verb': 'query',
                    'uri': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def events_get(
        self,
        **kwargs
    ):
        """List event logs.  # noqa: E501

        Retrieves the event logs for given time period. All date & times are in UTC.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.events_get(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _from (datetime): From the date and time (inclusive) to filter event log records by.. [optional]
            to (datetime): To the date and time (inclusive) to filter event log records by.. [optional]
            limit (int): Limit the number of records returned.. [optional]
            order (str): Ordering of the event's time. SortBy can be introduced later on.. [optional] if omitted the server will use the default value of "ASC"
            username (str): The username that did the actions.. [optional]
            verb (str): The HTTP verb corresponding to the action.. [optional]
            uri (str): The request uri.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [Event]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.events_get_endpoint.call_with_http_info(**kwargs)

