<h1 align="center">lunchable-primelunch</h1>

<div align="center">
    <p float="center">
        <img src=https://upload.wikimedia.org/wikipedia/commons/d/de/Amazon_icon.png
            width="35%" alt="lunchable">
        <img src=https://i.imgur.com/FyKDsG3.png
            width="60%" alt="lunchable">
    </p>
</div>

<p align="center">
LunchMoney Amazon Transaction Updater
</p>

<p align="center">
  <a href="https://github.com/juftin/lunchable-primelunch"><img src="https://img.shields.io/pypi/v/lunchable-primelunch?color=blue&label=lunchable-primelunch" alt="PyPI"></a>
  <a href="https://pypi.python.org/pypi/lunchable-primelunch/"><img src="https://img.shields.io/pypi/pyversions/lunchable-primelunch" alt="PyPI - Python Version"></a>
  <a href="https://juftin.github.io/lunchable-primelunch/"><img src="https://img.shields.io/static/v1?message=docs&color=526CFE&logo=Material+for+MkDocs&logoColor=FFFFFF&label=" alt="docs"></a>
  <a href="https://github.com/pypa/hatch"><img src="https://img.shields.io/badge/%F0%9F%A5%9A-Hatch-4051b5.svg" alt="Hatch project"></a>
  <a href="https://github.com/astral-sh/ruff"><img src="https://img.shields.io/endpoint?url=https://raw.githubusercontent.com/astral-sh/ruff/main/assets/badge/v2.json" alt="Ruff"></a>
  <a href="https://github.com/pre-commit/pre-commit"><img src="https://img.shields.io/badge/pre--commit-enabled-lightgreen?logo=pre-commit" alt="pre-commit"></a>
  <a href="https://github.com/semantic-release/semantic-release"><img src="https://img.shields.io/badge/%20%20%F0%9F%93%A6%F0%9F%9A%80-semantic--release-e10079.svg" alt="semantic-release"></a>
  <a href="https://gitmoji.dev"><img src="https://img.shields.io/badge/gitmoji-%20😜%20😍-FFDD67.svg" alt="Gitmoji"></a>
</p>

---

`PrimeLunch` is a command line tool that supports updating Amazon transaction notes with the items from
Amazon itself. This tool uses CSVs generated by the
[Amazon Order History Reporter](https://chrome.google.com/webstore/detail/amazon-order-history-repo/mgkilgclilajckgnedgjgnfdokkgnibi)
plugin on Chrome. Once you've gathered your transactions, export them as a CSV and scan them with the tool.
You'll be asked which transactions you'd like to update.

<div>
    <img src=https://i.imgur.com/C5IcOQl.png>
</div>

---

The plugin uses the dollar amounts on the CSV export to match Amazon transactions in LunchMoney.
When a matching dollar amount is found, `PrimeLunch` compares the date window between the transactions
to determine if they're really a match.

We're using
the [Amazon Order History Reporter](https://chrome.google.com/webstore/detail/amazon-order-history-repo/mgkilgclilajckgnedgjgnfdokkgnibi)
plugin because it gives us some functionality that Amazon doesn't: exporting Amazon transactions as they're
grouped on actual credit card transactions.

## Run via the Lunchable CLI

You can install lunchable with [pip](https://pypi.org/project/lunchable/) or
[pipx](https://pypa.github.io/pipx/). Make sure to use the
`lunchable[primelunch]` extra to install the `PrimeLunch` plugin.
You can also use the `lunchable[plugins]` extra to install all the
known plugins.

```shell
pipx install "lunchable[primelunch]"
```

```shell
pip install "lunchable[primelunch]"
```

The below command runs the `PrimeLunch` update tool:

```shell
lunchable plugins primelunch -f ~/Downloads/amazon_order_history.csv
```

The below command runs the `PrimeLunch` update tool using a date window of fourteen days
instead of the default seven days (these larger windows are especially useful for finding refunds and recurring
purchases):

```shell
lunchable plugins primelunch \
   --file ~/Downloads/amazon_order_history.csv \
   --window 14
```

Update all transactions without going through the confirmation prompt for each one:

```shell
lunchable plugins primelunch \
   --file ~/Downloads/amazon_order_history.csv \
   --all
```

Provide a LunchMoney API access token manually (`PrimeLunch` defaults to inheriting from the `LUNCHMONEY_ACCESS_TOKEN`
environment variable):

```shell
lunchable plugins primelunch \
   --file ~/Downloads/amazon_order_history.csv \
   --token ABCDEFGHIJKLMNOP
```

## References

This lunchable plugin was inspired by the original Lunchable Amazon importer
at [samwelnella/amazon-transactions-to-lunchmoney](https://github.com/samwelnella/amazon-transactions-to-lunchmoney).
