# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['p1monitor']

package_data = \
{'': ['*']}

install_requires = \
['aiohttp>=3.0.0', 'yarl>=1.6.0']

setup_kwargs = {
    'name': 'p1monitor',
    'version': '0.1.2',
    'description': 'Asynchronous Python client for the P1 Monitor',
    'long_description': '## Python - P1 Monitor API Client\n\n<!-- PROJECT SHIELDS -->\n[![GitHub Release][releases-shield]][releases]\n[![Python Versions][python-versions-shield]][pypi]\n![Project Stage][project-stage-shield]\n![Project Maintenance][maintenance-shield]\n[![License][license-shield]](LICENSE)\n\n[![GitHub Activity][commits-shield]][commits-url]\n[![Forks][forks-shield]][forks-url]\n[![Stargazers][stars-shield]][stars-url]\n[![Issues][issues-shield]][issues-url]\n[![Contributors][contributors-shield]][contributors-url]\n\n[![Code Quality][code-quality-shield]][code-quality]\n[![Maintainability][maintainability-shield]][maintainability-url]\n[![GitHub Last Commit][last-commit-shield]][commits-url]\n\nAsynchronous Python client for the P1 Monitor API.\n\n## About\n\nThere are many ways to read the serial port (P1) of your smart meter and what you do with the data that comes out. With this python library your platform can read [P1 Monitor][p1-monitor] via the API and use the data for example for an integration in [Home Assistant][home-assistant].\n\n## Installation\n\n```bash\npip install p1monitor\n```\n\n## Usage\n\n```python\nimport asyncio\n\nfrom p1monitor import P1Monitor\n\n\nasync def main():\n    """Show example on getting P1 Monitor data."""\n    async with P1Monitor(host="example_host") as client:\n        smartmeter = await client.smartmeter()\n        print(smartmeter)\n\n\nif __name__ == "__main__":\n    loop = asyncio.get_event_loop()\n    loop.run_until_complete(main())\n```\n\n## Data\n\nThere is a lot of data that you can read via the API:\n\n### SmartMeter\n- Gas Consumption\n- Power Consumption / Production\n- Energy Consumption Low/High\n- Energy Production Low/High\n\n### Phases\n- Voltage phases L1/2/3\n- Current Phases L1/2/3\n- Power consumed phases L1/2/3\n- Power Produced phases L1/2/3\n\n### Settings\n- Gas Consumption Tariff\n- Energy Consumption Tariff Low/High\n- Energy Production Tariff Low/High\n\n## Setting up development environment\n\nThis Python project is fully managed using the [Poetry][poetry] dependency\nmanager. But also relies on the use of NodeJS for certain checks during\ndevelopment.\n\nYou need at least:\n\n- Python 3.7+\n- [Poetry][poetry-install]\n\nTo install all packages, including all development requirements:\n\n```bash\npoetry install\n```\n\nAs this repository uses the [pre-commit][pre-commit] framework, all changes\nare linted and tested with each commit. You can run all checks and tests\nmanually, using the following command:\n\n```bash\npoetry run pre-commit run --all-files\n```\n\nTo run just the Python tests:\n\n```bash\npoetry run pytest\n```\n\n## License\n\nMIT License\n\nCopyright (c) 2021 Klaas Schoute\n\nPermission is hereby granted, free of charge, to any person obtaining a copy\nof this software and associated documentation files (the "Software"), to deal\nin the Software without restriction, including without limitation the rights\nto use, copy, modify, merge, publish, distribute, sublicense, and/or sell\ncopies of the Software, and to permit persons to whom the Software is\nfurnished to do so, subject to the following conditions:\n\nThe above copyright notice and this permission notice shall be included in all\ncopies or substantial portions of the Software.\n\nTHE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\nIMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\nFITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\nAUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\nLIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,\nOUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE\nSOFTWARE.\n\n<!-- MARKDOWN LINKS & IMAGES -->\n[code-quality-shield]: https://img.shields.io/lgtm/grade/python/g/klaasnicolaas/python-p1monitor.svg?logo=lgtm&logoWidth=18\n[code-quality]: https://lgtm.com/projects/g/klaasnicolaas/python-p1monitor/context:python\n[contributors-shield]: https://img.shields.io/github/contributors/klaasnicolaas/python-p1monitor.svg\n[contributors-url]: https://github.com/klaasnicolaas/python-p1monitor/graphs/contributors\n[commits-shield]: https://img.shields.io/github/commit-activity/y/klaasnicolaas/python-p1monitor.svg\n[commits-url]: https://github.com/klaasnicolaas/python-p1monitor/commits/master\n[forks-shield]: https://img.shields.io/github/forks/klaasnicolaas/python-p1monitor.svg\n[forks-url]: https://github.com/klaasnicolaas/python-p1monitor/network/members\n[issues-shield]: https://img.shields.io/github/issues/klaasnicolaas/python-p1monitor.svg\n[issues-url]: https://github.com/klaasnicolaas/python-p1monitor/issues\n[license-shield]: https://img.shields.io/github/license/klaasnicolaas/python-p1monitor.svg\n[last-commit-shield]: https://img.shields.io/github/last-commit/klaasnicolaas/python-p1monitor.svg\n[maintenance-shield]: https://img.shields.io/maintenance/yes/2021.svg\n[maintainability-shield]: https://api.codeclimate.com/v1/badges/443c476612a574d82467/maintainability\n[maintainability-url]: https://codeclimate.com/github/klaasnicolaas/python-p1monitor/maintainability\n[project-stage-shield]: https://img.shields.io/badge/project%20stage-experimental-yellow.svg\n[pypi]: https://pypi.org/project/p1monitor/\n[python-versions-shield]: https://img.shields.io/pypi/pyversions/p1monitor\n[releases-shield]: https://img.shields.io/github/release/klaasnicolaas/python-p1monitor.svg\n[releases]: https://github.com/klaasnicolaas/python-p1monitor/releases\n[stars-shield]: https://img.shields.io/github/stars/klaasnicolaas/python-p1monitor.svg\n[stars-url]: https://github.com/klaasnicolaas/python-p1monitor/stargazers\n\n[p1-monitor]: https://www.ztatz.nl/p1-monitor\n[home-assistant]: https://www.home-assistant.io\n[poetry-install]: https://python-poetry.org/docs/#installation\n[poetry]: https://python-poetry.org\n[pre-commit]: https://pre-commit.com\n',
    'author': 'Klaas Schoute',
    'author_email': 'hello@student-techlife.com',
    'maintainer': 'Klaas Schoute',
    'maintainer_email': 'hello@student-techlife.com',
    'url': 'https://github.com/klaasnicolaas/python-p1monitor',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
