Graphene Modeling

[FULL DOCUMENTATION](https://graphenemodeling.readthedocs.io/en/latest/index.html)

This Python package **models the electronic and optical properties of graphene**. The intent is to reproduce results found in the literature so that researchers need not write their own code which wastes time and may contain bugs that alter results. To boost confidence in the code in this repository, every piece of code should be accompanied by a figure that reproduces a result from a published paper.

View the [full documentation](https://graphenemodeling.readthedocs.io/en/latest/index.html).

**Install** the latest version with

```
> pip install graphenemodeling
```

Alternatively, if you are comfortable building from source, first select the latest stable version under `Branch: master -> Tags -> v#.#.#` and download or clone the repository.

**Test** your installation with the command

```
> python -m graphenemodeling
```

You should see the greeting

```
	Welcome to graphenemodeling version #.#.#!

    For a quick overview of this package's capabilities, run
    > python -m graphenemodeling overview

    For issues, contact Gregory Holdman at gholdman@protonmail.com
    or submit an issue or pull request on github.

```
