# Generated by Django 2.2.11 on 2020-03-06 15:46

from django.db import migrations, transaction
from django.db.models.functions import Concat
from django.db.models import CharField, F, Value


def add_extension(apps, schema_editor):
    # re: https://pulp.plan.io/issues/6223
    with transaction.atomic():
        ContentArtifact = apps.get_model('core', 'ContentArtifact')
        CollectionVersion = apps.get_model('ansible', 'CollectionVersion')
        ContentArtifact.objects.exclude(relative_path__endswith='.tar.gz').filter(
                content__in=CollectionVersion.objects.all()
        ).all().update(relative_path=Concat(F('relative_path'), Value('.tar.gz'), output_field=CharField()))


class Migration(migrations.Migration):

    dependencies = [
        ('ansible', '0015_ansiblerepository'),
    ]

    operations = [
        migrations.RunPython(add_extension),
    ]
