"""Test Color class"""
# pylint: disable=C0116,C0115,W0105,C0103
# Generated by CodiumAI
import unittest
from lzma import MODE_FAST

from maxgradient.log import Console
from maxgradient._mode import Mode
from maxgradient.color import Color, ColorParseError

"""
Code Analysis

Main functionalities:
- The Color class represents a color and provides various methods and properties \
    to manipulate and retrieve information about the color.
- It can be initialized with a color value in different formats such as hex, RGB, \
    or color names.
- The class supports conversion between different color formats and provides \
    properties to access the color values in different formats such as hex, \
    RGB, and RGB tuple.
- It also provides methods to lighten or darken the color, calculate contrast \
    with other colors, and generate a color table.

Methods:
- __init__(self, color: Any) - Initializes a Color object with the given color value.
- lighten(self, percent: float=0.5) - Returns a new color that is lightened by the specified percentage.
- darken(self, percent: float=0.5) - Returns a new color that is darkened by the specified percentage.
- get_contrast(self) - Calculates the contrast color (black or white) based on the current color.
- __eq__(self, other: object) - Compares two Color objects for equality.
- __hash__(self) - Returns the hash value of the Color object.
- __rich__(self) - Returns a rich panel representation of the Color object.
- named_table(cls) - Generates a table of named colors.
- color_table(cls) - Generates a table of colors from predefined color groups.

Fields:
- original: str - The original color value passed during initialization.
- red: int - The red component of the color.
- green: int - The green component of the color.
- blue: int - The blue component of the color.
- name: str - The name of the color.
- mode: Mode - The color mode (HEX, RGB, GC, RICH, X11).
- hex: str - The color value in hex format.
- rgb: str - The color value in RGB format.
- rgb_tuple: Tuple[int, int, int] - The color value as an RGB tuple.
- style: Style - The style object representing the color.
- bg_style: Style - The style object representing the background color.
"""
class TestColor(unittest.TestCase):
    # Tests that a Color object can be created with a valid color string
    def test_create_color_valid_string(self):
        color = Color('#FF0000')
        self.assertEqual(color.original, '#FF0000')
        self.assertEqual(color.red, 255)
        self.assertEqual(color.green, 0)
        self.assertEqual(color.blue, 0)
        self.assertEqual(color.name, 'red')
        self.assertEqual(color.mode, Mode.HEX)

    # Tests that the original color value can be accessed
    def test_access_original_color(self):
        color = Color('#FF0000')
        self.assertEqual(color.original, '#FF0000')

    # Tests that the red, green, and blue values can be accessed
    def test_access_red_green_blue_values(self):
        color = Color('#FF0000')
        self.assertEqual(color.red, 255)
        self.assertEqual(color.green, 0)
        self.assertEqual(color.blue, 0)

    # Tests that the color name can be accessed
    def test_access_color_name(self):
        color = Color('#FF0000')
        self.assertEqual(color.name, 'red')

    # Tests that the color mode can be accessed
    def test_access_color_mode(self):
        color = Color('#FF0000')
        self.assertEqual(color.mode, Mode.HEX)

    # Tests that an error is raised when creating a Color object with an invalid color string
    def test_create_color_invalid_string(self):
        with self.assertRaises(ColorParseError):
            color = Color('invalid')

    # Tests that an error is raised when setting the green value to a number greater than 255
    def test_set_green_value_greater_than_255(self):
        color = Color('#FF0000')
        with self.assertRaises(AssertionError):
            color.green = 300

    # Tests that an error is raised when setting the blue value to a negative number
    def test_set_blue_value_negative(self):
        color = Color('#00FF00')
        with self.assertRaises(AssertionError):
            color.blue = -50

    # Tests that an error is raised when setting the blue value to a number greater than 255
    def test_set_blue_value_greater_than_255(self):
        color = Color('#0000FF')
        with self.assertRaises(AssertionError):
            color.blue = 300

    # Tests that the contrast color for a white color can be obtained
    def test_get_contrast_for_white_color(self):
        color = Color('#FFFFFF')
        contrast = color.get_contrast()
        self.assertEqual(contrast, '#000000')
