# MIT License
#
# Copyright (c) 2022 Venera Foundation
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

# TODO(**IMMEDIATE**): Rewrite Lexer.
import rply

lexer = rply.LexerGenerator()

NUMS = '1234567890'
STRINGS = 'abcdefghijklmnopqrstuvwxyz'
STRINGS_ = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'

# hard builtins
lexer.add('PLUS', r'\+')
lexer.add('MINUS', r'-')
lexer.add('IF', r'if')
lexer.add('METHOD', r'::')
lexer.add('OPEN_PAREN', r'\(')
lexer.add('CLOSE_PAREN', '\)')
lexer.add('OPEN_FN', '{')
lexer.add('CLOSE_FN', '}')
lexer.add('DEF_FN', 'def')
lexer.add('STRING_STATEMENT', "'")
lexer.add('STRING_STATEMENT', '"')
lexer.add('IGNORE', '//')
lexer.add('SPACE', ' ')
lexer.add('EQ', '=')
lexer.add('EQEQ', '==')
lexer.add('STARTER', ':')
lexer.add('METRO', 'metro')
lexer.add('INDENT', r'\n')

# soft builtins
lexer.add('PRINT', 'print')

# constants
for num in NUMS:
    lexer.add('INTEGER', num)

for string in STRINGS:
    lexer.add('STRING', string)

for string in STRINGS_:
    lexer.add('STRING', string)

# ignore
lexer.ignore(r'\n')
lexer.ignore(r'\s+')

listed = [
    'STRING',
    'SPACE',
    'IGNORE',
    'EQ',
    'EQEQ',
    'STARTER',
    'METRO',
    'STRING_STATEMENT',
    'DEF_FN',
    'OPEN_FN',
    'CLOSE_FN',
    'METHOD',
    'IF',
    'PLUS',
    'MINUS',
    'PRINT',
    'INTEGER',
    'OPEN_PAREN',
    'CLOSE_PAREN',
    'OPEN_FN',
    'CLOSE_FN',
    'INDENT',
]
