from datetime import datetime, timedelta
from json import dumps
from typing import Any
from uuid import uuid1

class TestEvent(object):

    #region Constructor

    def __init__(self, testName: str) -> TestEvent:
        self.__testName = testName
        self.__notes = {}
        self.__start = None
        self.__end = None
        self.__duration = None

    #endregion

    #region Overloads
    
    def __str__(self) -> str:
        s = dumps(self.__dict__)
        return s
    
    #endregion
    
    #region Properties

    @property
    def TestName(self) -> str:
        return self.__testName

    @property
    def Notes(self) -> {}:
        return self.__notes

    @property
    def Start(self) -> datetime:
        return self.__start

    @property
    def End(self) -> datetime:
        return self.__end

    @property
    def EventDurationSeconds(self) -> float:
        if not self._start or self._end:
            return 0.0
        else:
            if not self.__duration:
                self.__duration = self.__end - self.__start
            return self.__duration.total_seconds()

    #endregion

    #region Class Methods

    def start(self) -> None:
        self.__start = datetime.now()
   
    def end(self) -> None:
        self.__end = datetime.now()

    def add_note(self, key: str, val: Any) -> None:

        if not key:
            raise ValueError("key cannot be None or empty...")

        if key in self.__notes.keys():
            key = "{}-{}".format(key, uuid1())

        self.__notes[key] = val

    #endregion