# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['igel', 'igel.cnn', 'igel.extras', 'igel.servers']

package_data = \
{'': ['*']}

install_requires = \
['Pillow>=8.3.2,<9.0.0',
 'PyYAML==5.3.1',
 'click>=8.0.1,<9.0.0',
 'fastapi>=0.65.2,<0.66.0',
 'joblib>=0.16.0,<0.17.0',
 'pandas==1.1.1',
 'scikit-learn==0.23.2',
 'uvicorn>=0.14.0,<0.15.0']

extras_require = \
{':python_version < "3.8"': ['importlib_metadata>=1.6.0,<2.0.0']}

entry_points = \
{'console_scripts': ['igel = igel.__main__:cli']}

setup_kwargs = {
    'name': 'igel',
    'version': '0.6.0',
    'description': 'a delightful machine learning tool that allows you to train, test and use models without writing code',
    'long_description': '====\nigel\n====\n\n|\n\n.. image:: https://img.shields.io/pypi/v/igel?color=green\n        :alt: PyPI\n        :target: https://pypi.python.org/pypi/igel\n.. image:: https://img.shields.io/github/workflow/status/nidhaloff/igel/build\n        :target: https://github.com/nidhaloff/igel/actions/workflows/build.yml\n        :alt: GitHub Workflow Status\n.. image:: https://pepy.tech/badge/igel\n        :target: https://pepy.tech/project/igel\n.. image:: https://readthedocs.org/projects/igel/badge/?version=latest\n        :target: https://igel.readthedocs.io/en/latest/?badge=latest\n        :alt: Documentation Status\n\n.. image:: https://img.shields.io/pypi/wheel/igel\n        :alt: PyPI - Wheel\n        :target: https://pypi.python.org/pypi/igel\n\n\n.. image:: https://img.shields.io/github/stars/nidhaloff/igel?style=social\n        :alt: GitHub Repo stars\n        :target: https://pypi.python.org/pypi/igel\n\n.. image:: https://img.shields.io/twitter/url?url=https%3A%2F%2Ftwitter.com%2FNidhalBaccouri\n        :alt: Twitter URL\n        :target: https://twitter.com/NidhalBaccouri\n\n|\n\nA delightful machine learning tool that allows you to train/fit, test and use models **without writing code**\n\n.. note::\n    I\'m also working on a GUI desktop app for igel based on people\'s requests. You can find it under\n    `Igel-UI <https://github.com/nidhaloff/igel-ui/>`_. Please consider supporting the project!\n\n* Free software: MIT license\n* Documentation: https://igel.readthedocs.io.\n\n.. contents:: Table of Contents\n    :depth: 3\n\n|\n|\n\nMotivation & Goal\n------------------\n\nThe goal of the project is to provide machine learning for **everyone**, both technical and non-technical\nusers.\n\nI needed a tool sometimes, which I can use to fast create a machine learning prototype. Whether to build\nsome proof of concept or create a fast draft model to prove a point. I find myself often stuck at writing\nboilerplate code and/or thinking too much of how to start this.\n\nTherefore, I decided to create **igel**. Hopefully, it will make it easier for technical and non-technical\nusers to build machine learning models.\n\nFeatures\n---------\n- Usage from GUI\n- Supports most dataset types (csv, txt, excel, json, html)\n- Supports all state of the art machine learning models (even preview models)\n- Supports different data preprocessing methods\n- Provides flexibility and data control while writing configurations\n- Supports cross validation\n- Supports both hyperparameter search (version >= 0.2.8)\n- Supports yaml and json format\n- Supports different sklearn metrics for regression, classification and clustering\n- Supports multi-output/multi-target regression and classification\n- Supports multi-processing for parallel model construction\n\nIntro\n--------\n\nigel is built on top of scikit-learn. It provides a simple way to use machine learning without writing\na **single line of code**.\n\nAll you need is a **yaml** (or **json**) file, where you need to describe what you are trying to do. That\'s it!\n\nIgel supports all sklearn\'s machine learning functionality, whether regression, classification or clustering.\nPrecisely, you can use **63** different machine learning models in igel.\n\nIgel supports most used dataset types in the data science field. For instance, your input dataset can be\na csv, txt, excel sheet, json or even html file that you want to fetch. All these types are supported by igel.\nIn the background, igel uses pandas to read and convert your input dataset to a dataframe.\n\n Unlike other ML tools, igel is lightweight in the sense that it has minimal dependencies.\n Precisely, igel uses pandas in the background for data manipulation/preprocessing and sklearn for the machine\n learning part. Hence, it depends only on these two famous packages.\n\nInstallation\n-------------\n\n- The easiest way is to install igel using `pip <https://packaging.python.org/guides/tool-recommendations/>`_\n\n.. code-block:: console\n\n    $ pip install -U igel\n\n- Check the docs for other ways to install igel from source\n\nRunning with Docker\n--------------------\n\n- Use the official image (recommended):\n\nYou can pull the image first from docker hub\n\n.. code-block:: console\n\n    $ docker pull nidhaloff/igel\n\nThen use it:\n\n.. code-block:: console\n\n    $ docker run -it --rm -v $(pwd):/data nidhaloff/igel fit -yml \'your_file.yaml\' -dp \'your_dataset.csv\'\n\n\n- Alternatively, you can create your own image locally if you want:\n\nYou can run igel inside of docker by first building the image:\n\n.. code-block:: console\n\n    $ docker build -t igel .\n\nAnd then running it and attaching your current directory (does not need to be the igel directory) as /data (the workdir) inside of the container:\n\n.. code-block:: console\n\n    $ docker run -it --rm -v $(pwd):/data igel fit -yml \'your_file.yaml\' -dp \'your_dataset.csv\'\n\nModels\n-------\n\nIgel\'s supported models:\n\n.. code-block:: console\n\n        +--------------------+----------------------------+-------------------------+\n        |      regression    |        classification      |        clustering       |\n        +--------------------+----------------------------+-------------------------+\n        |   LinearRegression |         LogisticRegression |                  KMeans |\n        |              Lasso |                      Ridge |     AffinityPropagation |\n        |          LassoLars |               DecisionTree |                   Birch |\n        | BayesianRegression |                  ExtraTree | AgglomerativeClustering |\n        |    HuberRegression |               RandomForest |    FeatureAgglomeration |\n        |              Ridge |                 ExtraTrees |                  DBSCAN |\n        |  PoissonRegression |                        SVM |         MiniBatchKMeans |\n        |      ARDRegression |                  LinearSVM |    SpectralBiclustering |\n        |  TweedieRegression |                      NuSVM |    SpectralCoclustering |\n        | TheilSenRegression |            NearestNeighbor |      SpectralClustering |\n        |    GammaRegression |              NeuralNetwork |               MeanShift |\n        |   RANSACRegression | PassiveAgressiveClassifier |                  OPTICS |\n        |       DecisionTree |                 Perceptron |                KMedoids |\n        |          ExtraTree |               BernoulliRBM |                    ---- |\n        |       RandomForest |           BoltzmannMachine |                    ---- |\n        |         ExtraTrees |       CalibratedClassifier |                    ---- |\n        |                SVM |                   Adaboost |                    ---- |\n        |          LinearSVM |                    Bagging |                    ---- |\n        |              NuSVM |           GradientBoosting |                    ---- |\n        |    NearestNeighbor |        BernoulliNaiveBayes |                    ---- |\n        |      NeuralNetwork |      CategoricalNaiveBayes |                    ---- |\n        |         ElasticNet |       ComplementNaiveBayes |                    ---- |\n        |       BernoulliRBM |         GaussianNaiveBayes |                    ---- |\n        |   BoltzmannMachine |      MultinomialNaiveBayes |                    ---- |\n        |           Adaboost |                       ---- |                    ---- |\n        |            Bagging |                       ---- |                    ---- |\n        |   GradientBoosting |                       ---- |                    ---- |\n        +--------------------+----------------------------+-------------------------+\n\nQuick Start\n------------\n\n\nRun :code:`igel version` to check the version.\n\nRun :code:`igel info` to get meta data about the project.\n\nYou can run the help command to get instructions:\n\n.. code-block:: console\n\n    $ igel --help\n\n    # or just\n\n    $ igel -h\n    """\n    Take some time and read the output of help command. You ll save time later if you understand how to use igel.\n    """\n\n- Demo:\n\n.. image:: ../assets/igel-help.gif\n\n---------------------------------------------------------------------------------------------------------\n\nConfiguration\n##############\n\nFirst step is to provide a yaml file (you can also use json if you want)\n\nYou can do this manually by creating a .yaml file (called igel.yaml by convention but you can name if whatever you want)\nand editing it yourself.\nHowever, if you are lazy (and you probably are, like me :D), you can use the igel init command to get started fast,\nwhich will create a basic config file for you on the fly.\n\n\n\n\n.. code-block:: console\n\n    """\n    igel init <args>\n    possible optional args are: (notice that these args are optional, so you can also just run igel init if you want)\n    -type: regression, classification or clustering\n    -model: model you want to use\n    -target: target you want to predict\n\n\n    Example:\n    If I want to use neural networks to classify whether someone is sick or not using the indian-diabetes dataset,\n    then I would use this command to initialize a yaml file n.b. you may need to rename outcome column in .csv to sick:\n    $ igel init -type "classification" -model "NeuralNetwork" -target "sick"\n    """\n    $ igel init\n\nAfter running the command, an igel.yaml file will be created for you in the current working directory. You can\ncheck it out and modify it if you want to, otherwise you can also create everything from scratch.\n\n- Demo:\n\n.. image:: ../assets/igel-init.gif\n\n-----------------------------------------------------------------------------------------------------------\n\n.. code-block:: yaml\n\n        # model definition\n        model:\n            # in the type field, you can write the type of problem you want to solve. Whether regression, classification or clustering\n            # Then, provide the algorithm you want to use on the data. Here I\'m using the random forest algorithm\n            type: classification\n            algorithm: RandomForest     # make sure you write the name of the algorithm in pascal case\n            arguments:\n                n_estimators: 100   # here, I set the number of estimators (or trees) to 100\n                max_depth: 30       # set the max_depth of the tree\n\n        # target you want to predict\n        # Here, as an example, I\'m using the famous indians-diabetes dataset, where I want to predict whether someone have diabetes or not.\n        # Depending on your data, you need to provide the target(s) you want to predict here\n        target:\n            - sick\n\nIn the example above, I\'m using random forest to classify whether someone have\ndiabetes or not depending on some features in the dataset\nI used the famous indian diabetes in this example `indian-diabetes dataset <https://www.kaggle.com/uciml/pima-indians-diabetes-database>`_)\n\nNotice that I passed :code:`n_estimators` and :code:`max_depth` as additional arguments to the model.\nIf you don\'t provide arguments then the default will be used.\nYou don\'t have to memorize the arguments for each model. You can always run :code:`igel models` in your terminal, which will\nget you to interactive mode, where you will be prompted to enter the model you want to use and type of the problem\nyou want to solve. Igel will then show you information about the model and a link that you can follow to see\na list of available arguments and how to use these.\n\nTrain a model\n##############\n\n- The expected way to use igel is from terminal (igel CLI):\n\nRun this command in terminal to fit/train a model, where you provide the **path to your dataset** and the **path to the yaml file**\n\n.. code-block:: console\n\n    $ igel fit --data_path \'path_to_your_csv_dataset.csv\' --yaml_path \'path_to_your_yaml_file.yaml\'\n\n    # or shorter\n\n    $ igel fit -dp \'path_to_your_csv_dataset.csv\' -yml \'path_to_your_yaml_file.yaml\'\n\n    """\n    That\'s it. Your "trained" model can be now found in the model_results folder\n    (automatically created for you in your current working directory).\n    Furthermore, a description can be found in the description.json file inside the model_results folder.\n    """\n\n- Demo:\n\n.. image:: ../assets/igel-fit.gif\n\n--------------------------------------------------------------------------------------------------------\n\nEvaluate the model\n###################\n\nYou can then evaluate the trained/pre-fitted model:\n\n.. code-block:: console\n\n    $ igel evaluate -dp \'path_to_your_evaluation_dataset.csv\'\n    """\n    This will automatically generate an evaluation.json file in the current directory, where all evaluation results are stored\n    """\n\n- Demo:\n\n.. image:: ../assets/igel-eval.gif\n\n------------------------------------------------------------------------------------------------------\n\nUse model for prediction\n#########################\n\nFinally, you can use the trained/pre-fitted model to make predictions if you are happy with the evaluation results:\n\n.. code-block:: console\n\n    $ igel predict -dp \'path_to_your_test_dataset.csv\'\n    """\n    This will generate a predictions.csv file in your current directory, where all predictions are stored in a csv file\n    """\n\n- Demo:\n\n.. image:: ../assets/igel-pred.gif\n\n.. image:: ../assets/igel-predict.gif\n\n----------------------------------------------------------------------------------------------------------\n\nStart an Experiment\n####################\n\nYou can combine the train, evaluate and predict phases using one single command called experiment:\n\n.. code-block:: console\n\n    $ igel experiment -DP "path_to_train_data path_to_eval_data path_to_test_data" -yml "path_to_yaml_file"\n\n    """\n    This will run fit using train_data, evaluate using eval_data and further generate predictions using the test_data\n    """\n\n- Demo:\n\n.. image:: ../assets/igel-experiment.gif\n\nUse igel from python (instead of terminal)\n###########################################\n\n- Alternatively, you can also write code if you want to:\n\n..  code-block:: python\n\n    from igel import Igel\n\n    Igel(cmd="fit", data_path="path_to_your_dataset", yaml_path="path_to_your_yaml_file")\n    """\n    check the examples folder for more\n    """\n\n\n----------------------------------------------------------------------------------------------------------\n\nServe the model\n#################\n\nThe next step is to use your model in production. Igel helps you with this task too by providing the serve command.\nRunning the serve command will tell igel to serve your model. Precisely, igel will automatically build\na REST server and serve your model on a specific host and port, which you can configure by passing these as\ncli options.\n\nThe easiest way is to run:\n\n.. code-block:: console\n\n    $ igel serve --model_results_dir "path_to_model_results_directory"\n\nNotice that igel needs the **--model_results_dir** or shortly -res_dir cli option in order to load the model and start the server.\nBy default, igel will serve your model on **localhost:8000**, however, you can easily override this by providing a host\nand a port cli options.\n\n.. code-block:: console\n\n    $ igel serve --model_results_dir "path_to_model_results_directory" --host "127.0.0.1" --port 8000\n\nIgel uses `FastAPI <https://fastapi.tiangolo.com/>`_ for creating the REST server, which is a modern high performance\nframework\nand `uvicorn <https://www.uvicorn.org/>`_ to run it under the hood.\n\n----------------------------------------------------------------------------------------------------------\n\n\nUse igel from python (instead of terminal)\n###########################################\n\n- Alternatively, you can also write code if you want to:\n\n..  code-block:: python\n\n    from igel import Igel\n\n    Igel(cmd="fit", data_path="path_to_your_dataset", yaml_path="path_to_your_yaml_file")\n    """\n    check the examples folder for more\n    """\n\n----------------------------------------------------------------------------------------------------------\n\n\nInteractive Mode\n------------------\n\nInteractive mode is new in >= v0.2.6\n\nThis mode basically offers you the freedom to write arguments on your way.\nYou are not restricted to write the arguments directly when using the command.\n\nThis means practically that you can use the commands (fit, evaluate, predict, experiment etc.)\nwithout specifying any additional arguments. For example:\n\n..  code-block:: python\n\n    igel fit\n\nif you just write this and click enter, you will be prompted to provide the additional mandatory arguments.\nAny version <= 0.2.5 will throw an error in this case, which why you need to make sure that you have\na >= 0.2.6 version.\n\n- Demo (init command):\n\n.. image:: ../assets/igel-init-interactive.gif\n\n- Demo (fit command):\n\n.. image:: ../assets/igel-fit-interactive.gif\n\nAs you can see, you don\'t need to memorize the arguments, you can just let igel ask you to enter them.\nIgel will provide you with a nice message explaining which argument you need to enter.\n\nThe value between brackets represents the default value. This means if you provide no value and hit return,\nthen the value between brackets will be taken as the default value.\n\nOverview\n----------\nThe main goal of igel is to provide you with a way to train/fit, evaluate and use models without writing code.\nInstead, all you need is to provide/describe what you want to do in a simple yaml file.\n\nBasically, you provide description or rather configurations in the yaml file as key value pairs.\nHere is an overview of all supported configurations (for now):\n\n.. code-block:: yaml\n\n    # dataset operations\n    dataset:\n        type: csv  # [str] -> type of your dataset\n        read_data_options: # options you want to supply for reading your data (See the detailed overview about this in the next section)\n            sep:  # [str] -> Delimiter to use.\n            delimiter:  # [str] -> Alias for sep.\n            header:     # [int, list of int] -> Row number(s) to use as the column names, and the start of the data.\n            names:  # [list] -> List of column names to use\n            index_col: # [int, str, list of int, list of str, False] -> Column(s) to use as the row labels of the DataFrame,\n            usecols:    # [list, callable] -> Return a subset of the columns\n            squeeze:    # [bool] -> If the parsed data only contains one column then return a Series.\n            prefix:     # [str] -> Prefix to add to column numbers when no header, e.g. ‘X’ for X0, X1, …\n            mangle_dupe_cols:   # [bool] -> Duplicate columns will be specified as ‘X’, ‘X.1’, …’X.N’, rather than ‘X’…’X’. Passing in False will cause data to be overwritten if there are duplicate names in the columns.\n            dtype:  # [Type name, dict maping column name to type] -> Data type for data or columns\n            engine:     # [str] -> Parser engine to use. The C engine is faster while the python engine is currently more feature-complete.\n            converters: # [dict] -> Dict of functions for converting values in certain columns. Keys can either be integers or column labels.\n            true_values: # [list] -> Values to consider as True.\n            false_values: # [list] -> Values to consider as False.\n            skipinitialspace: # [bool] -> Skip spaces after delimiter.\n            skiprows: # [list-like] -> Line numbers to skip (0-indexed) or number of lines to skip (int) at the start of the file.\n            skipfooter: # [int] -> Number of lines at bottom of file to skip\n            nrows: # [int] -> Number of rows of file to read. Useful for reading pieces of large files.\n            na_values: # [scalar, str, list, dict] ->  Additional strings to recognize as NA/NaN.\n            keep_default_na: # [bool] ->  Whether or not to include the default NaN values when parsing the data.\n            na_filter: # [bool] -> Detect missing value markers (empty strings and the value of na_values). In data without any NAs, passing na_filter=False can improve the performance of reading a large file.\n            verbose: # [bool] -> Indicate number of NA values placed in non-numeric columns.\n            skip_blank_lines: # [bool] -> If True, skip over blank lines rather than interpreting as NaN values.\n            parse_dates: # [bool, list of int, list of str, list of lists, dict] ->  try parsing the dates\n            infer_datetime_format: # [bool] -> If True and parse_dates is enabled, pandas will attempt to infer the format of the datetime strings in the columns, and if it can be inferred, switch to a faster method of parsing them.\n            keep_date_col: # [bool] -> If True and parse_dates specifies combining multiple columns then keep the original columns.\n            dayfirst: # [bool] -> DD/MM format dates, international and European format.\n            cache_dates: # [bool] -> If True, use a cache of unique, converted dates to apply the datetime conversion.\n            thousands: # [str] -> the thousands operator\n            decimal: # [str] -> Character to recognize as decimal point (e.g. use ‘,’ for European data).\n            lineterminator: # [str] -> Character to break file into lines.\n            escapechar: # [str] ->  One-character string used to escape other characters.\n            comment: # [str] -> Indicates remainder of line should not be parsed. If found at the beginning of a line, the line will be ignored altogether. This parameter must be a single character.\n            encoding: # [str] -> Encoding to use for UTF when reading/writing (ex. ‘utf-8’).\n            dialect: # [str, csv.Dialect] -> If provided, this parameter will override values (default or not) for the following parameters: delimiter, doublequote, escapechar, skipinitialspace, quotechar, and quoting\n            delim_whitespace: # [bool] -> Specifies whether or not whitespace (e.g. \' \' or \'    \') will be used as the sep\n            low_memory: # [bool] -> Internally process the file in chunks, resulting in lower memory use while parsing, but possibly mixed type inference.\n            memory_map: # [bool] -> If a filepath is provided for filepath_or_buffer, map the file object directly onto memory and access the data directly from there. Using this option can improve performance because there is no longer any I/O overhead.\n\n        random_numbers: # random numbers options in case you wanted to generate the same random numbers on each run\n            generate_reproducible:  # [bool] -> set this to true to generate reproducible results\n            seed:   # [int] -> the seed number is optional. A seed will be set up for you if you didn\'t provide any\n\n        split:  # split options\n            test_size: 0.2  #[float] -> 0.2 means 20% for the test data, so 80% are automatically for training\n            shuffle: true   # [bool] -> whether to shuffle the data before/while splitting\n            stratify: None  # [list, None] -> If not None, data is split in a stratified fashion, using this as the class labels.\n\n        preprocess: # preprocessing options\n            missing_values: mean    # [str] -> other possible values: [drop, median, most_frequent, constant] check the docs for more\n            encoding:\n                type: oneHotEncoding  # [str] -> other possible values: [labelEncoding]\n            scale:  # scaling options\n                method: standard    # [str] -> standardization will scale values to have a 0 mean and 1 standard deviation  | you can also try minmax\n                target: inputs  # [str] -> scale inputs. | other possible values: [outputs, all] # if you choose all then all values in the dataset will be scaled\n\n\n    # model definition\n    model:\n        type: classification    # [str] -> type of the problem you want to solve. | possible values: [regression, classification, clustering]\n        algorithm: NeuralNetwork    # [str (notice the pascal case)] -> which algorithm you want to use. | type igel algorithms in the Terminal to know more\n        arguments:          # model arguments: you can check the available arguments for each model by running igel help in your terminal\n        use_cv_estimator: false     # [bool] -> if this is true, the CV class of the specific model will be used if it is supported\n        cross_validate:\n            cv: # [int] -> number of kfold (default 5)\n            n_jobs:   # [signed int] -> The number of CPUs to use to do the computation (default None)\n            verbose: # [int] -> The verbosity level. (default 0)\n        hyperparameter_search:\n            method: grid_search   # method you want to use: grid_search and random_search are supported\n            parameter_grid:     # put your parameters grid here that you want to use, an example is provided below\n                param1: [val1, val2]\n                param2: [val1, val2]\n            arguments:  # additional arguments you want to provide for the hyperparameter search\n                cv: 5   # number of folds\n                refit: true   # whether to refit the model after the search\n                return_train_score: false   # whether to return the train score\n                verbose: 0      # verbosity level\n\n    # target you want to predict\n    target:  # list of strings: basically put here the column(s), you want to predict that exist in your csv dataset\n        - put the target you want to predict here\n        - you can assign many target if you are making a multioutput prediction\n\nRead Data Options\n------------------\n\n.. note::\n    igel uses pandas under the hood to read & parse the data. Hence, you can\n    find this data optional parameters also in the pandas official documentation.\n\nA detailed overview of the configurations you can provide in the yaml (or json) file is given below.\nNotice that you will certainly not need all the configuration values for the dataset. They are optional.\nGenerally, igel will figure out how to read your dataset.\n\nHowever, you can help it by providing extra fields using this read_data_options section.\nFor example, one of the helpful values in my opinion is the "sep", which defines how your columns\nin the csv dataset are separated. Generally, csv datasets are separated by commas, which is also the default value\nhere. However, it may be separated by a semicolon in your case.\n\nHence, you can provide this in the read_data_options. Just add the :code:`sep: ";"` under read_data_options.\n\n\n\n.. list-table:: Supported Read Data Options\n   :widths: 25 25 50\n   :header-rows: 1\n\n   * - Parameter\n     - Type\n     - Explanation\n   * - sep\n     - str, default ‘,’\n     - Delimiter to use. If sep is None, the C engine cannot automatically detect the separator, but the Python parsing engine can, meaning the latter will be used and automatically detect the separator by Python’s builtin sniffer tool, csv.Sniffer. In addition, separators longer than 1 character and different from \'\\s+\' will be interpreted as regular expressions and will also force the use of the Python parsing engine. Note that regex delimiters are prone to ignoring quoted data. Regex example: \'\\r\\t\'.\n   * - delimiter\n     - default None\n     - Alias for sep.\n   * - header\n     - int, list of int, default ‘infer’\n     - Row number(s) to use as the column names, and the start of the data. Default behavior is to infer the column names: if no names are passed the behavior is identical to header=0 and column names are inferred from the first line of the file, if column names are passed explicitly then the behavior is identical to header=None. Explicitly pass header=0 to be able to replace existing names. The header can be a list of integers that specify row locations for a multi-index on the columns e.g. [0,1,3]. Intervening rows that are not specified will be skipped (e.g. 2 in this example is skipped). Note that this parameter ignores commented lines and empty lines if skip_blank_lines=True, so header=0 denotes the first line of data rather than the first line of the file.\n   * - names\n     - array-like, optional\n     - List of column names to use. If the file contains a header row, then you should explicitly pass header=0 to override the column names. Duplicates in this list are not allowed.\n   * - index_col\n     - int, str, sequence of int / str, or False, default None\n     - Column(s) to use as the row labels of the DataFrame, either given as string name or column index. If a sequence of int / str is given, a MultiIndex is used. Note: index_col=False can be used to force pandas to not use the first column as the index, e.g. when you have a malformed file with delimiters at the end of each line.\n   * - usecols\n     - list-like or callable, optional\n     - Return a subset of the columns. If list-like, all elements must either be positional (i.e. integer indices into the document columns) or strings that correspond to column names provided either by the user in names or inferred from the document header row(s). For example, a valid list-like usecols parameter would be [0, 1, 2] or [\'foo\', \'bar\', \'baz\']. Element order is ignored, so usecols=[0, 1] is the same as [1, 0]. To instantiate a DataFrame from data with element order preserved use pd.read_csv(data, usecols=[\'foo\', \'bar\'])[[\'foo\', \'bar\']] for columns in [\'foo\', \'bar\'] order or pd.read_csv(data, usecols=[\'foo\', \'bar\'])[[\'bar\', \'foo\']] for [\'bar\', \'foo\'] order. If callable, the callable function will be evaluated against the column names, returning names where the callable function evaluates to True. An example of a valid callable argument would be lambda x: x.upper() in [\'AAA\', \'BBB\', \'DDD\']. Using this parameter results in much faster parsing time and lower memory usage.\n   * - squeeze\n     - bool, default False\n     - If the parsed data only contains one column then return a Series.\n\n   * - prefix\n     - str, optional\n     - Prefix to add to column numbers when no header, e.g. ‘X’ for X0, X1, …\n   * - mangle_dupe_cols\n     - bool, default True\n     - Duplicate columns will be specified as ‘X’, ‘X.1’, …’X.N’, rather than ‘X’…’X’. Passing in False will cause data to be overwritten if there are duplicate names in the columns.\n   * - dtype\n     - {‘c’, ‘python’}, optional\n     - Parser engine to use. The C engine is faster while the python engine is currently more feature-complete.\n   * - converters\n     - dict, optional\n     - Dict of functions for converting values in certain columns. Keys can either be integers or column labels.\n   * - true_values\n     - list, optional\n     - Values to consider as True.\n\n   * - false_values\n     - list, optional\n     - Values to consider as False.\n   * - skipinitialspace\n     - bool, default False\n     - Skip spaces after delimiter.\n   * - skiprows\n     - list-like, int or callable, optional\n     - Line numbers to skip (0-indexed) or number of lines to skip (int) at the start of the file. If callable, the callable function will be evaluated against the row indices, returning True if the row should be skipped and False otherwise. An example of a valid callable argument would be lambda x: x in [0, 2].\n   * - skipfooter\n     - int, default 0\n     - Number of lines at bottom of file to skip (Unsupported with engine=’c’).\n   * - nrows\n     - int, optional\n     - Number of rows of file to read. Useful for reading pieces of large files.\n   * - na_values\n     - scalar, str, list-like, or dict, optional\n     - Additional strings to recognize as NA/NaN. If dict passed, specific per-column NA values. By default the following values are interpreted as NaN: ‘’, ‘#N/A’, ‘#N/A N/A’, ‘#NA’, ‘-1.#IND’, ‘-1.#QNAN’, ‘-NaN’, ‘-nan’, ‘1.#IND’, ‘1.#QNAN’, ‘<NA>’, ‘N/A’, ‘NA’, ‘NULL’, ‘NaN’, ‘n/a’, ‘nan’, ‘null’.\n   * - keep_default_na\n     - bool, default True\n     - Whether or not to include the default NaN values when parsing the data. Depending on whether na_values is passed in, the behavior is as follows: If keep_default_na is True, and na_values are specified, na_values is appended to the default NaN values used for parsing. If keep_default_na is True, and na_values are not specified, only the default NaN values are used for parsing. If keep_default_na is False, and na_values are specified, only the NaN values specified na_values are used for parsing. If keep_default_na is False, and na_values are not specified, no strings will be parsed as NaN. Note that if na_filter is passed in as False, the keep_default_na and na_values parameters will be ignored.\n   * - na_filter\n     - bool, default True\n     - Detect missing value markers (empty strings and the value of na_values). In data without any NAs, passing na_filter=False can improve the performance of reading a large file.\n   * - verbose\n     - bool, default False\n     - Indicate number of NA values placed in non-numeric columns.\n   * - skip_blank_lines\n     - bool, default True\n     - If True, skip over blank lines rather than interpreting as NaN values.\n   * - parse_dates\n     - bool or list of int or names or list of lists or dict, default False\n     - The behavior is as follows: boolean. If True -> try parsing the index. list of int or names. e.g. If [1, 2, 3] -> try parsing columns 1, 2, 3 each as a separate date column. list of lists. e.g. If [[1, 3]] -> combine columns 1 and 3 and parse as a single date column. dict, e.g. {‘foo’ : [1, 3]} -> parse columns 1, 3 as date and call result ‘foo’ If a column or index cannot be represented as an array of datetimes, say because of an unparseable value or a mixture of timezones, the column or index will be returned unaltered as an object data type.\n   * - infer_datetime_format\n     - bool, default False\n     - If True and parse_dates is enabled, pandas will attempt to infer the format of the datetime strings in the columns, and if it can be inferred, switch to a faster method of parsing them. In some cases this can increase the parsing speed by 5-10x.\n   * - keep_date_col\n     - bool, default False\n     - If True and parse_dates specifies combining multiple columns then keep the original columns.\n   * - date_parser\n     - function, optional\n     - Function to use for converting a sequence of string columns to an array of datetime instances. The default uses dateutil.parser.parser to do the conversion. Pandas will try to call date_parser in three different ways, advancing to the next if an exception occurs: 1) Pass one or more arrays (as defined by parse_dates) as arguments; 2) concatenate (row-wise) the string values from the columns defined by parse_dates into a single array and pass that; and 3) call date_parser once for each row using one or more strings (corresponding to the columns defined by parse_dates) as arguments.\n   * - dayfirst\n     - bool, default False\n     - DD/MM format dates, international and European format.\n\n   * - cache_dates\n     - bool, default True\n     - If True, use a cache of unique, converted dates to apply the datetime conversion. May produce significant speed-up when parsing duplicate date strings, especially ones with timezone offsets.\n   * - thousands\n     - str, optional\n     - Thousands separator.\n   * - decimal\n     - str, default ‘.’\n     - Character to recognize as decimal point (e.g. use ‘,’ for European data).\n   * - lineterminator\n     - str (length 1), optional\n     - Character to break file into lines. Only valid with C parser.\n   * - escapechar\n     - str (length 1), optional\n     - One-character string used to escape other characters.\n   * - comment\n     - str, optional\n     - Indicates remainder of line should not be parsed. If found at the beginning of a line, the line will be ignored altogether.\n   * - encoding\n     - str, optional\n     - Encoding to use for UTF when reading/writing (ex. ‘utf-8’).\n   * - dialect\n     - str or csv.Dialect, optional\n     - If provided, this parameter will override values (default or not) for the following parameters: delimiter, doublequote, escapechar, skipinitialspace, quotechar, and quoting\n   * - low_memory\n     - bool, default True\n     - Internally process the file in chunks, resulting in lower memory use while parsing, but possibly mixed type inference. To ensure no mixed types either set False, or specify the type with the dtype parameter. Note that the entire file is read into a single DataFrame regardless,\n   * - memory_map\n     - bool, default False\n     - map the file object directly onto memory and access the data directly from there. Using this option can improve performance because there is no longer any I/O overhead.\n\n\nE2E Example\n-----------\n\nA complete end to end solution is provided in this section to prove the capabilities of **igel**.\nAs explained previously, you need to create a yaml configuration file. Here is an end to end example for\npredicting whether someone have diabetes or not using the **decision tree** algorithm. The dataset can be found in the examples folder.\n\n-  **Fit/Train a model**:\n\n.. code-block:: yaml\n\n        model:\n            type: classification\n            algorithm: DecisionTree\n\n        target:\n            - sick\n\n.. code-block:: console\n\n    $ igel fit -dp path_to_the_dataset -yml path_to_the_yaml_file\n\nThat\'s it, igel will now fit the model for you and save it in a model_results folder in your current directory.\n\n\n- **Evaluate the model**:\n\nEvaluate the pre-fitted model. Igel will load the pre-fitted model from the model_results directory and evaluate it for you.\nYou just need to run the evaluate command and provide the path to your evaluation data.\n\n.. code-block:: console\n\n    $ igel evaluate -dp path_to_the_evaluation_dataset\n\nThat\'s it! Igel will evaluate the model and store statistics/results in an **evaluation.json** file inside the model_results folder\n\n- **Predict**:\n\nUse the pre-fitted model to predict on new data. This is done automatically by igel, you just need to provide the\npath to your data that you want to use prediction on.\n\n.. code-block:: console\n\n    $ igel predict -dp path_to_the_new_dataset\n\nThat\'s it! Igel will use the pre-fitted model to make predictions and save it in a **predictions.csv** file inside the model_results folder\n\nAdvanced Usage\n---------------\n\nYou can also carry out some preprocessing methods or other operations by providing them in the yaml file.\nHere is an example, where the data is split to 80% for training and 20% for validation/testing.\nAlso, the data are shuffled while splitting.\n\nFurthermore, the data are preprocessed by replacing missing values with the mean ( you can also use median, mode etc..).\ncheck `this link <https://www.kaggle.com/uciml/pima-indians-diabetes-database>`_ for more information\n\n\n.. code-block:: yaml\n\n        # dataset operations\n        dataset:\n            split:\n                test_size: 0.2\n                shuffle: True\n                stratify: default\n\n            preprocess: # preprocessing options\n                missing_values: mean    # other possible values: [drop, median, most_frequent, constant] check the docs for more\n                encoding:\n                    type: oneHotEncoding  # other possible values: [labelEncoding]\n                scale:  # scaling options\n                    method: standard    # standardization will scale values to have a 0 mean and 1 standard deviation  | you can also try minmax\n                    target: inputs  # scale inputs. | other possible values: [outputs, all] # if you choose all then all values in the dataset will be scaled\n\n        # model definition\n        model:\n            type: classification\n            algorithm: RandomForest\n            arguments:\n                # notice that this is the available args for the random forest model. check different available args for all supported models by running igel help\n                n_estimators: 100\n                max_depth: 20\n\n        # target you want to predict\n        target:\n            - sick\n\nThen, you can fit the model by running the igel command as shown in the other examples\n\n.. code-block:: console\n\n    $ igel fit -dp path_to_the_dataset -yml path_to_the_yaml_file\n\nFor evaluation\n\n.. code-block:: console\n\n    $ igel evaluate -dp path_to_the_evaluation_dataset\n\nFor production\n\n.. code-block:: console\n\n    $ igel predict -dp path_to_the_new_dataset\n\nExamples\n----------\n\nIn the examples folder in the repository, you will find a data folder,where the famous indian-diabetes, iris dataset\nand the linnerud (from sklearn) datasets are stored.\nFurthermore, there are end to end examples inside each folder, where there are scripts and yaml files that\nwill help you get started.\n\n\nThe indian-diabetes-example folder contains two examples to help you get started:\n\n- The first example is using a **neural network**, where the configurations are stored in the neural-network.yaml file\n- The second example is using a **random forest**, where the configurations are stored in the random-forest.yaml file\n\nThe iris-example folder contains a **logistic regression** example, where some preprocessing (one hot encoding)\nis conducted on the target column to show you more the capabilities of igel.\n\nFurthermore, the multioutput-example contains a **multioutput regression** example.\nFinally, the cv-example contains an example using the Ridge classifier using cross validation.\n\nYou can also find a cross validation and a hyperparameter search examples in the folder.\n\nI suggest you play around with the examples and igel cli. However,\nyou can also directly execute the fit.py, evaluate.py and predict.py if you want to.\n\nGUI\n----\n\nYou can also run the igel UI if you are not familiar with the terminal. Just install igel on your machine\nas mentioned above. Then run this single command in your terminal\n\n.. code-block:: console\n\n    $ igel gui\n\nThis will open up the gui, which is very simple to use. Check examples of how the gui looks like and how to use it\nhere: https://github.com/nidhaloff/igel-ui\n\n\nLinks\n------\n\n- Article: https://medium.com/@nidhalbacc/machine-learning-without-writing-code-984b238dd890\n\n\n\nHelp/GetHelp\n---------------\n\nIf you are facing any problems, please feel free to open an issue.\nAdditionally, you can make contact with the author for further information/questions.\n\nDo you like igel?\nYou can always help the development of this project by:\n\n- Following on github and/or twitter\n- Star the github repo\n- Watch the github repo for new releases\n- Tweet about the package\n- Help others with issues on github\n- Create issues and pull requests\n- Sponsor the project\n\nContributions\n--------------\n\nYou think this project is useful and you want to bring new ideas, new features, bug fixes, extend the docs?\n\nContributions are always welcome.\nMake sure you read `the guidelines <https://igel.readthedocs.io/en/latest/contributing.html>`_ first\n\nLicense\n--------\n\nMIT license\n\nCopyright (c) 2020-present, Nidhal Baccouri\n',
    'author': 'nidhal baccouri',
    'author_email': 'nidhalbacc@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
