"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpOrigin = void 0;
const cloudfront = require("@aws-cdk/aws-cloudfront");
/**
 * An Origin for an HTTP server or S3 bucket configured for website hosting.
 *
 * @experimental
 */
class HttpOrigin extends cloudfront.OriginBase {
    constructor(domainName, props = {}) {
        super(domainName, props);
        this.props = props;
        validateSecondsInRangeOrUndefined('readTimeout', 1, 60, props.readTimeout);
        validateSecondsInRangeOrUndefined('keepaliveTimeout', 1, 60, props.keepaliveTimeout);
    }
    renderCustomOriginConfig() {
        var _a, _b, _c;
        return {
            originProtocolPolicy: (_a = this.props.protocolPolicy) !== null && _a !== void 0 ? _a : cloudfront.OriginProtocolPolicy.HTTPS_ONLY,
            httpPort: this.props.httpPort,
            httpsPort: this.props.httpsPort,
            originReadTimeout: (_b = this.props.readTimeout) === null || _b === void 0 ? void 0 : _b.toSeconds(),
            originKeepaliveTimeout: (_c = this.props.keepaliveTimeout) === null || _c === void 0 ? void 0 : _c.toSeconds(),
        };
    }
}
exports.HttpOrigin = HttpOrigin;
/**
 * Throws an error if a duration is defined and not an integer number of seconds within a range.
 */
function validateSecondsInRangeOrUndefined(name, min, max, duration) {
    if (duration === undefined) {
        return;
    }
    const value = duration.toSeconds();
    if (!Number.isInteger(value) || value < min || value > max) {
        throw new Error(`${name}: Must be an int between ${min} and ${max} seconds (inclusive); received ${value}.`);
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaHR0cC1vcmlnaW4uanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJodHRwLW9yaWdpbi50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSxzREFBc0Q7QUErQ3REOzs7O0dBSUc7QUFDSCxNQUFhLFVBQVcsU0FBUSxVQUFVLENBQUMsVUFBVTtJQUVuRCxZQUFZLFVBQWtCLEVBQW1CLFFBQXlCLEVBQUU7UUFDMUUsS0FBSyxDQUFDLFVBQVUsRUFBRSxLQUFLLENBQUMsQ0FBQztRQURzQixVQUFLLEdBQUwsS0FBSyxDQUFzQjtRQUcxRSxpQ0FBaUMsQ0FBQyxhQUFhLEVBQUUsQ0FBQyxFQUFFLEVBQUUsRUFBRSxLQUFLLENBQUMsV0FBVyxDQUFDLENBQUM7UUFDM0UsaUNBQWlDLENBQUMsa0JBQWtCLEVBQUUsQ0FBQyxFQUFFLEVBQUUsRUFBRSxLQUFLLENBQUMsZ0JBQWdCLENBQUMsQ0FBQztJQUN2RixDQUFDO0lBRVMsd0JBQXdCOztRQUNoQyxPQUFPO1lBQ0wsb0JBQW9CLFFBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxjQUFjLG1DQUFJLFVBQVUsQ0FBQyxvQkFBb0IsQ0FBQyxVQUFVO1lBQzdGLFFBQVEsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLFFBQVE7WUFDN0IsU0FBUyxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsU0FBUztZQUMvQixpQkFBaUIsUUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLFdBQVcsMENBQUUsU0FBUyxFQUFFO1lBQ3RELHNCQUFzQixRQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsZ0JBQWdCLDBDQUFFLFNBQVMsRUFBRTtTQUNqRSxDQUFDO0lBQ0osQ0FBQztDQUNGO0FBbEJELGdDQWtCQztBQUVEOztHQUVHO0FBQ0gsU0FBUyxpQ0FBaUMsQ0FBQyxJQUFZLEVBQUUsR0FBVyxFQUFFLEdBQVcsRUFBRSxRQUF1QjtJQUN4RyxJQUFJLFFBQVEsS0FBSyxTQUFTLEVBQUU7UUFBRSxPQUFPO0tBQUU7SUFDdkMsTUFBTSxLQUFLLEdBQUcsUUFBUSxDQUFDLFNBQVMsRUFBRSxDQUFDO0lBQ25DLElBQUksQ0FBQyxNQUFNLENBQUMsU0FBUyxDQUFDLEtBQUssQ0FBQyxJQUFJLEtBQUssR0FBRyxHQUFHLElBQUksS0FBSyxHQUFHLEdBQUcsRUFBRTtRQUMxRCxNQUFNLElBQUksS0FBSyxDQUFDLEdBQUcsSUFBSSw0QkFBNEIsR0FBRyxRQUFRLEdBQUcsa0NBQWtDLEtBQUssR0FBRyxDQUFDLENBQUM7S0FDOUc7QUFDSCxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgY2xvdWRmcm9udCBmcm9tICdAYXdzLWNkay9hd3MtY2xvdWRmcm9udCc7XG5pbXBvcnQgKiBhcyBjZGsgZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5cbi8qKlxuICogUHJvcGVydGllcyBmb3IgYW4gT3JpZ2luIGJhY2tlZCBieSBhbiBTMyB3ZWJzaXRlLWNvbmZpZ3VyZWQgYnVja2V0LCBsb2FkIGJhbGFuY2VyLCBvciBjdXN0b20gSFRUUCBzZXJ2ZXIuXG4gKlxuICogQGV4cGVyaW1lbnRhbFxuICovXG5leHBvcnQgaW50ZXJmYWNlIEh0dHBPcmlnaW5Qcm9wcyBleHRlbmRzIGNsb3VkZnJvbnQuT3JpZ2luUHJvcHMge1xuICAvKipcbiAgICogU3BlY2lmaWVzIHRoZSBwcm90b2NvbCAoSFRUUCBvciBIVFRQUykgdGhhdCBDbG91ZEZyb250IHVzZXMgdG8gY29ubmVjdCB0byB0aGUgb3JpZ2luLlxuICAgKlxuICAgKiBAZGVmYXVsdCBPcmlnaW5Qcm90b2NvbFBvbGljeS5IVFRQU19PTkxZXG4gICAqL1xuICByZWFkb25seSBwcm90b2NvbFBvbGljeT86IGNsb3VkZnJvbnQuT3JpZ2luUHJvdG9jb2xQb2xpY3k7XG5cbiAgLyoqXG4gICAqIFRoZSBIVFRQIHBvcnQgdGhhdCBDbG91ZEZyb250IHVzZXMgdG8gY29ubmVjdCB0byB0aGUgb3JpZ2luLlxuICAgKlxuICAgKiBAZGVmYXVsdCA4MFxuICAgKi9cbiAgcmVhZG9ubHkgaHR0cFBvcnQ/OiBudW1iZXI7XG5cbiAgLyoqXG4gICAqIFRoZSBIVFRQUyBwb3J0IHRoYXQgQ2xvdWRGcm9udCB1c2VzIHRvIGNvbm5lY3QgdG8gdGhlIG9yaWdpbi5cbiAgICpcbiAgICogQGRlZmF1bHQgNDQzXG4gICAqL1xuICByZWFkb25seSBodHRwc1BvcnQ/OiBudW1iZXI7XG5cbiAgLyoqXG4gICAqIFNwZWNpZmllcyBob3cgbG9uZywgaW4gc2Vjb25kcywgQ2xvdWRGcm9udCB3YWl0cyBmb3IgYSByZXNwb25zZSBmcm9tIHRoZSBvcmlnaW4sIGFsc28ga25vd24gYXMgdGhlIG9yaWdpbiByZXNwb25zZSB0aW1lb3V0LlxuICAgKiBUaGUgdmFsaWQgcmFuZ2UgaXMgZnJvbSAxIHRvIDYwIHNlY29uZHMsIGluY2x1c2l2ZS5cbiAgICpcbiAgICogQGRlZmF1bHQgRHVyYXRpb24uc2Vjb25kcygzMClcbiAgICovXG4gIHJlYWRvbmx5IHJlYWRUaW1lb3V0PzogY2RrLkR1cmF0aW9uO1xuXG4gIC8qKlxuICAgKiBTcGVjaWZpZXMgaG93IGxvbmcsIGluIHNlY29uZHMsIENsb3VkRnJvbnQgcGVyc2lzdHMgaXRzIGNvbm5lY3Rpb24gdG8gdGhlIG9yaWdpbi5cbiAgICogVGhlIHZhbGlkIHJhbmdlIGlzIGZyb20gMSB0byA2MCBzZWNvbmRzLCBpbmNsdXNpdmUuXG4gICAqXG4gICAqIEBkZWZhdWx0IER1cmF0aW9uLnNlY29uZHMoNSlcbiAgICovXG4gIHJlYWRvbmx5IGtlZXBhbGl2ZVRpbWVvdXQ/OiBjZGsuRHVyYXRpb247XG59XG5cbi8qKlxuICogQW4gT3JpZ2luIGZvciBhbiBIVFRQIHNlcnZlciBvciBTMyBidWNrZXQgY29uZmlndXJlZCBmb3Igd2Vic2l0ZSBob3N0aW5nLlxuICpcbiAqIEBleHBlcmltZW50YWxcbiAqL1xuZXhwb3J0IGNsYXNzIEh0dHBPcmlnaW4gZXh0ZW5kcyBjbG91ZGZyb250Lk9yaWdpbkJhc2Uge1xuXG4gIGNvbnN0cnVjdG9yKGRvbWFpbk5hbWU6IHN0cmluZywgcHJpdmF0ZSByZWFkb25seSBwcm9wczogSHR0cE9yaWdpblByb3BzID0ge30pIHtcbiAgICBzdXBlcihkb21haW5OYW1lLCBwcm9wcyk7XG5cbiAgICB2YWxpZGF0ZVNlY29uZHNJblJhbmdlT3JVbmRlZmluZWQoJ3JlYWRUaW1lb3V0JywgMSwgNjAsIHByb3BzLnJlYWRUaW1lb3V0KTtcbiAgICB2YWxpZGF0ZVNlY29uZHNJblJhbmdlT3JVbmRlZmluZWQoJ2tlZXBhbGl2ZVRpbWVvdXQnLCAxLCA2MCwgcHJvcHMua2VlcGFsaXZlVGltZW91dCk7XG4gIH1cblxuICBwcm90ZWN0ZWQgcmVuZGVyQ3VzdG9tT3JpZ2luQ29uZmlnKCk6IGNsb3VkZnJvbnQuQ2ZuRGlzdHJpYnV0aW9uLkN1c3RvbU9yaWdpbkNvbmZpZ1Byb3BlcnR5IHwgdW5kZWZpbmVkIHtcbiAgICByZXR1cm4ge1xuICAgICAgb3JpZ2luUHJvdG9jb2xQb2xpY3k6IHRoaXMucHJvcHMucHJvdG9jb2xQb2xpY3kgPz8gY2xvdWRmcm9udC5PcmlnaW5Qcm90b2NvbFBvbGljeS5IVFRQU19PTkxZLFxuICAgICAgaHR0cFBvcnQ6IHRoaXMucHJvcHMuaHR0cFBvcnQsXG4gICAgICBodHRwc1BvcnQ6IHRoaXMucHJvcHMuaHR0cHNQb3J0LFxuICAgICAgb3JpZ2luUmVhZFRpbWVvdXQ6IHRoaXMucHJvcHMucmVhZFRpbWVvdXQ/LnRvU2Vjb25kcygpLFxuICAgICAgb3JpZ2luS2VlcGFsaXZlVGltZW91dDogdGhpcy5wcm9wcy5rZWVwYWxpdmVUaW1lb3V0Py50b1NlY29uZHMoKSxcbiAgICB9O1xuICB9XG59XG5cbi8qKlxuICogVGhyb3dzIGFuIGVycm9yIGlmIGEgZHVyYXRpb24gaXMgZGVmaW5lZCBhbmQgbm90IGFuIGludGVnZXIgbnVtYmVyIG9mIHNlY29uZHMgd2l0aGluIGEgcmFuZ2UuXG4gKi9cbmZ1bmN0aW9uIHZhbGlkYXRlU2Vjb25kc0luUmFuZ2VPclVuZGVmaW5lZChuYW1lOiBzdHJpbmcsIG1pbjogbnVtYmVyLCBtYXg6IG51bWJlciwgZHVyYXRpb24/OiBjZGsuRHVyYXRpb24pIHtcbiAgaWYgKGR1cmF0aW9uID09PSB1bmRlZmluZWQpIHsgcmV0dXJuOyB9XG4gIGNvbnN0IHZhbHVlID0gZHVyYXRpb24udG9TZWNvbmRzKCk7XG4gIGlmICghTnVtYmVyLmlzSW50ZWdlcih2YWx1ZSkgfHwgdmFsdWUgPCBtaW4gfHwgdmFsdWUgPiBtYXgpIHtcbiAgICB0aHJvdyBuZXcgRXJyb3IoYCR7bmFtZX06IE11c3QgYmUgYW4gaW50IGJldHdlZW4gJHttaW59IGFuZCAke21heH0gc2Vjb25kcyAoaW5jbHVzaXZlKTsgcmVjZWl2ZWQgJHt2YWx1ZX0uYCk7XG4gIH1cbn1cbiJdfQ==