"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TmUserPoolClient = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const cognito = require("aws-cdk-lib/aws-cognito");
const constructs_1 = require("constructs");
class TmUserPoolClient extends constructs_1.Construct {
    constructor(scope, id, userPoolProps = {}, userPoolClientProps = {}) {
        super(scope, id);
        this.defaultUserPoolProps = {
            signInCaseSensitive: false,
            selfSignUpEnabled: true,
            passwordPolicy: {
                minLength: 12,
                requireDigits: true,
                requireLowercase: true,
                requireUppercase: true,
            },
            signInAliases: {
                email: true,
                phone: false,
                username: false,
                preferredUsername: false,
            },
        };
        this.defaultUserPoolClientProps = {
            oAuth: {
                flows: {
                    authorizationCodeGrant: true
                },
                callbackUrls: ["http://localhost:8000/oauth2/token"],
                logoutUrls: ["http://localhost:8000/logged-out"],
                scopes: [cognito.OAuthScope.EMAIL, cognito.OAuthScope.OPENID]
            },
            idTokenValidity: aws_cdk_lib_1.Duration.hours(24),
            generateSecret: false
        };
        let luserPoolProps = {
            ...this.defaultUserPoolProps,
            ...userPoolProps
        };
        this.userPool = new cognito.UserPool(this, `${id}-userpool`, luserPoolProps);
        let lUserPoolClientProps = {
            userPool: this.userPool,
            ...userPoolClientProps
        };
        //
        this.userPoolClient = new cognito.UserPoolClient(this, "UserPoolClient", lUserPoolClientProps);
        const describeCognitoUserPoolClient = new aws_cdk_lib_1.custom_resources.AwsCustomResource(this, 'DescribeCognitoUserPoolClient', {
            resourceType: 'Custom::DescribeCognitoUserPoolClient',
            onCreate: {
                service: 'CognitoIdentityServiceProvider',
                action: 'describeUserPoolClient',
                parameters: {
                    UserPoolId: this.userPool.userPoolId,
                    ClientId: this.userPoolClient.userPoolClientId,
                },
                physicalResourceId: aws_cdk_lib_1.custom_resources.PhysicalResourceId.of(this.userPoolClient.userPoolClientId),
            },
            // TODO: can we restrict this policy more?
            policy: aws_cdk_lib_1.custom_resources.AwsCustomResourcePolicy.fromSdkCalls({
                resources: aws_cdk_lib_1.custom_resources.AwsCustomResourcePolicy.ANY_RESOURCE,
            }),
        });
        const userPoolClientSecret = describeCognitoUserPoolClient.getResponseField('UserPoolClient.ClientSecret');
        new aws_cdk_lib_1.CfnOutput(this, "CognitoUserPoolId", { value: this.userPool.userPoolId, exportName: 'CognitoUserPoolId' });
        new aws_cdk_lib_1.CfnOutput(this, "CognitoUserPoolClientId", { value: this.userPoolClient.userPoolClientId, exportName: 'CognitoUserPoolClientId' });
        new aws_cdk_lib_1.CfnOutput(this, "CognitoUserPoolClientSecret", { value: userPoolClientSecret, exportName: 'CognitoUserPoolClientSecret' });
    }
}
exports.TmUserPoolClient = TmUserPoolClient;
_a = JSII_RTTI_SYMBOL_1;
TmUserPoolClient[_a] = { fqn: "@toumoro-cdk/cognito.TmUserPoolClient", version: "1.0.9" };
//# sourceMappingURL=data:application/json;base64,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