
class Config:
    @classmethod
    def from_data(cls, service_id: int, **kwargs):
        return cls(service_id, **{k.lower().replace('-', '_').replace('3rd', 'third'): v for k, v in kwargs.items()})

    def __init__(
            self,
            service_id: int,
            server_name: str = None,
            admin_password: str = None,
            server_password: str = None,
            player_on_map: str = None,
            disable_pvp: str = None,
            hardcore: str = None,
            crosshair: str = None,
            no_hud: str = None,
            voice_chat: str = None,
            near_chat_only: str = None,
            third_person: str = None,
            leave_messages: str = None,
            join_messages: str = None,
            message_of_the_day: str = None,
            difficulty_offset: str = None,
            motd_duration: str = None,
            disable_structure_decay_pve: str = None,
            allow_flyer_carry_pve: str = None,
            max_structures_in_range: str = None,
            enable_pvp_gamma: str = None,
            no_tribute_downloads: str = None,
            daycyclespeedscale: str = None,
            nighttimespeedscale: str = None,
            daytimespeedscale: str = None,
            dinodamagemultiplier: str = None,
            playerdamagemultiplier: str = None,
            structuredamagemultiplier: str = None,
            playerresistancemultiplier: str = None,
            dinoresistancemultiplier: str = None,
            structureresistancemultiplier: str = None,
            xpmultiplier: str = None,
            tamingspeedmultiplier: str = None,
            harvestamountmultiplier: str = None,
            harvesthealthmultiplier: str = None,
            playercharacterwaterdrainmultiplier: str = None,
            playercharacterfooddrainmultiplier: str = None,
            dinocharacterfooddrainmultiplier: str = None,
            playercharacterstaminadrainmultiplier: str = None,
            dinocharacterstaminadrainmultiplier: str = None,
            playercharacterhealthrecoverymultiplier: str = None,
            dinocharacterhealthrecoverymultiplier: str = None,
            dinocountmultiplier: str = None,
            pvestructuredecayperiodmultiplier: str = None,
            resourcesrespawnperiodmultiplier: str = None,
            clampresourceharvestdamage: str = None,
            map: str = None,
            restart_countdown_seconds: str = None,
            active_mods: str = None,
            start_with_backup: str = None,
            players_join_no_check_list: str = None,
            ban_list: str = None,
            prevent_download_survivors: str = None,
            prevent_download_items: str = None,
            prevent_download_dinos: str = None,
            admin_list: str = None,
            default_map: str = None,
            map_mod_id: str = None,
            active_total_conversion: str = None,
            disabledeathspectator: str = None,
            onlyadminrejoinasspectator: str = None,
            battlenumoftribestostartgame: str = None,
            timetocollapserod: str = None,
            battleautostartgameinterval: str = None,
            battleautorestartgameinterval: str = None,
            battlesuddendeathinterval: str = None,
            structuredestructiontag: str = None,
            forcerespawndinos: str = None,
            banlisturl: str = None,
            autosaveperiodminutes: str = None,
            activateadminlogs: str = None,
            gamelogbuffer: str = None,
            map_expert: str = None,
            disabledinodecaypve: str = None,
            pvedinodecayperiodmultiplier: str = None,
            disablepvegamma: str = None,
            exlusivejoin: str = None,
            playersexclusivejoinlist: str = None,
            forceallstructurelocking: str = None,
            autodestroyoldstructuresmultiplier: str = None,
            bjoinnotifications: str = None,
            bshowstatusnotificationmessages: str = None,
            perplatformmaxstructuresmultiplier: str = None,
            spectatorpassword: str = None,
            allowcavebuildingpve: str = None,
            nofishloot: str = None,
            disabledinoriding: str = None,
            disabledinotaming: str = None,
            maxpersonaltameddinos: str = None,
            onlydecayunsnappedcorestructures: str = None,
            tributeitemexpirationseconds: str = None,
            tributedinoexpirationseconds: str = None,
            tributecharacterexpirationseconds: str = None,
            current_admin_password: str = None,
            activateadmintribelogs: str = None,
            tribenamechangecooldown: str = None,
            allowhidedamagesourcefromlogs: str = None,
            randomsupplycratepoints: str = None,
            disableweatherfog: str = None,
            adminlogging: str = None,
            bforcecanridefliers: str = None,
            allowteksuitpowersingenesis: str = None,
            enablecryosicknesspve: str = None,
            cryopodnerfduration: str = None,
            cryopodnerfdamagemult: str = None,
            itemstacksizemultiplier: str = None,
            allowcavebuildingpvp: str = None,
            **kwargs
    ):
        self.server_name = server_name
        self.admin_password = admin_password
        self.server_password = server_password
        self.player_on_map = player_on_map
        self.disable_pvp = disable_pvp
        self.hardcore = hardcore
        self.crosshair = crosshair
        self.no_hud = no_hud
        self.voice_chat = voice_chat
        self.near_chat_only = near_chat_only
        self.third_person = third_person
        self.leave_messages = leave_messages
        self.join_messages = join_messages
        self.message_of_the_day = message_of_the_day
        self.difficulty_offset = difficulty_offset
        self.motd_duration = motd_duration
        self.disable_structure_decay_pve = disable_structure_decay_pve
        self.allow_flyer_carry_pve = allow_flyer_carry_pve
        self.max_structures_in_range = max_structures_in_range
        self.enable_pvp_gamma = enable_pvp_gamma
        self.no_tribute_downloads = no_tribute_downloads
        self.daycyclespeedscale = daycyclespeedscale
        self.nighttimespeedscale = nighttimespeedscale
        self.daytimespeedscale = daytimespeedscale
        self.dinodamagemultiplier = dinodamagemultiplier
        self.playerdamagemultiplier = playerdamagemultiplier
        self.structuredamagemultiplier = structuredamagemultiplier
        self.playerresistancemultiplier = playerresistancemultiplier
        self.dinoresistancemultiplier = dinoresistancemultiplier
        self.structureresistancemultiplier = structureresistancemultiplier
        self.xpmultiplier = xpmultiplier
        self.tamingspeedmultiplier = tamingspeedmultiplier
        self.harvestamountmultiplier = harvestamountmultiplier
        self.harvesthealthmultiplier = harvesthealthmultiplier
        self.playercharacterwaterdrainmultiplier = playercharacterwaterdrainmultiplier
        self.playercharacterfooddrainmultiplier = playercharacterfooddrainmultiplier
        self.dinocharacterfooddrainmultiplier = dinocharacterfooddrainmultiplier
        self.playercharacterstaminadrainmultiplier = playercharacterstaminadrainmultiplier
        self.dinocharacterstaminadrainmultiplier = dinocharacterstaminadrainmultiplier
        self.playercharacterhealthrecoverymultiplier = playercharacterhealthrecoverymultiplier
        self.dinocharacterhealthrecoverymultiplier = dinocharacterhealthrecoverymultiplier
        self.dinocountmultiplier = dinocountmultiplier
        self.pvestructuredecayperiodmultiplier = pvestructuredecayperiodmultiplier
        self.resourcesrespawnperiodmultiplier = resourcesrespawnperiodmultiplier
        self.clampresourceharvestdamage = clampresourceharvestdamage
        self.map = map
        self.restart_countdown_seconds = restart_countdown_seconds
        self.active_mods = active_mods
        self.start_with_backup = start_with_backup
        self.players_join_no_check_list = players_join_no_check_list
        self.ban_list = ban_list
        self.prevent_download_survivors = prevent_download_survivors
        self.prevent_download_items = prevent_download_items
        self.prevent_download_dinos = prevent_download_dinos
        self.admin_list = admin_list
        self.default_map = default_map
        self.map_mod_id = map_mod_id
        self.active_total_conversion = active_total_conversion
        self.disabledeathspectator = disabledeathspectator
        self.onlyadminrejoinasspectator = onlyadminrejoinasspectator
        self.battlenumoftribestostartgame = battlenumoftribestostartgame
        self.timetocollapserod = timetocollapserod
        self.battleautostartgameinterval = battleautostartgameinterval
        self.battleautorestartgameinterval = battleautorestartgameinterval
        self.battlesuddendeathinterval = battlesuddendeathinterval
        self.structuredestructiontag = structuredestructiontag
        self.forcerespawndinos = forcerespawndinos
        self.banlisturl = banlisturl
        self.autosaveperiodminutes = autosaveperiodminutes
        self.activateadminlogs = activateadminlogs
        self.gamelogbuffer = gamelogbuffer
        self.map_expert = map_expert
        self.disabledinodecaypve = disabledinodecaypve
        self.pvedinodecayperiodmultiplier = pvedinodecayperiodmultiplier
        self.disablepvegamma = disablepvegamma
        self.exlusivejoin = exlusivejoin
        self.playersexclusivejoinlist = playersexclusivejoinlist
        self.forceallstructurelocking = forceallstructurelocking
        self.autodestroyoldstructuresmultiplier = autodestroyoldstructuresmultiplier
        self.bjoinnotifications = bjoinnotifications
        self.bshowstatusnotificationmessages = bshowstatusnotificationmessages
        self.perplatformmaxstructuresmultiplier = perplatformmaxstructuresmultiplier
        self.spectatorpassword = spectatorpassword
        self.allowcavebuildingpve = allowcavebuildingpve
        self.nofishloot = nofishloot
        self.disabledinoriding = disabledinoriding
        self.disabledinotaming = disabledinotaming
        self.maxpersonaltameddinos = maxpersonaltameddinos
        self.onlydecayunsnappedcorestructures = onlydecayunsnappedcorestructures
        self.tributeitemexpirationseconds = tributeitemexpirationseconds
        self.tributedinoexpirationseconds = tributedinoexpirationseconds
        self.tributecharacterexpirationseconds = tributecharacterexpirationseconds
        self.current_admin_password = current_admin_password
        self.activateadmintribelogs = activateadmintribelogs
        self.tribenamechangecooldown = tribenamechangecooldown
        self.allowhidedamagesourcefromlogs = allowhidedamagesourcefromlogs
        self.randomsupplycratepoints = randomsupplycratepoints
        self.disableweatherfog = disableweatherfog
        self.adminlogging = adminlogging
        self.bforcecanridefliers = bforcecanridefliers
        self.allowteksuitpowersingenesis = allowteksuitpowersingenesis
        self.enablecryosicknesspve = enablecryosicknesspve
        self.cryopodnerfduration = cryopodnerfduration
        self.cryopodnerfdamagemult = cryopodnerfdamagemult
        self.itemstacksizemultiplier = itemstacksizemultiplier
        self.allowcavebuildingpvp = allowcavebuildingpvp
        self.service_id = service_id
        for k, v in kwargs.items():
            self.__dict__[k] = v

    def __repr__(self):
        params = [f"{k}={repr(v)}" for k, v in self.__dict__.items()]
        return f"<{self.__class__.__name__}({', '.join(params)})>"

