"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
// tslint:disable: max-line-length
const core_1 = require("@aws-cdk/core");
const ssm = require("../lib");
const app = new core_1.App();
const stack = new core_1.Stack(app, 'integ-parameter-arns');
const input = new core_1.CfnParameter(stack, 'ParameterNameParameter', { type: 'String', default: 'myParamName' });
const params = [
    new ssm.StringParameter(stack, 'StringAutogen', { stringValue: 'hello, world' }),
    new ssm.StringParameter(stack, 'StringSimple', { stringValue: 'hello, world', parameterName: 'simple-name' }),
    new ssm.StringParameter(stack, 'StringPath', { stringValue: 'hello, world', parameterName: '/path/name/foo/bar' }),
    new ssm.StringListParameter(stack, 'ListAutogen', { stringListValue: ['hello', 'world'] }),
    new ssm.StringListParameter(stack, 'ListSimple', { stringListValue: ['hello', 'world'], parameterName: 'list-simple-name' }),
    new ssm.StringListParameter(stack, 'ListPath', { stringListValue: ['hello', 'world'], parameterName: '/list/path/name' }),
    new ssm.StringParameter(stack, 'ParameterizedSimple', { stringValue: 'hello, world', parameterName: input.valueAsString, simpleName: true }),
    new ssm.StringParameter(stack, 'ParameterizedNonSimple', { stringValue: 'hello, world', parameterName: `/${input.valueAsString}/non/simple`, simpleName: false }),
];
for (const p of params) {
    new core_1.CfnOutput(stack, `${p.node.id}Arn`, { value: p.parameterArn });
}
app.synth();
//# sourceMappingURL=data:application/json;base64,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