# 🎉 Version 0.3.0 Deployment Complete! 🎉

## Deployment Summary - November 21, 2025

### ✅ Successfully Deployed Version 0.3.0!

**Package**: `parallel-llm`  
**Version**: 0.3.0  
**PyPI URL**: https://pypi.org/project/parallel-llm/0.3.0/  
**Deployment Time**: November 21, 2025, 11:45 AM IST

---

## 📦 Major Changes in v0.3.0

### 🏗️ Package Restructuring
The package has been completely reorganized to follow best practices and match standard import patterns:

- **`parallel_llm.core`**: Core model architecture (`DiffusionTransformer`) and configuration (`ModelConfig`).
- **`parallel_llm.training`**: Training components (`DistributedTrainer`, `TrainingConfig`, `DiffusionLoss`).
- **`parallel_llm.inference`**: Inference components (`ParallelGenerator`, `InferenceConfig`).
- **`parallel_llm.utils`**: Utility modules (`TextDataset`, `MultimodalDataset`).

### ✨ New Features
- **New Loss Functions**: Added `DiffusionLoss` and `ContrastiveLoss` in `parallel_llm.training.losses`.
- **Data Utilities**: Added `TextDataset`, `MultimodalDataset`, and `PreTokenizedDataset` in `parallel_llm.utils.data`.
- **Improved CLI**: Updated Command Line Interface to support the new structure.

### 🔄 Backward Compatibility
- Top-level imports (e.g., `from parallel_llm import DiffusionTransformer`) still work.
- Old configuration classes are aliased where appropriate.

---

## 🚀 Installation

```bash
pip install parallel-llm==0.3.0
```

## 💻 Usage Examples

### Training
```python
from parallel_llm.core import ModelConfig, DiffusionTransformer
from parallel_llm.training import TrainingConfig, DistributedTrainer
from parallel_llm.utils import TextDataset

# Configure
config = ModelConfig(hidden_size=512, num_hidden_layers=8)
model = DiffusionTransformer(config)

# Train
trainer = DistributedTrainer(model, TrainingConfig(output_dir="./output"))
trainer.train()
```

### Inference
```python
from parallel_llm.inference import ParallelGenerator, GenerationConfig

# Generate
generator = ParallelGenerator(model, GenerationConfig(max_new_tokens=128))
output = generator.generate(input_tokens)
```

---

## 🧹 Cleanup & Verification

- **Cleaned**: Removed temporary test environments, old build artifacts, and simplified example scripts.
- **Verified**: Package structure validated, builds successfully, and uploads to PyPI.
- **Platform Note**: Windows users may encounter PyTorch DLL issues (standard for PyTorch on Windows without CUDA). Linux/CUDA environments are fully supported.

---

## 🔗 Links
- **PyPI**: https://pypi.org/project/parallel-llm/
- **GitHub**: https://github.com/furqan-y-khan/parallel-llm
- **Issues**: https://github.com/furqan-y-khan/parallel-llm/issues

---

*Deployment completed successfully by Antigravity*
