## Contributing to polyply

Thanks for contributing to polyply!

Everyone is welcome to contribute to the polyply package as described below. 

#### Reporting issues

If you've found something going wrong with polyply let us know by opening an [issue](https://github.com/marrink-lab/polyply_1.0/issues). This way we can fix it as fast as possible. 

If your issue isn't a problem with the code and instead you would like some help using polyply for your project, let us know on the [discussion forum](https://github.com/marrink-lab/polyply_1.0/discussions).

As a rule of thumb, give a quick look to the [FAQs]( https://github.com/marrink-lab/polyply_1.0/wiki/FAQs) and [discussion forum]( https://github.com/marrink-lab/polyply_1.0/discussions), 
if you are in doubt as to whether you are experiencing an actual bug or if the usage of polyply is unclear. In any case we’d love to know, so we can improve the situation. 

#### Contributing parameters

Polyply curates a library of polymer parameters for different force-fields, especially the Martini force-field. We are happy to accept submissions of polymer parameters to the polyply library. To submit parameters simply open an [issue](https://github.com/marrink-lab/polyply_1.0/issues). More details on submitting parameters can be found 
[here](https://github.com/marrink-lab/polyply_1.0/wiki/Submit-polymer-parameters).

#### Contributing code

To contribute code simply open a pull request. The dev-tream will try its best to assist with tips, tricks, and guidance to make a PR as successful as possible. If you are in doubt as to whether your code addition/project would be accepted simply open an issue and let us help you. 
