import cdk = require('@aws-cdk/cdk');
/**
 * Properties for defining a `AWS::IoT::Certificate`
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-certificate.html
 */
export interface CfnCertificateProps {
    /**
     * `AWS::IoT::Certificate.CertificateSigningRequest`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-certificate.html#cfn-iot-certificate-certificatesigningrequest
     */
    readonly certificateSigningRequest: string;
    /**
     * `AWS::IoT::Certificate.Status`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-certificate.html#cfn-iot-certificate-status
     */
    readonly status: string;
}
/**
 * A CloudFormation `AWS::IoT::Certificate`
 *
 * @cloudformationResource AWS::IoT::Certificate
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-certificate.html
 */
export declare class CfnCertificate extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly cfnResourceTypeName = "AWS::IoT::Certificate";
    /**
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * `AWS::IoT::Certificate.CertificateSigningRequest`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-certificate.html#cfn-iot-certificate-certificatesigningrequest
     */
    certificateSigningRequest: string;
    /**
     * `AWS::IoT::Certificate.Status`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-certificate.html#cfn-iot-certificate-status
     */
    status: string;
    /**
     * Create a new `AWS::IoT::Certificate`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnCertificateProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::IoT::Policy`
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-policy.html
 */
export interface CfnPolicyProps {
    /**
     * `AWS::IoT::Policy.PolicyDocument`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-policy.html#cfn-iot-policy-policydocument
     */
    readonly policyDocument: object | cdk.IResolvable;
    /**
     * `AWS::IoT::Policy.PolicyName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-policy.html#cfn-iot-policy-policyname
     */
    readonly policyName?: string;
}
/**
 * A CloudFormation `AWS::IoT::Policy`
 *
 * @cloudformationResource AWS::IoT::Policy
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-policy.html
 */
export declare class CfnPolicy extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly cfnResourceTypeName = "AWS::IoT::Policy";
    /**
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * `AWS::IoT::Policy.PolicyDocument`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-policy.html#cfn-iot-policy-policydocument
     */
    policyDocument: object | cdk.IResolvable;
    /**
     * `AWS::IoT::Policy.PolicyName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-policy.html#cfn-iot-policy-policyname
     */
    policyName: string | undefined;
    /**
     * Create a new `AWS::IoT::Policy`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnPolicyProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::IoT::PolicyPrincipalAttachment`
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-policyprincipalattachment.html
 */
export interface CfnPolicyPrincipalAttachmentProps {
    /**
     * `AWS::IoT::PolicyPrincipalAttachment.PolicyName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-policyprincipalattachment.html#cfn-iot-policyprincipalattachment-policyname
     */
    readonly policyName: string;
    /**
     * `AWS::IoT::PolicyPrincipalAttachment.Principal`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-policyprincipalattachment.html#cfn-iot-policyprincipalattachment-principal
     */
    readonly principal: string;
}
/**
 * A CloudFormation `AWS::IoT::PolicyPrincipalAttachment`
 *
 * @cloudformationResource AWS::IoT::PolicyPrincipalAttachment
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-policyprincipalattachment.html
 */
export declare class CfnPolicyPrincipalAttachment extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly cfnResourceTypeName = "AWS::IoT::PolicyPrincipalAttachment";
    /**
     * `AWS::IoT::PolicyPrincipalAttachment.PolicyName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-policyprincipalattachment.html#cfn-iot-policyprincipalattachment-policyname
     */
    policyName: string;
    /**
     * `AWS::IoT::PolicyPrincipalAttachment.Principal`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-policyprincipalattachment.html#cfn-iot-policyprincipalattachment-principal
     */
    principal: string;
    /**
     * Create a new `AWS::IoT::PolicyPrincipalAttachment`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnPolicyPrincipalAttachmentProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::IoT::Thing`
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thing.html
 */
export interface CfnThingProps {
    /**
     * `AWS::IoT::Thing.AttributePayload`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thing.html#cfn-iot-thing-attributepayload
     */
    readonly attributePayload?: CfnThing.AttributePayloadProperty | cdk.IResolvable;
    /**
     * `AWS::IoT::Thing.ThingName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thing.html#cfn-iot-thing-thingname
     */
    readonly thingName?: string;
}
/**
 * A CloudFormation `AWS::IoT::Thing`
 *
 * @cloudformationResource AWS::IoT::Thing
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thing.html
 */
export declare class CfnThing extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly cfnResourceTypeName = "AWS::IoT::Thing";
    /**
     * `AWS::IoT::Thing.AttributePayload`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thing.html#cfn-iot-thing-attributepayload
     */
    attributePayload: CfnThing.AttributePayloadProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::IoT::Thing.ThingName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thing.html#cfn-iot-thing-thingname
     */
    thingName: string | undefined;
    /**
     * Create a new `AWS::IoT::Thing`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnThingProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnThing {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-thing-attributepayload.html
     */
    interface AttributePayloadProperty {
        /**
         * `CfnThing.AttributePayloadProperty.Attributes`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-thing-attributepayload.html#cfn-iot-thing-attributepayload-attributes
         */
        readonly attributes?: {
            [key: string]: (string);
        } | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::IoT::ThingPrincipalAttachment`
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thingprincipalattachment.html
 */
export interface CfnThingPrincipalAttachmentProps {
    /**
     * `AWS::IoT::ThingPrincipalAttachment.Principal`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thingprincipalattachment.html#cfn-iot-thingprincipalattachment-principal
     */
    readonly principal: string;
    /**
     * `AWS::IoT::ThingPrincipalAttachment.ThingName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thingprincipalattachment.html#cfn-iot-thingprincipalattachment-thingname
     */
    readonly thingName: string;
}
/**
 * A CloudFormation `AWS::IoT::ThingPrincipalAttachment`
 *
 * @cloudformationResource AWS::IoT::ThingPrincipalAttachment
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thingprincipalattachment.html
 */
export declare class CfnThingPrincipalAttachment extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly cfnResourceTypeName = "AWS::IoT::ThingPrincipalAttachment";
    /**
     * `AWS::IoT::ThingPrincipalAttachment.Principal`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thingprincipalattachment.html#cfn-iot-thingprincipalattachment-principal
     */
    principal: string;
    /**
     * `AWS::IoT::ThingPrincipalAttachment.ThingName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thingprincipalattachment.html#cfn-iot-thingprincipalattachment-thingname
     */
    thingName: string;
    /**
     * Create a new `AWS::IoT::ThingPrincipalAttachment`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnThingPrincipalAttachmentProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::IoT::TopicRule`
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicrule.html
 */
export interface CfnTopicRuleProps {
    /**
     * `AWS::IoT::TopicRule.TopicRulePayload`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicrule.html#cfn-iot-topicrule-topicrulepayload
     */
    readonly topicRulePayload: CfnTopicRule.TopicRulePayloadProperty | cdk.IResolvable;
    /**
     * `AWS::IoT::TopicRule.RuleName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicrule.html#cfn-iot-topicrule-rulename
     */
    readonly ruleName?: string;
}
/**
 * A CloudFormation `AWS::IoT::TopicRule`
 *
 * @cloudformationResource AWS::IoT::TopicRule
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicrule.html
 */
export declare class CfnTopicRule extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly cfnResourceTypeName = "AWS::IoT::TopicRule";
    /**
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * `AWS::IoT::TopicRule.TopicRulePayload`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicrule.html#cfn-iot-topicrule-topicrulepayload
     */
    topicRulePayload: CfnTopicRule.TopicRulePayloadProperty | cdk.IResolvable;
    /**
     * `AWS::IoT::TopicRule.RuleName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicrule.html#cfn-iot-topicrule-rulename
     */
    ruleName: string | undefined;
    /**
     * Create a new `AWS::IoT::TopicRule`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnTopicRuleProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnTopicRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html
     */
    interface ActionProperty {
        /**
         * `CfnTopicRule.ActionProperty.CloudwatchAlarm`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-cloudwatchalarm
         */
        readonly cloudwatchAlarm?: CfnTopicRule.CloudwatchAlarmActionProperty | cdk.IResolvable;
        /**
         * `CfnTopicRule.ActionProperty.CloudwatchMetric`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-cloudwatchmetric
         */
        readonly cloudwatchMetric?: CfnTopicRule.CloudwatchMetricActionProperty | cdk.IResolvable;
        /**
         * `CfnTopicRule.ActionProperty.DynamoDB`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-dynamodb
         */
        readonly dynamoDb?: CfnTopicRule.DynamoDBActionProperty | cdk.IResolvable;
        /**
         * `CfnTopicRule.ActionProperty.DynamoDBv2`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-dynamodbv2
         */
        readonly dynamoDBv2?: CfnTopicRule.DynamoDBv2ActionProperty | cdk.IResolvable;
        /**
         * `CfnTopicRule.ActionProperty.Elasticsearch`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-elasticsearch
         */
        readonly elasticsearch?: CfnTopicRule.ElasticsearchActionProperty | cdk.IResolvable;
        /**
         * `CfnTopicRule.ActionProperty.Firehose`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-firehose
         */
        readonly firehose?: CfnTopicRule.FirehoseActionProperty | cdk.IResolvable;
        /**
         * `CfnTopicRule.ActionProperty.IotAnalytics`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-iotanalytics
         */
        readonly iotAnalytics?: CfnTopicRule.IotAnalyticsActionProperty | cdk.IResolvable;
        /**
         * `CfnTopicRule.ActionProperty.Kinesis`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-kinesis
         */
        readonly kinesis?: CfnTopicRule.KinesisActionProperty | cdk.IResolvable;
        /**
         * `CfnTopicRule.ActionProperty.Lambda`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-lambda
         */
        readonly lambda?: CfnTopicRule.LambdaActionProperty | cdk.IResolvable;
        /**
         * `CfnTopicRule.ActionProperty.Republish`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-republish
         */
        readonly republish?: CfnTopicRule.RepublishActionProperty | cdk.IResolvable;
        /**
         * `CfnTopicRule.ActionProperty.S3`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-s3
         */
        readonly s3?: CfnTopicRule.S3ActionProperty | cdk.IResolvable;
        /**
         * `CfnTopicRule.ActionProperty.Sns`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-sns
         */
        readonly sns?: CfnTopicRule.SnsActionProperty | cdk.IResolvable;
        /**
         * `CfnTopicRule.ActionProperty.Sqs`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-sqs
         */
        readonly sqs?: CfnTopicRule.SqsActionProperty | cdk.IResolvable;
        /**
         * `CfnTopicRule.ActionProperty.StepFunctions`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-stepfunctions
         */
        readonly stepFunctions?: CfnTopicRule.StepFunctionsActionProperty | cdk.IResolvable;
    }
}
export declare namespace CfnTopicRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchalarmaction.html
     */
    interface CloudwatchAlarmActionProperty {
        /**
         * `CfnTopicRule.CloudwatchAlarmActionProperty.AlarmName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchalarmaction.html#cfn-iot-topicrule-cloudwatchalarmaction-alarmname
         */
        readonly alarmName: string;
        /**
         * `CfnTopicRule.CloudwatchAlarmActionProperty.RoleArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchalarmaction.html#cfn-iot-topicrule-cloudwatchalarmaction-rolearn
         */
        readonly roleArn: string;
        /**
         * `CfnTopicRule.CloudwatchAlarmActionProperty.StateReason`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchalarmaction.html#cfn-iot-topicrule-cloudwatchalarmaction-statereason
         */
        readonly stateReason: string;
        /**
         * `CfnTopicRule.CloudwatchAlarmActionProperty.StateValue`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchalarmaction.html#cfn-iot-topicrule-cloudwatchalarmaction-statevalue
         */
        readonly stateValue: string;
    }
}
export declare namespace CfnTopicRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchmetricaction.html
     */
    interface CloudwatchMetricActionProperty {
        /**
         * `CfnTopicRule.CloudwatchMetricActionProperty.MetricName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchmetricaction.html#cfn-iot-topicrule-cloudwatchmetricaction-metricname
         */
        readonly metricName: string;
        /**
         * `CfnTopicRule.CloudwatchMetricActionProperty.MetricNamespace`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchmetricaction.html#cfn-iot-topicrule-cloudwatchmetricaction-metricnamespace
         */
        readonly metricNamespace: string;
        /**
         * `CfnTopicRule.CloudwatchMetricActionProperty.MetricTimestamp`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchmetricaction.html#cfn-iot-topicrule-cloudwatchmetricaction-metrictimestamp
         */
        readonly metricTimestamp?: string;
        /**
         * `CfnTopicRule.CloudwatchMetricActionProperty.MetricUnit`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchmetricaction.html#cfn-iot-topicrule-cloudwatchmetricaction-metricunit
         */
        readonly metricUnit: string;
        /**
         * `CfnTopicRule.CloudwatchMetricActionProperty.MetricValue`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchmetricaction.html#cfn-iot-topicrule-cloudwatchmetricaction-metricvalue
         */
        readonly metricValue: string;
        /**
         * `CfnTopicRule.CloudwatchMetricActionProperty.RoleArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchmetricaction.html#cfn-iot-topicrule-cloudwatchmetricaction-rolearn
         */
        readonly roleArn: string;
    }
}
export declare namespace CfnTopicRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-dynamodbaction.html
     */
    interface DynamoDBActionProperty {
        /**
         * `CfnTopicRule.DynamoDBActionProperty.HashKeyField`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-dynamodbaction.html#cfn-iot-topicrule-dynamodbaction-hashkeyfield
         */
        readonly hashKeyField: string;
        /**
         * `CfnTopicRule.DynamoDBActionProperty.HashKeyType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-dynamodbaction.html#cfn-iot-topicrule-dynamodbaction-hashkeytype
         */
        readonly hashKeyType?: string;
        /**
         * `CfnTopicRule.DynamoDBActionProperty.HashKeyValue`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-dynamodbaction.html#cfn-iot-topicrule-dynamodbaction-hashkeyvalue
         */
        readonly hashKeyValue: string;
        /**
         * `CfnTopicRule.DynamoDBActionProperty.PayloadField`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-dynamodbaction.html#cfn-iot-topicrule-dynamodbaction-payloadfield
         */
        readonly payloadField?: string;
        /**
         * `CfnTopicRule.DynamoDBActionProperty.RangeKeyField`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-dynamodbaction.html#cfn-iot-topicrule-dynamodbaction-rangekeyfield
         */
        readonly rangeKeyField?: string;
        /**
         * `CfnTopicRule.DynamoDBActionProperty.RangeKeyType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-dynamodbaction.html#cfn-iot-topicrule-dynamodbaction-rangekeytype
         */
        readonly rangeKeyType?: string;
        /**
         * `CfnTopicRule.DynamoDBActionProperty.RangeKeyValue`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-dynamodbaction.html#cfn-iot-topicrule-dynamodbaction-rangekeyvalue
         */
        readonly rangeKeyValue?: string;
        /**
         * `CfnTopicRule.DynamoDBActionProperty.RoleArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-dynamodbaction.html#cfn-iot-topicrule-dynamodbaction-rolearn
         */
        readonly roleArn: string;
        /**
         * `CfnTopicRule.DynamoDBActionProperty.TableName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-dynamodbaction.html#cfn-iot-topicrule-dynamodbaction-tablename
         */
        readonly tableName: string;
    }
}
export declare namespace CfnTopicRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-dynamodbv2action.html
     */
    interface DynamoDBv2ActionProperty {
        /**
         * `CfnTopicRule.DynamoDBv2ActionProperty.PutItem`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-dynamodbv2action.html#cfn-iot-topicrule-dynamodbv2action-putitem
         */
        readonly putItem?: CfnTopicRule.PutItemInputProperty | cdk.IResolvable;
        /**
         * `CfnTopicRule.DynamoDBv2ActionProperty.RoleArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-dynamodbv2action.html#cfn-iot-topicrule-dynamodbv2action-rolearn
         */
        readonly roleArn?: string;
    }
}
export declare namespace CfnTopicRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-elasticsearchaction.html
     */
    interface ElasticsearchActionProperty {
        /**
         * `CfnTopicRule.ElasticsearchActionProperty.Endpoint`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-elasticsearchaction.html#cfn-iot-topicrule-elasticsearchaction-endpoint
         */
        readonly endpoint: string;
        /**
         * `CfnTopicRule.ElasticsearchActionProperty.Id`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-elasticsearchaction.html#cfn-iot-topicrule-elasticsearchaction-id
         */
        readonly id: string;
        /**
         * `CfnTopicRule.ElasticsearchActionProperty.Index`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-elasticsearchaction.html#cfn-iot-topicrule-elasticsearchaction-index
         */
        readonly index: string;
        /**
         * `CfnTopicRule.ElasticsearchActionProperty.RoleArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-elasticsearchaction.html#cfn-iot-topicrule-elasticsearchaction-rolearn
         */
        readonly roleArn: string;
        /**
         * `CfnTopicRule.ElasticsearchActionProperty.Type`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-elasticsearchaction.html#cfn-iot-topicrule-elasticsearchaction-type
         */
        readonly type: string;
    }
}
export declare namespace CfnTopicRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-firehoseaction.html
     */
    interface FirehoseActionProperty {
        /**
         * `CfnTopicRule.FirehoseActionProperty.DeliveryStreamName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-firehoseaction.html#cfn-iot-topicrule-firehoseaction-deliverystreamname
         */
        readonly deliveryStreamName: string;
        /**
         * `CfnTopicRule.FirehoseActionProperty.RoleArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-firehoseaction.html#cfn-iot-topicrule-firehoseaction-rolearn
         */
        readonly roleArn: string;
        /**
         * `CfnTopicRule.FirehoseActionProperty.Separator`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-firehoseaction.html#cfn-iot-topicrule-firehoseaction-separator
         */
        readonly separator?: string;
    }
}
export declare namespace CfnTopicRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-iotanalyticsaction.html
     */
    interface IotAnalyticsActionProperty {
        /**
         * `CfnTopicRule.IotAnalyticsActionProperty.ChannelName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-iotanalyticsaction.html#cfn-iot-topicrule-iotanalyticsaction-channelname
         */
        readonly channelName: string;
        /**
         * `CfnTopicRule.IotAnalyticsActionProperty.RoleArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-iotanalyticsaction.html#cfn-iot-topicrule-iotanalyticsaction-rolearn
         */
        readonly roleArn: string;
    }
}
export declare namespace CfnTopicRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-kinesisaction.html
     */
    interface KinesisActionProperty {
        /**
         * `CfnTopicRule.KinesisActionProperty.PartitionKey`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-kinesisaction.html#cfn-iot-topicrule-kinesisaction-partitionkey
         */
        readonly partitionKey?: string;
        /**
         * `CfnTopicRule.KinesisActionProperty.RoleArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-kinesisaction.html#cfn-iot-topicrule-kinesisaction-rolearn
         */
        readonly roleArn: string;
        /**
         * `CfnTopicRule.KinesisActionProperty.StreamName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-kinesisaction.html#cfn-iot-topicrule-kinesisaction-streamname
         */
        readonly streamName: string;
    }
}
export declare namespace CfnTopicRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-lambdaaction.html
     */
    interface LambdaActionProperty {
        /**
         * `CfnTopicRule.LambdaActionProperty.FunctionArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-lambdaaction.html#cfn-iot-topicrule-lambdaaction-functionarn
         */
        readonly functionArn?: string;
    }
}
export declare namespace CfnTopicRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-putiteminput.html
     */
    interface PutItemInputProperty {
        /**
         * `CfnTopicRule.PutItemInputProperty.TableName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-putiteminput.html#cfn-iot-topicrule-putiteminput-tablename
         */
        readonly tableName: string;
    }
}
export declare namespace CfnTopicRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-republishaction.html
     */
    interface RepublishActionProperty {
        /**
         * `CfnTopicRule.RepublishActionProperty.RoleArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-republishaction.html#cfn-iot-topicrule-republishaction-rolearn
         */
        readonly roleArn: string;
        /**
         * `CfnTopicRule.RepublishActionProperty.Topic`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-republishaction.html#cfn-iot-topicrule-republishaction-topic
         */
        readonly topic: string;
    }
}
export declare namespace CfnTopicRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-s3action.html
     */
    interface S3ActionProperty {
        /**
         * `CfnTopicRule.S3ActionProperty.BucketName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-s3action.html#cfn-iot-topicrule-s3action-bucketname
         */
        readonly bucketName: string;
        /**
         * `CfnTopicRule.S3ActionProperty.Key`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-s3action.html#cfn-iot-topicrule-s3action-key
         */
        readonly key: string;
        /**
         * `CfnTopicRule.S3ActionProperty.RoleArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-s3action.html#cfn-iot-topicrule-s3action-rolearn
         */
        readonly roleArn: string;
    }
}
export declare namespace CfnTopicRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-snsaction.html
     */
    interface SnsActionProperty {
        /**
         * `CfnTopicRule.SnsActionProperty.MessageFormat`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-snsaction.html#cfn-iot-topicrule-snsaction-messageformat
         */
        readonly messageFormat?: string;
        /**
         * `CfnTopicRule.SnsActionProperty.RoleArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-snsaction.html#cfn-iot-topicrule-snsaction-rolearn
         */
        readonly roleArn: string;
        /**
         * `CfnTopicRule.SnsActionProperty.TargetArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-snsaction.html#cfn-iot-topicrule-snsaction-targetarn
         */
        readonly targetArn: string;
    }
}
export declare namespace CfnTopicRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-sqsaction.html
     */
    interface SqsActionProperty {
        /**
         * `CfnTopicRule.SqsActionProperty.QueueUrl`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-sqsaction.html#cfn-iot-topicrule-sqsaction-queueurl
         */
        readonly queueUrl: string;
        /**
         * `CfnTopicRule.SqsActionProperty.RoleArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-sqsaction.html#cfn-iot-topicrule-sqsaction-rolearn
         */
        readonly roleArn: string;
        /**
         * `CfnTopicRule.SqsActionProperty.UseBase64`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-sqsaction.html#cfn-iot-topicrule-sqsaction-usebase64
         */
        readonly useBase64?: boolean | cdk.IResolvable;
    }
}
export declare namespace CfnTopicRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-stepfunctionsaction.html
     */
    interface StepFunctionsActionProperty {
        /**
         * `CfnTopicRule.StepFunctionsActionProperty.ExecutionNamePrefix`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-stepfunctionsaction.html#cfn-iot-topicrule-stepfunctionsaction-executionnameprefix
         */
        readonly executionNamePrefix?: string;
        /**
         * `CfnTopicRule.StepFunctionsActionProperty.RoleArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-stepfunctionsaction.html#cfn-iot-topicrule-stepfunctionsaction-rolearn
         */
        readonly roleArn: string;
        /**
         * `CfnTopicRule.StepFunctionsActionProperty.StateMachineName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-stepfunctionsaction.html#cfn-iot-topicrule-stepfunctionsaction-statemachinename
         */
        readonly stateMachineName: string;
    }
}
export declare namespace CfnTopicRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-topicrulepayload.html
     */
    interface TopicRulePayloadProperty {
        /**
         * `CfnTopicRule.TopicRulePayloadProperty.Actions`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-topicrulepayload.html#cfn-iot-topicrule-topicrulepayload-actions
         */
        readonly actions: Array<CfnTopicRule.ActionProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnTopicRule.TopicRulePayloadProperty.AwsIotSqlVersion`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-topicrulepayload.html#cfn-iot-topicrule-topicrulepayload-awsiotsqlversion
         */
        readonly awsIotSqlVersion?: string;
        /**
         * `CfnTopicRule.TopicRulePayloadProperty.Description`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-topicrulepayload.html#cfn-iot-topicrule-topicrulepayload-description
         */
        readonly description?: string;
        /**
         * `CfnTopicRule.TopicRulePayloadProperty.ErrorAction`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-topicrulepayload.html#cfn-iot-topicrule-topicrulepayload-erroraction
         */
        readonly errorAction?: CfnTopicRule.ActionProperty | cdk.IResolvable;
        /**
         * `CfnTopicRule.TopicRulePayloadProperty.RuleDisabled`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-topicrulepayload.html#cfn-iot-topicrule-topicrulepayload-ruledisabled
         */
        readonly ruleDisabled: boolean | cdk.IResolvable;
        /**
         * `CfnTopicRule.TopicRulePayloadProperty.Sql`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-topicrulepayload.html#cfn-iot-topicrule-topicrulepayload-sql
         */
        readonly sql: string;
    }
}
