###--- Common PREFIX for SPARQL query ---###
PREFIX_RDFS = 'PREFIX rdfs:   <http://www.w3.org/2000/01/rdf-schema#> '
PREFIX_RDF = 'PREFIX rdf:    <http://www.w3.org/1999/02/22-rdf-syntax-ns#> '
PREFIX_XSD = 'PREFIX xsd:    <http://www.w3.org/2001/XMLSchema#> '
PREFIX_OWL = 'PREFIX owl:    <http://www.w3.org/2002/07/owl#> '
PREFIX_OM = 'PREFIX om:     <http://www.ontology-of-units-of-measure.org/resource/om-2/> '

###--- Common IRI for units of measure ---###
OM_MEASURE = 'http://www.ontology-of-units-of-measure.org/resource/om-2/Measure'
OM_HASPHENOMENON = 'http://www.ontology-of-units-of-measure.org/resource/om-2/hasPhenomenon'
OM_HASVALUE = 'http://www.ontology-of-units-of-measure.org/resource/om-2/hasValue'
OM_HASNUMERICALVALUE = 'http://www.ontology-of-units-of-measure.org/resource/om-2/hasNumericalValue'
OM_HASUNIT = 'http://www.ontology-of-units-of-measure.org/resource/om-2/hasUnit'

###--- Common IRI for Time ---###
TIME_HASTIME = 'http://www.w3.org/2006/time#hasTime'
TIME_NUMERICPOSITION = 'http://www.w3.org/2006/time#numericPosition'
TIME_HASTRS = 'http://www.w3.org/2006/time#hasTRS'
TIME_INTIMEPOSITION = 'http://www.w3.org/2006/time#inTimePosition'

###--- Common IRI for OntoAgent ---###
ONTOAGENT_HASOPERATION = 'http://www.theworldavatar.com/ontology/ontoagent/MSM.owl#hasOperation'
ONTOAGENT_HASINPUT = 'http://www.theworldavatar.com/ontology/ontoagent/MSM.owl#hasInput'
ONTOAGENT_HASMANDATORYPART = 'http://www.theworldavatar.com/ontology/ontoagent/MSM.owl#hasMandatoryPart'
ONTOAGENT_HASTYPE = 'http://www.theworldavatar.com/ontology/ontoagent/MSM.owl#hasType'
ONTOAGENT_HASNAME = 'http://www.theworldavatar.com/ontology/ontoagent/MSM.owl#hasName'

###--- Common IRI for OntoDerivation ---###
ONTODERIVATION_ISDERIVEDFROM = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontoderivation/OntoDerivation.owl#isDerivedFrom'
ONTODERIVATION_DERIVATIONASYN = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontoderivation/OntoDerivation.owl#DerivationAsyn'

###--- IRIs for OntoDoE ---###
ONTODOE_DESIGNOFEXPERIMENT = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontodoe/OntoDoE.owl#DesignOfExperiment'
ONTODOE_STRATEGY = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontodoe/OntoDoE.owl#Strategy'
ONTODOE_TSEMO = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontodoe/OntoDoE.owl#TSEMO'
ONTODOE_LHS = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontodoe/OntoDoE.owl#LHS'
ONTODOE_CRITERION = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontodoe/OntoDoE.owl#Criterion'
ONTODOE_CENTER = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontodoe/OntoDoE.owl#Center'
ONTODOE_MAXIMUM = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontodoe/OntoDoE.owl#Maximum'
ONTODOE_CENTERMAXIMUM = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontodoe/OntoDoE.owl#CenterMaximum'
ONTODOE_CORRELATION = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontodoe/OntoDoE.owl#Correlation'
ONTODOE_DOMAIN = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontodoe/OntoDoE.owl#Domain'
ONTODOE_DESIGNVARIABLE = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontodoe/OntoDoE.owl#DesignVariable'
ONTODOE_CONTINUOUSVARIABLE = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontodoe/OntoDoE.owl#ContinuousVariable'
ONTODOE_CATEGORICALVARIABLE = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontodoe/OntoDoE.owl#CategoricalVariable'
ONTODOE_SYSTEMRESPONSE = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontodoe/OntoDoE.owl#SystemResponse'
ONTODOE_HISTORICALDATA = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontodoe/OntoDoE.owl#HistoricalData'
ONTODOE_NEWEXPERIMENT = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontodoe/OntoDoE.owl#NewExperiment'
ONTODOE_USESSTRATEGY = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontodoe/OntoDoE.owl#usesStrategy'
ONTODOE_HASDOMAIN = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontodoe/OntoDoE.owl#hasDomain'
ONTODOE_HASDESIGNVARIABLE = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontodoe/OntoDoE.owl#hasDesignVariable'
ONTODOE_HASSYSTEMRESPONSE = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontodoe/OntoDoE.owl#hasSystemResponse'
ONTODOE_UTILISESHISTORICALDATA = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontodoe/OntoDoE.owl#utilisesHistoricalData'
ONTODOE_PROPOSESNEWEXPERIMENT = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontodoe/OntoDoE.owl#proposesNewExperiment'
ONTODOE_REFERSTO = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontodoe/OntoDoE.owl#refersTo'
ONTODOE_UPPERLIMIT = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontodoe/OntoDoE.owl#upperLimit'
ONTODOE_LOWERLIMIT = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontodoe/OntoDoE.owl#lowerLimit'
ONTODOE_POSITIONALID = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontodoe/OntoDoE.owl#positionalID'
ONTODOE_MAXIMISE = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontodoe/OntoDoE.owl#maximise'
ONTODOE_NUMOFNEWEXP = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontodoe/OntoDoE.owl#numOfNewExp'
ONTODOE_NRETRIES = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontodoe/OntoDoE.owl#nRetries'
ONTODOE_NSPECTRALPOINTS = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontodoe/OntoDoE.owl#nSpectralPoints'
ONTODOE_NGENERATIONS = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontodoe/OntoDoE.owl#nGenerations'
ONTODOE_POPULATIONSIZE = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontodoe/OntoDoE.owl#populationSize'
ONTODOE_SEED = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontodoe/OntoDoE.owl#seed'

###--- IRIs for OntoRxn ---###
ONTORXN_REACTIONEXPERIMENT = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontorxn/OntoRxn.owl#ReactionExperiment'
ONTORXN_REACTIONVARIATION = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontorxn/OntoRxn.owl#ReactionVariation'
ONTORXN_CHEMICALREACTION = 'http://www.theworldavatar.com/ontology/ontocape/material/substance/reaction_mechanism.owl#ChemicalReaction'
ONTORXN_CATALYST = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontorxn/OntoRxn.owl#Catalyst'
ONTORXN_SOLVENT = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontorxn/OntoRxn.owl#Solvent'
ONTOKIN_PRODUCT = 'http://www.theworldavatar.com/ontology/ontokin/OntoKin.owl#Product'
ONTORXN_TARGETPRODUCT = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontorxn/OntoRxn.owl#TargetProduct'
ONTORXN_IMPURITY = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontorxn/OntoRxn.owl#Impurity'
ONTORXN_PERFORMANCEINDICATOR = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontorxn/OntoRxn.owl#PerformanceIndicator'
ONTORXN_ENVIRONMENTALFACTOR = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontorxn/OntoRxn.owl#EnvironmentalFactor'
ONTORXN_YIELD = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontorxn/OntoRxn.owl#Yield'
ONTORXN_ECOSCORE = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontorxn/OntoRxn.owl#EcoScore'
ONTORXN_CONVERSION = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontorxn/OntoRxn.owl#Conversion'
ONTORXN_SPACETIMEYIELD = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontorxn/OntoRxn.owl#SpaceTimeYield'
ONTORXN_RUNMATERIALCOST = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontorxn/OntoRxn.owl#RunMaterialCost'
ONTORXN_REACTIONCONDITION = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontorxn/OntoRxn.owl#ReactionCondition'
ONTORXN_RESIDENCETIME = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontorxn/OntoRxn.owl#ResidenceTime'
ONTORXN_REACTIONTEMPERATURE = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontorxn/OntoRxn.owl#ReactionTemperature'
ONTORXN_REACTIONPRESSURE = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontorxn/OntoRxn.owl#ReactionPressure'
ONTORXN_STOICHIOMETRYRATIO = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontorxn/OntoRxn.owl#StoichiometryRatio'
ONTORXN_REACTIONSCALE = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontorxn/OntoRxn.owl#ReactionScale'
ONTORXN_INPUTCHEMICAL = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontorxn/OntoRxn.owl#InputChemical'
ONTORXN_OUTPUTCHEMICAL = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontorxn/OntoRxn.owl#OutputChemical'
ONTOCAPE_SINGLEPHASE = 'http://www.theworldavatar.com/ontology/ontocape/material/phase_system/phase_system.owl#SinglePhase'
ONTOCAPE_STATEOFAGGREGATION = 'http://www.theworldavatar.com/ontology/ontocape/material/phase_system/phase_system.owl#StateOfAggregation'
ONTOCAPE_PHASECOMPONENT = 'http://www.theworldavatar.com/ontology/ontocape/material/phase_system/phase_system.owl#PhaseComponent'
ONTOCAPE_COMPOSITION = 'http://www.theworldavatar.com/ontology/ontocape/material/phase_system/phase_system.owl#Composition'
ONTOCAPE_PHASECOMPONENTCONCENTRATION = 'http://www.theworldavatar.com/ontology/ontocape/material/phase_system/phase_system.owl#PhaseComponentConcentration'
ONTOCAPE_PHYSICALCONTEXT = 'http://www.theworldavatar.com/ontology/ontocape/material/phase_system/phase_system.owl#PhysicalContext'
ONTOCAPE_VOLUMEBASEDCONCENTRATION = 'http://www.theworldavatar.com/ontology/ontocape/material/phase_system/phase_system.owl#Volume-BasedConcentration'
ONTOCAPE_MOLARITY = 'http://www.theworldavatar.com/ontology/ontocape/material/phase_system/phase_system.owl#Molarity'
ONTOCAPE_CHEMICALSPECIES = 'http://www.theworldavatar.com/ontology/ontocape/material/substance/substance.owl#ChemicalSpecies'
ONTORXN_HASVARIATION = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontorxn/OntoRxn.owl#hasVariation'
ONTORXN_ISVARIATIONOF = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontorxn/OntoRxn.owl#isVariationOf'
ONTORXN_CONDUCTEDIN = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontorxn/OntoRxn.owl#conductedIn'
ONTORXN_ISOCCURENCEOF = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontorxn/OntoRxn.owl#isOccurenceOf'
ONTORXN_ISREALISEDAS = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontorxn/OntoRxn.owl#isRealisedAs'
ONTOCAPE_CATALYST = 'http://www.theworldavatar.com/ontology/ontocape/material/substance/reaction_mechanism.owl#hasCatalyst'
ONTORXN_HASSOLVENT = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontorxn/OntoRxn.owl#hasSolvent'
ONTORXN_HASRXNTYPE = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontorxn/OntoRxn.owl#hasRxnType'
ONTORXN_HASPERFORMANCEINDICATOR = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontorxn/OntoRxn.owl#hasPerformanceIndicator'
ONTORXN_HASENVIRONMENTALFACTOR = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontorxn/OntoRxn.owl#hasEnvironmentalFactor'
ONTORXN_HASYIELD = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontorxn/OntoRxn.owl#hasYield'
ONTORXN_HASECOSCORE = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontorxn/OntoRxn.owl#hasEcoScore'
ONTORXN_HASCONVERSION = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontorxn/OntoRxn.owl#hasConversion'
ONTORXN_HASSPACETIMEYIELD = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontorxn/OntoRxn.owl#hasSpaceTimeYield'
ONTORXN_HASRUNMATERIALCOST = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontorxn/OntoRxn.owl#hasRunMaterialCost'
ONTORXN_HASREACTIONCONDITION = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontorxn/OntoRxn.owl#hasReactionCondition'
ONTORXN_HASRESTIME = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontorxn/OntoRxn.owl#hasResTime'
ONTORXN_HASRXNTEMPERATURE = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontorxn/OntoRxn.owl#hasRxnTemperature'
ONTORXN_HASRXNPRESSURE = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontorxn/OntoRxn.owl#hasRxnPressure'
ONTORXN_HASSTOICHIOMETRYRATIO = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontorxn/OntoRxn.owl#hasStoichiometryRatio'
ONTORXN_HASRXNSCALE = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontorxn/OntoRxn.owl#hasRxnScale'
ONTORXN_INDICATESMULTIPLICITYOF = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontorxn/OntoRxn.owl#indicatesMultiplicityOf'
ONTORXN_INDICATESUSAGEOF = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontorxn/OntoRxn.owl#indicatesUsageOf'
ONTORXN_HASINPUTCHEMICAL = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontorxn/OntoRxn.owl#hasInputChemical'
ONTORXN_HASOUTPUTCHEMICAL = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontorxn/OntoRxn.owl#hasOutputChemical'
ONTOCAPE_REPRESENTSTHERMODYNAMICBEHAVIOROF = 'http://www.theworldavatar.com/ontology/ontocape/material/material.owl#representsThermodynamicBehaviorOf'
ONTOCAPE_THERMODYNAMICBEHAVIOR = 'http://www.theworldavatar.com/ontology/ontocape/material/material.owl#thermodynamicBehavior'
ONTORXN_ISREALISATIONOF = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontorxn/OntoRxn.owl#isRealisationOf'
ONTOCAPE_HASSTATEOFAGGREGATION = 'http://www.theworldavatar.com/ontology/ontocape/material/phase_system/phase_system.owl#hasStateOfAggregation'
ONTOCAPE_ISCOMPOSEDOFSUBSYSTEM = 'http://www.theworldavatar.com/ontology/ontocape/upper_level/system.owl#isComposedOfSubsystem'
ONTOCAPE_HAS_COMPOSITION = 'http://www.theworldavatar.com/ontology/ontocape/material/phase_system/phase_system.owl#has_composition'
ONTOCAPE_COMPRISESDIRECTLY = 'http://www.theworldavatar.com/ontology/ontocape/upper_level/system.owl#comprisesDirectly'
ONTOCAPE_HAS_PHYSICAL_CONTEXT = 'http://www.theworldavatar.com/ontology/ontocape/material/phase_system/phase_system.owl#has_physical_context'
ONTOCAPE_HASPROPERTY = 'http://www.theworldavatar.com/ontology/ontocape/upper_level/system.owl#hasProperty'
ONTOCAPE_REPRESENTSOCCURENCEOF = 'http://www.theworldavatar.com/ontology/ontocape/material/phase_system/phase_system.owl#representsOccurenceOf'
ONTORXN_HASRINCHI = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontorxn/OntoRxn.owl#hasRInChI'
ONTORXN_HASRDFILE = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontorxn/OntoRxn.owl#hasRDFILE'
ONTORXN_CDXML = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontorxn/OntoRxn.owl#cdXML'
ONTORXN_RXNSMILES = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontorxn/OntoRxn.owl#rxnSMILES'
ONTORXN_RXNCXSMILES = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontorxn/OntoRxn.owl#rxnCXSMILES'

###--- IRIs for OntoLab ---###
ONTOCAPE_REFERSTOMATERIAL = 'http://www.theworldavatar.com/ontology/ontocape/chemical_process_system/CPS_behavior/behavior.owl#refersToMaterial'
DBPEDIA_MANUFACTURER = 'https://dbpedia.org/ontology/manufacturer'
ONTOLAB_CONTAINS = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontolab/OntoLab.owl#contains'
ONTOLAB_HASARGUMENT = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontolab/OntoLab.owl#hasArgument'
ONTOLAB_HASHEIGHT = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontolab/OntoLab.owl#hasHeight'
ONTOLAB_HASLENGTH = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontolab/OntoLab.owl#hasLength'
ONTOLAB_HASPOWERSUPPLY = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontolab/OntoLab.owl#hasPowerSupply'
ONTOLAB_HASPRICE = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontolab/OntoLab.owl#hasPrice'
ONTOLAB_HASQUANTITY = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontolab/OntoLab.owl#hasQuantity'
ONTOLAB_HASSETTING = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontolab/OntoLab.owl#hasSetting'
ONTOLAB_HASWEIGHT = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontolab/OntoLab.owl#hasWeight'
ONTOLAB_HASWIDTH = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontolab/OntoLab.owl#hasWidth'
ONTOLAB_ISCONTAINEDIN = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontolab/OntoLab.owl#isContainedIn'
ONTOLAB_ISPREPAREDBY = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontolab/OntoLab.owl#isPreparedBy'
ONTOLAB_ISSPECIFIEDBY = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontolab/OntoLab.owl#isSpecifiedBy'
ONTOLAB_SPECIFIES = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontolab/OntoLab.owl#specifies'
SAREF_CONSISTSOF = 'https://saref.etsi.org/core/consistsOf'
ONTOLAB_HASARGSTR = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontolab/OntoLab.owl#hasArgStr'
ONTOLAB_HASCMDSTR = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontolab/OntoLab.owl#hasCmdStr'
OM_AMOUNTOFMONEY = 'http://www.ontology-of-units-of-measure.org/resource/om-2/AmountOfMoney'
OM_BODYMASS = 'http://www.ontology-of-units-of-measure.org/resource/om-2/BodyMass'
OM_HEIGHT = 'http://www.ontology-of-units-of-measure.org/resource/om-2/Height'
OM_LENGTH = 'http://www.ontology-of-units-of-measure.org/resource/om-2/Length'
OM_QUANTITY = 'http://www.ontology-of-units-of-measure.org/resource/om-2/Quantity'
OM_WIDTH = 'http://www.ontology-of-units-of-measure.org/resource/om-2/Width'
ONTOCAPE_MATERIALAMOUNT = 'http://www.theworldavatar.com/ontology/ontocape/chemical_process_system/CPS_behavior/behavior.owl#MaterialAmount'
ONTOCAPE_MATERIAL = 'http://www.theworldavatar.com/ontology/ontocape/material/material.owl#Material'
DBPEDIA_ORGANISATION = 'https://dbpedia.org/ontology/Organisation'
ONTOLAB_ARGUMENT = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontolab/OntoLab.owl#Argument'
ONTOLAB_CHEMICALSOLUTION = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontolab/OntoLab.owl#ChemicalSolution'
ONTOLAB_PREPARATIONMETHOD = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontolab/OntoLab.owl#PreparationMethod'
ONTOLAB_DRIED = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontolab/OntoLab.owl#Dried'
ONTOLAB_DURATIONSETTING = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontolab/OntoLab.owl#DurationSetting'
ONTOLAB_PARAMETERSETTING = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontolab/OntoLab.owl#ParameterSetting'
ONTOLAB_EQUIPMENTSETTINGS = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontolab/OntoLab.owl#EquipmentSettings'
ONTOLAB_LABEQUIPMENT = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontolab/OntoLab.owl#LabEquipment'
ONTOLAB_EXTERNALBATTERY = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontolab/OntoLab.owl#ExternalBattery'
ONTOLAB_EXTERNALDC = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontolab/OntoLab.owl#ExternalDC'
ONTOLAB_FLOWRATESETTING = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontolab/OntoLab.owl#FlowRateSetting'
SAREF_DEVICE = 'https://saref.etsi.org/core/Device'
ONTOLAB_LABORATORY = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontolab/OntoLab.owl#Laboratory'
ONTOLAB_LITHIUMBATTERY = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontolab/OntoLab.owl#LithiumBattery'
ONTOLAB_NIMHRECHARGEABLEBATTERY = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontolab/OntoLab.owl#NiMHRechargeableBattery'
ONTOLAB_POWERSUPPLY = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontolab/OntoLab.owl#PowerSupply'
ONTOLAB_REPURIFIED = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontolab/OntoLab.owl#Repurified'
ONTOLAB_SOLARPOWERPACK = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontolab/OntoLab.owl#SolarPowerPack'
ONTOLAB_SPARGED = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontolab/OntoLab.owl#Sparged'
ONTOLAB_SYNTHESISEDINHOUSE = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontolab/OntoLab.owl#SynthesisedInHouse'
ONTOLAB_TEMPERATURESETTING = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontolab/OntoLab.owl#TemperatureSetting'
ONTOLAB_USEDASRECEIVED = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontolab/OntoLab.owl#UsedAsReceived'
ONTOLAB_VOLUMESETTING = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontolab/OntoLab.owl#VolumeSetting'
SAREF_COMMAND = 'https://saref.etsi.org/core/Command'

###--- IRIs for OntoVapourtec ---###
ONTOVAPOURTEC_FILLS = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontovapourtec/OntoVapourtec.owl#fills'
ONTOVAPOURTEC_ISFILLEDWITH = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontovapourtec/OntoVapourtec.owl#isFilledWith'
ONTOVAPOURTEC_HASFILLLEVEL = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontovapourtec/OntoVapourtec.owl#hasFillLevel'
ONTOVAPOURTEC_HASFLOWRATESETTING = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontovapourtec/OntoVapourtec.owl#hasFlowRateSetting'
ONTOVAPOURTEC_HASINTERNALDIAMETER = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontovapourtec/OntoVapourtec.owl#hasInternalDiameter'
ONTOVAPOURTEC_HASMAXLEVEL = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontovapourtec/OntoVapourtec.owl#hasMaxLevel'
ONTOVAPOURTEC_HASREACTORLENGTH = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontovapourtec/OntoVapourtec.owl#hasReactorLength'
ONTOVAPOURTEC_HASREACTORMATERIAL = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontovapourtec/OntoVapourtec.owl#hasReactorMaterial'
ONTOVAPOURTEC_HASREACTORTEMPERATURESETTING = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontovapourtec/OntoVapourtec.owl#hasReactorTemperatureSetting'
ONTOVAPOURTEC_HASREACTORVOLUME = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontovapourtec/OntoVapourtec.owl#hasReactorVolume'
ONTOVAPOURTEC_HASRESIDENCETIMESETTING = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontovapourtec/OntoVapourtec.owl#hasResidenceTimeSetting'
ONTOVAPOURTEC_HASSAMPLELOOPVOLUMESETTING = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontovapourtec/OntoVapourtec.owl#hasSampleLoopVolumeSetting'
ONTOVAPOURTEC_HASSITE = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontovapourtec/OntoVapourtec.owl#hasSite'
ONTOVAPOURTEC_HASWARNINGLEVEL = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontovapourtec/OntoVapourtec.owl#hasWarningLevel'
ONTOVAPOURTEC_HOLDS = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontovapourtec/OntoVapourtec.owl#holds'
ONTOVAPOURTEC_ISHELDIN = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontovapourtec/OntoVapourtec.owl#isHeldIn'
ONTOVAPOURTEC_PUMPSLIQUIDFROM = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontovapourtec/OntoVapourtec.owl#pumpsLiquidFrom'
SAREF_ACCOMPLISHES = 'https://saref.etsi.org/core/accomplishes'
SAREF_ACTSUPON = 'https://saref.etsi.org/core/actsUpon'
SAREF_HASCOMMAND = 'https://saref.etsi.org/core/hasCommand'
SAREF_HASFUNCTION = 'https://saref.etsi.org/core/hasFunction'
SAREF_HASSTATE = 'https://saref.etsi.org/core/hasState'
SAREF_ISACCOMPLISHEDBY = 'https://saref.etsi.org/core/isAccomplishedBy'
SAREF_ISCOMMANDOF = 'https://saref.etsi.org/core/isCommandOf'
SAREF_ISOFFEREDBY = 'https://saref.etsi.org/core/isOfferedBy'
SAREF_OFFERS = 'https://saref.etsi.org/core/offers'
SAREF_REPRESENTS = 'https://saref.etsi.org/core/represents'
OM_DIAMETER = 'http://www.ontology-of-units-of-measure.org/resource/om-2/Diameter'
OM_VOLUME = 'http://www.ontology-of-units-of-measure.org/resource/om-2/Volume'
OM_VOLUMETRICFLOWRATE = 'http://www.ontology-of-units-of-measure.org/resource/om-2/VolumetricFlowRate'
ONTOVAPOURTEC_VIAL = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontovapourtec/OntoVapourtec.owl#Vial'
ONTOVAPOURTEC_AUTOSAMPLER = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontovapourtec/OntoVapourtec.owl#AutoSampler'
ONTOVAPOURTEC_AUTOSAMPLERSITE = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontovapourtec/OntoVapourtec.owl#AutoSamplerSite'
ONTOVAPOURTEC_AUTOSAMPLERFUNCTION = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontovapourtec/OntoVapourtec.owl#AutoSamplerFunction'
ONTOVAPOURTEC_AUTOSAMPLERCOMMAND = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontovapourtec/OntoVapourtec.owl#AutoSamplerCommand'
SAREF_FUNCTION = 'https://saref.etsi.org/core/Function'
ONTOVAPOURTEC_AUTOSAMPLERTASK = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontovapourtec/OntoVapourtec.owl#AutoSamplerTask'
SAREF_TASK = 'https://saref.etsi.org/core/Task'
ONTOVAPOURTEC_CLEANREACTOR = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontovapourtec/OntoVapourtec.owl#CleanReactor'
ONTOVAPOURTEC_VAPOURTECFUNCTION = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontovapourtec/OntoVapourtec.owl#VapourtecFunction'
ONTOVAPOURTEC_CLEARREACTIONS = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontovapourtec/OntoVapourtec.owl#ClearReactions'
ONTOVAPOURTEC_CLEANINGREACTION = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontovapourtec/OntoVapourtec.owl#CleaningReaction'
ONTOVAPOURTEC_VAPOURTECSTATE = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontovapourtec/OntoVapourtec.owl#VapourtecState'
ONTOVAPOURTEC_REACTIONCOMPLETED = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontovapourtec/OntoVapourtec.owl#ReactionCompleted'
ONTOVAPOURTEC_CONNECTTOFLOWCOMMANDER = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontovapourtec/OntoVapourtec.owl#ConnectToFlowCommander'
ONTOVAPOURTEC_INACTIVE = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontovapourtec/OntoVapourtec.owl#Inactive'
ONTOVAPOURTEC_CONNECTION = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontovapourtec/OntoVapourtec.owl#Connection'
ONTOVAPOURTEC_EXPFILEPATH = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontovapourtec/OntoVapourtec.owl#ExpFilePath'
ONTOVAPOURTEC_FAULTRECOVERY = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontovapourtec/OntoVapourtec.owl#FaultRecovery'
ONTOVAPOURTEC_FAULTRECOVERYCOMMAND = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontovapourtec/OntoVapourtec.owl#FaultRecoveryCommand'
ONTOVAPOURTEC_FAULTY = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontovapourtec/OntoVapourtec.owl#Faulty'
ONTOVAPOURTEC_FLOWCHEMISTRY = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontovapourtec/OntoVapourtec.owl#FlowChemistry'
ONTOVAPOURTEC_FLOWCOMMANDER = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontovapourtec/OntoVapourtec.owl#FlowCommander'
SAREF_SERVICE = 'https://saref.etsi.org/core/Service'
ONTOVAPOURTEC_VAPOURTECRS400 = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontovapourtec/OntoVapourtec.owl#VapourtecRS400'
ONTOVAPOURTEC_GETCOMMAND = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontovapourtec/OntoVapourtec.owl#GetCommand'
ONTOVAPOURTEC_GETSTATE = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontovapourtec/OntoVapourtec.owl#GetState'
ONTOVAPOURTEC_IDLE = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontovapourtec/OntoVapourtec.owl#Idle'
ONTOVAPOURTEC_LAUNCH = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontovapourtec/OntoVapourtec.owl#Launch'
ONTOVAPOURTEC_STARTFLOWCOMMANDER = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontovapourtec/OntoVapourtec.owl#StartFlowCommander'
ONTOVAPOURTEC_LOADEXPERIMENT = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontovapourtec/OntoVapourtec.owl#LoadExperiment'
ONTOVAPOURTEC_RUNREACTOR = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontovapourtec/OntoVapourtec.owl#RunReactor'
ONTOVAPOURTEC_NULL = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontovapourtec/OntoVapourtec.owl#Null'
ONTOVAPOURTEC_PUMPSETTINGS = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontovapourtec/OntoVapourtec.owl#PumpSettings'
ONTOVAPOURTEC_VAPOURTECR2PUMP = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontovapourtec/OntoVapourtec.owl#VapourtecR2Pump'
ONTOVAPOURTEC_SAMPLELOOPVOLUMESETTING = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontovapourtec/OntoVapourtec.owl#SampleLoopVolumeSetting'
ONTOVAPOURTEC_REACTORSETTING = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontovapourtec/OntoVapourtec.owl#ReactorSettings'
ONTOVAPOURTEC_VAPOURTECR4REACTOR = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontovapourtec/OntoVapourtec.owl#VapourtecR4Reactor'
ONTOVAPOURTEC_REACTORTEMPERATURESETTING = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontovapourtec/OntoVapourtec.owl#ReactorTemperatureSetting'
ONTOVAPOURTEC_RESIDENCETIMESETTING = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontovapourtec/OntoVapourtec.owl#ResidenceTimeSetting'
ONTOVAPOURTEC_RUNNINGREACTOR = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontovapourtec/OntoVapourtec.owl#RunningReaction'
ONTOVAPOURTEC_VAPOURTECR2PUMPFUNCTION = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontovapourtec/OntoVapourtec.owl#VapourtecR2PumpFunction'
ONTOVAPOURTEC_VAPOURTECR2PUMPCOMMAND = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontovapourtec/OntoVapourtec.owl#VapourtecR2PumpCommand'
ONTOVAPOURTEC_VAPOURTECR2PUMPTASK = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontovapourtec/OntoVapourtec.owl#VapourtecR2PumpTask'
ONTOVAPOURTEC_VAPOURTECR4REACTORFUNCTION = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontovapourtec/OntoVapourtec.owl#VapourtecR4ReactorFunction'
ONTOVAPOURTEC_VAPOURTECR4REACTORCOMMAND = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontovapourtec/OntoVapourtec.owl#VapourtecR4ReactorCommand'
ONTOVAPOURTEC_VAPOURTECR4REACTORTASK = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontovapourtec/OntoVapourtec.owl#VapourtecR4ReactorTask'
SAREF_STATE = 'https://saref.etsi.org/core/State'

###--- IRIs for OntoHPLC ---###
OM_COMMONLYHASUNIT = 'http://www.ontology-of-units-of-measure.org/resource/om-2/commonlyHasUnit'
ONTOHPLC_PEAKAREA = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontohplc/OntoHPLC.owl#PeakArea'
ONTOUOM_MILLIABSORBANCEUNITMULTIPLIESMINUTE = 'http://theworldavatar.com/resource/ontouom/milli_absorbance_unit_multiplies_minute'
ONTOHPLC_ATRETENTIONTIME = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontohplc/OntoHPLC.owl#atRetentionTime'
ONTOHPLC_GENERATEDFOR = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontohplc/OntoHPLC.owl#generatedFor'
ONTOHPLC_HASJOB = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontohplc/OntoHPLC.owl#hasJob'
ONTOHPLC_HASPEAKAREA = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontohplc/OntoHPLC.owl#hasPeakArea'
ONTOHPLC_HASREPORT = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontohplc/OntoHPLC.owl#hasReport'
ONTOHPLC_HASRESPONSEFACTOR = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontohplc/OntoHPLC.owl#hasResponseFactor'
ONTOHPLC_HASRETENTIONTIME = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontohplc/OntoHPLC.owl#hasRetentionTime'
ONTOHPLC_INDICATESCOMPONENT = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontohplc/OntoHPLC.owl#indicatesComponent'
ONTOHPLC_RECORDS = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontohplc/OntoHPLC.owl#records'
ONTOHPLC_REFERSTOSPECIES = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontohplc/OntoHPLC.owl#refersToSpecies'
ONTOHPLC_RESPONSEFACTOR = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontohplc/OntoHPLC.owl#ResponseFactor'
ONTOHPLC_RETENTIONTIME = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontohplc/OntoHPLC.owl#RetentionTime'
ONTOHPLC_USESINTERNALSTANDARD = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontohplc/OntoHPLC.owl#usesInternalStandard'
ONTOHPLC_USESMETHOD = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontohplc/OntoHPLC.owl#usesMethod'
ONTOHPLC_HASREPORTPATH = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontohplc/OntoHPLC.owl#hasReportPath'
ONTOHPLC_HPLCREPORT = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontohplc/OntoHPLC.owl#HPLCReport'
OM_DURATION = 'http://www.ontology-of-units-of-measure.org/resource/om-2/Duration'
OM_QUANTITYOFDIMENSIONONE = 'http://www.ontology-of-units-of-measure.org/resource/om-2/QuantityOfDimensionOne'
ONTOSPECIES_SPECIES = 'http://www.theworldavatar.com/ontology/ontospecies/OntoSpecies.owl#Species'
ONTOHPLC_CHROMATOGRAMMEASUREMENT = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontohplc/OntoHPLC.owl#ChromatogramMeasurement'
ONTOHPLC_CHROMATOGRAMMEASUREMENTCOMMAND = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontohplc/OntoHPLC.owl#ChromatogramMeasurementCommand'
ONTOHPLC_CHROMATOGRAMPOINT = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontohplc/OntoHPLC.owl#ChromatogramPoint'
ONTOHPLC_HPLCJOB = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontohplc/OntoHPLC.owl#HPLCJob'
ONTOHPLC_HPLCMETHOD = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontohplc/OntoHPLC.owl#HPLCMethod'
ONTOHPLC_INTERNALSTANDARD = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontohplc/OntoHPLC.owl#InternalStandard'
ONTOHPLC_HIGHPERFORMANCELIQUIDCHROMATOGRAPHY = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontohplc/OntoHPLC.owl#HighPerformanceLiquidChromatography'
ONTOHPLC_LIQUIDCHROMATOGRAPHY = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontohplc/OntoHPLC.owl#LiquidChromatography'

###--- IRIs for OntoBPR ---###
ONTOBPR_BACKPRESSUREREGULATOR = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontobpr/OntoBPR.owl#BackPressureRegulator'
ONTOBPR_REACTORPRESSURECONTROL = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontobpr/OntoBPR.owl#ReactorPressureControl'
ONTOBPR_PRESSUREADJUSTMENT = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontobpr/OntoBPR.owl#PressureAdjustment'
ONTOBPR_PRESSUREADJUSTMENTCOMMAND = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontobpr/OntoBPR.owl#PressureAdjustmentCommand'
