# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['greenbone', 'greenbone.feed.sync', 'tests']

package_data = \
{'': ['*']}

modules = \
['poetry']
install_requires = \
['rich>=13.2.0']

extras_require = \
{':python_version < "3.11"': ['tomli>=2.0.1,<3.0.0']}

entry_points = \
{'console_scripts': ['greenbone-feed-sync = greenbone.feed.sync.main:main']}

setup_kwargs = {
    'name': 'greenbone-feed-sync',
    'version': '23.1.1',
    'description': 'Synchronization for the Greenbone Community Feed',
    'long_description': '![Greenbone Logo](https://www.greenbone.net/wp-content/uploads/gb_new-logo_horizontal_rgb_small.png)\n\n# greenbone-feed-sync <!-- omit in toc -->\n\nNew script for syncing the Greenbone Community Feed\n\n- [Installation](#installation)\n  - [Requirements](#requirements)\n  - [Install using pip](#install-using-pip)\n- [Usage](#usage)\n- [Settings](#settings)\n  - [verbose](#verbose)\n  - [quiet](#quiet)\n  - [config](#config)\n  - [private-directory](#private-directory)\n  - [compression-level](#compression-level)\n  - [type](#type)\n  - [feed-url](#feed-url)\n  - [destination-prefix](#destination-prefix)\n  - [gvmd-data-destination](#gvmd-data-destination)\n  - [gvmd-data-url](#gvmd-data-url)\n  - [notus-destination](#notus-destination)\n  - [notus-url](#notus-url)\n  - [nasl-destination](#nasl-destination)\n  - [nasl-url](#nasl-url)\n  - [scap-data-destination](#scap-data-destination)\n  - [scap-data-url](#scap-data-url)\n  - [cert-data-destination](#cert-data-destination)\n  - [cert-data-url](#cert-data-url)\n  - [report-formats-destination](#report-formats-destination)\n  - [report-formats-url](#report-formats-url)\n  - [scan-configs-destination](#scan-configs-destination)\n  - [scan-configs-url](#scan-configs-url)\n  - [port-lists-destination](#port-lists-destination)\n  - [port-lists-url](#port-lists-url)\n  - [gvmd-lock-file](#gvmd-lock-file)\n  - [openvas-lock-file](#openvas-lock-file)\n  - [fail-fast](#fail-fast)\n  - [no-wait](#no-wait)\n  - [wait-interval](#wait-interval)\n  - [rsync-timeout](#rsync-timeout)\n- [Config](#config-1)\n- [Development](#development)\n- [Maintainer](#maintainer)\n- [Contributing](#contributing)\n- [License](#license)\n\n## Installation\n\n### Requirements\n\nPython 3.9 and later is supported.\n\n`greenbone-feed-sync` requires the `rsync` tool being installed and available\nwithin the `PATH`.\n\nOn Debian based Distributions like Ubuntu and Kali `rsync` can be installed via\n\n    apt install rsync\n\n### Install using pip\n\nYou can install the latest stable release of **greenbone-feed-sync** from the\nPython Package Index (pypi) using [pip]\n\n    python3 -m pip install greenbone-feed-sync\n\n## Usage\n\nMost of the time you should just run the script without any arguments to\ndownload the new data for all necessary feed types\n\n    greenbone-feed-sync\n\nTo get verbose progress output during the data download you might increase the\nverbosity\n\n    greenbone-feed-sync -vvv\n\n\nIf the script is run in a cron job the output can be turned of via\n\n    greenbone-feed-sync --quiet\n\n## Settings\n\nThe `greenbone-feed-sync` script is adjustable for all kind of purposes and very\nflexible which content gets downloaded. Most likely you will never need to\nadjust the settings because the defaults will suffice. Changing the settings\nis only required for experts and testing purposes.\n\n### verbose\n\n| Name | Value |\n|------|-------|\n| CLI Argument | `--verbose, -v` |\n| Config Variable  | verbose |\n| Environment Variable | `GREENBONE_FEED_SYNC_VERBOSE` |\n| Default Value | 2 |\n| Description | Log verbosity. `-vvv` for maximum verbosity. |\n\n### quiet\n\n| Name | Value |\n|------|-------|\n| CLI Argument | `--quiet` |\n| Config Variable  |  |\n| Environment Variable | |\n| Default Value | |\n| Description | Disable all log output. Same as setting `verbose` or  `GREENBONE_FEED_SYNC_VERBOSE` to 0 |\n\n### config\n\n| Name | Value |\n|------|-------|\n| CLI Argument | `--config, -c` |\n| Config Variable  |  |\n| Environment Variable |  |\n| Default Value | `~/.config/greenbone-feed-sync.toml` and `/etc/gvm/greenbone-feed-sync.toml` |\n| Description | TOML config file to load settings from. |\n\n### private-directory\n\n| Name | Value |\n|------|-------|\n| CLI Argument | `--private-directory` |\n| Config Variable  | private-directory |\n| Environment Variable | `GREENBONE_FEED_SYNC_PRIVATE_DIRECTORY` |\n| Default Value |  |\n| Description | (Sub-)Directory to exclude from the sync which will never get deleted automatically. |\n\n### compression-level\n\n| Name | Value |\n|------|-------|\n| CLI Argument | `--compression-level` |\n| Config Variable  | compression-level |\n| Environment Variable | `GREENBONE_FEED_SYNC_COMPRESSION_LEVEL` |\n| Default Value | 9 |\n| Description | rsync compression level 0-9. (0 - no compression, 9 - high compression) |\n\n### type\n\n| Name | Value |\n|------|-------|\n| CLI Argument | `--type` |\n| Config Variable  |  |\n| Environment Variable |  |\n| Default Value | all  |\n| Description | Specifies which feed data should be downloaded. |\n\n### feed-url\n\n| Name | Value |\n|------|-------|\n| CLI Argument |  |\n| Config Variable  | feed-url |\n| Environment Variable | `GREENBONE_FEED_SYNC_URL` |\n| Default Value | `rsync://feed.community.greenbone.net/community` |\n| Description | URL to download the feed data from. Other URLs will be relative to this URL by default. For example using `rsync://example.com` as feed url the notus url will be `rsync://example.com/vulnerability-feed/22.04/vt-data/notus/`. |\n\n### destination-prefix\n\n| Name | Value |\n|------|-------|\n| CLI Argument |  |\n| Config Variable  | destination-prefix |\n| Environment Variable | `GREENBONE_FEED_SYNC_DESTINATION_PREFIX`  |\n| Default Value | `/var/lib/` |\n| Description | Directory prefix to use for default feed data download destinations. Other download destinations will be relative to this path by default. For example using `/opt/lib` as destination prefix will change the default of the notus destination to `/opt/lib/notus`. |\n\n### gvmd-data-destination\n\n| Name | Value |\n|------|-------|\n| CLI Argument | `--gvmd-data-destination` |\n| Config Variable  | gvmd-data-destination |\n| Environment Variable | `GREENBONE_FEED_SYNC_GVMD_DATA_DESTINATION` |\n| Default Value | `/var/lib/gvm/data-objects/gvmd/22.04/` |\n| Description | Destination of the downloaded gvmd data. |\n\n### gvmd-data-url\n\n| Name | Value |\n|------|-------|\n| CLI Argument | `--gvmd-data-url` |\n| Config Variable  | gvmd-data-url |\n| Environment Variable | `GREENBONE_FEED_SYNC_GVMD_DATA_URL` |\n| Default Value | `rsync://feed.community.greenbone.net/community/data-feed/22.04/` |\n| Description | URL to download the gvmd data from. This includes scan-configs, report-formats and port-lists. |\n\n### notus-destination\n\n| Name | Value |\n|------|-------|\n| CLI Argument | `--notus-destination` |\n| Config Variable  | notus-destination |\n| Environment Variable | `GREENBONE_FEED_SYNC_NOTUS_DESTINATION` |\n| Default Value | `/var/lib/notus` |\n| Description | Destination of the downloaded notus data. |\n\n### notus-url\n\n| Name | Value |\n|------|-------|\n| CLI Argument | `--notus-url` |\n| Config Variable  | notus-url |\n| Environment Variable | `GREENBONE_FEED_SYNC_NOTUS_URL` |\n| Default Value | `rsync://feed.community.greenbone.net/community/vulnerability-feed/22.04/vt-data/notus/` |\n| Description | URL to download the notus data from. |\n\n### nasl-destination\n\n| Name | Value |\n|------|-------|\n| CLI Argument | `--nasl-destination` |\n| Config Variable  | nasl-destination |\n| Environment Variable | `GREENBONE_FEED_SYNC_NASL_DESTINATION` |\n| Default Value | `/var/lib/openvas/plugins` |\n| Description | Destination of the downloaded nasl data. |\n\n### nasl-url\n\n| Name | Value |\n|------|-------|\n| CLI Argument | `--nasl-url` |\n| Config Variable  | nasl-url |\n| Environment Variable | `GREENBONE_FEED_SYNC_NASL_URL` |\n| Default Value | `rsync://feed.community.greenbone.net/community/vulnerability-feed/22.04/vt-data/nasl/` |\n| Description | URL to download the nasl data from. |\n\n### scap-data-destination\n\n| Name | Value |\n|------|-------|\n| CLI Argument | `--scap-data-destination` |\n| Config Variable  | scap-data-destination |\n| Environment Variable | `GREENBONE_FEED_SYNC_SCAP_DATA_DESTINATION` |\n| Default Value | `/var/lib/gvm/scap-data` |\n| Description | Destination of the downloaded SCAP data. |\n\n### scap-data-url\n\n| Name | Value |\n|------|-------|\n| CLI Argument | `--scap-data-url` |\n| Config Variable  | scap-data-url |\n| Environment Variable | `GREENBONE_FEED_SYNC_SCAP_DATA_URL` |\n| Default Value | `rsync://feed.community.greenbone.net/community/vulnerability-feed/22.04/scap-data` |\n| Description | URL to download the SCAP data from. |\n\n### cert-data-destination\n\n| Name | Value |\n|------|-------|\n| CLI Argument | `--cert-data-destination` |\n| Config Variable  | cert-data-destination |\n| Environment Variable | `GREENBONE_FEED_SYNC_CERT_DATA_DESTINATION` |\n| Default Value | `/var/lib/gvm/cert-data` |\n| Description | Destination of the downloaded CERT data. |\n\n### cert-data-url\n\n| Name | Value |\n|------|-------|\n| CLI Argument | `--cert-data-url` |\n| Config Variable  | cert-data-url |\n| Environment Variable | `GREENBONE_FEED_SYNC_CERT_DATA_URL` |\n| Default Value | `rsync://feed.community.greenbone.net/community/vulnerability-feed/22.04/cert-data` |\n| Description | URL to download the CERT data from. |\n\n### report-formats-destination\n\n| Name | Value |\n|------|-------|\n| CLI Argument | `--report-formats-destination` |\n| Config Variable  | report-formats-destination |\n| Environment Variable | `GREENBONE_FEED_SYNC_REPORT_FORMATS_DESTINATION` |\n| Default Value | `/var/lib/gvm/data-objects/gvmd/22.04/report-formats` |\n| Description | Destination of the downloaded report format data. |\n\n### report-formats-url\n\n| Name | Value |\n|------|-------|\n| CLI Argument | `--report-formats-url` |\n| Config Variable  | report-formats-url |\n| Environment Variable | `GREENBONE_FEED_SYNC_REPORT_FORMATS_URL` |\n| Default Value | `rsync://feed.community.greenbone.net/community/data-feed/22.04/report-formats` |\n| Description | URL to download the report format data from. |\n\n### scan-configs-destination\n\n| Name | Value |\n|------|-------|\n| CLI Argument | `--scan-configs-destination` |\n| Config Variable  | scan-configs-destination |\n| Environment Variable | `GREENBONE_FEED_SYNC_SCAN_CONFIGS_DESTINATION` |\n| Default Value | `/var/lib/gvm/data-objects/gvmd/22.04/scan-configs` |\n| Description | Destination of the downloaded scan config data. |\n\n### scan-configs-url\n\n| Name | Value |\n|------|-------|\n| CLI Argument | `--scan-configs-url` |\n| Config Variable  | scan-configs-url |\n| Environment Variable | `GREENBONE_FEED_SYNC_SCAN_CONFIGS_URL` |\n| Default Value | `rsync://feed.community.greenbone.net/community/data-feed/22.04/scan-configs` |\n| Description | URL to download the scan config data from. |\n\n### port-lists-destination\n\n| Name | Value |\n|------|-------|\n| CLI Argument | `--port-lists-destination` |\n| Config Variable  | port-lists-destination |\n| Environment Variable | `GREENBONE_FEED_SYNC_PORT_LISTS_DESTINATION` |\n| Default Value | `/var/lib/gvm/data-objects/gvmd/22.04/port-lists` |\n| Description | Destination of the downloaded port list data. |\n\n### port-lists-url\n\n| Name | Value |\n|------|-------|\n| CLI Argument | `--port-lists-url` |\n| Config Variable  | port-lists-url |\n| Environment Variable | `GREENBONE_FEED_SYNC_PORT_LISTS_URL` |\n| Default Value | `rsync://feed.community.greenbone.net/community/data-feed/22.04/port-lists` |\n| Description | URL to download the port list data from. |\n\n### gvmd-lock-file\n\n| Name | Value |\n|------|-------|\n| CLI Argument | `--gvmd-lock-file` |\n| Config Variable  | gvmd-lock-file |\n| Environment Variable | `GREENBONE_FEED_SYNC_GVMD_LOCK_FILE` |\n| Default Value | `/var/lib/openvas/feed-update.lock` |\n| Description | File to use for locking the feed synchronization for data loaded by the gvmd daemon. Used to avoid that more then one process accesses the feed data at the same time. |\n\n### openvas-lock-file\n\n| Name | Value |\n|------|-------|\n| CLI Argument | `--openvas-lock-file` |\n| Config Variable  | openvas-lock-file |\n| Environment Variable | `GREENBONE_FEED_SYNC_OPENVAS_LOCK_FILE` |\n| Default Value | `/var/lib/gvm/feed-update.lock` |\n| Description | File to use for locking the feed synchronization for data loaded by the openvas scanner. Used to avoid that more then one process accesses the feed data at the same time. |\n\n### fail-fast\n\n| Name | Value |\n|------|-------|\n| CLI Argument | `--fail-fast, --failfast` |\n| Config Variable  | fail-fast |\n| Environment Variable | `GREENBONE_FEED_SYNC_FAIL_FAST` |\n| Default Value | false |\n| Description | Stop after a first error has occurred. Otherwise the script tries to download additional data if specified. |\n\n### no-wait\n\n| Name | Value |\n|------|-------|\n| CLI Argument | `--no-wait` |\n| Config Variable  | no-wait |\n| Environment Variable | `GREENBONE_FEED_SYNC_NO_WAIT` |\n| Default Value | false |\n| Description | Fail directly if the lock file can\'t be acquired. |\n\n### wait-interval\n\n| Name | Value |\n|------|-------|\n| CLI Argument | `--wait-interval` |\n| Config Variable  | wait-interval |\n| Environment Variable | `GREENBONE_FEED_SYNC_LOCK_WAIT_INTERVAL` |\n| Default Value | 5 |\n| Description | Time to wait in seconds after failed lock attempt before re-trying to lock the file. |\n\n### rsync-timeout\n\n| Name | Value |\n|------|-------|\n| CLI Argument | `--rsync-timeout` |\n| Config Variable  | rsync-timeout |\n| Environment Variable | `GREENBONE_FEED_SYNC_RSYNC_TIMEOUT` |\n| Default Value | |\n| Description | Maximum I/O timeout in seconds used for rsync. If no data is transferred for the specified time then rsync will exit. By default no timeout is set and the rsync default will be used. |\n\n## Config\n\nIt is possible to use a config file for loading the settings of the\n`greenbone-feed-sync` script. The config file uses the [TOML] format. Without\nexplicitly passing a config file, `greenbone-feed-sync` tries to load\n`~/.config/greenbone-feed-sync.toml` and if that file doesn\'t exist afterwards\n`/etc/gvm/greenbone-feed-sync.toml`.\n\nExample:\n\n```toml\n[greenbone-feed-sync]\ndestination-prefix = "/opt/greenbone-feed"\nlock-file = "/opt/greenbone-feed.lock"\nno-wait = true\n```\n\n## Development\n\n**greenbone-feed-sync** uses [poetry] for its own dependency management and\nbuild process.\n\nFirst install poetry via pip\n\n    python3 -m pip install --user poetry\n\nAfterwards run\n\n    poetry install\n\nin the checkout directory of **greenbone-feed-sync** (the directory containing\nthe `pyproject.toml` file) to install all dependencies including the packages\nonly required for development.\n\nAfterwards activate the git hooks for auto-formatting and linting via\n[autohooks].\n\n    poetry run autohooks activate\n\nValidate the activated git hooks by running\n\n    poetry run autohooks check\n\n## Maintainer\n\nThis project is maintained by [Greenbone Networks GmbH][Greenbone Networks]\n\n## Contributing\n\nYour contributions are highly appreciated. Please\n[create a pull request](https://github.com/greenbone/greeenbon-feed-sync/pulls)\non GitHub. Bigger changes need to be discussed with the development team via the\n[issues section at GitHub](https://github.com/greenbone/greenbone-feed-sync/issues)\nfirst.\n\n## License\n\nCopyright (C) 2022-2023 [Greenbone Networks GmbH][Greenbone Networks]\n\nLicensed under the [GNU General Public License v3.0 or later](LICENSE).\n\n[Greenbone Networks]: https://www.greenbone.net/\n[poetry]: https://python-poetry.org/\n[pip]: https://pip.pypa.io/\n[autohooks]: https://github.com/greenbone/autohooks\n[TOML]: https://toml.io/\n',
    'author': 'Björn Ricks',
    'author_email': 'bjoern.ricks@greenbone.net',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'py_modules': modules,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
