# Autogenerated. Do not modify.
#
# Profile: 21.60
from typing import List as list
from typing import Optional

from fit_tool.base_type import BaseType
from fit_tool.data_message import DataMessage
from fit_tool.definition_message import DefinitionMessage
from fit_tool.developer_field import DeveloperField
from fit_tool.endian import Endian
from fit_tool.field import Field
from fit_tool.profile.profile_type import *
from fit_tool.sub_field import SubField


class SegmentLapMessage(DataMessage):
    ID = 142
    NAME = 'segment_lap'

    @staticmethod
    def __get_field_size(definition_message: DefinitionMessage, field_id: int) -> int:
        size = 0
        if definition_message:
            field_definition = definition_message.get_field_definition(field_id)
            if field_definition:
                size = field_definition.size

        return size

    def __init__(self, definition_message=None, developer_fields=None, local_id: int = 0,
                 endian: Endian = Endian.LITTLE):
        super().__init__(name=SegmentLapMessage.NAME,
                         global_id=SegmentLapMessage.ID,
                         local_id=definition_message.local_id if definition_message else local_id,
                         endian=definition_message.endian if definition_message else endian,
                         definition_message=definition_message,
                         developer_fields=developer_fields,
                         fields=[
                             MessageIndexField(
                                 size=self.__get_field_size(definition_message, MessageIndexField.ID),
                                 growable=definition_message is None),
                             TimestampField(
                                 size=self.__get_field_size(definition_message, TimestampField.ID),
                                 growable=definition_message is None),
                             SegmentLapEventField(
                                 size=self.__get_field_size(definition_message, SegmentLapEventField.ID),
                                 growable=definition_message is None),
                             SegmentLapEventTypeField(
                                 size=self.__get_field_size(definition_message, SegmentLapEventTypeField.ID),
                                 growable=definition_message is None),
                             SegmentLapStartTimeField(
                                 size=self.__get_field_size(definition_message, SegmentLapStartTimeField.ID),
                                 growable=definition_message is None),
                             SegmentLapStartPositionLatField(
                                 size=self.__get_field_size(definition_message, SegmentLapStartPositionLatField.ID),
                                 growable=definition_message is None),
                             SegmentLapStartPositionLongField(
                                 size=self.__get_field_size(definition_message, SegmentLapStartPositionLongField.ID),
                                 growable=definition_message is None),
                             SegmentLapEndPositionLatField(
                                 size=self.__get_field_size(definition_message, SegmentLapEndPositionLatField.ID),
                                 growable=definition_message is None),
                             SegmentLapEndPositionLongField(
                                 size=self.__get_field_size(definition_message, SegmentLapEndPositionLongField.ID),
                                 growable=definition_message is None),
                             SegmentLapTotalElapsedTimeField(
                                 size=self.__get_field_size(definition_message, SegmentLapTotalElapsedTimeField.ID),
                                 growable=definition_message is None),
                             SegmentLapTotalTimerTimeField(
                                 size=self.__get_field_size(definition_message, SegmentLapTotalTimerTimeField.ID),
                                 growable=definition_message is None),
                             SegmentLapTotalDistanceField(
                                 size=self.__get_field_size(definition_message, SegmentLapTotalDistanceField.ID),
                                 growable=definition_message is None),
                             SegmentLapTotalCyclesField(
                                 size=self.__get_field_size(definition_message, SegmentLapTotalCyclesField.ID),
                                 growable=definition_message is None),
                             SegmentLapTotalCaloriesField(
                                 size=self.__get_field_size(definition_message, SegmentLapTotalCaloriesField.ID),
                                 growable=definition_message is None),
                             SegmentLapTotalFatCaloriesField(
                                 size=self.__get_field_size(definition_message, SegmentLapTotalFatCaloriesField.ID),
                                 growable=definition_message is None),
                             SegmentLapAvgSpeedField(
                                 size=self.__get_field_size(definition_message, SegmentLapAvgSpeedField.ID),
                                 growable=definition_message is None),
                             SegmentLapMaxSpeedField(
                                 size=self.__get_field_size(definition_message, SegmentLapMaxSpeedField.ID),
                                 growable=definition_message is None),
                             SegmentLapAvgHeartRateField(
                                 size=self.__get_field_size(definition_message, SegmentLapAvgHeartRateField.ID),
                                 growable=definition_message is None),
                             SegmentLapMaxHeartRateField(
                                 size=self.__get_field_size(definition_message, SegmentLapMaxHeartRateField.ID),
                                 growable=definition_message is None),
                             SegmentLapAvgCadenceField(
                                 size=self.__get_field_size(definition_message, SegmentLapAvgCadenceField.ID),
                                 growable=definition_message is None),
                             SegmentLapMaxCadenceField(
                                 size=self.__get_field_size(definition_message, SegmentLapMaxCadenceField.ID),
                                 growable=definition_message is None),
                             SegmentLapAvgPowerField(
                                 size=self.__get_field_size(definition_message, SegmentLapAvgPowerField.ID),
                                 growable=definition_message is None),
                             SegmentLapMaxPowerField(
                                 size=self.__get_field_size(definition_message, SegmentLapMaxPowerField.ID),
                                 growable=definition_message is None),
                             SegmentLapTotalAscentField(
                                 size=self.__get_field_size(definition_message, SegmentLapTotalAscentField.ID),
                                 growable=definition_message is None),
                             SegmentLapTotalDescentField(
                                 size=self.__get_field_size(definition_message, SegmentLapTotalDescentField.ID),
                                 growable=definition_message is None),
                             SegmentLapSportField(
                                 size=self.__get_field_size(definition_message, SegmentLapSportField.ID),
                                 growable=definition_message is None),
                             SegmentLapEventGroupField(
                                 size=self.__get_field_size(definition_message, SegmentLapEventGroupField.ID),
                                 growable=definition_message is None),
                             SegmentLapNecLatField(
                                 size=self.__get_field_size(definition_message, SegmentLapNecLatField.ID),
                                 growable=definition_message is None),
                             SegmentLapNecLongField(
                                 size=self.__get_field_size(definition_message, SegmentLapNecLongField.ID),
                                 growable=definition_message is None),
                             SegmentLapSwcLatField(
                                 size=self.__get_field_size(definition_message, SegmentLapSwcLatField.ID),
                                 growable=definition_message is None),
                             SegmentLapSwcLongField(
                                 size=self.__get_field_size(definition_message, SegmentLapSwcLongField.ID),
                                 growable=definition_message is None),
                             SegmentLapNameField(
                                 size=self.__get_field_size(definition_message, SegmentLapNameField.ID),
                                 growable=definition_message is None),
                             SegmentLapNormalizedPowerField(
                                 size=self.__get_field_size(definition_message, SegmentLapNormalizedPowerField.ID),
                                 growable=definition_message is None),
                             SegmentLapLeftRightBalanceField(
                                 size=self.__get_field_size(definition_message, SegmentLapLeftRightBalanceField.ID),
                                 growable=definition_message is None),
                             SegmentLapSubSportField(
                                 size=self.__get_field_size(definition_message, SegmentLapSubSportField.ID),
                                 growable=definition_message is None),
                             SegmentLapTotalWorkField(
                                 size=self.__get_field_size(definition_message, SegmentLapTotalWorkField.ID),
                                 growable=definition_message is None),
                             SegmentLapAvgAltitudeField(
                                 size=self.__get_field_size(definition_message, SegmentLapAvgAltitudeField.ID),
                                 growable=definition_message is None),
                             SegmentLapMaxAltitudeField(
                                 size=self.__get_field_size(definition_message, SegmentLapMaxAltitudeField.ID),
                                 growable=definition_message is None),
                             SegmentLapGpsAccuracyField(
                                 size=self.__get_field_size(definition_message, SegmentLapGpsAccuracyField.ID),
                                 growable=definition_message is None),
                             SegmentLapAvgGradeField(
                                 size=self.__get_field_size(definition_message, SegmentLapAvgGradeField.ID),
                                 growable=definition_message is None),
                             SegmentLapAvgPosGradeField(
                                 size=self.__get_field_size(definition_message, SegmentLapAvgPosGradeField.ID),
                                 growable=definition_message is None),
                             SegmentLapAvgNegGradeField(
                                 size=self.__get_field_size(definition_message, SegmentLapAvgNegGradeField.ID),
                                 growable=definition_message is None),
                             SegmentLapMaxPosGradeField(
                                 size=self.__get_field_size(definition_message, SegmentLapMaxPosGradeField.ID),
                                 growable=definition_message is None),
                             SegmentLapMaxNegGradeField(
                                 size=self.__get_field_size(definition_message, SegmentLapMaxNegGradeField.ID),
                                 growable=definition_message is None),
                             SegmentLapAvgTemperatureField(
                                 size=self.__get_field_size(definition_message, SegmentLapAvgTemperatureField.ID),
                                 growable=definition_message is None),
                             SegmentLapMaxTemperatureField(
                                 size=self.__get_field_size(definition_message, SegmentLapMaxTemperatureField.ID),
                                 growable=definition_message is None),
                             SegmentLapTotalMovingTimeField(
                                 size=self.__get_field_size(definition_message, SegmentLapTotalMovingTimeField.ID),
                                 growable=definition_message is None),
                             SegmentLapAvgPosVerticalSpeedField(
                                 size=self.__get_field_size(definition_message, SegmentLapAvgPosVerticalSpeedField.ID),
                                 growable=definition_message is None),
                             SegmentLapAvgNegVerticalSpeedField(
                                 size=self.__get_field_size(definition_message, SegmentLapAvgNegVerticalSpeedField.ID),
                                 growable=definition_message is None),
                             SegmentLapMaxPosVerticalSpeedField(
                                 size=self.__get_field_size(definition_message, SegmentLapMaxPosVerticalSpeedField.ID),
                                 growable=definition_message is None),
                             SegmentLapMaxNegVerticalSpeedField(
                                 size=self.__get_field_size(definition_message, SegmentLapMaxNegVerticalSpeedField.ID),
                                 growable=definition_message is None),
                             SegmentLapTimeInHrZoneField(
                                 size=self.__get_field_size(definition_message, SegmentLapTimeInHrZoneField.ID),
                                 growable=definition_message is None),
                             SegmentLapTimeInSpeedZoneField(
                                 size=self.__get_field_size(definition_message, SegmentLapTimeInSpeedZoneField.ID),
                                 growable=definition_message is None),
                             SegmentLapTimeInCadenceZoneField(
                                 size=self.__get_field_size(definition_message, SegmentLapTimeInCadenceZoneField.ID),
                                 growable=definition_message is None),
                             SegmentLapTimeInPowerZoneField(
                                 size=self.__get_field_size(definition_message, SegmentLapTimeInPowerZoneField.ID),
                                 growable=definition_message is None),
                             SegmentLapRepetitionNumField(
                                 size=self.__get_field_size(definition_message, SegmentLapRepetitionNumField.ID),
                                 growable=definition_message is None),
                             SegmentLapMinAltitudeField(
                                 size=self.__get_field_size(definition_message, SegmentLapMinAltitudeField.ID),
                                 growable=definition_message is None),
                             SegmentLapMinHeartRateField(
                                 size=self.__get_field_size(definition_message, SegmentLapMinHeartRateField.ID),
                                 growable=definition_message is None),
                             SegmentLapActiveTimeField(
                                 size=self.__get_field_size(definition_message, SegmentLapActiveTimeField.ID),
                                 growable=definition_message is None),
                             SegmentLapWorkoutStepIndexField(
                                 size=self.__get_field_size(definition_message, SegmentLapWorkoutStepIndexField.ID),
                                 growable=definition_message is None),
                             SegmentLapSportEventField(
                                 size=self.__get_field_size(definition_message, SegmentLapSportEventField.ID),
                                 growable=definition_message is None),
                             SegmentLapAvgLeftTorqueEffectivenessField(
                                 size=self.__get_field_size(definition_message,
                                                            SegmentLapAvgLeftTorqueEffectivenessField.ID),
                                 growable=definition_message is None),
                             SegmentLapAvgRightTorqueEffectivenessField(
                                 size=self.__get_field_size(definition_message,
                                                            SegmentLapAvgRightTorqueEffectivenessField.ID),
                                 growable=definition_message is None),
                             SegmentLapAvgLeftPedalSmoothnessField(
                                 size=self.__get_field_size(definition_message,
                                                            SegmentLapAvgLeftPedalSmoothnessField.ID),
                                 growable=definition_message is None),
                             SegmentLapAvgRightPedalSmoothnessField(
                                 size=self.__get_field_size(definition_message,
                                                            SegmentLapAvgRightPedalSmoothnessField.ID),
                                 growable=definition_message is None),
                             SegmentLapAvgCombinedPedalSmoothnessField(
                                 size=self.__get_field_size(definition_message,
                                                            SegmentLapAvgCombinedPedalSmoothnessField.ID),
                                 growable=definition_message is None),
                             SegmentLapStatusField(
                                 size=self.__get_field_size(definition_message, SegmentLapStatusField.ID),
                                 growable=definition_message is None),
                             SegmentLapUuidField(
                                 size=self.__get_field_size(definition_message, SegmentLapUuidField.ID),
                                 growable=definition_message is None),
                             SegmentLapAvgFractionalCadenceField(
                                 size=self.__get_field_size(definition_message, SegmentLapAvgFractionalCadenceField.ID),
                                 growable=definition_message is None),
                             SegmentLapMaxFractionalCadenceField(
                                 size=self.__get_field_size(definition_message, SegmentLapMaxFractionalCadenceField.ID),
                                 growable=definition_message is None),
                             SegmentLapTotalFractionalCyclesField(
                                 size=self.__get_field_size(definition_message,
                                                            SegmentLapTotalFractionalCyclesField.ID),
                                 growable=definition_message is None),
                             SegmentLapFrontGearShiftCountField(
                                 size=self.__get_field_size(definition_message, SegmentLapFrontGearShiftCountField.ID),
                                 growable=definition_message is None),
                             SegmentLapRearGearShiftCountField(
                                 size=self.__get_field_size(definition_message, SegmentLapRearGearShiftCountField.ID),
                                 growable=definition_message is None),
                             SegmentLapTimeStandingField(
                                 size=self.__get_field_size(definition_message, SegmentLapTimeStandingField.ID),
                                 growable=definition_message is None),
                             SegmentLapStandCountField(
                                 size=self.__get_field_size(definition_message, SegmentLapStandCountField.ID),
                                 growable=definition_message is None),
                             SegmentLapAvgLeftPcoField(
                                 size=self.__get_field_size(definition_message, SegmentLapAvgLeftPcoField.ID),
                                 growable=definition_message is None),
                             SegmentLapAvgRightPcoField(
                                 size=self.__get_field_size(definition_message, SegmentLapAvgRightPcoField.ID),
                                 growable=definition_message is None),
                             SegmentLapAvgLeftPowerPhaseField(
                                 size=self.__get_field_size(definition_message, SegmentLapAvgLeftPowerPhaseField.ID),
                                 growable=definition_message is None),
                             SegmentLapAvgLeftPowerPhasePeakField(
                                 size=self.__get_field_size(definition_message,
                                                            SegmentLapAvgLeftPowerPhasePeakField.ID),
                                 growable=definition_message is None),
                             SegmentLapAvgRightPowerPhaseField(
                                 size=self.__get_field_size(definition_message, SegmentLapAvgRightPowerPhaseField.ID),
                                 growable=definition_message is None),
                             SegmentLapAvgRightPowerPhasePeakField(
                                 size=self.__get_field_size(definition_message,
                                                            SegmentLapAvgRightPowerPhasePeakField.ID),
                                 growable=definition_message is None),
                             SegmentLapAvgPowerPositionField(
                                 size=self.__get_field_size(definition_message, SegmentLapAvgPowerPositionField.ID),
                                 growable=definition_message is None),
                             SegmentLapMaxPowerPositionField(
                                 size=self.__get_field_size(definition_message, SegmentLapMaxPowerPositionField.ID),
                                 growable=definition_message is None),
                             SegmentLapAvgCadencePositionField(
                                 size=self.__get_field_size(definition_message, SegmentLapAvgCadencePositionField.ID),
                                 growable=definition_message is None),
                             SegmentLapMaxCadencePositionField(
                                 size=self.__get_field_size(definition_message, SegmentLapMaxCadencePositionField.ID),
                                 growable=definition_message is None),
                             SegmentLapManufacturerField(
                                 size=self.__get_field_size(definition_message, SegmentLapManufacturerField.ID),
                                 growable=definition_message is None),
                             SegmentLapTotalGritField(
                                 size=self.__get_field_size(definition_message, SegmentLapTotalGritField.ID),
                                 growable=definition_message is None),
                             SegmentLapTotalFlowField(
                                 size=self.__get_field_size(definition_message, SegmentLapTotalFlowField.ID),
                                 growable=definition_message is None),
                             SegmentLapAvgGritField(
                                 size=self.__get_field_size(definition_message, SegmentLapAvgGritField.ID),
                                 growable=definition_message is None),
                             SegmentLapAvgFlowField(
                                 size=self.__get_field_size(definition_message, SegmentLapAvgFlowField.ID),
                                 growable=definition_message is None),
                             SegmentLapTotalFractionalAscentField(
                                 size=self.__get_field_size(definition_message,
                                                            SegmentLapTotalFractionalAscentField.ID),
                                 growable=definition_message is None),
                             SegmentLapTotalFractionalDescentField(
                                 size=self.__get_field_size(definition_message,
                                                            SegmentLapTotalFractionalDescentField.ID),
                                 growable=definition_message is None)
                         ])

        self.growable = self.definition_message is None

    @classmethod
    def from_bytes(cls, definition_message: DefinitionMessage, developer_fields: list[DeveloperField],
                   bytes_buffer: bytes, offset: int = 0):
        message = cls(definition_message=definition_message, developer_fields=developer_fields)
        message.read_from_bytes(bytes_buffer, offset)
        return message

    @property
    def message_index(self) -> Optional[int]:
        field = self.get_field(MessageIndexField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @message_index.setter
    def message_index(self, value: int):
        field = self.get_field(MessageIndexField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    # timestamp : milliseconds from January 1st, 1970 at 00:00:00 UTC

    @property
    def timestamp(self) -> Optional[int]:
        field = self.get_field(TimestampField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    # timestamp : milliseconds from January 1st, 1970 at 00:00:00 UTC

    @timestamp.setter
    def timestamp(self, value: int):
        field = self.get_field(TimestampField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def event(self) -> Optional[Event]:
        field = self.get_field(SegmentLapEventField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @event.setter
    def event(self, value: Event):
        field = self.get_field(SegmentLapEventField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def event_type(self) -> Optional[EventType]:
        field = self.get_field(SegmentLapEventTypeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @event_type.setter
    def event_type(self, value: EventType):
        field = self.get_field(SegmentLapEventTypeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    # timestamp : milliseconds from January 1st, 1970 at 00:00:00 UTC

    @property
    def start_time(self) -> Optional[int]:
        field = self.get_field(SegmentLapStartTimeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    # timestamp : milliseconds from January 1st, 1970 at 00:00:00 UTC

    @start_time.setter
    def start_time(self, value: int):
        field = self.get_field(SegmentLapStartTimeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def start_position_lat(self) -> Optional[float]:
        field = self.get_field(SegmentLapStartPositionLatField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @start_position_lat.setter
    def start_position_lat(self, value: float):
        field = self.get_field(SegmentLapStartPositionLatField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def start_position_long(self) -> Optional[float]:
        field = self.get_field(SegmentLapStartPositionLongField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @start_position_long.setter
    def start_position_long(self, value: float):
        field = self.get_field(SegmentLapStartPositionLongField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def end_position_lat(self) -> Optional[float]:
        field = self.get_field(SegmentLapEndPositionLatField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @end_position_lat.setter
    def end_position_lat(self, value: float):
        field = self.get_field(SegmentLapEndPositionLatField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def end_position_long(self) -> Optional[float]:
        field = self.get_field(SegmentLapEndPositionLongField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @end_position_long.setter
    def end_position_long(self, value: float):
        field = self.get_field(SegmentLapEndPositionLongField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def total_elapsed_time(self) -> Optional[float]:
        field = self.get_field(SegmentLapTotalElapsedTimeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @total_elapsed_time.setter
    def total_elapsed_time(self, value: float):
        field = self.get_field(SegmentLapTotalElapsedTimeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def total_timer_time(self) -> Optional[float]:
        field = self.get_field(SegmentLapTotalTimerTimeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @total_timer_time.setter
    def total_timer_time(self, value: float):
        field = self.get_field(SegmentLapTotalTimerTimeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def total_distance(self) -> Optional[float]:
        field = self.get_field(SegmentLapTotalDistanceField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @total_distance.setter
    def total_distance(self, value: float):
        field = self.get_field(SegmentLapTotalDistanceField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def total_cycles(self) -> Optional[int]:
        field = self.get_field(SegmentLapTotalCyclesField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @total_cycles.setter
    def total_cycles(self, value: int):
        field = self.get_field(SegmentLapTotalCyclesField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def total_strokes(self) -> Optional[int]:
        field = self.get_field(SegmentLapTotalCyclesField.ID)
        type_field = self.get_field(SegmentLapSportField.ID)

        is_sub_field_valid = type_field and type_field.get_value() in [2]
        if field and field.is_valid() and is_sub_field_valid:
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @total_strokes.setter
    def total_strokes(self, value: int):
        field = self.get_field(SegmentLapTotalCyclesField.ID)
        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def total_calories(self) -> Optional[int]:
        field = self.get_field(SegmentLapTotalCaloriesField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @total_calories.setter
    def total_calories(self, value: int):
        field = self.get_field(SegmentLapTotalCaloriesField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def total_fat_calories(self) -> Optional[int]:
        field = self.get_field(SegmentLapTotalFatCaloriesField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @total_fat_calories.setter
    def total_fat_calories(self, value: int):
        field = self.get_field(SegmentLapTotalFatCaloriesField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_speed(self) -> Optional[float]:
        field = self.get_field(SegmentLapAvgSpeedField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_speed.setter
    def avg_speed(self, value: float):
        field = self.get_field(SegmentLapAvgSpeedField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def max_speed(self) -> Optional[float]:
        field = self.get_field(SegmentLapMaxSpeedField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @max_speed.setter
    def max_speed(self, value: float):
        field = self.get_field(SegmentLapMaxSpeedField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_heart_rate(self) -> Optional[int]:
        field = self.get_field(SegmentLapAvgHeartRateField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_heart_rate.setter
    def avg_heart_rate(self, value: int):
        field = self.get_field(SegmentLapAvgHeartRateField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def max_heart_rate(self) -> Optional[int]:
        field = self.get_field(SegmentLapMaxHeartRateField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @max_heart_rate.setter
    def max_heart_rate(self, value: int):
        field = self.get_field(SegmentLapMaxHeartRateField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_cadence(self) -> Optional[int]:
        field = self.get_field(SegmentLapAvgCadenceField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_cadence.setter
    def avg_cadence(self, value: int):
        field = self.get_field(SegmentLapAvgCadenceField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def max_cadence(self) -> Optional[int]:
        field = self.get_field(SegmentLapMaxCadenceField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @max_cadence.setter
    def max_cadence(self, value: int):
        field = self.get_field(SegmentLapMaxCadenceField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_power(self) -> Optional[int]:
        field = self.get_field(SegmentLapAvgPowerField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_power.setter
    def avg_power(self, value: int):
        field = self.get_field(SegmentLapAvgPowerField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def max_power(self) -> Optional[int]:
        field = self.get_field(SegmentLapMaxPowerField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @max_power.setter
    def max_power(self, value: int):
        field = self.get_field(SegmentLapMaxPowerField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def total_ascent(self) -> Optional[int]:
        field = self.get_field(SegmentLapTotalAscentField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @total_ascent.setter
    def total_ascent(self, value: int):
        field = self.get_field(SegmentLapTotalAscentField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def total_descent(self) -> Optional[int]:
        field = self.get_field(SegmentLapTotalDescentField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @total_descent.setter
    def total_descent(self, value: int):
        field = self.get_field(SegmentLapTotalDescentField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def sport(self) -> Optional[Sport]:
        field = self.get_field(SegmentLapSportField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @sport.setter
    def sport(self, value: Sport):
        field = self.get_field(SegmentLapSportField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def event_group(self) -> Optional[int]:
        field = self.get_field(SegmentLapEventGroupField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @event_group.setter
    def event_group(self, value: int):
        field = self.get_field(SegmentLapEventGroupField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def nec_lat(self) -> Optional[float]:
        field = self.get_field(SegmentLapNecLatField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @nec_lat.setter
    def nec_lat(self, value: float):
        field = self.get_field(SegmentLapNecLatField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def nec_long(self) -> Optional[float]:
        field = self.get_field(SegmentLapNecLongField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @nec_long.setter
    def nec_long(self, value: float):
        field = self.get_field(SegmentLapNecLongField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def swc_lat(self) -> Optional[float]:
        field = self.get_field(SegmentLapSwcLatField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @swc_lat.setter
    def swc_lat(self, value: float):
        field = self.get_field(SegmentLapSwcLatField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def swc_long(self) -> Optional[float]:
        field = self.get_field(SegmentLapSwcLongField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @swc_long.setter
    def swc_long(self, value: float):
        field = self.get_field(SegmentLapSwcLongField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def segment_lap_name(self) -> Optional[str]:
        field = self.get_field(SegmentLapNameField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @segment_lap_name.setter
    def segment_lap_name(self, value: str):
        field = self.get_field(SegmentLapNameField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def normalized_power(self) -> Optional[int]:
        field = self.get_field(SegmentLapNormalizedPowerField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @normalized_power.setter
    def normalized_power(self, value: int):
        field = self.get_field(SegmentLapNormalizedPowerField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def left_right_balance(self) -> Optional[int]:
        field = self.get_field(SegmentLapLeftRightBalanceField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @left_right_balance.setter
    def left_right_balance(self, value: int):
        field = self.get_field(SegmentLapLeftRightBalanceField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def sub_sport(self) -> Optional[SubSport]:
        field = self.get_field(SegmentLapSubSportField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @sub_sport.setter
    def sub_sport(self, value: SubSport):
        field = self.get_field(SegmentLapSubSportField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def total_work(self) -> Optional[int]:
        field = self.get_field(SegmentLapTotalWorkField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @total_work.setter
    def total_work(self, value: int):
        field = self.get_field(SegmentLapTotalWorkField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_altitude(self) -> Optional[float]:
        field = self.get_field(SegmentLapAvgAltitudeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_altitude.setter
    def avg_altitude(self, value: float):
        field = self.get_field(SegmentLapAvgAltitudeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def max_altitude(self) -> Optional[float]:
        field = self.get_field(SegmentLapMaxAltitudeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @max_altitude.setter
    def max_altitude(self, value: float):
        field = self.get_field(SegmentLapMaxAltitudeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def gps_accuracy(self) -> Optional[int]:
        field = self.get_field(SegmentLapGpsAccuracyField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @gps_accuracy.setter
    def gps_accuracy(self, value: int):
        field = self.get_field(SegmentLapGpsAccuracyField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_grade(self) -> Optional[float]:
        field = self.get_field(SegmentLapAvgGradeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_grade.setter
    def avg_grade(self, value: float):
        field = self.get_field(SegmentLapAvgGradeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_pos_grade(self) -> Optional[float]:
        field = self.get_field(SegmentLapAvgPosGradeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_pos_grade.setter
    def avg_pos_grade(self, value: float):
        field = self.get_field(SegmentLapAvgPosGradeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_neg_grade(self) -> Optional[float]:
        field = self.get_field(SegmentLapAvgNegGradeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_neg_grade.setter
    def avg_neg_grade(self, value: float):
        field = self.get_field(SegmentLapAvgNegGradeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def max_pos_grade(self) -> Optional[float]:
        field = self.get_field(SegmentLapMaxPosGradeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @max_pos_grade.setter
    def max_pos_grade(self, value: float):
        field = self.get_field(SegmentLapMaxPosGradeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def max_neg_grade(self) -> Optional[float]:
        field = self.get_field(SegmentLapMaxNegGradeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @max_neg_grade.setter
    def max_neg_grade(self, value: float):
        field = self.get_field(SegmentLapMaxNegGradeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_temperature(self) -> Optional[int]:
        field = self.get_field(SegmentLapAvgTemperatureField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_temperature.setter
    def avg_temperature(self, value: int):
        field = self.get_field(SegmentLapAvgTemperatureField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def max_temperature(self) -> Optional[int]:
        field = self.get_field(SegmentLapMaxTemperatureField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @max_temperature.setter
    def max_temperature(self, value: int):
        field = self.get_field(SegmentLapMaxTemperatureField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def total_moving_time(self) -> Optional[float]:
        field = self.get_field(SegmentLapTotalMovingTimeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @total_moving_time.setter
    def total_moving_time(self, value: float):
        field = self.get_field(SegmentLapTotalMovingTimeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_pos_vertical_speed(self) -> Optional[float]:
        field = self.get_field(SegmentLapAvgPosVerticalSpeedField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_pos_vertical_speed.setter
    def avg_pos_vertical_speed(self, value: float):
        field = self.get_field(SegmentLapAvgPosVerticalSpeedField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_neg_vertical_speed(self) -> Optional[float]:
        field = self.get_field(SegmentLapAvgNegVerticalSpeedField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_neg_vertical_speed.setter
    def avg_neg_vertical_speed(self, value: float):
        field = self.get_field(SegmentLapAvgNegVerticalSpeedField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def max_pos_vertical_speed(self) -> Optional[float]:
        field = self.get_field(SegmentLapMaxPosVerticalSpeedField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @max_pos_vertical_speed.setter
    def max_pos_vertical_speed(self, value: float):
        field = self.get_field(SegmentLapMaxPosVerticalSpeedField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def max_neg_vertical_speed(self) -> Optional[float]:
        field = self.get_field(SegmentLapMaxNegVerticalSpeedField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @max_neg_vertical_speed.setter
    def max_neg_vertical_speed(self, value: float):
        field = self.get_field(SegmentLapMaxNegVerticalSpeedField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def time_in_hr_zone(self) -> Optional[list[float]]:
        field = self.get_field(SegmentLapTimeInHrZoneField.ID)
        if field and field.is_valid():
            return field.get_values()
        else:
            return None

    @time_in_hr_zone.setter
    def time_in_hr_zone(self, value: list[float]):
        field = self.get_field(SegmentLapTimeInHrZoneField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                field.set_values(value)

    @property
    def time_in_speed_zone(self) -> Optional[list[float]]:
        field = self.get_field(SegmentLapTimeInSpeedZoneField.ID)
        if field and field.is_valid():
            return field.get_values()
        else:
            return None

    @time_in_speed_zone.setter
    def time_in_speed_zone(self, value: list[float]):
        field = self.get_field(SegmentLapTimeInSpeedZoneField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                field.set_values(value)

    @property
    def time_in_cadence_zone(self) -> Optional[list[float]]:
        field = self.get_field(SegmentLapTimeInCadenceZoneField.ID)
        if field and field.is_valid():
            return field.get_values()
        else:
            return None

    @time_in_cadence_zone.setter
    def time_in_cadence_zone(self, value: list[float]):
        field = self.get_field(SegmentLapTimeInCadenceZoneField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                field.set_values(value)

    @property
    def time_in_power_zone(self) -> Optional[list[float]]:
        field = self.get_field(SegmentLapTimeInPowerZoneField.ID)
        if field and field.is_valid():
            return field.get_values()
        else:
            return None

    @time_in_power_zone.setter
    def time_in_power_zone(self, value: list[float]):
        field = self.get_field(SegmentLapTimeInPowerZoneField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                field.set_values(value)

    @property
    def repetition_num(self) -> Optional[int]:
        field = self.get_field(SegmentLapRepetitionNumField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @repetition_num.setter
    def repetition_num(self, value: int):
        field = self.get_field(SegmentLapRepetitionNumField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def min_altitude(self) -> Optional[float]:
        field = self.get_field(SegmentLapMinAltitudeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @min_altitude.setter
    def min_altitude(self, value: float):
        field = self.get_field(SegmentLapMinAltitudeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def min_heart_rate(self) -> Optional[int]:
        field = self.get_field(SegmentLapMinHeartRateField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @min_heart_rate.setter
    def min_heart_rate(self, value: int):
        field = self.get_field(SegmentLapMinHeartRateField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def active_time(self) -> Optional[float]:
        field = self.get_field(SegmentLapActiveTimeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @active_time.setter
    def active_time(self, value: float):
        field = self.get_field(SegmentLapActiveTimeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def workout_step_index(self) -> Optional[int]:
        field = self.get_field(SegmentLapWorkoutStepIndexField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @workout_step_index.setter
    def workout_step_index(self, value: int):
        field = self.get_field(SegmentLapWorkoutStepIndexField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def sport_event(self) -> Optional[SportEvent]:
        field = self.get_field(SegmentLapSportEventField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @sport_event.setter
    def sport_event(self, value: SportEvent):
        field = self.get_field(SegmentLapSportEventField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_left_torque_effectiveness(self) -> Optional[float]:
        field = self.get_field(SegmentLapAvgLeftTorqueEffectivenessField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_left_torque_effectiveness.setter
    def avg_left_torque_effectiveness(self, value: float):
        field = self.get_field(SegmentLapAvgLeftTorqueEffectivenessField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_right_torque_effectiveness(self) -> Optional[float]:
        field = self.get_field(SegmentLapAvgRightTorqueEffectivenessField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_right_torque_effectiveness.setter
    def avg_right_torque_effectiveness(self, value: float):
        field = self.get_field(SegmentLapAvgRightTorqueEffectivenessField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_left_pedal_smoothness(self) -> Optional[float]:
        field = self.get_field(SegmentLapAvgLeftPedalSmoothnessField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_left_pedal_smoothness.setter
    def avg_left_pedal_smoothness(self, value: float):
        field = self.get_field(SegmentLapAvgLeftPedalSmoothnessField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_right_pedal_smoothness(self) -> Optional[float]:
        field = self.get_field(SegmentLapAvgRightPedalSmoothnessField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_right_pedal_smoothness.setter
    def avg_right_pedal_smoothness(self, value: float):
        field = self.get_field(SegmentLapAvgRightPedalSmoothnessField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_combined_pedal_smoothness(self) -> Optional[float]:
        field = self.get_field(SegmentLapAvgCombinedPedalSmoothnessField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_combined_pedal_smoothness.setter
    def avg_combined_pedal_smoothness(self, value: float):
        field = self.get_field(SegmentLapAvgCombinedPedalSmoothnessField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def status(self) -> Optional[SegmentLapStatus]:
        field = self.get_field(SegmentLapStatusField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @status.setter
    def status(self, value: SegmentLapStatus):
        field = self.get_field(SegmentLapStatusField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def uuid(self) -> Optional[str]:
        field = self.get_field(SegmentLapUuidField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @uuid.setter
    def uuid(self, value: str):
        field = self.get_field(SegmentLapUuidField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_fractional_cadence(self) -> Optional[float]:
        field = self.get_field(SegmentLapAvgFractionalCadenceField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_fractional_cadence.setter
    def avg_fractional_cadence(self, value: float):
        field = self.get_field(SegmentLapAvgFractionalCadenceField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def max_fractional_cadence(self) -> Optional[float]:
        field = self.get_field(SegmentLapMaxFractionalCadenceField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @max_fractional_cadence.setter
    def max_fractional_cadence(self, value: float):
        field = self.get_field(SegmentLapMaxFractionalCadenceField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def total_fractional_cycles(self) -> Optional[float]:
        field = self.get_field(SegmentLapTotalFractionalCyclesField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @total_fractional_cycles.setter
    def total_fractional_cycles(self, value: float):
        field = self.get_field(SegmentLapTotalFractionalCyclesField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def front_gear_shift_count(self) -> Optional[int]:
        field = self.get_field(SegmentLapFrontGearShiftCountField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @front_gear_shift_count.setter
    def front_gear_shift_count(self, value: int):
        field = self.get_field(SegmentLapFrontGearShiftCountField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def rear_gear_shift_count(self) -> Optional[int]:
        field = self.get_field(SegmentLapRearGearShiftCountField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @rear_gear_shift_count.setter
    def rear_gear_shift_count(self, value: int):
        field = self.get_field(SegmentLapRearGearShiftCountField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def time_standing(self) -> Optional[float]:
        field = self.get_field(SegmentLapTimeStandingField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @time_standing.setter
    def time_standing(self, value: float):
        field = self.get_field(SegmentLapTimeStandingField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def stand_count(self) -> Optional[int]:
        field = self.get_field(SegmentLapStandCountField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @stand_count.setter
    def stand_count(self, value: int):
        field = self.get_field(SegmentLapStandCountField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_left_pco(self) -> Optional[int]:
        field = self.get_field(SegmentLapAvgLeftPcoField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_left_pco.setter
    def avg_left_pco(self, value: int):
        field = self.get_field(SegmentLapAvgLeftPcoField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_right_pco(self) -> Optional[int]:
        field = self.get_field(SegmentLapAvgRightPcoField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_right_pco.setter
    def avg_right_pco(self, value: int):
        field = self.get_field(SegmentLapAvgRightPcoField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_left_power_phase(self) -> Optional[list[float]]:
        field = self.get_field(SegmentLapAvgLeftPowerPhaseField.ID)
        if field and field.is_valid():
            return field.get_values()
        else:
            return None

    @avg_left_power_phase.setter
    def avg_left_power_phase(self, value: list[float]):
        field = self.get_field(SegmentLapAvgLeftPowerPhaseField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                field.set_values(value)

    @property
    def avg_left_power_phase_peak(self) -> Optional[list[float]]:
        field = self.get_field(SegmentLapAvgLeftPowerPhasePeakField.ID)
        if field and field.is_valid():
            return field.get_values()
        else:
            return None

    @avg_left_power_phase_peak.setter
    def avg_left_power_phase_peak(self, value: list[float]):
        field = self.get_field(SegmentLapAvgLeftPowerPhasePeakField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                field.set_values(value)

    @property
    def avg_right_power_phase(self) -> Optional[list[float]]:
        field = self.get_field(SegmentLapAvgRightPowerPhaseField.ID)
        if field and field.is_valid():
            return field.get_values()
        else:
            return None

    @avg_right_power_phase.setter
    def avg_right_power_phase(self, value: list[float]):
        field = self.get_field(SegmentLapAvgRightPowerPhaseField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                field.set_values(value)

    @property
    def avg_right_power_phase_peak(self) -> Optional[list[float]]:
        field = self.get_field(SegmentLapAvgRightPowerPhasePeakField.ID)
        if field and field.is_valid():
            return field.get_values()
        else:
            return None

    @avg_right_power_phase_peak.setter
    def avg_right_power_phase_peak(self, value: list[float]):
        field = self.get_field(SegmentLapAvgRightPowerPhasePeakField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                field.set_values(value)

    @property
    def avg_power_position(self) -> Optional[list[int]]:
        field = self.get_field(SegmentLapAvgPowerPositionField.ID)
        if field and field.is_valid():
            return field.get_values()
        else:
            return None

    @avg_power_position.setter
    def avg_power_position(self, value: list[int]):
        field = self.get_field(SegmentLapAvgPowerPositionField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                field.set_values(value)

    @property
    def max_power_position(self) -> Optional[list[int]]:
        field = self.get_field(SegmentLapMaxPowerPositionField.ID)
        if field and field.is_valid():
            return field.get_values()
        else:
            return None

    @max_power_position.setter
    def max_power_position(self, value: list[int]):
        field = self.get_field(SegmentLapMaxPowerPositionField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                field.set_values(value)

    @property
    def avg_cadence_position(self) -> Optional[list[int]]:
        field = self.get_field(SegmentLapAvgCadencePositionField.ID)
        if field and field.is_valid():
            return field.get_values()
        else:
            return None

    @avg_cadence_position.setter
    def avg_cadence_position(self, value: list[int]):
        field = self.get_field(SegmentLapAvgCadencePositionField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                field.set_values(value)

    @property
    def max_cadence_position(self) -> Optional[list[int]]:
        field = self.get_field(SegmentLapMaxCadencePositionField.ID)
        if field and field.is_valid():
            return field.get_values()
        else:
            return None

    @max_cadence_position.setter
    def max_cadence_position(self, value: list[int]):
        field = self.get_field(SegmentLapMaxCadencePositionField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                field.set_values(value)

    @property
    def manufacturer(self) -> Optional[int]:
        field = self.get_field(SegmentLapManufacturerField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @manufacturer.setter
    def manufacturer(self, value: int):
        field = self.get_field(SegmentLapManufacturerField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def total_grit(self) -> Optional[float]:
        field = self.get_field(SegmentLapTotalGritField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @total_grit.setter
    def total_grit(self, value: float):
        field = self.get_field(SegmentLapTotalGritField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def total_flow(self) -> Optional[float]:
        field = self.get_field(SegmentLapTotalFlowField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @total_flow.setter
    def total_flow(self, value: float):
        field = self.get_field(SegmentLapTotalFlowField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_grit(self) -> Optional[float]:
        field = self.get_field(SegmentLapAvgGritField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_grit.setter
    def avg_grit(self, value: float):
        field = self.get_field(SegmentLapAvgGritField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_flow(self) -> Optional[float]:
        field = self.get_field(SegmentLapAvgFlowField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_flow.setter
    def avg_flow(self, value: float):
        field = self.get_field(SegmentLapAvgFlowField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def total_fractional_ascent(self) -> Optional[float]:
        field = self.get_field(SegmentLapTotalFractionalAscentField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @total_fractional_ascent.setter
    def total_fractional_ascent(self, value: float):
        field = self.get_field(SegmentLapTotalFractionalAscentField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def total_fractional_descent(self) -> Optional[float]:
        field = self.get_field(SegmentLapTotalFractionalDescentField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @total_fractional_descent.setter
    def total_fractional_descent(self, value: float):
        field = self.get_field(SegmentLapTotalFractionalDescentField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)


class MessageIndexField(Field):
    ID = 254

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='message_index',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class TimestampField(Field):
    ID = 253

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='timestamp',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=-631065600000,
            scale=0.001,
            size=size,
            units='ms',
            type_name='date_time',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapEventField(Field):
    ID = 0

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='event',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapEventTypeField(Field):
    ID = 1

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='event_type',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapStartTimeField(Field):
    ID = 2

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='start_time',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=-631065600000,
            scale=0.001,
            size=size,
            units='ms',
            type_name='date_time',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapStartPositionLatField(Field):
    ID = 3

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='start_position_lat',
            field_id=self.ID,
            base_type=BaseType.SINT32,
            offset=0,
            scale=11930464.711111112,
            size=size,
            units='degrees',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapStartPositionLongField(Field):
    ID = 4

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='start_position_long',
            field_id=self.ID,
            base_type=BaseType.SINT32,
            offset=0,
            scale=11930464.711111112,
            size=size,
            units='degrees',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapEndPositionLatField(Field):
    ID = 5

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='end_position_lat',
            field_id=self.ID,
            base_type=BaseType.SINT32,
            offset=0,
            scale=11930464.711111112,
            size=size,
            units='degrees',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapEndPositionLongField(Field):
    ID = 6

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='end_position_long',
            field_id=self.ID,
            base_type=BaseType.SINT32,
            offset=0,
            scale=11930464.711111112,
            size=size,
            units='degrees',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapTotalElapsedTimeField(Field):
    ID = 7

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='total_elapsed_time',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1000,
            size=size,
            units='s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapTotalTimerTimeField(Field):
    ID = 8

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='total_timer_time',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1000,
            size=size,
            units='s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapTotalDistanceField(Field):
    ID = 9

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='total_distance',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=100,
            size=size,
            units='m',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapTotalCyclesField(Field):
    ID = 10

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='total_cycles',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1,
            size=size,
            units='cycles',
            type_name='',
            growable=growable,
            sub_fields=[
                SubField(
                    name='total_strokes',
                    base_type=BaseType.UINT32,
                    scale=1,
                    offset=0,
                    units='strokes',
                    reference_map={
                        SegmentLapSportField.ID: [2]
                    })
            ]
        )


class SegmentLapTotalCaloriesField(Field):
    ID = 11

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='total_calories',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            units='kcal',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapTotalFatCaloriesField(Field):
    ID = 12

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='total_fat_calories',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            units='kcal',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapAvgSpeedField(Field):
    ID = 13

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_speed',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1000,
            size=size,
            units='m/s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapMaxSpeedField(Field):
    ID = 14

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='max_speed',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1000,
            size=size,
            units='m/s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapAvgHeartRateField(Field):
    ID = 15

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_heart_rate',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            units='bpm',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapMaxHeartRateField(Field):
    ID = 16

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='max_heart_rate',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            units='bpm',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapAvgCadenceField(Field):
    ID = 17

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_cadence',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            units='rpm',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapMaxCadenceField(Field):
    ID = 18

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='max_cadence',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            units='rpm',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapAvgPowerField(Field):
    ID = 19

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_power',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            units='watts',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapMaxPowerField(Field):
    ID = 20

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='max_power',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            units='watts',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapTotalAscentField(Field):
    ID = 21

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='total_ascent',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            units='m',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapTotalDescentField(Field):
    ID = 22

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='total_descent',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            units='m',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapSportField(Field):
    ID = 23

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='sport',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapEventGroupField(Field):
    ID = 24

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='event_group',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapNecLatField(Field):
    ID = 25

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='nec_lat',
            field_id=self.ID,
            base_type=BaseType.SINT32,
            offset=0,
            scale=11930464.711111112,
            size=size,
            units='degrees',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapNecLongField(Field):
    ID = 26

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='nec_long',
            field_id=self.ID,
            base_type=BaseType.SINT32,
            offset=0,
            scale=11930464.711111112,
            size=size,
            units='degrees',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapSwcLatField(Field):
    ID = 27

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='swc_lat',
            field_id=self.ID,
            base_type=BaseType.SINT32,
            offset=0,
            scale=11930464.711111112,
            size=size,
            units='degrees',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapSwcLongField(Field):
    ID = 28

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='swc_long',
            field_id=self.ID,
            base_type=BaseType.SINT32,
            offset=0,
            scale=11930464.711111112,
            size=size,
            units='degrees',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapNameField(Field):
    ID = 29

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='name',
            field_id=self.ID,
            base_type=BaseType.STRING,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapNormalizedPowerField(Field):
    ID = 30

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='normalized_power',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            units='watts',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapLeftRightBalanceField(Field):
    ID = 31

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='left_right_balance',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapSubSportField(Field):
    ID = 32

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='sub_sport',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapTotalWorkField(Field):
    ID = 33

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='total_work',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1,
            size=size,
            units='J',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapAvgAltitudeField(Field):
    ID = 34

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_altitude',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=500,
            scale=5,
            size=size,
            units='m',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapMaxAltitudeField(Field):
    ID = 35

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='max_altitude',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=500,
            scale=5,
            size=size,
            units='m',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapGpsAccuracyField(Field):
    ID = 36

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='gps_accuracy',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            units='m',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapAvgGradeField(Field):
    ID = 37

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_grade',
            field_id=self.ID,
            base_type=BaseType.SINT16,
            offset=0,
            scale=100,
            size=size,
            units='%',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapAvgPosGradeField(Field):
    ID = 38

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_pos_grade',
            field_id=self.ID,
            base_type=BaseType.SINT16,
            offset=0,
            scale=100,
            size=size,
            units='%',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapAvgNegGradeField(Field):
    ID = 39

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_neg_grade',
            field_id=self.ID,
            base_type=BaseType.SINT16,
            offset=0,
            scale=100,
            size=size,
            units='%',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapMaxPosGradeField(Field):
    ID = 40

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='max_pos_grade',
            field_id=self.ID,
            base_type=BaseType.SINT16,
            offset=0,
            scale=100,
            size=size,
            units='%',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapMaxNegGradeField(Field):
    ID = 41

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='max_neg_grade',
            field_id=self.ID,
            base_type=BaseType.SINT16,
            offset=0,
            scale=100,
            size=size,
            units='%',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapAvgTemperatureField(Field):
    ID = 42

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_temperature',
            field_id=self.ID,
            base_type=BaseType.SINT8,
            offset=0,
            scale=1,
            size=size,
            units='C',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapMaxTemperatureField(Field):
    ID = 43

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='max_temperature',
            field_id=self.ID,
            base_type=BaseType.SINT8,
            offset=0,
            scale=1,
            size=size,
            units='C',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapTotalMovingTimeField(Field):
    ID = 44

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='total_moving_time',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1000,
            size=size,
            units='s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapAvgPosVerticalSpeedField(Field):
    ID = 45

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_pos_vertical_speed',
            field_id=self.ID,
            base_type=BaseType.SINT16,
            offset=0,
            scale=1000,
            size=size,
            units='m/s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapAvgNegVerticalSpeedField(Field):
    ID = 46

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_neg_vertical_speed',
            field_id=self.ID,
            base_type=BaseType.SINT16,
            offset=0,
            scale=1000,
            size=size,
            units='m/s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapMaxPosVerticalSpeedField(Field):
    ID = 47

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='max_pos_vertical_speed',
            field_id=self.ID,
            base_type=BaseType.SINT16,
            offset=0,
            scale=1000,
            size=size,
            units='m/s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapMaxNegVerticalSpeedField(Field):
    ID = 48

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='max_neg_vertical_speed',
            field_id=self.ID,
            base_type=BaseType.SINT16,
            offset=0,
            scale=1000,
            size=size,
            units='m/s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapTimeInHrZoneField(Field):
    ID = 49

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='time_in_hr_zone',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1000,
            size=size,
            units='s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapTimeInSpeedZoneField(Field):
    ID = 50

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='time_in_speed_zone',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1000,
            size=size,
            units='s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapTimeInCadenceZoneField(Field):
    ID = 51

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='time_in_cadence_zone',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1000,
            size=size,
            units='s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapTimeInPowerZoneField(Field):
    ID = 52

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='time_in_power_zone',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1000,
            size=size,
            units='s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapRepetitionNumField(Field):
    ID = 53

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='repetition_num',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapMinAltitudeField(Field):
    ID = 54

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='min_altitude',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=500,
            scale=5,
            size=size,
            units='m',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapMinHeartRateField(Field):
    ID = 55

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='min_heart_rate',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            units='bpm',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapActiveTimeField(Field):
    ID = 56

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='active_time',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1000,
            size=size,
            units='s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapWorkoutStepIndexField(Field):
    ID = 57

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='wkt_step_index',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapSportEventField(Field):
    ID = 58

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='sport_event',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapAvgLeftTorqueEffectivenessField(Field):
    ID = 59

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_left_torque_effectiveness',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=2,
            size=size,
            units='percent',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapAvgRightTorqueEffectivenessField(Field):
    ID = 60

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_right_torque_effectiveness',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=2,
            size=size,
            units='percent',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapAvgLeftPedalSmoothnessField(Field):
    ID = 61

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_left_pedal_smoothness',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=2,
            size=size,
            units='percent',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapAvgRightPedalSmoothnessField(Field):
    ID = 62

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_right_pedal_smoothness',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=2,
            size=size,
            units='percent',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapAvgCombinedPedalSmoothnessField(Field):
    ID = 63

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_combined_pedal_smoothness',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=2,
            size=size,
            units='percent',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapStatusField(Field):
    ID = 64

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='status',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapUuidField(Field):
    ID = 65

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='uuid',
            field_id=self.ID,
            base_type=BaseType.STRING,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapAvgFractionalCadenceField(Field):
    ID = 66

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_fractional_cadence',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=128,
            size=size,
            units='rpm',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapMaxFractionalCadenceField(Field):
    ID = 67

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='max_fractional_cadence',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=128,
            size=size,
            units='rpm',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapTotalFractionalCyclesField(Field):
    ID = 68

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='total_fractional_cycles',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=128,
            size=size,
            units='cycles',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapFrontGearShiftCountField(Field):
    ID = 69

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='front_gear_shift_count',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapRearGearShiftCountField(Field):
    ID = 70

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='rear_gear_shift_count',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapTimeStandingField(Field):
    ID = 71

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='time_standing',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1000,
            size=size,
            units='s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapStandCountField(Field):
    ID = 72

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='stand_count',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapAvgLeftPcoField(Field):
    ID = 73

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_left_pco',
            field_id=self.ID,
            base_type=BaseType.SINT8,
            offset=0,
            scale=1,
            size=size,
            units='mm',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapAvgRightPcoField(Field):
    ID = 74

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_right_pco',
            field_id=self.ID,
            base_type=BaseType.SINT8,
            offset=0,
            scale=1,
            size=size,
            units='mm',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapAvgLeftPowerPhaseField(Field):
    ID = 75

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_left_power_phase',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=0.7111111,
            size=size,
            units='degrees',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapAvgLeftPowerPhasePeakField(Field):
    ID = 76

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_left_power_phase_peak',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=0.7111111,
            size=size,
            units='degrees',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapAvgRightPowerPhaseField(Field):
    ID = 77

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_right_power_phase',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=0.7111111,
            size=size,
            units='degrees',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapAvgRightPowerPhasePeakField(Field):
    ID = 78

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_right_power_phase_peak',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=0.7111111,
            size=size,
            units='degrees',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapAvgPowerPositionField(Field):
    ID = 79

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_power_position',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            units='watts',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapMaxPowerPositionField(Field):
    ID = 80

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='max_power_position',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            units='watts',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapAvgCadencePositionField(Field):
    ID = 81

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_cadence_position',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            units='rpm',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapMaxCadencePositionField(Field):
    ID = 82

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='max_cadence_position',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            units='rpm',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapManufacturerField(Field):
    ID = 83

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='manufacturer',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapTotalGritField(Field):
    ID = 84

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='total_grit',
            field_id=self.ID,
            base_type=BaseType.FLOAT32,
            offset=0,
            scale=1,
            size=size,
            units='kGrit',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapTotalFlowField(Field):
    ID = 85

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='total_flow',
            field_id=self.ID,
            base_type=BaseType.FLOAT32,
            offset=0,
            scale=1,
            size=size,
            units='Flow',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapAvgGritField(Field):
    ID = 86

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_grit',
            field_id=self.ID,
            base_type=BaseType.FLOAT32,
            offset=0,
            scale=1,
            size=size,
            units='kGrit',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapAvgFlowField(Field):
    ID = 87

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_flow',
            field_id=self.ID,
            base_type=BaseType.FLOAT32,
            offset=0,
            scale=1,
            size=size,
            units='Flow',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapTotalFractionalAscentField(Field):
    ID = 89

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='total_fractional_ascent',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=100,
            size=size,
            units='m',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentLapTotalFractionalDescentField(Field):
    ID = 90

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='total_fractional_descent',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=100,
            size=size,
            units='m',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )
