# Autogenerated. Do not modify.
#
# Profile: 21.60
from typing import List as list
from typing import Optional

from fit_tool.base_type import BaseType
from fit_tool.data_message import DataMessage
from fit_tool.definition_message import DefinitionMessage
from fit_tool.developer_field import DeveloperField
from fit_tool.endian import Endian
from fit_tool.field import Field


class CapabilitiesMessage(DataMessage):
    ID = 1
    NAME = 'capabilities'

    @staticmethod
    def __get_field_size(definition_message: DefinitionMessage, field_id: int) -> int:
        size = 0
        if definition_message:
            field_definition = definition_message.get_field_definition(field_id)
            if field_definition:
                size = field_definition.size

        return size

    def __init__(self, definition_message=None, developer_fields=None, local_id: int = 0,
                 endian: Endian = Endian.LITTLE):
        super().__init__(name=CapabilitiesMessage.NAME,
                         global_id=CapabilitiesMessage.ID,
                         local_id=definition_message.local_id if definition_message else local_id,
                         endian=definition_message.endian if definition_message else endian,
                         definition_message=definition_message,
                         developer_fields=developer_fields,
                         fields=[
                             CapabilitiesLanguagesField(
                                 size=self.__get_field_size(definition_message, CapabilitiesLanguagesField.ID),
                                 growable=definition_message is None),
                             CapabilitiesSportsField(
                                 size=self.__get_field_size(definition_message, CapabilitiesSportsField.ID),
                                 growable=definition_message is None),
                             CapabilitiesWorkoutsSupportedField(
                                 size=self.__get_field_size(definition_message, CapabilitiesWorkoutsSupportedField.ID),
                                 growable=definition_message is None),
                             CapabilitiesConnectivitySupportedField(
                                 size=self.__get_field_size(definition_message,
                                                            CapabilitiesConnectivitySupportedField.ID),
                                 growable=definition_message is None)
                         ])

        self.growable = self.definition_message is None

    @classmethod
    def from_bytes(cls, definition_message: DefinitionMessage, developer_fields: list[DeveloperField],
                   bytes_buffer: bytes, offset: int = 0):
        message = cls(definition_message=definition_message, developer_fields=developer_fields)
        message.read_from_bytes(bytes_buffer, offset)
        return message

    @property
    def languages(self) -> Optional[list[int]]:
        field = self.get_field(CapabilitiesLanguagesField.ID)
        if field and field.is_valid():
            return field.get_values()
        else:
            return None

    @languages.setter
    def languages(self, value: list[int]):
        field = self.get_field(CapabilitiesLanguagesField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                field.set_values(value)

    @property
    def sports(self) -> Optional[list[int]]:
        field = self.get_field(CapabilitiesSportsField.ID)
        if field and field.is_valid():
            return field.get_values()
        else:
            return None

    @sports.setter
    def sports(self, value: list[int]):
        field = self.get_field(CapabilitiesSportsField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                field.set_values(value)

    @property
    def workouts_supported(self) -> Optional[int]:
        field = self.get_field(CapabilitiesWorkoutsSupportedField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @workouts_supported.setter
    def workouts_supported(self, value: int):
        field = self.get_field(CapabilitiesWorkoutsSupportedField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def connectivity_supported(self) -> Optional[int]:
        field = self.get_field(CapabilitiesConnectivitySupportedField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @connectivity_supported.setter
    def connectivity_supported(self, value: int):
        field = self.get_field(CapabilitiesConnectivitySupportedField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)


class CapabilitiesLanguagesField(Field):
    ID = 0

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='languages',
            field_id=self.ID,
            base_type=BaseType.UINT8Z,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class CapabilitiesSportsField(Field):
    ID = 1

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='sports',
            field_id=self.ID,
            base_type=BaseType.UINT8Z,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class CapabilitiesWorkoutsSupportedField(Field):
    ID = 21

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='workouts_supported',
            field_id=self.ID,
            base_type=BaseType.UINT32Z,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class CapabilitiesConnectivitySupportedField(Field):
    ID = 23

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='connectivity_supported',
            field_id=self.ID,
            base_type=BaseType.UINT32Z,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )
