# Autogenerated. Do not modify.
#
# Profile: 21.60
from typing import List as list
from typing import Optional

from fit_tool.base_type import BaseType
from fit_tool.data_message import DataMessage
from fit_tool.definition_message import DefinitionMessage
from fit_tool.developer_field import DeveloperField
from fit_tool.endian import Endian
from fit_tool.field import Field
from fit_tool.profile.profile_type import *


class BikeProfileMessage(DataMessage):
    ID = 6
    NAME = 'bike_profile'

    @staticmethod
    def __get_field_size(definition_message: DefinitionMessage, field_id: int) -> int:
        size = 0
        if definition_message:
            field_definition = definition_message.get_field_definition(field_id)
            if field_definition:
                size = field_definition.size

        return size

    def __init__(self, definition_message=None, developer_fields=None, local_id: int = 0,
                 endian: Endian = Endian.LITTLE):
        super().__init__(name=BikeProfileMessage.NAME,
                         global_id=BikeProfileMessage.ID,
                         local_id=definition_message.local_id if definition_message else local_id,
                         endian=definition_message.endian if definition_message else endian,
                         definition_message=definition_message,
                         developer_fields=developer_fields,
                         fields=[
                             MessageIndexField(
                                 size=self.__get_field_size(definition_message, MessageIndexField.ID),
                                 growable=definition_message is None),
                             BikeProfileNameField(
                                 size=self.__get_field_size(definition_message, BikeProfileNameField.ID),
                                 growable=definition_message is None),
                             BikeProfileSportField(
                                 size=self.__get_field_size(definition_message, BikeProfileSportField.ID),
                                 growable=definition_message is None),
                             BikeProfileSubSportField(
                                 size=self.__get_field_size(definition_message, BikeProfileSubSportField.ID),
                                 growable=definition_message is None),
                             BikeProfileOdometerField(
                                 size=self.__get_field_size(definition_message, BikeProfileOdometerField.ID),
                                 growable=definition_message is None),
                             BikeProfileBikeSpdAntIdField(
                                 size=self.__get_field_size(definition_message, BikeProfileBikeSpdAntIdField.ID),
                                 growable=definition_message is None),
                             BikeProfileBikeCadAntIdField(
                                 size=self.__get_field_size(definition_message, BikeProfileBikeCadAntIdField.ID),
                                 growable=definition_message is None),
                             BikeProfileBikeSpdcadAntIdField(
                                 size=self.__get_field_size(definition_message, BikeProfileBikeSpdcadAntIdField.ID),
                                 growable=definition_message is None),
                             BikeProfileBikePowerAntIdField(
                                 size=self.__get_field_size(definition_message, BikeProfileBikePowerAntIdField.ID),
                                 growable=definition_message is None),
                             BikeProfileCustomWheelsizeField(
                                 size=self.__get_field_size(definition_message, BikeProfileCustomWheelsizeField.ID),
                                 growable=definition_message is None),
                             BikeProfileAutoWheelsizeField(
                                 size=self.__get_field_size(definition_message, BikeProfileAutoWheelsizeField.ID),
                                 growable=definition_message is None),
                             BikeProfileBikeWeightField(
                                 size=self.__get_field_size(definition_message, BikeProfileBikeWeightField.ID),
                                 growable=definition_message is None),
                             BikeProfilePowerCalFactorField(
                                 size=self.__get_field_size(definition_message, BikeProfilePowerCalFactorField.ID),
                                 growable=definition_message is None),
                             BikeProfileAutoWheelCalField(
                                 size=self.__get_field_size(definition_message, BikeProfileAutoWheelCalField.ID),
                                 growable=definition_message is None),
                             BikeProfileAutoPowerZeroField(
                                 size=self.__get_field_size(definition_message, BikeProfileAutoPowerZeroField.ID),
                                 growable=definition_message is None),
                             BikeProfileIdField(
                                 size=self.__get_field_size(definition_message, BikeProfileIdField.ID),
                                 growable=definition_message is None),
                             BikeProfileSpdEnabledField(
                                 size=self.__get_field_size(definition_message, BikeProfileSpdEnabledField.ID),
                                 growable=definition_message is None),
                             BikeProfileCadEnabledField(
                                 size=self.__get_field_size(definition_message, BikeProfileCadEnabledField.ID),
                                 growable=definition_message is None),
                             BikeProfileSpdcadEnabledField(
                                 size=self.__get_field_size(definition_message, BikeProfileSpdcadEnabledField.ID),
                                 growable=definition_message is None),
                             BikeProfilePowerEnabledField(
                                 size=self.__get_field_size(definition_message, BikeProfilePowerEnabledField.ID),
                                 growable=definition_message is None),
                             BikeProfileCrankLengthField(
                                 size=self.__get_field_size(definition_message, BikeProfileCrankLengthField.ID),
                                 growable=definition_message is None),
                             BikeProfileEnabledField(
                                 size=self.__get_field_size(definition_message, BikeProfileEnabledField.ID),
                                 growable=definition_message is None),
                             BikeProfileBikeSpdAntIdTransTypeField(
                                 size=self.__get_field_size(definition_message,
                                                            BikeProfileBikeSpdAntIdTransTypeField.ID),
                                 growable=definition_message is None),
                             BikeProfileBikeCadAntIdTransTypeField(
                                 size=self.__get_field_size(definition_message,
                                                            BikeProfileBikeCadAntIdTransTypeField.ID),
                                 growable=definition_message is None),
                             BikeProfileBikeSpdcadAntIdTransTypeField(
                                 size=self.__get_field_size(definition_message,
                                                            BikeProfileBikeSpdcadAntIdTransTypeField.ID),
                                 growable=definition_message is None),
                             BikeProfileBikePowerAntIdTransTypeField(
                                 size=self.__get_field_size(definition_message,
                                                            BikeProfileBikePowerAntIdTransTypeField.ID),
                                 growable=definition_message is None),
                             BikeProfileOdometerRolloverField(
                                 size=self.__get_field_size(definition_message, BikeProfileOdometerRolloverField.ID),
                                 growable=definition_message is None),
                             BikeProfileFrontGearNumField(
                                 size=self.__get_field_size(definition_message, BikeProfileFrontGearNumField.ID),
                                 growable=definition_message is None),
                             BikeProfileFrontGearField(
                                 size=self.__get_field_size(definition_message, BikeProfileFrontGearField.ID),
                                 growable=definition_message is None),
                             BikeProfileRearGearNumField(
                                 size=self.__get_field_size(definition_message, BikeProfileRearGearNumField.ID),
                                 growable=definition_message is None),
                             BikeProfileRearGearField(
                                 size=self.__get_field_size(definition_message, BikeProfileRearGearField.ID),
                                 growable=definition_message is None),
                             BikeProfileShimanoDi2EnabledField(
                                 size=self.__get_field_size(definition_message, BikeProfileShimanoDi2EnabledField.ID),
                                 growable=definition_message is None)
                         ])

        self.growable = self.definition_message is None

    @classmethod
    def from_bytes(cls, definition_message: DefinitionMessage, developer_fields: list[DeveloperField],
                   bytes_buffer: bytes, offset: int = 0):
        message = cls(definition_message=definition_message, developer_fields=developer_fields)
        message.read_from_bytes(bytes_buffer, offset)
        return message

    @property
    def message_index(self) -> Optional[int]:
        field = self.get_field(MessageIndexField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @message_index.setter
    def message_index(self, value: int):
        field = self.get_field(MessageIndexField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def bike_profile_name(self) -> Optional[str]:
        field = self.get_field(BikeProfileNameField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @bike_profile_name.setter
    def bike_profile_name(self, value: str):
        field = self.get_field(BikeProfileNameField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def sport(self) -> Optional[Sport]:
        field = self.get_field(BikeProfileSportField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @sport.setter
    def sport(self, value: Sport):
        field = self.get_field(BikeProfileSportField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def sub_sport(self) -> Optional[SubSport]:
        field = self.get_field(BikeProfileSubSportField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @sub_sport.setter
    def sub_sport(self, value: SubSport):
        field = self.get_field(BikeProfileSubSportField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def odometer(self) -> Optional[float]:
        field = self.get_field(BikeProfileOdometerField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @odometer.setter
    def odometer(self, value: float):
        field = self.get_field(BikeProfileOdometerField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def bike_spd_ant_id(self) -> Optional[int]:
        field = self.get_field(BikeProfileBikeSpdAntIdField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @bike_spd_ant_id.setter
    def bike_spd_ant_id(self, value: int):
        field = self.get_field(BikeProfileBikeSpdAntIdField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def bike_cad_ant_id(self) -> Optional[int]:
        field = self.get_field(BikeProfileBikeCadAntIdField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @bike_cad_ant_id.setter
    def bike_cad_ant_id(self, value: int):
        field = self.get_field(BikeProfileBikeCadAntIdField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def bike_spdcad_ant_id(self) -> Optional[int]:
        field = self.get_field(BikeProfileBikeSpdcadAntIdField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @bike_spdcad_ant_id.setter
    def bike_spdcad_ant_id(self, value: int):
        field = self.get_field(BikeProfileBikeSpdcadAntIdField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def bike_power_ant_id(self) -> Optional[int]:
        field = self.get_field(BikeProfileBikePowerAntIdField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @bike_power_ant_id.setter
    def bike_power_ant_id(self, value: int):
        field = self.get_field(BikeProfileBikePowerAntIdField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def custom_wheelsize(self) -> Optional[float]:
        field = self.get_field(BikeProfileCustomWheelsizeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @custom_wheelsize.setter
    def custom_wheelsize(self, value: float):
        field = self.get_field(BikeProfileCustomWheelsizeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def auto_wheelsize(self) -> Optional[float]:
        field = self.get_field(BikeProfileAutoWheelsizeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @auto_wheelsize.setter
    def auto_wheelsize(self, value: float):
        field = self.get_field(BikeProfileAutoWheelsizeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def bike_weight(self) -> Optional[float]:
        field = self.get_field(BikeProfileBikeWeightField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @bike_weight.setter
    def bike_weight(self, value: float):
        field = self.get_field(BikeProfileBikeWeightField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def power_cal_factor(self) -> Optional[float]:
        field = self.get_field(BikeProfilePowerCalFactorField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @power_cal_factor.setter
    def power_cal_factor(self, value: float):
        field = self.get_field(BikeProfilePowerCalFactorField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def auto_wheel_cal(self) -> Optional[bool]:
        field = self.get_field(BikeProfileAutoWheelCalField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @auto_wheel_cal.setter
    def auto_wheel_cal(self, value: bool):
        field = self.get_field(BikeProfileAutoWheelCalField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def auto_power_zero(self) -> Optional[bool]:
        field = self.get_field(BikeProfileAutoPowerZeroField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @auto_power_zero.setter
    def auto_power_zero(self, value: bool):
        field = self.get_field(BikeProfileAutoPowerZeroField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def id(self) -> Optional[int]:
        field = self.get_field(BikeProfileIdField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @id.setter
    def id(self, value: int):
        field = self.get_field(BikeProfileIdField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def spd_enabled(self) -> Optional[bool]:
        field = self.get_field(BikeProfileSpdEnabledField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @spd_enabled.setter
    def spd_enabled(self, value: bool):
        field = self.get_field(BikeProfileSpdEnabledField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def cad_enabled(self) -> Optional[bool]:
        field = self.get_field(BikeProfileCadEnabledField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @cad_enabled.setter
    def cad_enabled(self, value: bool):
        field = self.get_field(BikeProfileCadEnabledField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def spdcad_enabled(self) -> Optional[bool]:
        field = self.get_field(BikeProfileSpdcadEnabledField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @spdcad_enabled.setter
    def spdcad_enabled(self, value: bool):
        field = self.get_field(BikeProfileSpdcadEnabledField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def power_enabled(self) -> Optional[bool]:
        field = self.get_field(BikeProfilePowerEnabledField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @power_enabled.setter
    def power_enabled(self, value: bool):
        field = self.get_field(BikeProfilePowerEnabledField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def crank_length(self) -> Optional[float]:
        field = self.get_field(BikeProfileCrankLengthField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @crank_length.setter
    def crank_length(self, value: float):
        field = self.get_field(BikeProfileCrankLengthField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def enabled(self) -> Optional[bool]:
        field = self.get_field(BikeProfileEnabledField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @enabled.setter
    def enabled(self, value: bool):
        field = self.get_field(BikeProfileEnabledField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def bike_spd_ant_id_trans_type(self) -> Optional[int]:
        field = self.get_field(BikeProfileBikeSpdAntIdTransTypeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @bike_spd_ant_id_trans_type.setter
    def bike_spd_ant_id_trans_type(self, value: int):
        field = self.get_field(BikeProfileBikeSpdAntIdTransTypeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def bike_cad_ant_id_trans_type(self) -> Optional[int]:
        field = self.get_field(BikeProfileBikeCadAntIdTransTypeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @bike_cad_ant_id_trans_type.setter
    def bike_cad_ant_id_trans_type(self, value: int):
        field = self.get_field(BikeProfileBikeCadAntIdTransTypeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def bike_spdcad_ant_id_trans_type(self) -> Optional[int]:
        field = self.get_field(BikeProfileBikeSpdcadAntIdTransTypeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @bike_spdcad_ant_id_trans_type.setter
    def bike_spdcad_ant_id_trans_type(self, value: int):
        field = self.get_field(BikeProfileBikeSpdcadAntIdTransTypeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def bike_power_ant_id_trans_type(self) -> Optional[int]:
        field = self.get_field(BikeProfileBikePowerAntIdTransTypeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @bike_power_ant_id_trans_type.setter
    def bike_power_ant_id_trans_type(self, value: int):
        field = self.get_field(BikeProfileBikePowerAntIdTransTypeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def odometer_rollover(self) -> Optional[int]:
        field = self.get_field(BikeProfileOdometerRolloverField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @odometer_rollover.setter
    def odometer_rollover(self, value: int):
        field = self.get_field(BikeProfileOdometerRolloverField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def front_gear_num(self) -> Optional[int]:
        field = self.get_field(BikeProfileFrontGearNumField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @front_gear_num.setter
    def front_gear_num(self, value: int):
        field = self.get_field(BikeProfileFrontGearNumField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def front_gear(self) -> Optional[list[int]]:
        field = self.get_field(BikeProfileFrontGearField.ID)
        if field and field.is_valid():
            return field.get_values()
        else:
            return None

    @front_gear.setter
    def front_gear(self, value: list[int]):
        field = self.get_field(BikeProfileFrontGearField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                field.set_values(value)

    @property
    def rear_gear_num(self) -> Optional[int]:
        field = self.get_field(BikeProfileRearGearNumField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @rear_gear_num.setter
    def rear_gear_num(self, value: int):
        field = self.get_field(BikeProfileRearGearNumField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def rear_gear(self) -> Optional[list[int]]:
        field = self.get_field(BikeProfileRearGearField.ID)
        if field and field.is_valid():
            return field.get_values()
        else:
            return None

    @rear_gear.setter
    def rear_gear(self, value: list[int]):
        field = self.get_field(BikeProfileRearGearField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                field.set_values(value)

    @property
    def shimano_di2_enabled(self) -> Optional[bool]:
        field = self.get_field(BikeProfileShimanoDi2EnabledField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @shimano_di2_enabled.setter
    def shimano_di2_enabled(self, value: bool):
        field = self.get_field(BikeProfileShimanoDi2EnabledField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)


class MessageIndexField(Field):
    ID = 254

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='message_index',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class BikeProfileNameField(Field):
    ID = 0

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='name',
            field_id=self.ID,
            base_type=BaseType.STRING,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class BikeProfileSportField(Field):
    ID = 1

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='sport',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class BikeProfileSubSportField(Field):
    ID = 2

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='sub_sport',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class BikeProfileOdometerField(Field):
    ID = 3

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='odometer',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=100,
            size=size,
            units='m',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class BikeProfileBikeSpdAntIdField(Field):
    ID = 4

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='bike_spd_ant_id',
            field_id=self.ID,
            base_type=BaseType.UINT16Z,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class BikeProfileBikeCadAntIdField(Field):
    ID = 5

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='bike_cad_ant_id',
            field_id=self.ID,
            base_type=BaseType.UINT16Z,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class BikeProfileBikeSpdcadAntIdField(Field):
    ID = 6

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='bike_spdcad_ant_id',
            field_id=self.ID,
            base_type=BaseType.UINT16Z,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class BikeProfileBikePowerAntIdField(Field):
    ID = 7

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='bike_power_ant_id',
            field_id=self.ID,
            base_type=BaseType.UINT16Z,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class BikeProfileCustomWheelsizeField(Field):
    ID = 8

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='custom_wheelsize',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1000,
            size=size,
            units='m',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class BikeProfileAutoWheelsizeField(Field):
    ID = 9

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='auto_wheelsize',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1000,
            size=size,
            units='m',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class BikeProfileBikeWeightField(Field):
    ID = 10

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='bike_weight',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=10,
            size=size,
            units='kg',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class BikeProfilePowerCalFactorField(Field):
    ID = 11

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='power_cal_factor',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=10,
            size=size,
            units='%',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class BikeProfileAutoWheelCalField(Field):
    ID = 12

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='auto_wheel_cal',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class BikeProfileAutoPowerZeroField(Field):
    ID = 13

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='auto_power_zero',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class BikeProfileIdField(Field):
    ID = 14

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='id',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class BikeProfileSpdEnabledField(Field):
    ID = 15

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='spd_enabled',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class BikeProfileCadEnabledField(Field):
    ID = 16

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='cad_enabled',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class BikeProfileSpdcadEnabledField(Field):
    ID = 17

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='spdcad_enabled',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class BikeProfilePowerEnabledField(Field):
    ID = 18

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='power_enabled',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class BikeProfileCrankLengthField(Field):
    ID = 19

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='crank_length',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=-110,
            scale=2,
            size=size,
            units='mm',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class BikeProfileEnabledField(Field):
    ID = 20

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='enabled',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class BikeProfileBikeSpdAntIdTransTypeField(Field):
    ID = 21

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='bike_spd_ant_id_trans_type',
            field_id=self.ID,
            base_type=BaseType.UINT8Z,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class BikeProfileBikeCadAntIdTransTypeField(Field):
    ID = 22

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='bike_cad_ant_id_trans_type',
            field_id=self.ID,
            base_type=BaseType.UINT8Z,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class BikeProfileBikeSpdcadAntIdTransTypeField(Field):
    ID = 23

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='bike_spdcad_ant_id_trans_type',
            field_id=self.ID,
            base_type=BaseType.UINT8Z,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class BikeProfileBikePowerAntIdTransTypeField(Field):
    ID = 24

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='bike_power_ant_id_trans_type',
            field_id=self.ID,
            base_type=BaseType.UINT8Z,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class BikeProfileOdometerRolloverField(Field):
    ID = 37

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='odometer_rollover',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class BikeProfileFrontGearNumField(Field):
    ID = 38

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='front_gear_num',
            field_id=self.ID,
            base_type=BaseType.UINT8Z,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class BikeProfileFrontGearField(Field):
    ID = 39

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='front_gear',
            field_id=self.ID,
            base_type=BaseType.UINT8Z,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class BikeProfileRearGearNumField(Field):
    ID = 40

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='rear_gear_num',
            field_id=self.ID,
            base_type=BaseType.UINT8Z,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class BikeProfileRearGearField(Field):
    ID = 41

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='rear_gear',
            field_id=self.ID,
            base_type=BaseType.UINT8Z,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class BikeProfileShimanoDi2EnabledField(Field):
    ID = 44

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='shimano_di2_enabled',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )
