# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from .. import _utilities, _tables

__all__ = ['Certifi']


class Certifi(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate: Optional[pulumi.Input[str]] = None,
                 certificate_chain: Optional[pulumi.Input[str]] = None,
                 node_name: Optional[pulumi.Input[str]] = None,
                 overwrite: Optional[pulumi.Input[bool]] = None,
                 private_key: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Create a Certifi resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] certificate: The PEM encoded certificate
        :param pulumi.Input[str] certificate_chain: The PEM encoded certificate chain
        :param pulumi.Input[str] node_name: The node name
        :param pulumi.Input[bool] overwrite: Whether to overwrite an existing certificate
        :param pulumi.Input[str] private_key: The PEM encoded private key
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if certificate is None:
                raise TypeError("Missing required property 'certificate'")
            __props__['certificate'] = certificate
            __props__['certificate_chain'] = certificate_chain
            if node_name is None:
                raise TypeError("Missing required property 'node_name'")
            __props__['node_name'] = node_name
            __props__['overwrite'] = overwrite
            if private_key is None:
                raise TypeError("Missing required property 'private_key'")
            __props__['private_key'] = private_key
            __props__['expiration_date'] = None
            __props__['file_name'] = None
            __props__['issuer'] = None
            __props__['public_key_size'] = None
            __props__['public_key_type'] = None
            __props__['ssl_fingerprint'] = None
            __props__['start_date'] = None
            __props__['subject'] = None
            __props__['subject_alternative_names'] = None
        super(Certifi, __self__).__init__(
            'proxmox:System/certifi:Certifi',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            certificate: Optional[pulumi.Input[str]] = None,
            certificate_chain: Optional[pulumi.Input[str]] = None,
            expiration_date: Optional[pulumi.Input[str]] = None,
            file_name: Optional[pulumi.Input[str]] = None,
            issuer: Optional[pulumi.Input[str]] = None,
            node_name: Optional[pulumi.Input[str]] = None,
            overwrite: Optional[pulumi.Input[bool]] = None,
            private_key: Optional[pulumi.Input[str]] = None,
            public_key_size: Optional[pulumi.Input[int]] = None,
            public_key_type: Optional[pulumi.Input[str]] = None,
            ssl_fingerprint: Optional[pulumi.Input[str]] = None,
            start_date: Optional[pulumi.Input[str]] = None,
            subject: Optional[pulumi.Input[str]] = None,
            subject_alternative_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'Certifi':
        """
        Get an existing Certifi resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] certificate: The PEM encoded certificate
        :param pulumi.Input[str] certificate_chain: The PEM encoded certificate chain
        :param pulumi.Input[str] expiration_date: The expiration date
        :param pulumi.Input[str] file_name: The file name
        :param pulumi.Input[str] issuer: The issuer
        :param pulumi.Input[str] node_name: The node name
        :param pulumi.Input[bool] overwrite: Whether to overwrite an existing certificate
        :param pulumi.Input[str] private_key: The PEM encoded private key
        :param pulumi.Input[int] public_key_size: The public key size
        :param pulumi.Input[str] public_key_type: The public key type
        :param pulumi.Input[str] ssl_fingerprint: The SSL fingerprint
        :param pulumi.Input[str] start_date: The start date
        :param pulumi.Input[str] subject: The subject
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subject_alternative_names: The subject alternative names
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["certificate"] = certificate
        __props__["certificate_chain"] = certificate_chain
        __props__["expiration_date"] = expiration_date
        __props__["file_name"] = file_name
        __props__["issuer"] = issuer
        __props__["node_name"] = node_name
        __props__["overwrite"] = overwrite
        __props__["private_key"] = private_key
        __props__["public_key_size"] = public_key_size
        __props__["public_key_type"] = public_key_type
        __props__["ssl_fingerprint"] = ssl_fingerprint
        __props__["start_date"] = start_date
        __props__["subject"] = subject
        __props__["subject_alternative_names"] = subject_alternative_names
        return Certifi(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def certificate(self) -> pulumi.Output[str]:
        """
        The PEM encoded certificate
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter(name="certificateChain")
    def certificate_chain(self) -> pulumi.Output[Optional[str]]:
        """
        The PEM encoded certificate chain
        """
        return pulumi.get(self, "certificate_chain")

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> pulumi.Output[str]:
        """
        The expiration date
        """
        return pulumi.get(self, "expiration_date")

    @property
    @pulumi.getter(name="fileName")
    def file_name(self) -> pulumi.Output[str]:
        """
        The file name
        """
        return pulumi.get(self, "file_name")

    @property
    @pulumi.getter
    def issuer(self) -> pulumi.Output[str]:
        """
        The issuer
        """
        return pulumi.get(self, "issuer")

    @property
    @pulumi.getter(name="nodeName")
    def node_name(self) -> pulumi.Output[str]:
        """
        The node name
        """
        return pulumi.get(self, "node_name")

    @property
    @pulumi.getter
    def overwrite(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to overwrite an existing certificate
        """
        return pulumi.get(self, "overwrite")

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> pulumi.Output[str]:
        """
        The PEM encoded private key
        """
        return pulumi.get(self, "private_key")

    @property
    @pulumi.getter(name="publicKeySize")
    def public_key_size(self) -> pulumi.Output[int]:
        """
        The public key size
        """
        return pulumi.get(self, "public_key_size")

    @property
    @pulumi.getter(name="publicKeyType")
    def public_key_type(self) -> pulumi.Output[str]:
        """
        The public key type
        """
        return pulumi.get(self, "public_key_type")

    @property
    @pulumi.getter(name="sslFingerprint")
    def ssl_fingerprint(self) -> pulumi.Output[str]:
        """
        The SSL fingerprint
        """
        return pulumi.get(self, "ssl_fingerprint")

    @property
    @pulumi.getter(name="startDate")
    def start_date(self) -> pulumi.Output[str]:
        """
        The start date
        """
        return pulumi.get(self, "start_date")

    @property
    @pulumi.getter
    def subject(self) -> pulumi.Output[str]:
        """
        The subject
        """
        return pulumi.get(self, "subject")

    @property
    @pulumi.getter(name="subjectAlternativeNames")
    def subject_alternative_names(self) -> pulumi.Output[Sequence[str]]:
        """
        The subject alternative names
        """
        return pulumi.get(self, "subject_alternative_names")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

