﻿
#Область ОбработчикиСобытийФормы

Процедура ПриОткрытии()
	
	Если Не ПустаяСтрока(ПараметрЗапуска) Тогда
		ОбработатьПараметрыЗапуска(ПараметрЗапуска);
	КонецЕсли;
	
КонецПроцедуры

#КонецОбласти

#Область ОбработчикиКомандФормы

Процедура СравнитьНажатие(Элемент)
	СравнениеСпискаФайлов(ПервыйФайл, ВторойФайл);
КонецПроцедуры

#КонецОбласти

#Область ОбработчикиСобытийЭлементовШапкиФормы

Процедура ПервыйФайлНачалоВыбора(Элемент, СтандартнаяОбработка)
	НачалоВыбораФайла(Элемент, СтандартнаяОбработка, РежимДиалогаВыбораФайла.Открытие);
КонецПроцедуры

Процедура ВторойФайлНачалоВыбора(Элемент, СтандартнаяОбработка)
	НачалоВыбораФайла(Элемент, СтандартнаяОбработка, РежимДиалогаВыбораФайла.Открытие);
КонецПроцедуры

#КонецОбласти

#Область СлужебныеПроцедурыИФункции

Процедура СравнениеСпискаФайлов(ПервыйФайл, ВторойФайл, Результат = "")
	
	Перем ПервыйСписокФайлов, ВторойСписокФайлов;
	
	Если Не ПрочитатьСписокФайлов(ПервыйФайл, ПервыйСписокФайлов) Тогда
		ПервыйСписокФайлов = Новый Массив;
		ПервыйСписокФайлов.Добавить(ПервыйФайл);
	КонецЕсли;
	
	Если Не ПрочитатьСписокФайлов(ВторойФайл, ВторойСписокФайлов) Тогда
		ВторойСписокФайлов = Новый Массив;
		ВторойСписокФайлов.Добавить(ВторойФайл);
	КонецЕсли;
	
	Если ПервыйСписокФайлов.Количество() <> ВторойСписокФайлов.Количество() Тогда
		Предупреждение("Количество файлов в списках различается");
		Возврат;
	КонецЕсли;
	
	ЗаписываемРезультатВФайл = Не ПустаяСтрока(Результат);
	Если ЗаписываемРезультатВФайл Тогда
		ЗаписьТекста = Новый ЗаписьТекста(Результат, , , Ложь);
	КонецЕсли;
	
	Счетчик = 0;
	ВсеФайлыСовпали = Истина;
	
	Пока Счетчик < ПервыйСписокФайлов.Количество() Цикл
		
		ПервыйФайлДляСравнения = ПервыйСписокФайлов[Счетчик];
		ВторойФайлДляСравнения = ВторойСписокФайлов[Счетчик];
		
		Если ФайлыСходятся(ПервыйФайлДляСравнения, ВторойФайлДляСравнения, ЗаписываемРезультатВФайл) Тогда
			
			Если ЗаписываемРезультатВФайл Тогда
				ЗаписьТекста.ЗаписатьСтроку(ПервыйФайлДляСравнения);
			КонецЕсли;
			
		Иначе
			ВсеФайлыСовпали = Ложь;
		КонецЕсли;
		
		Счетчик = Счетчик + 1;
		
	КонецЦикла;
	
	Если ЗаписываемРезультатВФайл Тогда
		ЗаписьТекста.Закрыть();
	КонецЕсли;
	
	Если ВсеФайлыСовпали И Не ЗаписываемРезультатВФайл Тогда
		Предупреждение("Все файлы сходятся");
	КонецЕсли;
	
КонецПроцедуры

Функция ФайлыСходятся(ПервыйФайл, ВторойФайл, ЗаписываемРезультатВФайл = Ложь)
	
	Перем УдалитьПервыйФайл, УдалитьВторойФайл;
	
	ПервыйВременныйФайл = ПолучитьИмяФайлаДляСравнения(ПервыйФайл, УдалитьПервыйФайл);
	ВторойВременныйФайл = ПолучитьИмяФайлаДляСравнения(ВторойФайл, УдалитьВторойФайл);

	СравнениеФайлов = Новый СравнениеФайлов;
	
	СравнениеФайлов.ПервыйФайл = ПервыйВременныйФайл;
	СравнениеФайлов.ВторойФайл = ВторойВременныйФайл;
	
	СравнениеФайлов.СпособСравнения = СпособСравненияФайлов.ТабличныйДокумент;
	СравнениеФайлов.ИгнорироватьПустоеПространство = Истина;
		
	ФайлыСовпали = СравнениеФайлов.Сравнить();
	
	Если Не ФайлыСовпали И Не ЗаписываемРезультатВФайл Тогда
		СравнениеФайлов.ПоказатьРазличияМодально();
	КонецЕсли;
	
	Если УдалитьПервыйФайл Тогда
		УдалитьФайлы(ПервыйВременныйФайл);
	КонецЕсли;
	
	Если УдалитьВторойФайл Тогда
		УдалитьФайлы(ВторойВременныйФайл);
	КонецЕсли;
	
	Возврат ФайлыСовпали;
	
КонецФункции

Функция ПрочитатьСписокФайлов(ИмяФайла, СписокФайлов)
	
	ОбъектФайл = Новый Файл(ИмяФайла);
	
	Если ОбъектФайл.Расширение<>".txt" Тогда
		Возврат Ложь;
	КонецЕсли;
	
	СписокФайлов = Новый Массив;
	ЧтениеТекста = Новый ЧтениеТекста(ИмяФайла, КодировкаТекста.UTF8);
	
	СтрокаТекста = ЧтениеТекста.ПрочитатьСтроку();
	Пока СтрокаТекста <> Неопределено Цикл
		СписокФайлов.Добавить(СтрокаТекста);
		СтрокаТекста = ЧтениеТекста.ПрочитатьСтроку();
	КонецЦикла;
	
	ЧтениеТекста.Закрыть();
	
	Возврат Истина;
	
КонецФункции

Функция ПолучитьИмяФайлаДляСравнения(Файл, ВременныйФайл)
	
	ОбъектФайл = Новый Файл(Файл);
	
	Если ОбъектФайл.Расширение=".xml" Тогда
		
		ФайлДляСравнения = ПрочитатьТабличныйДокументИзXML(Файл);
		ВременныйФайл = Истина;
		
	Иначе
		
		ФайлДляСравнения = Файл;
		ВременныйФайл = Ложь;
		
	КонецЕсли;
	
	Возврат ФайлДляСравнения;

КонецФункции

Функция ПрочитатьТабличныйДокументИзXML(Файл)
	
	ВременныйФайлРаспаковки = ПолучитьИмяВременногоФайла("mxl");
	
	ЧтениеXML =  Новый ЧтениеXML;
	ЧтениеXML.ОткрытьФайл(Файл);
	ТабДок = СериализаторXDTO.ПрочитатьXML(ЧтениеXML, Тип("ТабличныйДокумент"));
	ТабДок.Записать(ВременныйФайлРаспаковки);

	Возврат ВременныйФайлРаспаковки;
	
КонецФункции

Процедура НачалоВыбораФайла(Элемент, СтандартнаяОбработка, РежимДиалога)
	
	СтандартнаяОбработка = Ложь;
	
	ДиалогВыбораФайла = Новый ДиалогВыбораФайла(РежимДиалога);
	
	Если ЗначениеЗаполнено(Элемент.Значение) Тогда
		
		Файл = Новый Файл(Элемент.Значение);
		ДиалогВыбораФайла.Каталог = Файл.Путь;
		
	КонецЕсли;
	
	ДиалогВыбораФайла.Заголовок = "Выберите файл";
		
	Если ДиалогВыбораФайла.Выбрать() Тогда
		Элемент.Значение = ДиалогВыбораФайла.ПолноеИмяФайла;
	КонецЕсли;
	
КонецПроцедуры

Процедура ОбработатьПараметрыЗапуска(ПараметрЗапуска)
	
	Параметры = РазобратьПараметрыЗапуска(ПараметрЗапуска);
	
	ПервыйФайл = Параметры.First;
	ВторойФайл = Параметры.Second;
	
	Если Параметры.Свойство("Result") Тогда
		Результат = Параметры.Result;
	КонецЕсли;
	
	СравнениеСпискаФайлов(ПервыйФайл, ВторойФайл, Результат);
	ЗавершитьРаботуСистемы(Ложь);
	
КонецПроцедуры

Функция РазобратьПараметрыЗапуска(СтрокаПараметров)
	
	МассивПараметров = СтрРазделить(СтрокаПараметров, ";", Ложь);
	
	Структура = Новый Структура;
	
	Для Каждого Элемент Из МассивПараметров Цикл
		
		КлючПараметр = СтрРазделить(Элемент, "=", Ложь);
		Структура.Вставить(ТРег(СокрЛП(КлючПараметр[0])), СокрЛП(КлючПараметр[1]));
		
	КонецЦикла;
	
	Возврат Структура;
	
КонецФункции

#КонецОбласти

