#!/usr/bin/env python3
# -*- coding: utf-8 -*-
#
# scikit-fda documentation build configuration file, created by
# sphinx-quickstart on Sun Oct 22 18:46:59 2017.
#
# This file is execfile()d with the current directory set to its
# containing dir.
#
# Note that not all possible configuration values are present in this
# autogenerated file.
#
# All configuration values have a default; values that are commented out
# serve to show the default.

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#

import os
import sys
import warnings

import pkg_resources
# Patch sphinx_gallery.binder.gen_binder_rst so as to point to .py file in
# repository
import sphinx_gallery.binder
# -- Extensions to the  Napoleon GoogleDocstring class ---------------------
from sphinx.ext.napoleon.docstring import GoogleDocstring

try:
    release = pkg_resources.get_distribution('scikit-fda').version
except pkg_resources.DistributionNotFound:
    print('To build the documentation, The distribution information of\n'
          'scikit-fda has to be available.  Either install the package\n'
          'into your development environment or run "setup.py develop"\n'
          'to setup the metadata.  A virtualenv is recommended!\n')
    sys.exit(1)
del pkg_resources

version = '.'.join(release.split('.')[:2])

# -- General configuration ------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
#
# needs_sphinx = '1.0'

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = ['sphinx.ext.autodoc',
              'sphinx.ext.autosummary',
              'sphinx.ext.todo',
              'sphinx.ext.viewcode',
              'sphinx.ext.napoleon',
              'sphinx.ext.mathjax',
              'sphinx_rtd_theme',
              'sphinx_gallery.gen_gallery',
              'sphinx.ext.intersphinx',
              'sphinx.ext.doctest',
              'jupyter_sphinx',
              'sphinx.ext.autodoc.typehints',
              'sphinxcontrib.bibtex']

bibtex_bibfiles = ['refs.bib']

autodoc_default_flags = ['members', 'inherited-members']


doctest_global_setup = '''
import numpy as np
np.set_printoptions(legacy='1.13')
'''

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
#
# source_suffix = ['.rst', '.md']
source_suffix = '.rst'

# The master toctree document.
master_doc = 'index'

# General information about the project.
project = 'scikit-fda'
copyright = ('2019, Grupo de Aprendizaje Automático - ' +
             'Universidad Autónoma de Madrid')
author = 'Author'

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = 'en'

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This patterns also effect to html_static_path and html_extra_path
exclude_patterns = ['_build', 'Thumbs.db', '.DS_Store']

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = 'sphinx'

# If true, `todo` and `todoList` produce output, else they produce nothing.
todo_include_todos = True

# -- Options for HTML output ----------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
html_theme = "pydata_sphinx_theme"

html_logo = "logo.png"

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
#
html_theme_options = {
    "use_edit_page_button": True,
    "github_url": "https://github.com/GAA-UAM/scikit-fda",
    "icon_links": [
        {
            "name": "PyPI",
            "url": "https://pypi.org/project/scikit-fda",
            "icon": "https://avatars.githubusercontent.com/u/2964877",
            "type": "url",
        },
    ],
    "logo": {
        "image_light": "logo.png",
        "image_dark": "logo.png",
    },
}

html_context = {
    "github_user": "GAA-UAM",
    "github_repo": "scikit-fda",
    "github_version": "develop",
    "doc_path": "docs",
}

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['_static']

# Custom sidebar templates, must be a dictionary that maps document names
# to template names.

# -- Options for HTMLHelp output ------------------------------------------

# Output file base name for HTML help builder.
htmlhelp_basename = 'skfdadoc'

# -- Options for LaTeX output ---------------------------------------------

latex_engine = 'lualatex'

latex_elements = {
    # The paper size ('letterpaper' or 'a4paper').
    #
    # 'papersize': 'letterpaper',

    # The font size ('10pt', '11pt' or '12pt').
    #
    # 'pointsize': '10pt',

    # Additional stuff for the LaTeX preamble.
    #
    # 'preamble': '',

    # Latex figure (float) alignment
    #
    # 'figure_align': 'htbp',
}

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title,
#  author, documentclass [howto, manual, or own class]).
latex_documents = [
    (master_doc, 'skfda.tex', 'scikit-fda Documentation',
     'Author', 'manual'),
]

# -- Options for manual page output ---------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [
    (master_doc, 'skfda', 'scikit-fda Documentation',
     [author], 1)
]

# -- Options for Texinfo output -------------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
    (master_doc, 'skfda', 'scikit-fda Documentation',
     author, 'skfda', 'One line description of project.',
     'Miscellaneous'),
]

# -- Options for Epub output ----------------------------------------------

# Bibliographic Dublin Core info.
epub_title = project
epub_author = author
epub_publisher = author
epub_copyright = copyright

# The unique identifier of the text. This can be a ISBN number
# or the project homepage.
#
# epub_identifier = ''

# A unique identification for the text.
#
# epub_uid = ''

# A list of files that should not be packed into the epub file.
epub_exclude_files = ['search.html']

intersphinx_mapping = {
    'python': ('https://docs.python.org/{.major}'.format(
        sys.version_info), None),
    'numpy': ('https://docs.scipy.org/doc/numpy/', None),
    'scipy': ('https://docs.scipy.org/doc/scipy/reference', None),
    'sklearn': ('https://scikit-learn.org/stable', None),
    'matplotlib': ('https://matplotlib.org/', None),
    'pandas': ('https://pandas.pydata.org/pandas-docs/stable/', None),
}


tutorial_list = [
    "plot_introduction.py",
    "plot_getting_data.py",
    "plot_basis_representation.py",
    "plot_skfda_sklearn.py",
]


class SkfdaExplicitSubOrder(object):
    """
    Class for use within the 'within_subsection_order' key.

    Inspired by Matplotlib gallery.

    """

    def __init__(self, src_dir: str) -> None:
        self.src_dir = src_dir  # src_dir is unused here
        self.ordered_list = tutorial_list

    def __call__(self, filename: str) -> str:
        """Return a string determining the sort order."""
        if filename in self.ordered_list:
            ind = self.ordered_list.index(filename)
            return f"{ind:04d}"

        # ensure not explicitly listed items come last.
        return f"zzz{filename}"


rtd_version = os.environ.get("READTHEDOCS_VERSION", "latest")
branch = "master" if rtd_version == "stable" else "develop"

sphinx_gallery_conf = {
    # path to your examples scripts
    'examples_dirs': ['../examples', '../tutorial'],
    # path where to save gallery generated examples
    'gallery_dirs': ['auto_examples', 'auto_tutorial'],
    'reference_url': {
        # The module you locally document uses None
        'skfda': None,
    },
    'backreferences_dir': 'backreferences',
    'doc_module': 'skfda',
    'within_subsection_order': SkfdaExplicitSubOrder,
    'binder': {
        'org': 'GAA-UAM',
        'repo': 'scikit-fda',
        'branch': branch,
        'binderhub_url': 'https://mybinder.org',
        'dependencies': ['../binder/requirements.txt'],
        'notebooks_dir': '../examples',
    },
}

warnings.filterwarnings(
    "ignore",
    category=UserWarning,
    message='Matplotlib is currently using agg, which is a'
    ' non-GUI backend, so cannot show the figure.',
)

autosummary_generate = True
autodoc_typehints = "description"
napoleon_use_rtype = True

autodoc_type_aliases = {
    "ArrayLike": "ArrayLike",
    "GridPointsLike": "Union[ArrayLike, Sequence[ArrayLike]]",
}

# Napoleon fix for attributes
# Taken from
# https://michaelgoerz.net/notes/extending-sphinx-napoleon-docstring-sections.html


# first, we define new methods for any new sections and add them to the class


def parse_keys_section(self, section):
    return self._format_fields('Keys', self._consume_fields())


GoogleDocstring._parse_keys_section = parse_keys_section


def parse_attributes_section(self, section):
    return self._format_fields('Attributes', self._consume_fields())


GoogleDocstring._parse_attributes_section = parse_attributes_section


def parse_class_attributes_section(self, section):
    return self._format_fields('Class Attributes', self._consume_fields())


GoogleDocstring._parse_class_attributes_section = parse_class_attributes_section

# we now patch the parse method to guarantee that the the above methods are
# assigned to the _section dict


def patched_parse(self):
    self._sections['keys'] = self._parse_keys_section
    self._sections['class attributes'] = self._parse_class_attributes_section
    self._unpatched_parse()


GoogleDocstring._unpatched_parse = GoogleDocstring._parse
GoogleDocstring._parse = patched_parse


# Binder integration
# Taken from
# https://stanczakdominik.github.io/posts/simple-binder-usage-with-sphinx-gallery-through-jupytext/
original_gen_binder_rst = sphinx_gallery.binder.gen_binder_rst


def patched_gen_binder_rst(*args, **kwargs):
    return original_gen_binder_rst(*args, **kwargs).replace(
        "../examples/auto_",
        "",
    ).replace(
        ".ipynb",
        ".py",
    )


#  # And then we finish our monkeypatching misdeed by redirecting

# sphinx-gallery to use our function:
sphinx_gallery.binder.gen_binder_rst = patched_gen_binder_rst
