# 786
# Aldy source: test_cn_real.py
#   This file is subject to the terms and conditions defined in
#   file 'LICENSE', which is part of this source code package.


import pytest  # noqa

from .test_cn_synthetic import assert_cn


def test_many_copies_multiple_solutions(real_gene, solver):
    # HG00465
    assert_cn(
        real_gene,
        solver,
        [
            {"1": 2, "141.1001": 2},
            {"1": 2, "61": 2},
            {"1": 2, "63": 2},
            {"1": 2, "141.1001": 1, "61": 1},
            {"1": 2, "141.1001": 1, "63": 1},
            {"1": 2, "61": 1, "63": 1},
        ],
        {
            "e1": (3.8, 2.1),
            "i1": (3.3, 2.5),
            "e2": (3.7, 2.1),
            "i2": (4.0, 1.9),
            "e5": (3.9, 2.0),
            "i5": (4.1, 2.0),
            "e6": (4.0, 2.0),
            "i6": (3.9, 1.8),
            "e3": (4.5, 1.8),
            "e9": (2.5, 3.6),
            "pce": (0, 4.1),
        },
    )


def test_right_fusion(real_gene, solver):
    # HG01190
    assert_cn(
        real_gene,
        solver,
        [{"1": 1, "68": 1}],
        {
            "e1": (1.8, 2.0),
            "i1": (1.9, 2.0),
            "e2": (0.9, 2.8),
            "i2": (1.0, 3.0),
            "e5": (1.0, 3.3),
            "i5": (1.1, 3.2),
            "e6": (1.0, 3.1),
            "i6": (1.1, 2.9),
            "e3": (1.1, 2.7),
            "e9": (1.3, 2.7),
            "pce": (0, 3.1),
        },
    )


def test_normal(real_gene, solver):
    # HG02260
    assert_cn(
        real_gene,
        solver,
        [{"1": 2}],
        {
            "e1": (1.8, 2.0),
            "i1": (1.9, 2.0),
            "e2": (2.0, 1.9),
            "i2": (1.9, 1.8),
            "e5": (1.8, 2.1),
            "i5": (1.9, 2.0),
            "e6": (2.0, 2.1),
            "i6": (2.0, 1.9),
            "e3": (2.0, 1.8),
            "e9": (2.1, 1.8),
            "pce": (0, 2.0),
        },
    )


def test_deletion(real_gene, solver):
    # NA12336
    assert_cn(
        real_gene,
        solver,
        [{"1": 1}],
        {
            "e1": (1.0, 1.9),
            "i1": (1.3, 1.6),
            "e2": (0.9, 1.6),
            "i2": (1.0, 1.9),
            "e5": (0.9, 2.2),
            "i5": (0.9, 2.0),
            "e6": (0.9, 1.9),
            "i6": (0.9, 1.8),
            "e3": (1.1, 1.7),
            "e9": (1.0, 1.8),
            "pce": (0, 1.9),
        },
    )


def test_right_fusion_with_copy(real_gene, solver):
    # NA12878
    assert_cn(
        real_gene,
        solver,
        [{"1": 2, "68": 1}],
        {
            "e1": (2.6, 2.0),
            "i1": (2.4, 2.3),
            "e2": (1.8, 2.9),
            "i2": (2.0, 2.9),
            "e5": (1.9, 3.0),
            "i5": (1.9, 3.0),
            "e6": (1.8, 2.9),
            "i6": (1.9, 2.9),
            "e3": (2.2, 2.5),
            "e9": (2.1, 2.6),
            "pce": (0, 3.0),
        },
    )


def test_normal2(real_gene, solver):
    # NA19239
    assert_cn(
        real_gene,
        solver,
        [{"1": 2}],
        {
            "e1": (1.6, 2.2),
            "i1": (2.0, 2.0),
            "e2": (2.0, 1.9),
            "i2": (2.0, 2.1),
            "e5": (1.9, 2.2),
            "i5": (2.0, 2.0),
            "e6": (1.9, 2.0),
            "i6": (1.9, 2.0),
            "e3": (2.1, 1.9),
            "e9": (2.1, 2.0),
            "pce": (0, 2.1),
        },
    )


def test_left_fusion(real_gene, solver):
    # NA19790
    assert_cn(
        real_gene,
        solver,
        [{"1": 2, "78": 1}, {"1": 2, "67": 1}],
        {
            "e1": (1.9, 2.0),
            "i1": (2.0, 1.9),
            "e2": (2.0, 2.0),
            "i2": (2.0, 2.0),
            "e5": (2.8, 1.2),
            "i5": (2.9, 1.0),
            "e6": (2.7, 0.9),
            "i6": (2.8, 0.9),
            "e3": (2.1, 1.9),
            "e9": (3.1, 1.0),
            "pce": (0, 1.0),
        },
    )


def test_gap(real_gene, solver):
    data = {
        "e1": (1.0, 1.9),
        "i1": (1.3, 1.6),
        "e2": (0.9, 1.6),
        "i2": (1.0, 1.9),
        "e5": (0.9, 2.2),
        "i5": (0.9, 2.0),
        "e6": (0.9, 1.9),
        "i6": (0.9, 1.8),
        "e3": (1.1, 1.7),
        "e9": (1.0, 1.8),
        "pce": (0, 1.9),
    }

    assert_cn(real_gene, solver, [{"1": 1}], data, gap=0.0)
    assert_cn(
        real_gene,
        solver,
        [
            {"1": 1},
            {"13": 1, "68": 1},
            {"16": 1, "141.1001": 1},
            {"16": 1, "61": 1},
            {"16": 1, "63": 1},
            {"141.1001": 1, "76": 1},
            {"141.1001": 1, "77": 1},
            {"61": 1, "76": 1},
            {"61": 1, "77": 1},
            {"63": 1, "76": 1},
            {"63": 1, "77": 1},
        ],
        data,
        gap=0.2,
    )
    assert_cn(
        real_gene,
        solver,
        [
            {"1": 1},
            {"13": 1, "68": 1},
            {"16": 1, "141.1001": 1},
            {"16": 1, "61": 1},
            {"16": 1, "63": 1},
            {"141.1001": 1, "76": 1},
            {"141.1001": 1, "77": 1},
            {"61": 1, "76": 1},
            {"61": 1, "77": 1},
            {"63": 1, "76": 1},
            {"63": 1, "77": 1},
        ],
        data,
        gap=0.65,
    )
