"use strict";
const assert_1 = require("@aws-cdk/assert");
const codepipeline = require("@aws-cdk/aws-codepipeline");
const sns = require("@aws-cdk/aws-sns");
const core_1 = require("@aws-cdk/core");
const cpactions = require("../lib");
module.exports = {
    'manual approval Action': {
        'allows passing an SNS Topic when constructing it'(test) {
            const stack = new core_1.Stack();
            const topic = new sns.Topic(stack, 'Topic');
            const manualApprovalAction = new cpactions.ManualApprovalAction({
                actionName: 'Approve',
                notificationTopic: topic,
            });
            const pipeline = new codepipeline.Pipeline(stack, 'pipeline');
            const stage = pipeline.addStage({ stageName: 'stage' });
            stage.addAction(manualApprovalAction);
            test.equal(manualApprovalAction.notificationTopic, topic);
            test.done();
        },
        'renders CustomData and ExternalEntityLink even if notificationTopic was not passed'(test) {
            const stack = new core_1.Stack();
            new codepipeline.Pipeline(stack, 'pipeline', {
                stages: [
                    {
                        stageName: 'Source',
                        actions: [new cpactions.GitHubSourceAction({
                                actionName: 'Source',
                                output: new codepipeline.Artifact(),
                                oauthToken: core_1.SecretValue.plainText('secret'),
                                owner: 'aws',
                                repo: 'aws-cdk',
                            })],
                    },
                    {
                        stageName: 'Approve',
                        actions: [
                            new cpactions.ManualApprovalAction({
                                actionName: 'Approval',
                                additionalInformation: 'extra info',
                                externalEntityLink: 'external link',
                            }),
                        ],
                    },
                ],
            });
            assert_1.expect(stack).to(assert_1.haveResourceLike('AWS::CodePipeline::Pipeline', {
                'Stages': [
                    {
                        'Name': 'Source',
                    },
                    {
                        'Name': 'Approve',
                        'Actions': [
                            {
                                'Name': 'Approval',
                                'Configuration': {
                                    'CustomData': 'extra info',
                                    'ExternalEntityLink': 'external link',
                                },
                            },
                        ],
                    },
                ],
            }));
            test.done();
        },
    },
};
//# sourceMappingURL=data:application/json;base64,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