define(["require", "exports"], function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.target_name = 'AUTO_SYNC::notebook';
    function get_cell_from_notebook(j, cell_number) {
        let cell = j.notebook.get_cell(cell_number);
        while (cell === null) {
            // Kind of meh hack to just keep spamming cells at bottom until we get to the cell we want.
            j.notebook.insert_cell_at_bottom();
            cell = j.notebook.get_cell(cell_number);
        }
        return cell;
    }
    exports.get_cell_from_notebook = get_cell_from_notebook;
    function update_cell_contents(j, data) {
        let cell = get_cell_from_notebook(j, data.cell_number);
        cell.set_text(data.cell_contents);
    }
    exports.update_cell_contents = update_cell_contents;
    function execute_cell_contents(j, data) {
        let cell = get_cell_from_notebook(j, data.cell_number);
        cell.focus_cell();
        cell.execute();
    }
    exports.execute_cell_contents = execute_cell_contents;
    function create_and_register_comm(j) {
        j.notebook.kernel.comm_manager.register_target(exports.target_name, 
        // comm is the frontend comm instance
        // msg is the comm_open message, which can carry data
        function (comm, _msg) {
            // Register handlers for later messages:
            comm.on_msg(function (msg) {
                if (msg.content.data.command === 'update') {
                    update_cell_contents(j, msg.content.data);
                }
                else if (msg.content.data.command === 'execute') {
                    execute_cell_contents(j, msg.content.data);
                }
                else {
                    // debugger;
                    console.log('Got an unexpected message: ', msg);
                }
            });
            comm.on_close(function (msg) {
                console.log('close', msg);
            });
        });
    }
    exports.create_and_register_comm = create_and_register_comm;
});
//# sourceMappingURL=utils.js.map