/* Select Widget
*/
Faceted.MultiSelectWidget = function(wid){
  var self = this;
  this.wid = wid;
  this.widget = jQuery('#' + this.wid + '_widget');
  this.widget.show();
  this.title = this.widget.find('legend').html();
  this.elements = this.widget.find('option');
  this.select = jQuery('#' + this.wid);
  this.multiple = this.select.attr("multiple") ? true: false;
  this.placeholder = this.widget.data('placeholder');
  this.closeOnSelect = this.widget.data('closeonselect');
  this.selected = [];

  this.select.select2({
    placeholder: this.placeholder,
    closeOnSelect : this.closeOnSelect,
    allowClear: true
  });

  // Faceted operator
  this.operatorElem = this.widget.find('.faceted-operator a');
  this.operatorVisible = this.operatorElem.length ? true: false;

  if(this.operatorVisible){
    this.operator = this.operatorElem.data('value');

    // Handle operator click
    this.operatorElem.click(function(evt){
      evt.preventDefault();
      self.operator_click(this, evt);
    });

    // Update text
    this.operatorElem.text(this.operatorElem.data(this.operator));

  }else{
    this.operator = this.widget.data('operator');
  }

  // Faceted version
  this.version = '';
  var version = jQuery('#faceted-version');
  if(version){
    this.version = version.text();
  }

  // Handle change
  jQuery('form', this.widget).submit(function(){
    return false;
  });

  var js_widget = this;
  this.select.on('select2-close', function(evt){
    js_widget.select_change(this, evt);
  });

  this.select.on('select2-removed', function(evt){
    js_widget.select_change(this, evt);
  });

  // Default value
  var value = this.select.val();
  if(value){
    this.selected = js_widget.widget.find('option:selected');
    if(this.multiple) {
      Faceted.Query[this.wid] = value;
    } else {
      Faceted.Query[this.wid] = [value];
    }
  }

  if(this.operatorVisible){
    Faceted.Query[self.wid + '-operator'] = self.operator;
  }

  // Bind events
  jQuery(Faceted.Events).bind(Faceted.Events.QUERY_CHANGED, function(evt){
    js_widget.synchronize();
  });
  jQuery(Faceted.Events).bind(Faceted.Events.RESET, function(evt){
    js_widget.reset();
  });
  if(this.widget.hasClass('faceted-count')){
    var sortcountable = this.widget.hasClass('faceted-sortcountable');
    jQuery(Faceted.Events).bind(Faceted.Events.QUERY_INITIALIZED, function(evt){
      js_widget.count(sortcountable);
    });
    jQuery(Faceted.Events).bind(Faceted.Events.FORM_DO_QUERY, function(evt, data){
      if(self.operator != 'and' && (data.wid == self.wid || data.wid == 'b_start')){
        return;
      }
      js_widget.count(sortcountable);
    });
  }
};

Faceted.MultiSelectWidget.prototype = {
  select_change: function(element, evt){
    if(!jQuery(element).val()){
      element = null;
    }
    this.do_query(element);
  },

  operator_click: function(element, evt){
    var self = this;
    if(self.operator === 'or'){
      self.operator = 'and';
      self.operatorElem.text(self.operatorElem.data('and'));
    }else{
      self.operator = 'or';
      self.operatorElem.text(self.operatorElem.data('or'));
    }
    Faceted.Form.do_query(this.wid + '-operator', self.operator);
  },

  operator_label: function(){
    if(!this.operatorVisible){
      return '';
    }

    var label = this.widget.find('.faceted-operator label');
    label = label.length ? label.text(): '';
    label += ' ' + this.operatorElem.data(this.operator);

    return '(' + label + ')';
  },

  do_query: function(element){
    if(!element){
      this.selected = [];
      return Faceted.Form.do_query(this.wid, []);
    }else{
      var value = jQuery(element).val();
      this.selected = this.widget.find('option:selected');
      return Faceted.Form.do_query(this.wid, value);
    }
  },

  reset: function(){
    this.select.val(null).trigger("change.select2");
    this.selected = [];
    this.widget.removeClass("faceted-widget-active");
  },

  synchronize: function(){
    var value = Faceted.Query[this.wid];
    if(value){
      this.select.val(value).trigger("change.select2");
      this.selected = this.widget.find('option:selected');
      this.widget.addClass("faceted-widget-active");
    } else {
      this.reset();
    }

    var operator = Faceted.Query[this.wid + '-operator'];
    if(this.operatorVisible && operator){
      operator = operator[0];
      this.operator = operator;
      this.operatorElem.data('value', operator);
      this.operatorElem.text(this.operatorElem.data(this.operator));
    }
  },

  criteria: function(){
    var html = [];
    var title = this.criteria_title();
    var body = this.criteria_body();
    if(title){
      html.push(title);
    }
    if(body){
      html.push(body);
    }
    return html;
  },

  criteria_title: function(){
    if(!this.selected.length){
      return '';
    }

    var link = jQuery('<a href="#" class="faceted-remove">remove</a>');
    link.attr('id', 'criteria_' + this.wid);
    link.attr('title', 'Remove ' + this.title + ' filters');
    var widget = this;
    link.click(function(evt){
      widget.criteria_remove();
      return false;
    });

    var html = jQuery('<dt>');
    html.attr('id', 'criteria_' + this.wid + '_label');
    html.append(link);
    html.append('<span>' + this.title + '</span>');
    return html;
  },

  criteria_body: function(){
    if(!this.selected.length){
      return '';
    }

    var widget = this;
    var html = jQuery('<dd>');
    html.attr('id', 'criteria_' + this.wid + '_entries');

    widget.selected.each(function(i){
      var span = jQuery('<span class="faceted-multiselect-criterion">');
      var element = jQuery(this);
      var id = element.attr('id');
      var value = element.val();
      var label = element.attr("title");

      var link = jQuery('<a href="#" class="faceted-remove">remove</a>');
      link.attr('id', 'criteria_' + id);
      link.attr('title', 'Remove ' + label + ' filter');
      link.click(function(evt){
        widget.criteria_remove(value, element);
        return false;
      });

      span.append(link);
      jQuery('<span>').text(label).appendTo(span);
      html.append(span);
    });

    return html;
  },


  criteria_remove: function(value, element){
    // Remove all
    if(!value){
      this.select.val(null).trigger("change.select2");
      this.do_query();
    }else{
      element.attr('selected', false);
      this.select.trigger("change.select2");
      this.do_query(this.select);
    }
  },


  count: function(sortcountable){
    var query = Faceted.SortedQuery();
    query.cid = this.wid;
    if(this.version){
      query.version = this.version;
    }
    if(this.operator && !query[this.wid + '-operator']){
      query[this.wid + '-operator'] = this.operator;
    }

    var context = this;
    jQuery(Faceted.Events).trigger(Faceted.Events.AJAX_START, {wid: context.wid});
    jQuery.getJSON(Faceted.BASEURL + '@@faceted_counter', query, function(data){
      context.count_update(data, sortcountable);
      jQuery(Faceted.Events).trigger(Faceted.Events.DO_UPDATE);
      jQuery(Faceted.Events).trigger(Faceted.Events.AJAX_STOP, {wid: context.wid});
    });
  },

  count_update: function(data, sortcountable){
    var context = this;
    var select = jQuery('select', context.widget);
    var options = jQuery('option', context.widget);
    var current_val = select.val();
    jQuery(options).each(function(){
      var option = jQuery(this);
      if(!option.attr('title')){
        return;
      }
      option.removeClass('faceted-select-item-disabled');
      option.attr('disabled', false);
      var key = option.val();

      var value = data[key];
      value = value ? value : 0;
      var option_txt = option.attr('title');
      option_txt += ' (' + value + ')';

      option.html(option_txt);
      if(sortcountable){
        option.data('count', value);
      }
      if(!value){
        option.attr('disabled', 'disabled');
        option.addClass('faceted-select-item-disabled');
      }
    });
    if(sortcountable){
      options.detach().sort(function(x, y) {
        var a = jQuery(x).data('count');
        var b = jQuery(y).data('count');
        return b - a;
      });
      select.append(options);
      select.val(current_val);
    }
  }
};

Faceted.initializeMultiSelectWidget = function(evt){
  jQuery('div.faceted-multiselect-widget').each(function(){
    var wid = jQuery(this).attr('id');
    wid = wid.split('_')[0];
    Faceted.Widgets[wid] = new Faceted.MultiSelectWidget(wid);
  });
};

jQuery(document).ready(function(){
  jQuery(Faceted.Events).bind(
    Faceted.Events.INITIALIZE,
    Faceted.initializeMultiSelectWidget);
});
