import React  from 'react';

// eslint-disable-next-line @typescript-eslint/naming-convention

// @ts-ignore
const Link = ({ className, href, children }) => {

  const onClick = (event: { metaKey: any; ctrlKey: any; preventDefault: () => void; }) => {
    // if ctrl or meta key are held on click, allow default behavior of opening link in new tab
    if (event.metaKey || event.ctrlKey) {
      return;
    }

    // prevent full page reload
    event.preventDefault();
    // update url
    window.history.pushState({}, "", href);

    // communicate to Routes that URL has changed
    const navEvent = new PopStateEvent('popstate');
    window.dispatchEvent(navEvent);
  };

  return (
    <a className={className}> href={href} onClick={onClick}
      {children}
    </a>
  );
};

export default Link;
