# PPshare 平台介绍

## PPshare 的概况及使用说明

PPshare是一个长期专注于科研数据的应用性平台，平台提供直接从互联网爬取、社区采取和团队整理数据并将其存入数据库，通过对数据质量进行严格控制为用户提供高质量科研数据。PPshare是一个开放的、免费的数据众享平台、不带任何商业性质和目的。

首先要特别感谢  [FuShare](https://github.com/jindaxiang/fushare), [TuShare](https://github.com/waditu/tushare) 在代码和项目开发上对本项目提供的借鉴和学习的机会!

PPshare 是基于 Python 的经管类数据接口库, 目的是实现对宏观经济、区域经济、产业经济、金融类数据股等常用的基本面数据、实时和历史行情数据、衍生数据从数据采集、数据清洗到数据落地的一套工具, 主要用于学术研究目的.

将继续开放公众号平台和网站：[数据皮皮侠](http://www.ppmandata.cn/) 等社区工具为大家提供服务，感兴趣的朋友请扫描关注“数据皮皮侠”公众号：

![qrcode_for_gh_f11b9fcdb9f1_344](C:\Users\Romer\Desktop\qrcode_for_gh_f11b9fcdb9f1_344.jpg)

# PPshare 数据说明

## PPshare 宏观经济

### 中国宏观杠杆率

接口: macro_cnbs

目标地址: http://114.115.232.154:8080/

描述: 获取中国国家金融与发展实验室-中国宏观杠杆率数据

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称           | 类型  | 默认显示 | 描述        |
| :------------- | :---- | :------- | :---------- |
| 年份           | str   | Y        | 日期, 年-月 |
| 居民部门       | float | Y        | –           |
| 非金融企业部门 | float | Y        | –           |
| 政府部门       | float | Y        | –           |
| 中央政府       | float | Y        | –           |
| 地方政府       | float | Y        | –           |
| 实体经济部门   | float | Y        | –           |
| 金融部门资产方 | float | Y        | –           |
| 金融部门负债方 | float | Y        | –           |

接口示例

```python
import ppshare as pp
macro_cnbs_df = pp.macro_cnbs()
print(macro_cnbs_df)
```

数据示例

```
年份       居民部门     非金融企业部门  ...      实体经济部门    金融部门资产方    金融部门负债方
0   1993-12   8.311222   91.658000  ...  107.791459   8.896441   7.128428
1   1994-12   7.808230   82.411703  ...   98.354271   9.808787   6.796868
2   1995-12   8.240004   80.950106  ...   97.850373  10.009081   7.006151
3   1996-03   8.403456   81.711651  ...   99.241521  10.183896   7.186300
4   1996-06   8.581114   82.051373  ...   99.679459  10.379730   7.380510
..      ...        ...         ...  ...         ...        ...        ...
93  2018-09  52.575456  155.641011  ...  245.227043  61.350917  60.645733
94  2018-12  53.198837  153.553140  ...  243.702122  60.638348  60.936158
95  2019-03  54.277928  156.881879  ...  248.828108  60.542178  59.417322
96  2019-06  55.304291  155.743313  ...  249.533412  58.736094  58.727086
97  2019-09  56.314848  155.618498  ...  251.147265  55.820243  59.358625
```

### 国民经济运行状况

#### 经济状况

##### LPR品种数据

接口: macro_china_lpr

目标地址: http://data.eastmoney.com/cjsj/globalRateLPR.html

描述: 获取中国LPR品种数据, 数据区间从19910421-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称       | 类型  | 默认显示 | 描述                           |
| :--------- | :---- | :------- | :----------------------------- |
| TRADE_DATE | str   | Y        | 日期                           |
| LPR1Y      | float | Y        | LPR_1Y利率(%)                  |
| LPR5Y      | float | Y        | LPR_5Y利率(%)                  |
| RATE_1     | float | Y        | 短期贷款利率:6个月至1年(含)(%) |
| RATE_2     | float | Y        | 中长期贷款利率:5年以上(%)      |

接口示例

```python
import PPshare as pp
macro_china_lpr_df = PP.macro_china_lpr()
print(macro_china_lpr_df)
```

数据示例

```
               TRADE_DATE  LPR1Y  LPR5Y  RATE_1  RATE_2
0     2020-03-20 00:00:00   4.05   4.75    4.35    4.90
1     2020-02-20 00:00:00   4.05   4.75    4.35    4.90
2     2020-01-20 00:00:00   4.15   4.80    4.35    4.90
3     2019-12-20 00:00:00   4.15   4.80    4.35    4.90
4     2019-11-20 00:00:00   4.15   4.80    4.35    4.90
                   ...    ...    ...     ...     ...
1493  1995-07-01 00:00:00    NaN    NaN   12.06   15.30
1494  1995-01-01 00:00:00    NaN    NaN   10.98   14.76
1495  1993-07-11 00:00:00    NaN    NaN   10.98   14.04
1496  1993-05-15 00:00:00    NaN    NaN    9.36   12.24
1497  1991-04-21 00:00:00    NaN    NaN    8.64    9.72
```

##### 中国GDP年率报告

接口: macro_china_gdp_yearly

目标地址: https://datacenter.jin10.com/reportType/dc_chinese_gdp_yoy

描述: 获取中国年度GDP数据, 数据区间从20110120-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 年率 | float | Y        | 年率      |

接口示例

```
import PPshare as pp
macro_china_gdp_yearly_df = pp.macro_china_gdp_yearly()
print(macro_china_gdp_yearly_df)
print(macro_china_gdp_yearly_df.name)
```

数据示例

macro_china_gdp_yearly_df.name:

```
gdp
```

macro_china_gdp_yearly_df:

```
2011-01-20    9.8
2011-04-15    9.7
2011-07-13    9.5
2011-10-18    9.1
2012-01-17    8.9
2019-01-21    6.4
2019-04-17    6.4
2019-07-15    6.2
2019-10-18      6
2020-01-17      0
```

#### 物价水平

##### 中国CPI年率报告

接口: macro_china_cpi_yearly

目标地址: https://datacenter.jin10.com/reportType/dc_chinese_cpi_yoy

描述: 获取中国年度CPI数据, 数据区间从19860201-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 年率 | float | Y        | 年率      |

接口示例

```
import PPshare as pp
macro_china_cpi_yearly_df = pp.macro_china_cpi_yearly()
print(macro_china_cpi_yearly_df)
print(macro_china_cpi_yearly_df.name)
```

数据示例

macro_china_cpi_yearly_df.name:

```
cpi
```

macro_china_cpi_yearly_df:

```
1986-02-01     7.1
1986-03-01     7.1
1986-04-01     7.1
1986-05-01     7.1
1986-06-01     7.1
1986-07-01     7.1
1986-08-01     7.1
1986-09-01     7.1
2019-08-09     2.8
2019-09-10     2.8
2019-10-15       3
2019-11-09     3.8
2019-12-10     4.5
2020-01-09     4.5
```

##### 中国CPI月率报告

接口: macro_china_cpi_monthly

目标地址: https://datacenter.jin10.com/reportType/dc_chinese_cpi_mom

描述: 获取中国月度CPI数据, 数据区间从19960201-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 年率 | float | Y        | 年率      |

接口示例

```
import PPshare as PP
macro_china_cpi_monthly_df = PP.macro_china_cpi_monthly()
print(macro_china_cpi_monthly_df)
print(macro_china_cpi_monthly_df.name)
```

数据示例

macro_china_cpi_monthly_df.name:

```
cpi
```

macro_china_cpi_monthly_df:

```
1996-02-01     2.1
1996-03-01     2.3
1996-04-01     0.6
1996-05-01     0.7
2019-07-10    -0.1
2019-08-09     0.4
2019-09-10     0.7
2019-10-15     0.9
2019-11-09     0.9
2019-12-10     0.4
2020-01-09       0
```

##### 中国PPI年率报告

接口: macro_china_ppi_yearly

目标地址: https://datacenter.jin10.com/reportType/dc_chinese_ppi_yoy

描述: 获取中国年度PPI数据, 数据区间从19950801-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 年率 | float | Y        | 年率      |

接口示例

```
import PPshare as PP
macro_china_ppi_yearly_df = PP.macro_china_ppi_yearly()
print(macro_china_ppi_yearly_df)
print(macro_china_ppi_yearly_df.name)
```

数据示例

macro_china_ppi_yearly_df.name:

```
ppi
```

macro_china_ppi_yearly_df:

```
1995-08-01    13.5
1995-09-01      13
1995-10-01    12.9
1995-11-01    12.5
1995-12-01    11.1
2019-08-09    -0.3
2019-09-10    -0.8
2019-10-15    -1.2
2019-11-09    -1.6
2019-12-10    -1.4
2020-01-09    -0.5
```

### 贸易状况

#### 以美元计算出口年率

接口: macro_china_exports_yoy

目标地址: https://datacenter.jin10.com/reportType/dc_chinese_exports_yoy

描述: 获取中国以美元计算出口年率报告, 数据区间从19820201-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 年率 | float | Y        | 年率      |

接口示例

```
import PPshare as PP
macro_china_exports_yoy_df = PP.macro_china_exports_yoy()
print(macro_china_exports_yoy_df)
print(macro_china_exports_yoy_df.name)
```

数据示例

macro_china_exports_yoy_df.name:

```
china_exports_yoy
```

macro_china_exports_yoy_df:

```
1982-02-01      8.7
1982-03-01     23.2
1982-04-01     12.2
1982-05-01     -2.5
1982-06-01     41.5
2019-03-08    -20.8
2019-04-12     14.2
2019-05-08     -2.7
2019-06-10      1.1
2019-07-12     -1.3
2019-08-08      3.3
2019-09-08       -1
2019-10-14     -3.2
2019-11-08     -0.9
2019-12-08     -1.1
2020-01-14        0
```

#### 以美元计算进口年率

接口: macro_china_imports_yoy

目标地址: https://datacenter.jin10.com/reportType/dc_chinese_imports_yoy

描述: 获取中国以美元计算进口年率报告, 数据区间从19960201-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 年率 | float | Y        | 年率      |

接口示例

```
import PPshare as PP
macro_china_imports_yoy_df = PP.macro_china_imports_yoy()
print(macro_china_imports_yoy_df)
print(macro_china_imports_yoy_df.name)
```

数据示例

macro_china_imports_yoy_df.name:

```
china_imports_yoy
```

macro_china_imports_yoy_df:

```
1996-02-01    55.8
1996-03-01    14.2
1996-04-01     8.7
1996-05-01     6.4
1996-06-01     4.5
2019-06-10    -8.5
2019-07-12    -7.3
2019-08-08    -5.6
2019-09-08    -5.6
2019-10-14    -8.5
2019-11-08    -6.5
2019-12-08     0.3
2020-01-14       0
```

#### 以美元计算贸易帐(亿美元)

接口: macro_china_trade_balance

目标地址: https://datacenter.jin10.com/reportType/dc_chinese_trade_balance

描述: 获取中国以美元计算贸易帐报告, 数据区间从19810201-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 年率 | float | Y        | 年率      |

接口示例

```
import PPshare as PP
macro_china_trade_balance_df = PP.macro_china_trade_balance()
print(macro_china_trade_balance_df)
print(macro_china_trade_balance_df.name)
```

数据示例

macro_china_trade_balance_df.name:

```
china_trade_balance
```

macro_china_trade_balance_df:

```
1981-02-01     -2.2
1981-03-01     -4.9
1981-04-01     -7.4
1981-05-01     -4.8
2019-10-14    396.5
2019-11-08    430.2
2019-12-08    387.3
2019-12-09        0
2020-01-14        0
```

### 产业指标

#### 规模以上工业增加值年率

接口: macro_china_industrial_production_yoy

目标地址: https://datacenter.jin10.com/reportType/dc_chinese_industrial_production_yoy

描述: 获取中国规模以上工业增加值年率报告, 数据区间从19900301-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 年率 | float | Y        | 年率      |

接口示例

```
import PPshare as PP
macro_china_industrial_production_yoy_df = PP.macro_china_industrial_production_yoy()
print(macro_china_industrial_production_yoy_df)
print(macro_china_industrial_production_yoy_df.name)
```

数据示例

macro_china_industrial_production_yoy_df.name:

```
china_industrial_production_yoy
```

macro_china_industrial_production_yoy_df:

```
1990-03-01      5
1990-04-01    0.8
1990-05-01    1.7
1990-06-01    3.3
1990-07-01      5
             ... 
2019-09-16    4.4
2019-10-18    5.8
2019-11-14    4.7
2019-12-16    6.2
2020-01-17      0
```

#### 官方制造业PMI

接口: macro_china_pmi_yearly

目标地址: https://datacenter.jin10.com/reportType/dc_chinese_manufacturing_pmi

描述: 获取中国年度PMI数据, 数据区间从20050201-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 年率 | float | Y        | 年率      |

接口示例

```
import PPshare as PP
macro_china_pmi_yearly_df = PP.macro_china_pmi_yearly()
print(macro_china_pmi_yearly_df)
print(macro_china_pmi_yearly_df.name)
```

数据示例

macro_china_pmi_yearly_df.name:

```
pmi
```

macro_china_pmi_yearly_df:

```
2005-02-01    54.7
2005-03-01    54.5
2005-04-01    57.9
2005-05-01    56.7
2005-06-01    52.9
              ... 
2019-09-30    49.8
2019-10-31    49.3
2019-11-30    50.2
2019-12-31    50.2
2020-01-31       0
```

#### 财新制造业PMI终值

接口: macro_china_cx_pmi_yearly

目标地址: https://datacenter.jin10.com/reportType/dc_chinese_caixin_manufacturing_pmi

描述: 获取中国年度财新 PMI 数据, 数据区间从20120120-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 年率 | float | Y        | 年率      |

接口示例

```
import PPshare as PP
macro_china_cx_pmi_yearly_df = PP.macro_china_cx_pmi_yearly()
print(macro_china_cx_pmi_yearly_df)
print(macro_china_cx_pmi_yearly_df.name)
```

数据示例

macro_china_cx_pmi_yearly_df.name:

```
cx_pmi
```

macro_china_cx_pmi_yearly_df:

```
2012-01-20    48.8
2012-02-22    49.6
2012-03-22    48.3
2012-04-23    49.1
2012-05-02    49.3
              ... 
2019-09-02    50.4
2019-09-30    51.4
2019-11-01    51.7
2019-12-02    51.8
2020-01-02    51.5
```

#### 财新服务业PMI

接口: macro_china_cx_services_pmi_yearly

目标地址: https://datacenter.jin10.com/reportType/dc_chinese_caixin_services_pmi

描述: 获取中国财新服务业PMI报告, 数据区间从20120405-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 年率 | float | Y        | 年率      |

接口示例

```
import PPshare as PP
macro_china_cx_services_pmi_yearly_df = PP.macro_china_cx_services_pmi_yearly()
print(macro_china_cx_services_pmi_yearly_df)
print(macro_china_cx_services_pmi_yearly_df.name)
```

数据示例

macro_china_cx_services_pmi_yearly_df.name:

```
cx_services_pmi
```

macro_china_cx_services_pmi_yearly_df:

```
2012-04-05    53.3
2012-05-04    54.1
2012-06-05    54.7
2012-07-04    52.3
2012-08-03    53.1
              ... 
2019-09-04    52.1
2019-10-08    51.3
2019-11-05    51.1
2019-12-04    53.5
2020-01-06    52.5
```

#### 中国官方非制造业PMI

接口: macro_china_non_man_pmi

目标地址: https://datacenter.jin10.com/reportType/dc_chinese_non_manufacturing_pmi

描述: 获取中国官方非制造业PMI, 数据区间从20160101-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 年率 | float | Y        | 年率      |

接口示例

```
import PPshare as PP
macro_china_non_man_pmi_df = PP.macro_china_non_man_pmi()
print(macro_china_non_man_pmi_df)
print(macro_china_non_man_pmi_df.name)
```

数据示例

macro_china_non_man_pmi_df.name:

```
cx_services_pmi
```

macro_china_non_man_pmi_df:

```
2007-02-01    60.4
2007-03-01    60.6
2007-04-01    58.2
2007-05-01    60.4
2007-06-01    62.2
              ... 
2019-09-30    53.7
2019-10-31    52.8
2019-11-30    54.4
2019-12-31    53.5
2020-01-31       0
```

### 金融指标

#### 外汇储备(亿美元)

接口: macro_china_fx_reserves_yearly

目标地址: https://datacenter.jin10.com/reportType/dc_chinese_fx_reserves

描述: 获取中国年度外汇储备数据, 数据区间从20140115-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 年率 | float | Y        | 年率      |

接口示例

```
import PPshare as PP
macro_china_fx_reserves_yearly_df = PP.macro_china_fx_reserves_yearly()
print(macro_china_fx_reserves_yearly_df)
print(macro_china_fx_reserves_yearly_df.name)
```

数据示例

macro_china_fx_reserves_yearly_df.name:

```
fx_reserves
```

macro_china_fx_reserves_yearly_df:

```
2014-01-15    39500
2014-07-15    39900
2015-01-15    32300
2016-03-07    32020
2016-04-07    32100
              ...  
2019-09-07    31070
2019-10-08    30920
2019-11-07    31050
2019-12-07    30960
2020-01-07    31080
```

#### M2货币供应年率

接口: macro_china_m2_yearly

目标地址: https://datacenter.jin10.com/reportType/dc_chinese_m2_money_supply_yoy

描述: 获取中国年度M2数据, 数据区间从19980201-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 年率 | float | Y        | 年率      |

接口示例

```
import PPshare as PP
macro_china_m2_yearly_df = PP.macro_china_m2_yearly()
print(macro_china_m2_yearly_df)
print(macro_china_m2_yearly_df.name)
```

数据示例

macro_china_m2_yearly_df.name:

```
m2
```

macro_china_m2_yearly_df:

```
1998-02-01    17.4
1998-03-01    16.7
1998-04-01    15.4
1998-05-01    14.6
1998-06-01    15.5
              ... 
2019-11-11     8.4
2019-11-14       0
2019-12-10     8.2
2019-12-13       0
2020-01-14       0
```

#### 中国货币供应量

接口: macro_china_money_supply

目标地址: http://data.eastmoney.com/cjsj/moneysupply.aspx

描述: 获取中国货币供应量月度数据, 数据区间从200801-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称        | 类型  | 默认显示 | 描述           |
| :---------- | :---- | :------- | :------------- |
| 月份        | str   | Y        | 日期-索引      |
| M2-数量     | float | Y        | 注意单位: 亿元 |
| M2-同比增长 | str   | Y        | 注意单位: %    |
| M2-环比增长 | str   | Y        | 注意单位: %    |
| M1-数量     | float | Y        | 注意单位: 亿元 |
| M1-同比增长 | str   | Y        | 注意单位: %    |
| M1-环比增长 | str   | Y        | 注意单位: %    |
| M0-数量     | float | Y        | 注意单位: 亿元 |
| M0-同比增长 | str   | Y        | 注意单位: %    |
| M0-环比增长 | str   | Y        | 注意单位: %    |

接口示例

```
import PPshare as PP
macro_china_money_supply_df = PP.macro_china_money_supply()
print(macro_china_money_supply_df)
```

数据示例

```
            月份       M2-数量 M2-同比增长 M2-环比增长  ... M1-环比增长     M0-数量 M0-同比增长  M0-环比增长
0    2020年03月份  2080900.00  10.10%   2.47%  ...   4.05%  83000.00  10.80%   -5.90%
1    2020年02月份  2030800.00   8.80%   0.38%  ...   1.32%  88200.00  10.90%   -5.36%
2    2020年01月份  2023100.00   8.40%   1.84%  ...  -5.30%  93200.00   6.60%   20.73%
3    2019年12月份  1986500.00   8.70%   1.28%  ...   2.40%  77200.00   5.40%    4.36%
4    2019年11月份  1961429.56   8.20%   0.81%  ...   0.78%  73973.82   4.80%    0.79%
..         ...         ...     ...     ...  ...     ...       ...     ...      ...
142  2008年05月份   436221.60  18.07%   1.61%  ...   1.09%  30169.30  12.88%   -2.01%
143  2008年04月份   429313.72  16.94%   1.48%  ...   0.55%  30789.61  10.70%    1.17%
144  2008年03月份   423054.53  16.19%   0.48%  ...   0.46%  30433.07  11.12%   -6.23%
145  2008年02月份   421037.84  17.39%   0.76%  ...  -3.03%  32454.47   5.96%  -11.50%
146  2008年01月份   417846.17  18.88%   3.58%  ...   1.54%  36673.15  31.21%   20.90%
```

#### 新房价指数

接口: macro_china_new_house_price

目标地址: http://data.eastmoney.com/cjsj/newhouse.html

描述: 获取中国新房价指数月度数据, 数据区间从201101-至今

限量: 单次返回所有历史数据, 目前该指数由上海和北京房价构成

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称                      | 类型  | 默认显示 | 描述 |
| :------------------------ | :---- | :------- | :--- |
| 日期                      | str   | Y        | 日期 |
| 城市                      | str   | Y        | –    |
| 新建住宅价格指数-环比     | float | Y        | –    |
| 新建住宅价格指数-同比     | float | Y        | –    |
| 新建住宅价格指数-定基     | float | Y        | –    |
| 新建商品住宅价格指数-环比 | float | Y        | –    |
| 新建商品住宅价格指数-同比 | float | Y        | –    |
| 新建商品住宅价格指数-定基 | float | Y        | –    |
| 二手住宅价格指数-环比     | float | Y        | –    |
| 二手住宅价格指数-同比     | float | Y        | –    |

接口示例

```
import PPshare as PP
macro_china_new_house_price_df = PP.macro_china_new_house_price()
print(macro_china_new_house_price_df)
```

数据示例

```
              日期  城市 新建住宅价格指数-环比  ... 新建商品住宅价格指数-定基 二手住宅价格指数-环比 二手住宅价格指数-同比
0    2020年03月01日  北京           -  ...             -       100.2        99.3
1    2020年03月01日  上海           -  ...             -       100.3       101.6
2    2020年02月01日  北京           -  ...             -        99.8        99.6
3    2020年02月01日  上海           -  ...             -       100.2       101.6
4    2020年01月01日  北京           -  ...             -       100.4       100.0
..           ...  ..         ...  ...           ...         ...         ...
217  2011年03月01日  上海       100.2  ...         102.3       100.4       100.5
218  2011年02月01日  北京       100.4  ...         103.5       100.4       102.9
219  2011年02月01日  上海       100.9  ...         102.1       100.4       102.0
220  2011年01月01日  北京       100.8  ...         103.0       100.3       102.6
221  2011年01月01日  上海       100.9  ...         101.0       100.5       101.7
```

#### 企业景气及企业家信心指数

接口: macro_china_enterprise_boom_index

目标地址: http://data.eastmoney.com/cjsj/qyjqzs.html

描述: 获取中国企业景气及企业家信心指数数据, 数据区间从 2005 一季度-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称                | 类型  | 默认显示 | 描述        |
| :------------------ | :---- | :------- | :---------- |
| 季度                | str   | Y        | 日期        |
| 企业景气指数-指数   | float | Y        | –           |
| 企业景气指数-同比   | float | Y        | 注意单位: % |
| 企业景气指数-环比   | float | Y        | 注意单位: % |
| 企业家信心指数-指数 | float | Y        | –           |
| 企业家信心指数-同比 | float | Y        | 注意单位: % |
| 企业家信心指数-环比 | float | Y        | 注意单位: % |

接口示例

```
import PPshare as PP
macro_china_enterprise_boom_index_df = PP.macro_china_enterprise_boom_index()
print(macro_china_enterprise_boom_index_df)
```

数据示例

```
          季度 企业景气指数-指数 企业景气指数-同比 企业景气指数-环比 企业家信心指数-指数 企业家信心指数-同比 企业家信心指数-环比
0   2020第1季度      88.2   -11.78%   -34.58%       90.9     -9.14%    -32.74%
1   2019第4季度     122.8    22.80%    -0.60%      123.6     23.60%     -0.70%
2   2019第3季度     123.4    23.40%     0.20%      124.3     24.30%      0.20%
3   2019第2季度     123.2    23.20%    -3.40%      124.1     24.10%     -3.80%
4   2019第1季度     126.6    26.60%     6.40%      127.9     27.90%      6.60%
..       ...       ...       ...       ...        ...        ...        ...
56  2006第1季度     131.5    31.50%    -0.20%      133.1     33.10%      7.70%
57  2005第4季度     131.7    31.70%    -0.30%      125.4     25.40%     -2.20%
58  2005第3季度     132.0    32.00%     0.29%      127.6     27.60%     -0.90%
59  2005第2季度     131.7    31.71%    -0.75%      128.5     28.50%     -7.35%
60  2005第1季度     132.5    32.46%    -2.27%      135.9     35.85%      5.04%
```

#### 全国税收收入

接口: macro_china_national_tax_receipts

目标地址: http://data.eastmoney.com/cjsj/nationaltaxreceipts.aspx

描述: 获取中国全国税收收入数据, 数据区间从 2005 一季度-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称         | 类型  | 默认显示 | 描述           |
| :----------- | :---- | :------- | :------------- |
| 季度         | str   | Y        | 日期           |
| 税收收入合计 | float | Y        | 注意单位: 亿元 |
| 较上年同期   | float | Y        | 注意单位: %    |
| 季度环比     | float | Y        | 注意单位: %    |

接口示例

```
import PPshare as PP
macro_china_national_tax_receipts_df = PP.macro_china_national_tax_receipts()
print(macro_china_national_tax_receipts_df)
```

数据示例

```
            季度     税收收入合计    较上年同期    季度环比
0     2020年第1季度   39029.00  -16.40%  -0.75%
1   2019年第1-4季度  157992.00    1.00%  -0.10%
2   2019年第1-3季度  126970.00   -0.40%  -0.24%
3   2019年第1-2季度   92424.00    0.90%   2.94%
4     2019年第1季度   46706.00    5.40%  -0.60%
..          ...        ...      ...     ...
54  2006年第1-2季度   18484.80   22.00%   0.14%
55    2006年第1季度    8626.32   19.00%   0.83%
56  2005年第1-3季度   21855.35   15.90%  -0.15%
57  2005年第1-2季度   15149.73   13.40%   0.09%
58    2005年第1季度    7249.16   10.70%   0.97%
```

#### 新增信贷数据

接口: macro_china_new_financial_credit

目标地址: http://data.eastmoney.com/cjsj/xzxd.html

描述: 获取中国新增信贷数据数据, 数据区间从 200801 至今, 月度数据

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称          | 类型 | 默认显示 | 描述           |
| :------------ | :--- | :------- | :------------- |
| 月份          | str  | Y        | –              |
| 当月          | str  | Y        | 注意单位: 亿元 |
| 当月-同比增长 | str  | Y        | 注意单位: %    |
| 当月-环比增长 | str  | Y        | 注意单位: %    |
| 累计          | str  | Y        | 注意单位: 亿元 |
| 累计-同比增长 | str  | Y        | 注意单位: %    |

接口示例

```
import PPshare as PP
macro_china_new_financial_credit_df = PP.macro_china_new_financial_credit()
print(macro_china_new_financial_credit_df)
```

数据示例

```
            月份       当月 当月-同比增长  当月-环比增长       累计 累计-同比增长
0    2020年06月份  19043.6   13.78    22.86   123300   23.03
1    2020年05月份    15500   30.74    -4.55   104256   24.89
2    2020年04月份  16239.5   85.96   -46.56  88756.4   23.92
3    2020年03月份  30390.3   55.18   321.96  72516.9    15.3
4    2020年02月份  7202.13   -5.74   -79.38  42126.6   -2.73
..         ...      ...     ...      ...      ...     ...
145  2008年05月份     3185   28.79   -32.09    21201    1.39
146  2008年04月份     4690   11.14    65.49    18016   -2.29
147  2008年03月份     2834  -35.84    16.43    13326   -6.27
148  2008年02月份     2434  -41.18   -69.79    10492    7.05
149  2008年01月份     8058   42.29  1561.44     8058   42.29
```

#### 居民消费价格指数

接口: macro_china_cpi

目标地址: http://data.eastmoney.com/cjsj/cpi.html

描述: 获取中国居民消费价格指数, 数据区间从 200801 至今, 月度数据

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称          | 类型 | 默认显示 | 描述        |
| :------------ | :--- | :------- | :---------- |
| 月份          | str  | Y        | –           |
| 全国-当月     | str  | Y        | –           |
| 全国-同比增长 | str  | Y        | 注意单位: % |
| 全国-环比增长 | str  | Y        | 注意单位: % |
| 全国-累计     | str  | Y        | –           |
| 城市-当月     | str  | Y        | –           |
| 城市-同比增长 | str  | Y        | 注意单位: % |
| 城市-环比增长 | str  | Y        | 注意单位: % |
| 城市-累计     | str  | Y        | –           |
| 农村-当月     | str  | Y        | –           |
| 农村-同比增长 | str  | Y        | 注意单位: % |
| 农村-环比增长 | str  | Y        | 注意单位: % |
| 农村-累计     | str  | Y        | –           |

接口示例

```
import PPshare as PP
macro_china_cpi_df = PP.macro_china_cpi()
print(macro_china_cpi_df)
```

数据示例

```
           月份  全国-当月 全国-同比增长 全国-环比增长  ...  农村-当月 农村-同比增长 农村-环比增长  农村-累计
0   2020年07月份  102.7    2.7%    0.6%  ...  103.7    3.7%    0.8%  104.5
1   2020年06月份  102.5    2.5%   -0.1%  ...  103.2    3.2%    0.0%  104.7
2   2020年05月份  102.4    2.4%   -0.8%  ...  103.0    3.0%   -0.9%  105.0
3   2020年04月份  103.3    3.3%   -0.9%  ...  104.0    4.0%   -1.0%  105.5
4   2020年03月份  104.3    4.3%   -1.2%  ...  105.3    5.3%   -1.3%  105.9
..        ...    ...     ...     ...  ...    ...     ...     ...    ...
6   2008年05月份  107.7    7.7%   -0.4%  ...  108.5    8.5%   -0.3%  108.8
7   2008年04月份  108.5    8.5%    0.1%  ...  109.3    9.3%    0.1%  108.8
8   2008年03月份  108.3    8.3%   -0.7%  ...  109.0    9.0%   -0.5%  108.7
9   2008年02月份  108.7    8.7%    2.6%  ...  109.2    9.2%    2.4%  108.5
10  2008年01月份  107.1    7.1%    1.2%  ...  107.7    7.7%    1.2%  107.7
```

#### 国内生产总值

接口: macro_china_gdp

目标地址: http://data.eastmoney.com/cjsj/gdp.html

描述: 获取中国国内生产总值, 数据区间从 200601 至今, 月度数据

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称                  | 类型 | 默认显示 | 描述           |
| :-------------------- | :--- | :------- | :------------- |
| 季度                  | str  | Y        | –              |
| 国内生产总值-绝对值   | str  | Y        | 注意单位: 亿元 |
| 国内生产总值-同比增长 | str  | Y        | 注意单位: %    |
| 第一产业-绝对值       | str  | Y        | 注意单位: 亿元 |
| 第一产业-同比增长     | str  | Y        | 注意单位: %    |
| 第二产业-绝对值       | str  | Y        | 注意单位: 亿元 |
| 第二产业-同比增长     | str  | Y        | 注意单位: %    |
| 第三产业-绝对值       | str  | Y        | 注意单位: 亿元 |
| 第三产业-同比增长     | str  | Y        | 注意单位: %    |

接口示例

```
import PPshare as PP
macro_china_gdp_df = PP.macro_china_gdp()
print(macro_china_gdp_df)
```

数据示例

```
             季度 国内生产总值-绝对值 国内生产总值-同比增长  ... 第二产业-同比增长   第三产业-绝对值 第三产业-同比增长
0   2020年第1-2季度  456614.00      -1.60%  ...    -1.90%  257802.00    -1.60%
1     2020年第1季度  206504.30      -6.80%  ...    -9.60%  122680.10    -5.20%
2   2019年第1-4季度  990865.10       6.10%  ...     5.70%  534233.10     6.90%
3   2019年第1-3季度  712845.40       6.20%  ...     5.60%  392927.90     7.00%
4   2019年第1-2季度  460636.70       6.30%  ...     5.80%  258307.50     7.00%
..          ...        ...         ...  ...       ...        ...       ...
13    2007年第1季度   57159.30      13.80%  ...    14.80%   27702.50    14.10%
14  2006年第1-4季度  219438.50      12.70%  ...    13.50%   91759.70    14.10%
15  2006年第1-3季度  155816.80      12.80%  ...    13.70%   67185.10    13.70%
16  2006年第1-2季度   99752.20      13.10%  ...    14.20%   44995.30    13.60%
17    2006年第1季度   47078.90      12.50%  ...    13.10%   22647.40    13.10%
```

#### 工业品出厂价格指数

接口: macro_china_ppi

目标地址: http://data.eastmoney.com/cjsj/ppi.html

描述: 获取工业品出厂价格指数, 数据区间从 200601 至今, 月度数据

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称         | 类型 | 默认显示 | 描述        |
| :----------- | :--- | :------- | :---------- |
| 月份         | str  | Y        | –           |
| 当月         | str  | Y        | –           |
| 当月同比增长 | str  | Y        | 注意单位: % |
| 累计         | str  | Y        | –           |

接口示例

```
import PPshare as PP
macro_china_ppi_df = PP.macro_china_ppi()
print(macro_china_ppi_df)
```

数据示例

```
           月份     当月  当月同比增长      累计
0   2020年07月份   97.6  -2.40%   98.00
1   2020年06月份   97.0  -3.00%   98.10
2   2020年05月份   96.3  -3.70%   98.30
3   2020年04月份   96.9  -3.10%   98.80
4   2020年03月份   98.5  -1.50%   99.40
..        ...    ...     ...     ...
10  2006年05月份  102.4   2.43%  102.57
11  2006年04月份  101.9   1.87%  102.60
12  2006年03月份  102.5   2.49%  102.90
13  2006年02月份  103.0   3.01%  103.00
14  2006年01月份  103.1   3.05%  103.05
```

#### 采购经理人指数

接口: macro_china_pmi

目标地址: http://data.eastmoney.com/cjsj/pmi.html

描述: 获取采购经理人指数, 数据区间从 200801 至今, 月度数据

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称              | 类型 | 默认显示 | 描述        |
| :---------------- | :--- | :------- | :---------- |
| 月份              | str  | Y        | –           |
| 制造业-指数       | str  | Y        | –           |
| 制造业-同比增长   | str  | Y        | 注意单位: % |
| 非制造业-指数     | str  | Y        | –           |
| 非制造业-同比增长 | str  | Y        | 注意单位: % |

接口示例

```
import PPshare as PP
macro_china_pmi_df = PP.macro_china_pmi()
print(macro_china_pmi_df)
```

数据示例

```
      月份 制造业-指数 制造业-同比增长 非制造业-指数 非制造业-同比增长
0   2020年07月份   51.1    2.82%    54.2     0.93%
1   2020年06月份   50.9    3.04%    54.4     0.37%
2   2020年05月份   50.6    2.43%    53.6    -1.29%
3   2020年04月份   50.8    1.40%    53.2    -2.03%
4   2020年03月份   52.0    2.97%    52.3    -4.56%
..        ...    ...      ...     ...       ...
6   2008年05月份   53.3   -4.31%    57.4    -7.72%
7   2008年04月份   59.2    1.02%    58.4    -3.31%
8   2008年03月份   58.4    4.10%    58.9     1.20%
9   2008年02月份   53.4    0.56%    59.3    -2.15%
10  2008年01月份   53.0   -3.81%    60.2    -0.33%
```

#### 中国城镇固定资产投资

接口: macro_china_gdzctz

目标地址: http://data.eastmoney.com/cjsj/gdzctz.html

描述: 获取中国城镇固定资产投资, 数据区间从 200802 至今, 月度数据

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称       | 类型 | 默认显示 | 描述           |
| :--------- | :--- | :------- | :------------- |
| 月份       | str  | Y        | –              |
| 当月       | str  | Y        | 注意单位: 亿元 |
| 同比增长   | str  | Y        | 注意单位: %    |
| 环比增长   | str  | Y        | 注意单位: %    |
| 自年初累计 | str  | Y        | 注意单位: 亿元 |

接口示例

```
import PPshare as PP
macro_china_gdzctz_df = PP.macro_china_gdzctz()
print(macro_china_gdzctz_df)
```

数据示例

```
           月份     当月     同比增长     环比增长   自年初累计
0   2020年07月份  47611   -4.38%  -42.23%  329214
1   2020年06月份  82409    1.06%   32.13%  281603
2   2020年05月份  62370    0.91%   18.40%  199194
3   2020年04月份  52679   -2.22%    3.65%  136824
4   2020年03月份  50822  -10.87%    0.00%   84145
..        ...    ...      ...      ...     ...
13  2008年06月份  18172   29.49%   53.29%   58436
14  2008年05月份  11854   25.44%   17.45%   40264
15  2008年04月份  10093   25.37%   -1.01%   28410
16  2008年03月份  10196   27.31%    0.00%   18317
17  2008年02月份      0    0.00%    0.00%    8121
```

#### 海关进出口增减情况一览表

接口: macro_china_hgjck

目标地址: http://data.eastmoney.com/cjsj/hgjck.html

描述: 获取中国海关进出口增减情况一览表, 数据区间从 200801 至今, 月度数据

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称                | 类型 | 默认显示 | 描述             |
| :------------------ | :--- | :------- | :--------------- |
| 月份                | str  | Y        | –                |
| 当月出口额-金额     | str  | Y        | 注意单位: 亿美元 |
| 当月出口额-同比增长 | str  | Y        | 注意单位: %      |
| 当月出口额-环比增长 | str  | Y        | 注意单位: %      |
| 当月进口额-金额     | str  | Y        | 注意单位: 亿美元 |
| 当月进口额-同比增长 | str  | Y        | 注意单位: %      |
| 当月进口额-环比增长 | str  | Y        | 注意单位: %      |
| 累计出口额-金额     | str  | Y        | 注意单位: 亿美元 |
| 累计出口额-同比增长 | str  | Y        | 注意单位: %      |
| 累计进口额-金额     | str  | Y        | 注意单位: 亿美元 |
| 累计进口额-同比增长 | str  | Y        | 注意单位: %      |

接口示例

```
import PPshare as PP
macro_china_hgjck_df = PP.macro_china_hgjck()
print(macro_china_hgjck_df)
```

数据示例

```
           月份 当月出口额-金额 当月出口额-同比增长  ... 累计出口额-同比增长  累计进口额-金额 累计进口额-同比增长
0   2020年07月份  2376.31      7.20%  ...     -4.10%  11062.48     -5.70%
1   2020年06月份  2135.74      0.50%  ...     -6.20%   9309.46     -7.10%
2   2020年05月份  2068.13     -3.30%  ...     -7.70%   7636.29     -8.20%
3   2020年04月份  2002.82      3.50%  ...     -9.00%   6200.48     -5.90%
4   2020年03月份  1851.48     -6.60%  ...    -13.30%   4650.11     -2.90%
..        ...      ...        ...  ...        ...       ...        ...
5   2008年05月份  1204.96     28.10%  ...     22.90%   4670.27     30.40%
6   2008年04月份  1187.07     21.80%  ...     21.50%   3665.73     27.90%
7   2008年03月份  1089.63     30.60%  ...     21.40%   2644.79     28.60%
8   2008年02月份   873.68      6.50%  ...     16.80%   1689.38     30.90%
9   2008年01月份  1096.40     26.60%  ...     26.60%    901.74     27.60%
```

#### 财政收入

接口: macro_china_czsr

目标地址: http://data.eastmoney.com/cjsj/czsr.html

描述: 获取中国财政收入, 数据区间从 200801 至今, 月度数据

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称          | 类型 | 默认显示 | 描述             |
| :------------ | :--- | :------- | :--------------- |
| 月份          | str  | Y        | –                |
| 当月          | str  | Y        | 注意单位: 亿元   |
| 当月-同比增长 | str  | Y        | 注意单位: %      |
| 当月-环比增长 | str  | Y        | 注意单位: %      |
| 累计          | str  | Y        | 注意单位: 亿美元 |
| 累计-同比增长 | str  | Y        | 注意单位: %      |

接口示例

```
import PPshare as PP
macro_china_czsr_df = PP.macro_china_czsr()
print(macro_china_czsr_df)
```

数据示例

```
      月份        当月  当月-同比增长  当月-环比增长  累计  累计-同比增长
0   2020年06月份  18504.00    3.22%   19.08%  96176.00  -10.80%
1   2020年05月份  15539.00  -10.01%   -3.78%  77672.00  -13.60%
2   2020年04月份  16149.00  -14.98%   50.20%  62133.00  -14.50%
3   2020年03月份  10752.00  -26.11%    0.00%  45984.00  -14.30%
4   2020年02月份      0.00    0.00%    0.00%  35232.00   -9.90%
..        ...       ...      ...      ...       ...      ...
3   2008年05月份   6268.18   52.60%   -8.16%  29064.37   33.80%
4   2008年04月份   6824.90   17.02%   54.55%  22796.22   29.40%
5   2008年03月份   4416.00   24.67%    6.18%  15971.34   35.50%
6   2008年02月份   4158.80   36.55%  -43.77%  11555.39   40.20%
7   2008年01月份   7396.64   42.35%  135.20%   7396.64   42.40%
```

#### 外汇贷款数据

接口: macro_china_whxd

目标地址: http://data.eastmoney.com/cjsj/whxd.html

描述: 获取外汇贷款数据, 数据区间从 200802 至今, 月度数据

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称     | 类型 | 默认显示 | 描述             |
| :------- | :--- | :------- | :--------------- |
| 月份     | str  | Y        | –                |
| 当月     | str  | Y        | 注意单位: 亿美元 |
| 同比增长 | str  | Y        | 注意单位: %      |
| 环比增长 | str  | Y        | 注意单位: %      |
| 累计     | str  | Y        | 注意单位: 亿美元 |

接口示例

```
import PPshare as PP
macro_china_whxd_df = PP.macro_china_whxd()
print(macro_china_whxd_df)
```

数据示例

```
      月份        当月      同比增长      环比增长       累计
0   2020年07月份  192.00   256.10%    24.68%  8835.00
1   2020年06月份  154.00   294.94%    -2.53%  8643.00
2   2020年05月份  158.00   154.84%   -23.67%  8489.00
3   2020年04月份  207.00   200.49%   727.27%  8331.00
4   2020年03月份  -33.00  -153.23%  -116.58%  8124.00
..        ...     ...       ...       ...      ...
13  2008年06月份   14.02   -84.35%   -53.33%  2753.36
14  2008年05月份   30.04   -13.15%    40.70%  2739.34
15  2008年04月份   21.35    39.82%   -79.40%  2709.30
16  2008年03月份  103.62   279.28%   -52.25%  2687.95
17  2008年02月份  217.02   754.75%   -90.83%  2584.33
```

#### 本外币存款

接口: macro_china_wbck

目标地址: http://data.eastmoney.com/cjsj/wbck.html

描述: 获取本外币存款, 数据区间从 200802 至今, 月度数据

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称     | 类型 | 默认显示 | 描述           |
| :------- | :--- | :------- | :------------- |
| 月份     | str  | Y        | –              |
| 当月     | str  | Y        | 注意单位: 亿元 |
| 同比增长 | str  | Y        | 注意单位: %    |
| 环比增长 | str  | Y        | 注意单位: %    |
| 累计     | str  | Y        | 注意单位: 亿元 |

接口示例

```
import PPshare as PP
macro_china_wbck_df = PP.macro_china_wbck()
print(macro_china_wbck_df)
```

数据示例

```
           月份        当月     同比增长     环比增长          累计
0   2020年07月份   1133.15  -79.29%  -96.33%  2131019.48
1   2020年06月份  30853.36   33.17%   33.24%  2129886.33
2   2020年05月份  23155.64   88.19%   97.66%  2099032.97
3   2020年04月份  11715.18  377.15%  -71.19%  2075877.33
4   2020年03月份  40661.59  129.27%  253.39%  2064162.15
..        ...       ...      ...      ...         ...
13  2008年06月份   7686.63  -14.22%  -12.28%   450227.49
14  2008年05月份   8763.12  370.97%   22.04%   442540.86
15  2008年04月份   7180.81   69.12%  -33.13%   433777.74
16  2008年03月份  10737.68   25.85%  -19.69%   426596.93
17  2008年02月份  13370.18  152.67%  -96.68%   415859.25
```

#### 币净投放与净回笼

接口: macro_china_hb

目标地址: http://www.chinamoney.com.cn/chinese/hb/

描述: 央行币净投放与净回笼, 数据区间从 19970310 至今, 周频率

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称       | 类型 | 默认显示 | 描述       |
| :--------- | :--- | :------- | :--------- |
| start_date | str  | Y        | 开始日期   |
| net_put_in | str  | Y        | 净投放(亿) |
| back       | str  | Y        | 回笼量(亿) |
| end_date   | str  | Y        | 结束日期   |
| put_in     | str  | Y        | 投放量(亿) |
| date       | str  | Y        | 周期       |

接口示例

```
import PPshare as PP
macro_china_hb_df = PP.macro_china_hb()
print(macro_china_hb_df)
```

数据示例

```
      start_date net_put_in  back    end_date put_in     date
0     1997-03-10          0     0  1997-03-16      0  1997-11
1     1997-03-17          0     0  1997-03-23      0  1997-12
2     1997-03-24          0     0  1997-03-30      0  1997-13
3     1997-03-31          0     0  1997-04-06      0  1997-14
4     1997-04-07          0     0  1997-04-13      0  1997-15
          ...        ...   ...         ...    ...      ...
1215  2020-07-20      -1650  3300  2020-07-26   1650  2020-30
1216  2020-07-27       1200  1600  2020-08-02   2800  2020-31
1217  2020-08-03      -2700  2800  2020-08-09    100  2020-32
1218  2020-08-10       4900   100  2020-08-16   5000  2020-33
1219  2020-08-17      -3500  5000  2020-08-23   1500  2020-34
```

#### 央行公开市场操作

接口: macro_china_gksccz

目标地址: http://www.chinamoney.com.cn/chinese/yhgkscczh/

描述: 央行公开市场操作, 数据区间从 20040116 至今, 周频率

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称                | 类型 | 默认显示 | 描述        |
| :------------------ | :--- | :------- | :---------- |
| rate                | str  | Y        | 中标利率(%) |
| trading_method      | str  | Y        | 正/逆回购   |
| deal_amount         | str  | Y        | 交易量(亿)  |
| period              | str  | Y        | 期限(天)    |
| operation_from_date | str  | Y        | 操作日期    |

接口示例

```
import PPshare as PP
macro_china_gksccz_df = PP.macro_china_gksccz()
print(macro_china_gksccz_df)
```

数据示例

```
      rate trading_method deal_amount period operation_from_date
0     2.82            逆回购         400     14          2004-01-16
1     2.83            正回购          50     91          2004-05-13
2     2.55            正回购         150     28          2004-05-13
3     2.65            正回购         300     28          2004-05-20
4     2.69            正回购         200     28          2004-05-27
    ...            ...         ...    ...                 ...
1955   2.2            逆回购         500      7          2020-08-17
1956   2.2            逆回购        1000      7          2020-08-18
1957   2.2            逆回购        1500      7          2020-08-19
1958  2.35            逆回购         500     14          2020-08-21
1959   2.2            逆回购        1500      7          2020-08-21
```

#### 新债券发行

接口: macro_china_bond_public

目标地址: http://www.chinamoney.com.cn/chinese/xzj

描述: 债券信息披露-新债券发行, 近期债券发行数据

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称                | 类型 | 默认显示 | 描述 |
| :------------------ | :--- | :------- | :--- |
| issue_price         | str  | Y        | –    |
| emit_enty           | str  | Y        | –    |
| coupon_type         | str  | Y        | –    |
| plnd_issue_vlmn_str | str  | Y        | –    |
| issue_price_str     | str  | Y        | –    |
| issue_date          | str  | Y        | –    |
| bond_type           | str  | Y        | –    |
| plnd_issue_vlmn     | str  | Y        | –    |
| bond_name           | str  | Y        | –    |
| bond_code           | str  | Y        | –    |
| rtng_shrt           | str  | Y        | –    |
| bond_period         | str  | Y        | –    |
| defined_code        | str  | Y        | –    |

接口示例

```
import PPshare as PP
macro_china_bond_public_df = PP.macro_china_bond_public()
print(macro_china_bond_public_df)
```

数据示例

```
    issue_price emit_enty coupon_type  ... rtng_shrt bond_period defined_code
0          None      None         未计息  ...      None        340日   eabej8aq8n
1          None      None         零息式  ...       AAA        340日   eabeitsg7n
2          None      None     附息式固定利率  ...       AAA         10年   eadgek956e
3          None      None     附息式固定利率  ...       AAA         15年   eadgdm86f1
4          None      None     附息式固定利率  ...       AAA          5年   eadgclnd8n
..          ...       ...         ...  ...       ...         ...          ...
410        None      None     附息式固定利率  ...       AAA          3年   digaam0gri
411        None      None     附息式固定利率  ...       AAA          3年   31101hrowk
412        None      None     附息式固定利率  ...       AA+          5年   277522ta3a
413        None      None     附息式固定利率  ...       AA-          5年   djbgj9xcxt
414        None      None     附息式固定利率  ...       AAA          3年   djaabv3nd8
```

#### 外汇和黄金储备

接口: macro_china_fx_gold

目标地址: http://data.eastmoney.com/cjsj/hjwh.html

描述: 获取中国外汇和黄金储备, 数据区间从 200801 至今, 月度数据

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| –    | –    | –    | –    |

输出参数

| 名称                     | 类型 | 默认显示 | 描述             |
| :----------------------- | :--- | :------- | :--------------- |
| date                     | str  | Y        | 年度和月份       |
| foreign_exchange_reserve | str  | Y        | 注意单位: 亿美元 |
| gold_reserves            | str  | Y        | 注意单位: 万盎司 |

接口示例

```
import PPshare as PP
macro_china_fx_gold_df = PP.macro_china_fx_gold()
print(macro_china_fx_gold_df)
```

数据示例

```
      date foreign_exchange_reserve gold_reserves
0    08年1月                15898.104          1929
1    08年2月               16471.3371          1929
2    08年3月                 16821.77          1929
3    08年4月               17566.5514          1929
4    08年5月               17969.6074          1929
..     ...                      ...           ...
145  20年2月                 31067.18          6264
146  20年3月                 30606.33          6264
147  20年4月                 30914.59          6264
148  20年5月                 31016.92          6264
149  20年6月                 31123.28          6264
```

#### 上海银行业同业拆借报告

接口: macro_china_shibor_all

目标地址: https://datacenter.jin10.com/reportType/dc_shibor

描述: 获取上海银行业同业拆借报告, 数据区间从20170317-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称       | 类型  | 默认显示 | 描述      |
| :--------- | :---- | :------- | :-------- |
| 日期       | str   | Y        | 日期-索引 |
| O/N_定价   | float | Y        | –         |
| O/N_涨跌幅 | float | Y        | 单位: 点  |
| 1W_定价    | float | Y        | –         |
| 1W_涨跌幅  | float | Y        | 单位: 点  |
| 2W_定价    | float | Y        | –         |
| 2W_涨跌幅  | float | Y        | 单位: 点  |
| 1M_定价    | float | Y        | –         |
| 1M_涨跌幅  | float | Y        | 单位: 点  |
| 3M_定价    | float | Y        | –         |
| 3M_涨跌幅  | float | Y        | 单位: 点  |
| 6M_定价    | float | Y        | –         |
| 6M_涨跌幅  | float | Y        | 单位: 点  |
| 9M_定价    | float | Y        | –         |
| 9M_涨跌幅  | float | Y        | 单位: 点  |
| 1Y_定价    | float | Y        | –         |
| 1Y_涨跌幅  | float | Y        | 单位: 点  |
| ON_定价    | float | Y        | –         |
| ON_涨跌幅  | float | Y        | 单位: 点  |
| 2M_定价    | float | Y        | –         |
| 2M_涨跌幅  | float | Y        | 单位: 点  |

接口示例

```
import PPshare as PP
macro_china_shibor_all_df = PP.macro_china_shibor_all()
print(macro_china_shibor_all_df)
```

数据示例

```
            O/N_定价  O/N_涨跌幅   1W_定价  1W_涨跌幅  ...   ON_定价  ON_涨跌幅   2M_定价  2M_涨跌幅
2017-03-17  2.6330      NaN  2.7250     NaN  ...     NaN     NaN     NaN     NaN
2017-03-20  2.6325    -0.05  3.9428  121.78  ...  2.0283     NaN  4.5915     NaN
2017-03-21  2.6477     1.52  3.9094  116.23  ...  2.3883   36.00  4.6113    1.98
2017-03-22  2.6507     0.30  4.3795  161.15  ...  2.3100   -7.83  4.8365   22.52
2017-03-23  2.6570     0.63  4.3538  156.28  ...  2.2263   -8.37  4.5410  -29.55
            ...      ...     ...     ...  ...     ...     ...     ...     ...
2020-04-16  0.7020    -9.90  1.3475  -28.45  ...  1.2485    5.68  1.9365   -2.60
2020-04-17  0.7160     1.40  1.3490  -30.80  ...  1.2717    2.32  1.9140   -2.25
2020-04-20  0.8960    18.00  1.4882  -24.88  ...  1.4213   14.97  2.0012    8.72
2020-04-21  0.9010     0.50  1.4832  -25.08  ...  1.3310   -9.03  1.9972   -0.40
2020-04-22  0.9010     0.00  1.4188  -18.72  ...  1.2177  -11.33  1.9992    0.20
```

#### 人民币香港银行同业拆息

接口: macro_china_hk_market_info

目标地址: https://datacenter.jin10.com/reportType/dc_hk_market_info

描述: 获取香港同业拆借报告, 数据区间从20170320-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称       | 类型  | 默认显示 | 描述      |
| :--------- | :---- | :------- | :-------- |
| 日期       | str   | Y        | 日期-索引 |
| O/N_定价   | float | Y        | –         |
| O/N_涨跌幅 | float | Y        | 单位: 点  |
| 1W_定价    | float | Y        | –         |
| 1W_涨跌幅  | float | Y        | 单位: 点  |
| 2W_定价    | float | Y        | –         |
| 2W_涨跌幅  | float | Y        | 单位: 点  |
| 1M_定价    | float | Y        | –         |
| 1M_涨跌幅  | float | Y        | 单位: 点  |
| 3M_定价    | float | Y        | –         |
| 3M_涨跌幅  | float | Y        | 单位: 点  |
| 6M_定价    | float | Y        | –         |
| 6M_涨跌幅  | float | Y        | 单位: 点  |
| 9M_定价    | float | Y        | –         |
| 9M_涨跌幅  | float | Y        | 单位: 点  |
| 1Y_定价    | float | Y        | –         |
| 1Y_涨跌幅  | float | Y        | 单位: 点  |
| ON_定价    | float | Y        | –         |
| ON_涨跌幅  | float | Y        | 单位: 点  |
| 2M_定价    | float | Y        | –         |
| 2M_涨跌幅  | float | Y        | 单位: 点  |

接口示例

```
import PPshare as PP
macro_china_hk_market_info_df = PP.macro_china_hk_market_info()
print(macro_china_hk_market_info_df)
```

数据示例

```
            O/N_定价  O/N_涨跌幅   1W_定价  1W_涨跌幅  ...   ON_定价  ON_涨跌幅   2M_定价  2M_涨跌幅
2017-03-17  2.6330      NaN  2.7250     NaN  ...     NaN     NaN     NaN     NaN
2017-03-20  2.6325    -0.05  3.9428  121.78  ...  2.0283     NaN  4.5915     NaN
2017-03-21  2.6477     1.52  3.9094  116.23  ...  2.3883   36.00  4.6113    1.98
2017-03-22  2.6507     0.30  4.3795  161.15  ...  2.3100   -7.83  4.8365   22.52
2017-03-23  2.6570     0.63  4.3538  156.28  ...  2.2263   -8.37  4.5410  -29.55
            ...      ...     ...     ...  ...     ...     ...     ...     ...
2020-04-16  0.7020    -9.90  1.3475  -28.45  ...  1.2485    5.68  1.9365   -2.60
2020-04-17  0.7160     1.40  1.3490  -30.80  ...  1.2717    2.32  1.9140   -2.25
2020-04-20  0.8960    18.00  1.4882  -24.88  ...  1.4213   14.97  2.0012    8.72
2020-04-21  0.9010     0.50  1.4832  -25.08  ...  1.3310   -9.03  1.9972   -0.40
2020-04-22  0.9010     0.00  1.4188  -18.72  ...  1.2177  -11.33  1.9992    0.20
```

### 其他指标

#### 中国日度沿海六大电库存

接口: macro_china_daily_energy

目标地址: https://datacenter.jin10.com/reportType/dc_qihuo_energy_report

描述: 获取中国日度沿海六大电库存数据, 数据区间从20160101-至今, 不再更新, 只能获得历史数据

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 数值 | float | Y        | energy    |

接口示例

```
import PPshare as PP
macro_china_daily_energy_df = PP.macro_china_daily_energy()
print(macro_china_daily_energy_df)
```

数据示例

macro_china_daily_energy_df:

```
          沿海六大电库存      日耗 存煤可用天数
2016-01-01  1167.60   64.20   18.19
2016-01-02  1162.90   63.40   18.34
2016-01-03  1160.80   62.60   18.54
2016-01-04  1185.30   57.60   20.58
2016-01-05  1150.20   57.20   20.11
              ...     ...    ...
2019-05-17   1639.47   61.71  26.56
2019-05-21   1591.92   62.67  25.40
2019-05-22   1578.63   59.54  26.51
2019-05-24   1671.83   60.65  27.56
2019-06-21   1786.64   66.57  26.84
```

#### 人民币汇率中间价报告

接口: macro_china_rmb

目标地址: https://datacenter.jin10.com/reportType/dc_rmb_data

描述: 获取中国人民币汇率中间价报告, 数据区间从20170103-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称                         | 类型  | 默认显示 | 描述       |
| :--------------------------- | :---- | :------- | :--------- |
| 日期                         | str   | Y        | 日期-索引  |
| 美元/人民币_中间价           | float | Y        | –          |
| 美元/人民币_涨跌幅           | float | Y        | 单位: 点   |
| 欧元/人民币_中间价           | float | Y        | –          |
| 欧元/人民币_涨跌幅           | float | Y        | 单位: 点   |
| 100日元/人民币_中间价        | float | Y        | –          |
| 100日元/人民币_涨跌幅        | float | Y        | 单位: 点对 |
| 港元/人民币_中间价           | float | Y        | –          |
| 港元/人民币_涨跌幅           | float | Y        | 单位: 点   |
| 英镑/人民币_中间价           | float | Y        | –          |
| 英镑/人民币_涨跌幅           | float | Y        | 单位: 点   |
| 澳元/人民币_中间价           | float | Y        | –          |
| 澳元/人民币_涨跌幅           | float | Y        | 单位: 点   |
| 新西兰元/人民币_中间价       | float | Y        | –          |
| 新西兰元/人民币_涨跌幅       | float | Y        | 单位: 点   |
| 新加坡元/人民币_中间价       | float | Y        | –          |
| 新加坡元/人民币_涨跌幅       | float | Y        | 单位: 点   |
| 瑞郎/人民币_中间价           | float | Y        | –          |
| 瑞郎/人民币_涨跌幅           | float | Y        | 单位: 点   |
| 加元/人民币_中间价           | float | Y        | –          |
| 加元/人民币_涨跌幅           | float | Y        | 单位: 点   |
| 人民币/马来西亚林吉特_中间价 | float | Y        | –          |
| 人民币/马来西亚林吉特_涨跌幅 | float | Y        | 单位: 点   |
| 人民币/俄罗斯卢布_中间价     | float | Y        | –          |
| 人民币/俄罗斯卢布_涨跌幅     | float | Y        | 单位: 点   |
| 人民币/南非兰特_中间价       | float | Y        | –          |
| 人民币/南非兰特_涨跌幅       | float | Y        | 单位: 点   |
| 人民币/韩元_中间价           | float | Y        | –          |
| 人民币/韩元_涨跌幅           | float | Y        | 单位: 点   |
| 人民币/阿联酋迪拉姆_中间价   | float | Y        | –          |
| 人民币/阿联酋迪拉姆_涨跌幅   | float | Y        | 单位: 点   |
| 人民币/沙特里亚尔_中间价     | float | Y        | –          |
| 人民币/沙特里亚尔_涨跌幅     | float | Y        | 单位: 点   |
| 人民币/匈牙利福林_中间价     | float | Y        | –          |
| 人民币/匈牙利福林_涨跌幅     | float | Y        | 单位: 点   |
| 人民币/波兰兹罗提_中间价     | float | Y        | –          |
| 人民币/波兰兹罗提_涨跌幅     | float | Y        | 单位: 点   |
| 人民币/丹麦克朗_中间价       | float | Y        | –          |
| 人民币/丹麦克朗_涨跌幅       | float | Y        | 单位: 点   |
| 人民币/瑞典克朗_中间价       | float | Y        | –          |
| 人民币/瑞典克朗_涨跌幅       | float | Y        | 单位: 点   |
| 人民币/丹麦克朗_中间价       | float | Y        | –          |
| 人民币/丹麦克朗_涨跌幅       | float | Y        | 单位: 点   |
| 人民币/挪威克朗_中间价       | float | Y        | –          |
| 人民币/挪威克朗_涨跌幅       | float | Y        | 单位: 点   |
| 人民币/土耳其里拉_中间价     | float | Y        | –          |
| 人民币/土耳其里拉_涨跌幅     | float | Y        | 单位: 点   |
| 人民币/墨西哥比索_中间价     | float | Y        | –          |
| 人民币/墨西哥比索_涨跌幅     | float | Y        | 单位: 点   |
| 人民币/泰铢_中间价           | float | Y        | –          |
| 人民币/泰铢_涨跌幅           | float | Y        | 单位: 点   |

接口示例

```
import PPshare as PP
macro_china_rmb_df = PP.macro_china_rmb()
print(macro_china_rmb_df)
```

数据示例

macro_china_rmb_df:

```
            美元/人民币_中间价  美元/人民币_涨跌幅  ...  人民币/泰铢_定价  人民币/泰铢_涨跌幅
2018-02-06      6.3072         NaN  ...     5.0191         NaN
2018-02-07      6.2882      -190.0  ...     5.0178       -13.0
2018-02-08      6.2822       -60.0  ...     5.0429       251.0
2018-02-09      6.3194       372.0  ...     5.0406       -23.0
2018-02-12      6.3001      -193.0  ...     5.0310       -96.0
                ...         ...  ...        ...         ...
2020-04-16      7.0714       312.0  ...     4.6260      -156.0
2020-04-17      7.0718         4.0  ...     4.6083      -177.0
2020-04-20      7.0657       -61.0  ...     4.5977      -106.0
2020-04-21      7.0752        95.0  ...     4.5929       -48.0
2020-04-22      7.0903       151.0  ...     4.5843       -86.0
```

#### 深圳融资融券报告

接口: macro_china_market_margin_sz

目标地址: https://datacenter.jin10.com/reportType/dc_market_margin_sz

描述: 获取深圳融资融券报告, 数据区间从20100331-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称             | 类型  | 默认显示 | 描述      |
| :--------------- | :---- | :------- | :-------- |
| 日期             | str   | Y        | 日期-索引 |
| 融资买入额(元)   | float | Y        | –         |
| 融资余额(元)     | float | Y        | –         |
| 融券卖出量(股)   | float | Y        | –         |
| 融券余量(股)     | float | Y        | –         |
| 融券余额(元)     | float | Y        | –         |
| 融资融券余额(元) | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_china_market_margin_sz_df = PP.macro_china_market_margin_sz()
print(macro_china_market_margin_sz_df)
```

数据示例

```
               融资买入额(元)       融资余额(元)  融券卖出量(股)    融券余量(股)     融券余额(元)  \
2010-03-31       684569        670796      4000       3900       70895
2010-04-08      6713260      14467758      2100       3100       56023
2010-04-09      9357095      19732998      6700       5400      108362
2010-04-12     10406563      24813027      2200       1000        8100
2010-04-15     16607172      47980287      4200       5200       97676
                 ...           ...       ...        ...         ...
2019-12-12  25190412075  423457288662  29769255  209557883  2504593151
2019-12-13  29636811209  423422868505  32820867  206092170  2509424768
2019-12-16  39166060634  428851154451  44000215  217123568  2647520178
2019-12-17  46930557203  433966722200  40492711  220945538  2750371397
2019-12-18  41043515833  438511398249  39150376  224554586  2761303194
               融资融券余额(元)
2010-03-31        741691
2010-04-08      14523781
2010-04-09      19841360
2010-04-12      24821127
2010-04-15      48077963
                  ...
2019-12-12  425961881813
2019-12-13  425932293273
2019-12-16  431498674629
2019-12-17  436717093597
2019-12-18  441272701443
```

#### 上海融资融券报告

接口: macro_china_market_margin_sh

目标地址: https://datacenter.jin10.com/reportType/dc_market_margin_sse

描述: 获取上海融资融券报告, 数据区间从20100331-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称         | 类型  | 默认显示 | 描述         |
| :----------- | :---- | :------- | :----------- |
| 日期         | str   | Y        | 日期-索引    |
| 融资余额     | float | Y        | 注意单位：元 |
| 融资买入额   | float | Y        | 注意单位：元 |
| 融券余量     | float | Y        | 注意单位：股 |
| 融券余额     | float | Y        | 注意单位：元 |
| 融券卖出量   | float | Y        | 注意单位：股 |
| 融资融券余额 | float | Y        | 注意单位：元 |

接口示例

```
import PPshare as PP
macro_china_market_margin_sh_df = PP.macro_china_market_margin_sh()
print(macro_china_market_margin_sh_df)
```

数据示例

```
                    融资余额         融资买入额  ...        融券卖出量        融资融券余额
2010-03-31  5.824813e+06  5.866316e+06  ...       3100.0  5.848955e+06
2010-04-01  6.842114e+06  1.054024e+06  ...          0.0  6.859439e+06
2010-04-02  6.762781e+06  2.075160e+05  ...          0.0  6.774710e+06
2010-04-06  1.009124e+07  3.329461e+06  ...          0.0  1.010151e+07
2010-04-07  2.508683e+07  1.514140e+07  ...       1400.0  2.512524e+07
                  ...           ...  ...          ...           ...
2020-08-17  7.320815e+11  6.532228e+10  ...  311910304.0  7.735001e+11
2020-08-18  7.371393e+11  5.588143e+10  ...  236068903.0  7.784736e+11
2020-08-19  7.381023e+11  5.470145e+10  ...  302792889.0  7.794299e+11
2020-08-20  7.368085e+11  3.763784e+10  ...  203660295.0  7.778967e+11
2020-08-21  7.352210e+11  3.599241e+10  ...  196118235.0  7.765762e+11
```

#### 上海黄金交易所报告

接口: macro_china_au_report

目标地址: https://datacenter.jin10.com/reportType/dc_sge_report

描述: 获取上海黄金交易所报告, 数据区间从20140905-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称       | 类型  | 默认显示 | 描述      |
| :--------- | :---- | :------- | :-------- |
| 日期       | str   | Y        | 日期-索引 |
| 商品       | float | Y        | –         |
| 开盘价     | float | Y        | –         |
| 最高价     | float | Y        | –         |
| 最低价     | float | Y        | –         |
| 收盘价     | float | Y        | –         |
| 涨跌       | float | Y        | –         |
| 涨跌幅     | float | Y        | –         |
| 加权平均价 | float | Y        | –         |
| 成交量     | float | Y        | –         |
| 成交金额   | float | Y        | –         |
| 持仓量     | float | Y        | –         |
| 交收方向   | float | Y        | –         |
| 交收量     | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_china_au_report_df = PP.macro_china_au_report()
print(macro_china_au_report_df)
```

数据示例

```
                  商品      开盘价      最高价  ...          持仓量   交收方向    交收量
日期                                      ...                           
2014-09-05    Pt9995   293.50   293.50  ...          NaN           NaN
2014-09-05   Ag(T+D)  4159.00  4197.00  ...  5.25224e+06   空支付多    NaN
2014-09-05   Ag99.99  4218.00  4218.00  ...          322           NaN
2014-09-05   Au(T+D)   250.52   252.48  ...       144574   多支付空  11848
2014-09-05  mAu(T+D)   250.87   252.50  ...       130808   多支付空  23644
              ...      ...      ...  ...          ...    ...    ...
2020-04-22  NYAuTN12   379.80   385.00  ...        63446           NaN
2020-04-22    PGC30g   375.83   379.50  ...          NaN           NaN
2020-04-22   Pt99.95   173.30   181.96  ...          NaN           NaN
2020-04-22   Au99.99   372.00   374.45  ...          NaN           NaN
2020-04-22   Ag(T+D)  3554.00  3620.00  ...  1.06485e+07  多支付给空  67050
```

### 中国电煤价格指数

#### 全国综合电煤价格指数

接口: macro_china_ctci

目标地址: http://jgjc.ndrc.gov.cn/dmzs.aspx?clmId=741

描述: 获取中国电煤价格指数-全国综合电煤价格指数图, 20140101-至今的所有历史数据

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称  | 类型  | 默认显示 | 描述 |
| :---- | :---- | :------- | :--- |
| date  | str   | Y        | 日期 |
| value | float | Y        | –    |

接口示例

```
import PPshare as PP
macro_china_ctci_df = PP.macro_china_ctci()
print(macro_china_ctci_df)
```

数据示例

```
        date   value
0   20140201  495.79
1   20140301  484.88
2   20140401  470.61
3   20140501  461.02
4   20140601  454.23
5   20140701  443.48
6   20140801  430.77
7   20140901  417.76
8   20141001  412.30
9   20141101  415.58
67  20190901  486.79
68  20191001  489.88
69  20191101  492.01
70  20191201  483.09
```

#### 各价区电煤价格指数

接口: macro_china_ctci_detail

目标地址: http://jgjc.ndrc.gov.cn/dmzs.aspx?clmId=741

描述: 获取中国电煤价格指数-各价区电煤价格指数, 具体年具体月的历史数据

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述 |
| :--- | :---- | :------- | :--- |
| 环比 | str   | Y        | 日期 |
| 上期 | float | Y        | –    |
| 同比 | float | Y        | –    |
| 本期 | float | Y        | –    |

接口示例

```
import PPshare as PP
macro_china_ctci_detail_df = PP.macro_china_ctci_detail()
print(macro_china_ctci_detail_df)
```

数据示例

```
          环比      上期      同比      本期
全国     -1.81  492.01   -7.11  483.09
天津市    -1.72  482.96  -12.83  474.65
冀北      0.56  453.80   -6.82  456.32
冀南     -0.89  471.71   -8.22  467.51
山西省    -2.43  344.46  -11.06  336.08
蒙西      0.51  292.07    4.31  293.56
蒙东     -0.04  274.00   11.53  273.90
辽宁省    -1.25  545.90   -6.91  539.09
吉林省    -0.97  556.83   -5.14  551.43
黑龙江省   -0.27  540.51   -0.84  539.07
上海市    -1.43  519.98  -10.75  512.55
江苏省    -0.85  535.04   -9.17  530.51
浙江省    -0.29  571.41   -2.57  569.78
安徽省    -1.12  574.23   -8.08  567.78
福建省    -1.01  532.02  -13.31  526.62
江西省     0.41  649.13   -5.46  651.79
山东省    -1.62  547.18  -12.24  538.33
河南省    -2.10  499.34  -18.86  488.87
湖北省    -0.75  583.65  -10.48  579.30
湖南省    -0.55  616.56   -9.44  613.18
广东省    -1.38  562.91   -8.65  555.12
广西自治区   0.48  682.33   -6.23  685.59
海南省     3.02  505.27   -4.46  520.53
重庆市    -5.14  613.98   -4.42  582.43
四川省    -0.10  570.25   -8.56  569.70
贵州省     0.85  488.61   -1.55  492.78
云南省    -3.38  457.68  -19.56  442.19
陕西省    -2.02  393.92  -10.11  385.95
甘肃省     0.30  463.03   -9.62  464.42
青海省     2.49  529.57    2.57  542.76
宁夏自治区  -2.46  362.00   -3.44  353.08
新疆自治区  -0.33  258.74    0.09  257.89
```

#### 历史电煤价格指数

接口: macro_china_ctci_detail_hist

目标地址: http://jgjc.ndrc.gov.cn/dmzs.aspx?clmId=741

描述: 获取中国电煤价格指数-历史电煤价格指数, 具体年的历史数据

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述                         |
| :--- | :--- | :--- | :--------------------------- |
| year | str  | Y    | year=”2018″, 从 2014-2019 年 |

输出参数

| 名称 | 类型  | 默认显示 | 描述 |
| :--- | :---- | :------- | :--- |
| 地区 | str   | Y        | 日期 |
| 月份 | float | Y        | –    |
| —    | —     | —        | –    |
| 月份 | float | Y        | –    |

接口示例

```
import PPshare as PP
macro_china_ctci_detail_hist_df = PP.macro_china_ctci_detail_hist(year="2018")
print(macro_china_ctci_detail_hist_df)
```

数据示例

```
       地区 2018年01月 2018年02月 2018年03月 2018年04月 2018年05月 2018年06月 2018年07月  \
0      全国   549.12   567.21   546.58   522.78   515.39   528.57   532.53   
1     天津市   561.23   583.85   585.94   551.54   524.41   528.97   540.94   
2      冀北   510.57   534.05   517.08   474.42   453.55   461.06   467.58   
3      冀南   530.74   540.18   532.12   514.28   503.97   497.25   493.77   
4     山西省   393.98   408.07   396.38   370.90   364.30   374.28   376.38   
5      蒙西   301.63   301.46   292.33   276.21   275.37   286.48   281.19   
6      蒙东   230.38   227.76   242.35   246.00   248.76   250.37   242.71   
7     辽宁省   563.70   563.07   558.31   538.79   530.65   537.27   553.26   
8     吉林省   543.02   548.27   535.59   513.15   506.41   522.02   544.06   
9    黑龙江省   519.31   522.83   495.48   477.43   470.00   472.85   483.66   
10    上海市   645.34   643.98   647.36   600.11   578.45   584.03   602.29   
11    江苏省   644.64   651.17   624.19   588.70   576.74   583.94   589.85   
12    浙江省   636.39   637.83   625.57   592.52   609.26   618.92   586.79   
13    安徽省   647.37   661.77   635.92   604.14   587.82   592.20   603.95   
14    福建省   656.82   650.69   649.71   613.20   573.53   600.93   618.63   
15    江西省   751.64   765.61   739.68   691.16   662.62   677.83   690.77   
16    山东省   628.53   649.27   634.08   592.92   573.53   586.10   594.91   
17    河南省   613.92   631.25   621.77   594.66   593.18   601.12   608.91   
18    湖北省   677.92   703.40   686.57   632.80   610.36   621.44   642.14   
19    湖南省   718.96   737.04   719.14   668.50   640.31   649.64   678.89   
20    广东省   651.36   657.91   649.06   634.28   630.47   640.65   639.35   
21  广西自治区   756.91   754.45   757.12   745.06   716.98   721.96   705.18   
22    海南省   614.98   625.04   637.07   593.45   525.72   565.77   587.75   
23    重庆市   619.37   629.52   620.51   598.80   571.14   570.81   611.41   
24    四川省   648.10   654.02   651.93   619.14   601.58   605.26   612.76   
25    贵州省   518.60   505.77   500.04   497.16   493.63   486.77   489.90   
26    云南省   467.09   388.74   421.98   447.52   482.76   513.48   510.29   
27    陕西省   463.31   478.76   465.24   442.26   435.63   436.38   428.95   
28    甘肃省   505.24   509.11   500.83   489.16   487.85   468.13   464.82   
29    青海省   544.92   549.28   548.58   536.46   524.28   510.17   516.74   
30  宁夏自治区   400.22   398.22   391.12   370.74   370.42   382.99   378.98   
31  新疆自治区   254.34   269.80   250.79   235.72   238.54   245.57   234.11   
   2018年08月 2018年09月 2018年10月 2018年11月 2018年12月  
0    522.40   522.16   523.47   520.09   522.20  
1    544.64   541.17   548.94   544.48   541.99  
2    466.16   471.52   485.16   489.72   490.16  
3    500.48   499.84   505.87   509.36   513.28  
4    371.11   371.23   378.49   377.88   375.88  
5    273.10   282.96   286.80   281.42   284.51  
6    228.15   242.71   251.47   245.58   250.44  
7    563.19   573.65   577.80   579.09   563.81  
8    573.05   588.78   592.40   581.29   568.79  
9    520.07   539.22   537.95   543.64   535.24  
10   607.19   585.45   574.96   574.26   555.67  
11   583.12   577.07   582.36   584.04   576.59  
12   575.81   583.42   587.16   584.79   587.46  
13   599.81   598.09   605.65   617.72   610.69  
14   609.29   604.87   601.59   607.44   608.93  
15   690.62   691.52   695.14   689.43   678.53  
16   590.17   588.25   596.28   613.43   616.25  
17   605.13   595.11   597.53   602.47   599.72  
18   638.43   625.53   629.82   647.10   653.36  
19   677.36   671.32   678.18   677.13   668.14  
20   629.72   626.41   616.66   607.70   612.66  
21   712.84   724.77   729.57   731.13   716.45  
22   587.61   590.36   558.11   544.82   534.33  
23   594.85   597.89   608.23   609.34   618.87  
24   622.66   608.49   601.19   623.04   642.92  
25   502.76   503.33   498.03   500.56   513.44  
26   530.24   540.00   541.58   549.68   569.41  
27   412.37   418.11   420.12   429.35   434.98  
28   454.77   482.04   502.39   513.85   501.55  
29   522.63   516.94   517.64   529.17   546.25  
30   374.67   376.04   372.16   365.67   368.41  
31   229.33   251.85   254.20   257.66   265.38  
```

## 美国宏观

### 经济状况

#### 美国GDP

接口: macro_usa_gdp_monthly

目标地址: https://datacenter.jin10.com/reportType/dc_usa_gdp

描述: 获取美国国内生产总值(GDP)报告, 数据区间从20080228-至今

限量: 单次返回某一个所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_usa_gdp_monthly_se = PP.macro_usa_gdp_monthly()
print(macro_usa_gdp_monthly_se.name)
print(macro_usa_gdp_monthly_se)
```

数据示例

macro_usa_gdp_monthly_se.name

```
gdp
```

macro_usa_gdp_monthly_se: pandas.Series

```
2008-02-28    0.6
2008-03-27    0.6
2008-04-30    0.9
2008-06-26      1
2008-07-31    1.9
             ... 
2019-09-26      2
2019-10-30      2
2019-11-27      2
2019-12-20    2.1
2020-01-30      0
```

### 物价水平

#### 美国CPI月率报告

接口: macro_usa_cpi_monthly

目标地址: https://datacenter.jin10.com/reportType/dc_usa_cpi

描述: 获取美国CPI月率报告, 数据区间从19700101-至今

限量: 单次返回某一个所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_usa_cpi_monthly_se = PP.macro_usa_cpi_monthly()
print(macro_usa_cpi_monthly_se.name)
print(macro_usa_cpi_monthly_se)
```

数据示例

macro_usa_cpi_monthly_se.name

```
cpi_monthly
```

macro_usa_cpi_monthly_se: pandas.Series

```
1970-01-01    0.5
1970-02-01    0.5
1970-03-01    0.5
1970-04-01    0.5
1970-05-01    0.5
             ... 
2019-09-12    0.1
2019-10-10    0.1
2019-11-13    0.4
2019-12-11    0.3
2020-01-14      0
```

#### 美国核心CPI月率报告

接口: macro_usa_core_cpi_monthly

目标地址: https://datacenter.jin10.com/reportType/dc_usa_core_cpi

描述: 获取美国核心CPI月率报告, 数据区间从19700101-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_usa_core_cpi_monthly_se = PP.macro_usa_core_cpi_monthly()
print(macro_usa_core_cpi_monthly_se.name)
print(macro_usa_core_cpi_monthly_se)
```

数据示例

macro_usa_core_cpi_monthly_se.name

```
usa_core_cpi
```

macro_usa_core_cpi_monthly_se: pandas.Series

```
1970-01-01    0.5
1970-02-01    0.5
1970-03-01    0.5
1970-04-01    0.8
1970-05-01    0.7
             ... 
2019-09-12    0.3
2019-10-10    0.1
2019-11-13    0.2
2019-12-11    0.2
2020-01-14      0
```

#### 美国个人支出月率报告

接口: macro_usa_personal_spending

目标地址: https://datacenter.jin10.com/reportType/dc_usa_personal_spending

描述: 获取美国个人支出月率报告, 数据区间从19700101-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_usa_personal_spending_se = PP.macro_usa_personal_spending()
print(macro_usa_personal_spending_se.name)
print(macro_usa_personal_spending_se)
```

数据示例

macro_usa_personal_spending_se.name

```
usa_personal_spending
```

macro_usa_personal_spending_se: pandas.Series

```
1970-01-01    0.4
1970-02-01      1
1970-03-01    0.8
1970-04-01   -0.3
1970-05-01    0.6
             ... 
2019-09-27    0.2
2019-10-31    0.2
2019-11-27    0.3
2019-12-20    0.4
2020-01-31      0
```

#### 美国零售销售月率报告

接口: macro_usa_retail_sales

目标地址: https://datacenter.jin10.com/reportType/dc_usa_retail_sales

描述: 获取美国零售销售月率报告, 数据区间从19920301-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_usa_retail_sales_se = PP.macro_usa_retail_sales()
print(macro_usa_retail_sales_se.name)
print(macro_usa_retail_sales_se)
```

数据示例

macro_usa_retail_sales_se.name

```
usa_retail_sales
```

macro_usa_retail_sales_se: pandas.Series

```
1992-03-01     0.1
1992-04-01    -0.3
1992-05-01     0.6
1992-06-01     0.5
1992-07-01     0.3
              ... 
2019-09-13     0.6
2019-10-16    -0.3
2019-11-15     0.4
2019-12-13     0.2
2020-01-16       0
```

#### 美国进口物价指数报告

接口: macro_usa_import_price

目标地址: https://datacenter.jin10.com/reportType/dc_usa_import_price

描述: 获取美国进口物价指数报告, 数据区间从19890201-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_usa_import_price_se = PP.macro_usa_import_price()
print(macro_usa_import_price_se.name)
print(macro_usa_import_price_se)
```

数据示例

macro_usa_import_price_se.name

```
usa_import_price
```

macro_usa_import_price_se: pandas.Series

```
1989-02-01       2
1989-03-01    -0.5
1989-04-01     0.8
1989-05-01     0.8
1989-06-01     0.7
              ... 
2019-09-13    -0.2
2019-10-11     0.1
2019-11-15    -0.5
2019-12-13     0.2
2020-01-16       0
```

#### 美国出口价格指数报告

接口: macro_usa_export_price

目标地址: https://datacenter.jin10.com/reportType/dc_usa_export_price

描述: 获取美国出口价格指数报告, 数据区间从19890201-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_usa_export_price_se = PP.macro_usa_export_price()
print(macro_usa_export_price_se.name)
print(macro_usa_export_price_se)
```

数据示例

macro_usa_export_price_se.name

```
usa_export_price
```

macro_usa_export_price_se: pandas.Series

```
1989-02-01     1.2
1989-03-01    -0.3
1989-04-01     0.6
1989-05-01    -0.2
1989-06-01     0.4
              ... 
2019-09-13    -0.6
2019-10-11    -0.2
2019-11-15    -0.1
2019-12-13     0.2
2020-01-16       0
```

### 劳动力市场

#### LMCI

接口: macro_usa_lmci

目标地址: https://datacenter.jin10.com/reportType/dc_usa_lmci

描述: 获取美联储劳动力市场状况指数报告, 数据区间从20141006-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_usa_lmci_se = PP.macro_usa_lmci()
print(macro_usa_lmci_se.name)
print(macro_usa_lmci_se)
```

数据示例

macro_usa_lmci_se.name

```
lmci
```

macro_usa_lmci_se: pandas.Series

```
2014-10-06      4
2014-11-10    3.9
2014-12-08    5.5
2015-01-12    7.3
2015-02-09    4.9
             ... 
2017-05-08    3.5
2017-06-05      0
2017-06-16    3.3
2017-07-10    1.5
2017-08-07      0
```

#### 失业率

##### 美国失业率报告

接口: macro_usa_unemployment_rate

目标地址: https://datacenter.jin10.com/reportType/dc_usa_unemployment_rate

描述: 获取美国失业率报告, 数据区间从19700101-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_usa_unemployment_rate_se = PP.macro_usa_unemployment_rate()
print(macro_usa_unemployment_rate_se.name)
print(macro_usa_unemployment_rate_se)
```

数据示例

macro_usa_unemployment_rate_se.name

```
unemployment_rate
```

macro_usa_unemployment_rate_se: pandas.Series

```
1970-01-01    3.5
1970-02-01    3.9
1970-03-01    4.2
1970-04-01    4.4
1970-05-01    4.6
             ... 
2019-09-06    3.7
2019-10-04    3.5
2019-11-01    3.6
2019-12-06    3.5
2020-01-10    3.5
```

##### 美国挑战者企业裁员人数报告

接口: macro_usa_job_cuts

目标地址: https://datacenter.jin10.com/reportType/dc_usa_job_cuts

描述: 获取美国挑战者企业裁员人数报告, 数据区间从19940201-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_usa_job_cuts_se = PP.macro_usa_job_cuts()
print(macro_usa_job_cuts_se.name)
print(macro_usa_job_cuts_se)
```

数据示例

macro_usa_job_cuts_se.name

```
usa_job_cuts
```

macro_usa_job_cuts_se: pandas.Series

```
1994-02-01     10.89
1994-03-01      3.46
1994-04-01       4.9
1994-05-01      3.61
1994-06-01      3.63
               ...  
2019-10-31    5.0275
2019-12-05    4.4569
2020-01-02    3.2843
2020-01-09         0
2020-02-06         0
```

#### 就业人口

##### 美国非农就业人数报告

接口: macro_usa_non_farm

目标地址: https://datacenter.jin10.com/reportType/dc_nonfarm_payrolls

描述: 获取美国非农就业人数报告, 数据区间从19700102-至今

限量: 单次返回某一个所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称       | 类型  | 默认显示 | 描述       |
| :--------- | :---- | :------- | :--------- |
| 日期       | str   | Y        | 日期-索引  |
| 今值(万人) | float | Y        | 今值(万人) |

接口示例

```
import PPshare as PP
macro_usa_non_farm_se = PP.macro_usa_non_farm()
print(macro_usa_non_farm_se.name)
print(macro_usa_non_farm_se)
```

数据示例

macro_usa_non_farm_se.name

```
non_farm
```

macro_usa_non_farm_se: pandas.Series

```
1970-01-02    15.3
1970-02-06    -6.4
1970-03-06    12.8
1970-04-03    14.8
1970-05-01   -10.4
              ...
2019-07-05    19.3
2019-08-02    15.9
2019-09-06    16.8
2019-10-04    13.6
2019-11-01       0
```

##### 美国ADP就业人数报告

接口: macro_usa_adp_employment

目标地址: https://datacenter.jin10.com/reportType/dc_adp_nonfarm_employment

描述: 获取美国ADP就业人数报告, 数据区间从20010601-至今

限量: 单次返回某一个所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称       | 类型  | 默认显示 | 描述       |
| :--------- | :---- | :------- | :--------- |
| 日期       | str   | Y        | 日期-索引  |
| 今值(万人) | float | Y        | 今值(万人) |

接口示例

```
import PPshare as PP
macro_usa_adp_employment_se = PP.macro_usa_adp_employment()
print(macro_usa_adp_employment_se.name)
print(macro_usa_adp_employment_se)
```

数据示例

macro_usa_adp_employment_se.name

```
adp
```

macro_usa_adp_employment_se: pandas.Series

```
2001-06-01   -17.5
2001-07-01     -23
2001-08-01   -20.3
2001-09-01   -24.6
2001-10-01   -26.1
              ... 
2019-09-05    15.7
2019-10-02     9.3
2019-10-30    12.1
2019-12-04    12.4
2020-01-08    20.2
```

#### 消费者收入与支出

##### 美国核心PCE物价指数年率报告

接口: macro_usa_core_pce_price

目标地址: https://datacenter.jin10.com/reportType/dc_usa_core_pce_price

描述: 获取美国核心PCE物价指数年率报告, 数据区间从19700101-至今

限量: 单次返回某一个所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_usa_core_pce_price_se = PP.macro_usa_core_pce_price()
print(macro_usa_core_pce_price_se.name)
print(macro_usa_core_pce_price_se)
```

数据示例

macro_usa_core_pce_price_se.name

```
core_pce_price
```

macro_usa_core_pce_price_se: pandas.Series

```
1970-01-01    4.8
1970-02-01    4.7
1970-03-01    4.8
1970-04-01    4.7
1970-05-01    4.7
             ... 
2019-09-27    1.8
2019-10-31    1.7
2019-11-27    1.7
2019-12-20    1.6
2020-01-31      0
```

##### 美国实际个人消费支出季率初值报告

接口: macro_usa_real_consumer_spending

目标地址: https://datacenter.jin10.com/reportType/dc_usa_real_consumer_spending

描述: 获取美国实际个人消费支出季率初值报告, 数据区间从20131107-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_usa_real_consumer_spending_se = PP.macro_usa_real_consumer_spending()
print(macro_usa_real_consumer_spending_se.name)
print(macro_usa_real_consumer_spending_se)
```

数据示例

macro_usa_real_consumer_spending_se.name

```
usa_real_consumer_spending
```

macro_usa_real_consumer_spending_se: pandas.Series

```
2013-11-07    1.5
2013-12-05    1.4
2013-12-20      2
2014-01-30    3.3
2014-02-28    2.6
             ... 
2019-09-26    4.6
2019-10-30    2.9
2019-11-27    2.9
2019-12-20    3.2
2020-01-30      0
```

### 贸易状况

#### 美国贸易帐报告

接口: macro_usa_trade_balance

目标地址: https://datacenter.jin10.com/reportType/dc_usa_trade_balance

描述: 获取美国贸易帐报告, 数据区间从19700101-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_usa_trade_balance_se = PP.macro_usa_trade_balance()
print(macro_usa_trade_balance_se.name)
print(macro_usa_trade_balance_se)
```

数据示例

macro_usa_trade_balance_se.name

```
usa_trade_balance
```

macro_usa_trade_balance_se: pandas.Series

```
1970-01-01       2
1970-02-01       1
1970-03-01       2
1970-04-01       1
1970-05-01       1
              ... 
2019-09-04    -540
2019-10-04    -550
2019-11-05    -511
2019-12-05    -469
2020-01-07    -431
```

#### 美国经常帐报告

接口: macro_usa_current_account

目标地址: https://datacenter.jin10.com/reportType/dc_usa_current_account

描述: 获取美国经常帐报告, 数据区间从20080317-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_usa_current_account_se = PP.macro_usa_current_account()
print(macro_usa_current_account_se.name)
print(macro_usa_current_account_se)
```

数据示例

macro_usa_current_account_se.name

```
usa_current_account
```

macro_usa_current_account_se: pandas.Series

```
2008-03-17    -1730
2008-06-17    -1760
2008-09-17    -1830
2008-12-17    -1740
2009-03-18    -1549
              ...  
2019-03-21        0
2019-03-27    -1439
2019-06-20    -1362
2019-09-19    -1252
2019-12-19    -1241
```

### 产业指标

#### 制造业

##### 贝克休斯钻井报告

接口: macro_usa_rig_count

目标地址: https://datacenter.jin10.com/reportType/dc_rig_count_summary

描述: 获取贝克休斯钻井报告, 数据区间从19870717-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称                  | 类型  | 默认显示 | 描述      |
| :-------------------- | :---- | :------- | :-------- |
| 日期                  | str   | Y        | 日期-索引 |
| 钻井总数_钻井数       | float | Y        | –         |
| 钻井总数_变化         | float | Y        | –         |
| 美国石油钻井_钻井数   | float | Y        | –         |
| 美国石油钻井_变化     | float | Y        | –         |
| 混合钻井_钻井数       | float | Y        | –         |
| 混合钻井_变化         | float | Y        | –         |
| 美国天然气钻井_钻井数 | float | Y        | –         |
| 美国天然气钻井_变化   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_usa_rig_count_df = PP.macro_usa_rig_count()
print(macro_usa_rig_count_df)
```

数据示例

```
            钻井总数_钻井数  钻井总数_变化  美国石油钻井_钻井数  ...  混合钻井_变化  美国天然气钻井_钻井数  美国天然气钻井_变化
2020-04-03      66.4     -6.4        56.2  ...      0.0         10.0        -0.2
2020-03-27      72.8     -4.4        62.4  ...      0.0         10.2        -0.4
2020-03-20      77.2     -2.0        66.4  ...      0.0         10.6        -0.1
2020-03-13      79.2     -0.1        68.3  ...      0.0         10.7        -0.2
2020-03-06      79.3      0.3        68.2  ...      0.0         10.9        -0.1
              ...      ...         ...  ...      ...          ...         ...
1987-08-14      99.8      1.5        62.0  ...      0.5         35.2         0.3
1987-08-07      98.3      1.0        61.3  ...     -0.1         34.9         0.3
1987-07-31      97.3      5.6        60.5  ...      0.1         34.6         1.5
1987-07-24      91.7     -0.5        56.5  ...     -0.5         33.1        -0.6
1987-07-17      92.2      NaN        55.9  ...      NaN         33.7         NaN
```

##### 美国生产者物价指数(PPI)报告

接口: macro_usa_ppi

目标地址: https://datacenter.jin10.com/reportType/dc_usa_ppi

描述: 获取美国生产者物价指数(PPI)报告, 数据区间从20080226-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_usa_ppi_se = PP.macro_usa_ppi()
print(macro_usa_ppi_se.name)
print(macro_usa_ppi_se)
```

数据示例

macro_usa_ppi_se.name

```
usa_ppi
```

macro_usa_ppi_se: pandas.Series

```
2008-02-26       1
2008-03-18     0.3
2008-04-15     1.1
2008-05-20     0.2
2008-06-17     1.4
              ... 
2019-09-11     0.1
2019-10-08    -0.3
2019-11-14     0.4
2019-12-12       0
2020-01-15       0
```

##### 美国核心生产者物价指数(PPI)报告

接口: macro_usa_core_ppi

目标地址: https://datacenter.jin10.com/reportType/dc_usa_core_ppi

描述: 获取美国核心生产者物价指数(PPI)报告, 数据区间从20080318-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_usa_core_ppi_se = PP.macro_usa_core_ppi()
print(macro_usa_core_ppi_se.name)
print(macro_usa_core_ppi_se)
```

数据示例

macro_usa_core_ppi_se.name

```
usa_core_ppi
```

macro_usa_core_ppi_se: pandas.Series

```
2008-03-18     0.5
2008-04-15     0.2
2008-05-20     0.4
2008-06-17     0.2
2008-08-19     0.7
              ... 
2019-09-11     0.3
2019-10-08    -0.3
2019-11-14     0.3
2019-12-12    -0.2
2020-01-15       0
```

##### 美国API原油库存报告

接口: macro_usa_api_crude_stock

目标地址: https://datacenter.jin10.com/reportType/dc_usa_api_crude_stock

描述: 获取美国API原油库存报告, 数据区间从20120328-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_usa_api_crude_stock_se = PP.macro_usa_api_crude_stock()
print(macro_usa_api_crude_stock_se.name)
print(macro_usa_api_crude_stock_se)
```

数据示例

macro_usa_api_crude_stock_se.name

```
usa_api_crude_stock
```

macro_usa_api_crude_stock_se: pandas.Series

```
2012-03-28     360.2
2012-04-04     784.8
2012-04-11     658.4
2012-04-18     340.9
2012-04-25     -98.5
               ...  
2019-12-27         0
2020-01-01         0
2020-01-02         0
2020-01-08    -594.5
2020-01-15         0
```

##### 美国Markit制造业PMI初值报告

接口: macro_usa_pmi

目标地址: https://datacenter.jin10.com/reportType/dc_usa_pmi

描述: 获取美国Markit制造业PMI初值报告, 数据区间从20120601-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_usa_pmi_se = PP.macro_usa_pmi()
print(macro_usa_pmi_se.name)
print(macro_usa_pmi_se)
```

数据示例

macro_usa_pmi_se.name

```
usa_pmi
```

macro_usa_pmi_se: pandas.Series

```
2012-06-01    52.9
2012-07-02    52.5
2012-07-24    51.8
2012-08-01    51.4
2012-08-23    51.9
              ... 
2019-11-22    52.2
2019-12-02    52.6
2019-12-16    52.6
2020-01-02    52.4
2020-01-24       0
```

##### 美国ISM制造业PMI报告

接口: macro_usa_ism_pmi

目标地址: https://datacenter.jin10.com/reportType/dc_usa_ism_pmi

描述: 获取美国ISM制造业PMI报告, 数据区间从19700101-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_usa_ism_pmi_se = PP.macro_usa_ism_pmi()
print(macro_usa_ism_pmi_se.name)
print(macro_usa_ism_pmi_se)
```

数据示例

macro_usa_ism_pmi_se.name

```
usa_ism_pmi
```

macro_usa_ism_pmi_se: pandas.Series

```
1970-01-01      52
1970-02-01    48.7
1970-03-01    47.4
1970-04-01    46.9
1970-05-01      45
              ... 
2019-09-03    49.1
2019-10-01    47.8
2019-11-01    48.3
2019-12-02    48.1
2020-01-03    47.2
```

#### 工业

##### 美国工业产出月率报告

接口: macro_usa_industrial_production

目标地址: https://datacenter.jin10.com/reportType/dc_usa_industrial_production

描述: 获取美国工业产出月率报告, 数据区间从19700101-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_usa_industrial_production_se = PP.macro_usa_industrial_production()
print(macro_usa_industrial_production_se.name)
print(macro_usa_industrial_production_se)
```

数据示例

macro_usa_industrial_production_se.name

```
usa_industrial_production
```

macro_usa_industrial_production_se: pandas.Series

```
1970-01-01    -0.3
1970-02-01    -1.9
1970-03-01    -0.1
1970-04-01    -0.1
1970-05-01    -0.3
              ... 
2019-09-17     0.8
2019-10-17    -0.3
2019-11-15    -0.9
2019-12-17     1.1
2020-01-17       0
```

##### 美国耐用品订单月率报告

接口: macro_usa_durable_goods_orders

目标地址: https://datacenter.jin10.com/reportType/dc_usa_durable_goods_orders

描述: 获取美国耐用品订单月率报告, 数据区间从20080227-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_usa_durable_goods_orders_se = PP.macro_usa_durable_goods_orders()
print(macro_usa_durable_goods_orders_se.name)
print(macro_usa_durable_goods_orders_se)
```

数据示例

macro_usa_durable_goods_orders_se.name

```
usa_durable_goods_orders
```

macro_usa_durable_goods_orders_se: pandas.Series

```
2008-02-27    -5.3
2008-03-26    -1.1
2008-04-24    -0.3
2008-05-28    -0.6
2008-06-25       0
              ... 
2019-10-24    -1.4
2019-11-27     0.2
2019-12-23    -2.1
2019-12-24       0
2020-01-28       0
```

##### 美国工厂订单月率报告

接口: macro_usa_factory_orders

目标地址: https://datacenter.jin10.com/reportType/dc_usa_factory_orders

描述: 获取美国工厂订单月率报告, 数据区间从19920401-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_usa_factory_orders_se = PP.macro_usa_factory_orders()
print(macro_usa_factory_orders_se.name)
print(macro_usa_factory_orders_se)
```

数据示例

macro_usa_factory_orders_se.name

```
usa_factory_orders
```

macro_usa_factory_orders_se: pandas.Series

```
1992-04-01     4.6
1992-05-01     1.9
1992-06-01     1.6
1992-07-01    -0.5
1992-08-01    -0.9
              ... 
2019-09-05     1.4
2019-10-03    -0.1
2019-11-04    -0.8
2019-12-05     0.2
2020-01-07    -0.7
```

#### 服务业

##### 美国Markit服务业PMI初值报告

接口: macro_usa_services_pmi

目标地址: https://datacenter.jin10.com/reportType/dc_usa_services_pmi

描述: 获取美国Markit服务业PMI初值报告, 数据区间从20120701-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_usa_services_pmi_se = PP.macro_usa_services_pmi()
print(macro_usa_services_pmi_se.name)
print(macro_usa_services_pmi_se)
```

数据示例

macro_usa_services_pmi_se.name

```
usa_services_pmi
```

macro_usa_services_pmi_se: pandas.Series

```
2012-07-01    53.2
2012-08-01    51.2
2012-09-01      52
2012-10-01    50.7
2012-11-01    52.7
              ... 
2019-11-22    50.6
2019-12-04    51.6
2019-12-16    51.6
2020-01-06    52.8
2020-01-24       0
```

##### 美国商业库存月率报告

接口: macro_usa_business_inventories

目标地址: https://datacenter.jin10.com/reportType/dc_usa_business_inventories

描述: 获取美国商业库存月率报告, 数据区间从19920301-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```python
import PPshare as pp
macro_usa_business_inventories_se = pp.macro_usa_business_inventories()
print(macro_usa_business_inventories_se.name)
print(macro_usa_business_inventories_se)
```

数据示例

macro_usa_business_inventories_se.name

```
usa_business_inventories
```

macro_usa_business_inventories_se: pandas.Series

```
1992-03-01     0.2
1992-04-01     0.4
1992-05-01     0.3
1992-06-01    -0.1
1992-07-01     0.7
              ... 
2019-09-13     0.3
2019-10-16    -0.1
2019-11-15    -0.1
2019-12-13     0.2
2020-01-16       0
```

##### 美国ISM非制造业PMI报告

接口: macro_usa_ism_non_pmi

目标地址: https://datacenter.jin10.com/reportType/dc_usa_ism_non_pmi

描述: 获取美国ISM非制造业PMI报告, 数据区间从19970801-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```python
import PPshare as pp
macro_usa_ism_non_pmi_se = PP.macro_usa_ism_non_pmi()
print(macro_usa_ism_non_pmi_se.name)
print(macro_usa_ism_non_pmi_se)
```

数据示例

macro_usa_ism_non_pmi_se.name

```
usa_ism_non_pmi
```

macro_usa_ism_non_pmi_se: pandas.Series

```
1997-08-01    56.7
1997-09-01      62
1997-10-01    56.2
1997-11-01    56.6
1997-12-01    58.5
              ... 
2019-09-05    56.4
2019-10-03    52.6
2019-11-05    54.7
2019-12-04    53.9
2020-01-07    55.0
```

##### 美国NAHB房产市场指数报告

接口: macro_usa_nahb_house_market_index

目标地址: https://datacenter.jin10.com/reportType/dc_usa_nahb_house_market_index

描述: 获取美国NAHB房产市场指数报告, 数据区间从19850201-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```python
import PPshare as pp
macro_usa_nahb_house_market_index_se = pp.macro_usa_nahb_house_market_index()
print(macro_usa_nahb_house_market_index_se.name)
print(macro_usa_nahb_house_market_index_se)
```

数据示例

macro_usa_nahb_house_market_index_se.name

```
usa_nahb_house_market_index
```

macro_usa_nahb_house_market_index_se: pandas.Series

```
1985-02-01    50
1985-03-01    58
1985-04-01    54
1985-05-01    49
1985-06-01    51
              ..
2019-09-17    68
2019-10-16    71
2019-11-18    71
2019-12-16    76
2020-01-16     0
```

#### 房地产

##### 美国NAHB房产市场指数报告

接口: macro_usa_nahb_house_market_index

目标地址: https://datacenter.jin10.com/reportType/dc_usa_nahb_house_market_index

描述: 获取美国NAHB房产市场指数报告, 数据区间从19850201-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_usa_nahb_house_market_index_se = PP.macro_usa_nahb_house_market_index()
print(macro_usa_nahb_house_market_index_se.name)
print(macro_usa_nahb_house_market_index_se)
```

数据示例

macro_usa_nahb_house_market_index_se.name

```
usa_nahb_house_market_index
```

macro_usa_nahb_house_market_index_se: pandas.Series

```
1985-02-01    50
1985-03-01    58
1985-04-01    54
1985-05-01    49
1985-06-01    51
              ..
2019-09-17    68
2019-10-16    71
2019-11-18    71
2019-12-16    76
2020-01-16     0
```

##### 美国新屋开工总数年化报告

接口: macro_usa_house_starts

目标地址: https://datacenter.jin10.com/reportType/dc_usa_house_starts

描述: 获取美国新屋开工总数年化报告, 数据区间从19700101-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_usa_house_starts_se = PP.macro_usa_house_starts()
print(macro_usa_house_starts_se.name)
print(macro_usa_house_starts_se)
```

数据示例

macro_usa_house_starts_se.name

```
usa_house_starts
```

macro_usa_house_starts_se: pandas.Series

```
1970-01-01    132.7
1970-02-01    108.5
1970-03-01    130.5
1970-04-01    131.9
1970-05-01    126.4
              ...  
2019-09-18    138.6
2019-10-17    126.6
2019-11-19    132.3
2019-12-17    136.5
2020-01-17        0
```

##### 美国新屋销售总数年化报告

接口: macro_usa_new_home_sales

目标地址: https://datacenter.jin10.com/reportType/dc_usa_new_home_sales

描述: 获取美国新屋销售总数年化报告, 数据区间从19700101-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_usa_new_home_sales_se = PP.macro_usa_new_home_sales()
print(macro_usa_new_home_sales_se.name)
print(macro_usa_new_home_sales_se)
```

数据示例

macro_usa_new_home_sales_se.name

```
usa_new_home_sales
```

macro_usa_new_home_sales_se: pandas.Series

```
1970-01-01    45.2
1970-02-01    46.1
1970-03-01    37.3
1970-04-01    38.9
1970-05-01    44.5
              ... 
2019-09-25    70.6
2019-10-24    73.8
2019-11-26      71
2019-12-23    71.9
2020-01-27       0
```

##### 美国营建许可总数报告

接口: macro_usa_building_permits

目标地址: https://datacenter.jin10.com/reportType/dc_usa_building_permits

描述: 获取美国营建许可总数报告, 数据区间从20080220-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_usa_building_permits_se = PP.macro_usa_building_permits()
print(macro_usa_building_permits_se.name)
print(macro_usa_building_permits_se)
```

数据示例

macro_usa_building_permits_se.name

```
usa_building_permits
```

macro_usa_building_permits_se: pandas.Series

```
2008-02-20      106
2008-03-18       98
2008-04-16       93
2008-05-16       98
2008-06-17       98
              ...  
2019-09-18    142.5
2019-10-17    139.1
2019-11-19    146.1
2019-12-17    147.4
2020-01-17        0
```

##### 美国成屋销售总数年化报告

接口: macro_usa_exist_home_sales

目标地址: https://datacenter.jin10.com/reportType/dc_usa_exist_home_sales

描述: 获取美国成屋销售总数年化报告, 数据区间从19700101-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```python
import PPshare as PP
macro_usa_exist_home_sales_se = PP.macro_usa_exist_home_sales()
print(macro_usa_exist_home_sales_se.name)
print(macro_usa_exist_home_sales_se)
```

数据示例

macro_usa_exist_home_sales_se.name

```python
usa_exist_home_sales
```

macro_usa_exist_home_sales_se: pandas.Series

```
1970-01-01    160
1970-02-01    153
1970-03-01    146
1970-04-01    137
1970-05-01    151
             ... 
2019-09-19    550
2019-10-22    536
2019-11-21    544
2019-12-19    535
2020-01-22      0
```

##### 美国FHFA房价指数月率报告

接口: macro_usa_house_price_index

目标地址: https://datacenter.jin10.com/reportType/dc_usa_house_price_index

描述: 获取美国FHFA房价指数月率报告, 数据区间从19910301-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```python
import PPshare as pp
macro_usa_house_price_index_se = PP.macro_usa_house_price_index()
print(macro_usa_house_price_index_se.name)
print(macro_usa_house_price_index_se)
```

数据示例

macro_usa_house_price_index_se.name

```
usa_house_price_index
```

macro_usa_house_price_index_se: pandas.Series

```
1991-03-01    0.5
1991-04-01      0
1991-05-01   -0.2
1991-06-01    0.1
1991-07-01    0.1
             ... 
2019-09-24    0.4
2019-10-23    0.2
2019-11-26    0.6
2019-12-31    0.2
2020-01-22      0
```

##### 美国S&P/CS20座大城市房价指数年率报告

接口: macro_usa_spcs20

目标地址: https://datacenter.jin10.com/reportType/dc_usa_spcs20

描述: 获取美国S&P/CS20座大城市房价指数年率报告, 数据区间从20010201-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as pp
macro_usa_spcs20_se = pp.macro_usa_spcs20()
print(macro_usa_spcs20_se.name)
print(macro_usa_spcs20_se)
```

数据示例

macro_usa_spcs20_se.name

```
usa_spcs20
```

macro_usa_spcs20_se: pandas.Series

```
2001-02-01    12.4
2001-03-01    12.2
2001-04-01      12
2001-05-01    11.4
2001-06-01    10.5
              ... 
2019-09-24       2
2019-10-29       2
2019-11-26     2.1
2019-12-31     2.2
2020-01-28       0
```

##### 美国成屋签约销售指数月率报告

接口: macro_usa_pending_home_sales

目标地址: https://datacenter.jin10.com/reportType/dc_usa_pending_home_sales

描述: 获取美国成屋签约销售指数月率报告, 数据区间从20010301-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```python
import PPshare as pp
macro_usa_pending_home_sales_se = PP.macro_usa_pending_home_sales()
print(macro_usa_pending_home_sales_se.name)
print(macro_usa_pending_home_sales_se)
```

数据示例

macro_usa_pending_home_sales_se.name

```
usa_pending_home_sales
```

macro_usa_pending_home_sales_se: pandas.Series

```
2001-03-01     5.1
2001-04-01    -4.7
2001-05-01    -2.9
2001-06-01     2.7
2001-07-01    -3.4
              ... 
2019-09-26     1.4
2019-10-29     1.4
2019-11-27    -1.3
2019-12-30     1.2
2020-01-29       0
```

### 领先指标

#### 美国谘商会消费者信心指数报告

接口: macro_usa_cb_consumer_confidence

目标地址: https://cdn.jin10.com/reports/dc_usa_cb_consumer_confidence_all.js?v=1578576859

描述: 获取美国谘商会消费者信心指数报告, 数据区间从19700101-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_usa_cb_consumer_confidence_se = PP.macro_usa_cb_consumer_confidence()
print(macro_usa_cb_consumer_confidence_se.name)
print(macro_usa_cb_consumer_confidence_se)
```

数据示例

macro_usa_cb_consumer_confidence_se.name

```
cb_consumer_confidence
```

macro_usa_cb_consumer_confidence_se: pandas.Series

```
1970-01-01      126
1970-02-01      126
1970-03-01    101.7
1970-04-01    101.7
1970-05-01       98
              ...  
2019-09-24    126.3
2019-10-29    126.1
2019-11-26    126.8
2019-12-31    126.5
2020-01-28        0
```

#### 美国NFIB小型企业信心指数报告

接口: macro_usa_nfib_small_business

目标地址: https://cdn.jin10.com/reports/dc_usa_nfib_small_business_all.js?v=1578576631

描述: 获取美国NFIB小型企业信心指数报告, 数据区间从19750201-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_usa_nfib_small_business_se = PP.macro_usa_nfib_small_business()
print(macro_usa_nfib_small_business_se.name)
print(macro_usa_nfib_small_business_se)
```

数据示例

macro_usa_nfib_small_business_se.name

```
nfib_small_business
```

macro_usa_nfib_small_business_se: pandas.Series

```
1975-02-01     86.67
1975-05-01     95.16
1975-08-01     99.36
1975-11-01    100.37
1976-02-01    102.01
               ...  
2019-09-10     103.1
2019-10-08     101.8
2019-11-12     102.4
2019-12-10     104.7
2020-01-14         0
```

#### 美国密歇根大学消费者信心指数初值报告

接口: macro_usa_michigan_consumer_sentiment

目标地址: https://cdn.jin10.com/reports/dc_usa_michigan_consumer_sentiment_all.js?v=1578576228

描述: 获取美国密歇根大学消费者信心指数初值报告, 数据区间从19700301-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_usa_michigan_consumer_sentiment_se = PP.macro_usa_michigan_consumer_sentiment()
print(macro_usa_michigan_consumer_sentiment_se.name)
print(macro_usa_michigan_consumer_sentiment_se)
```

数据示例

macro_usa_michigan_consumer_sentiment_se.name

```
michigan_consumer_sentiment
```

macro_usa_michigan_consumer_sentiment_se: pandas.Series

```
1970-03-01    78.1
1970-06-01    75.4
1970-09-01    77.6
1970-12-01    72.4
1971-03-01    78.1
              ... 
2019-11-08    95.5
2019-11-22    96.8
2019-12-06    96.8
2019-12-20    99.3
2020-01-17       0
```

### 其他

#### 美国EIA原油库存报告

接口: macro_usa_eia_crude_rate

目标地址: https://cdn.jin10.com/reports/dc_usa_michigan_consumer_sentiment_all.js?v=1578576228

描述: 获取美国EIA原油库存报告, 数据区间从19950801-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_usa_eia_crude_rate_se = PP.macro_usa_eia_crude_rate()
print(macro_usa_eia_crude_rate_se.name)
print(macro_usa_eia_crude_rate_se)
```

数据示例

macro_usa_eia_crude_rate_se.name

```
eia_crude_rate
```

macro_usa_eia_crude_rate_se: pandas.Series

```
1982-09-01     -262.6
1982-10-01         -8
1982-11-01      -41.3
1982-12-01      -87.6
1983-01-01       51.3
               ...   
2019-12-27          0
2019-12-28     -547.4
2020-01-04    -1146.3
2020-01-08      116.4
2020-01-15          0
```

#### 美国初请失业金人数报告

接口: macro_usa_initial_jobless

目标地址: https://cdn.jin10.com/reports/dc_usa_michigan_consumer_sentiment_all.js?v=1578576228

描述: 获取美国初请失业金人数报告, 数据区间从19700101-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_usa_initial_jobless_se = PP.macro_usa_initial_jobless()
print(macro_usa_initial_jobless_se.name)
print(macro_usa_initial_jobless_se)
```

数据示例

macro_usa_initial_jobless_se.name

```
initial_jobless
```

macro_usa_initial_jobless_se: pandas.Series

```
1970-01-01    22.1087
1970-02-01    24.9318
1970-03-01      25.85
1970-04-01    26.8682
1970-05-01    33.1591
               ...   
2019-12-19       23.5
2019-12-26       22.4
2020-01-02       22.3
2020-01-09       21.4
2020-01-16          0
```

#### 美国原油产量报告

接口: macro_usa_crude_inner

目标地址: https://cdn.jin10.com/reports/dc_usa_michigan_consumer_sentiment_all.js?v=1578576228

描述: 获取美国原油产量报告, 数据区间从19830107-至今, 每周三公布(美国节假日除外), 美国能源信息署(EIA)

限量: 单次返回所有历史数据

报告内容: 美国能源信息署（EIA）在北京时间每周三晚公布EIA报告，除了公布美国原油库存、汽油库存等数据外，报告还包含美国上周国内原油产量的数据。
报告组成：美国国内原油产量、美国本土48州原油产量和美国阿拉斯加州原油产量。
数据关系：美国国内原油产量=美国本土48州原油产量+美国阿拉斯加州原油产量
单位均为万桶/日。

数据解读: 该数据反映了美国原油供应侧的情况，理论而言，当美国国内原油产量录得增加，通常导致油价下跌；当产量减少，则通常导致油价上扬。

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称                        | 类型  | 默认显示 | 描述      |
| :-------------------------- | :---- | :------- | :-------- |
| 日期                        | str   | Y        | 日期-索引 |
| 美国国内原油总量_产量       | float | Y        | –         |
| 美国国内原油总量_变化       | float | Y        | –         |
| 美国本土48州原油产量_产量   | float | Y        | –         |
| 美国本土48州原油产量_变化   | float | Y        | –         |
| 美国阿拉斯加州原油产量_产量 | float | Y        | –         |
| 美国阿拉斯加州原油产量_变化 | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_usa_crude_inner_df = PP.macro_usa_crude_inner()
print(macro_usa_crude_inner_df)
```

数据示例

```
            美国国内原油总量_产量  美国国内原油总量_变化  ...  美国阿拉斯加州原油产量_产量  美国阿拉斯加州原油产量_变化
2020-04-10       1230.0        -10.0  ...            47.7            -0.4
2020-04-03       1240.0        -60.0  ...            48.1             0.6
2020-03-27       1300.0          0.0  ...            47.5             1.6
2020-03-20       1300.0        -10.0  ...            45.9            -1.9
2020-03-13       1310.0         10.0  ...            47.8             0.5
                 ...          ...  ...             ...             ...
1983-02-04        866.0          2.6  ...             0.0             0.0
1983-01-28        863.4          0.0  ...             0.0             0.0
1983-01-21        863.4          0.0  ...             0.0             0.0
1983-01-14        863.4          0.0  ...             0.0             0.0
1983-01-07        863.4          NaN  ...             0.0             NaN
```

## 欧元区宏观

### 国民经济运行状况

#### 经济状况

##### 欧元区季度GDP年率报告

接口: macro_euro_gdp_yoy

目标地址: https://datacenter.jin10.com/reportType/dc_eurozone_gdp_yoy

描述: 获取欧元区季度GDP年率报告, 数据区间从20131114-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_euro_gdp_yoy_se = PP.macro_euro_gdp_yoy()
print(macro_euro_gdp_yoy_se.name)
print(macro_euro_gdp_yoy_se)
```

数据示例

macro_euro_gdp_yoy_se.name

```
gdp_yoy
```

macro_euro_gdp_yoy_se: pandas.Series

```
2013-11-14   -0.4
2013-12-04   -0.4
2014-01-10   -0.3
2014-02-14    0.5
2014-03-05    0.5
             ... 
2019-08-14    1.3
2019-09-06    1.2
2019-10-31    1.1
2019-11-14    1.2
2019-12-05    1.2
```

#### 物价水平

##### 欧元区CPI月率报告

接口: macro_euro_cpi_mom

目标地址: https://datacenter.jin10.com/reportType/dc_eurozone_cpi_mom

描述: 获取欧元区CPI月率报告, 数据区间从19900301-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_euro_cpi_mom_se = PP.macro_euro_cpi_mom()
print(macro_euro_cpi_mom_se.name)
print(macro_euro_cpi_mom_se)
```

数据示例

macro_euro_cpi_mom_se.name

```
cpi_mom
```

macro_euro_cpi_mom_se: pandas.Series

```
1990-03-01     0.4
1990-04-01     0.2
1990-05-01     0.4
1990-06-01     0.2
1990-07-01     0.1
              ... 
2019-09-18     0.1
2019-10-16     0.2
2019-11-15     0.1
2019-12-18    -0.3
2020-01-17       0
```

##### 欧元区CPI年率报告

接口: macro_euro_cpi_yoy

目标地址: https://datacenter.jin10.com/reportType/dc_eurozone_cpi_yoy

描述: 获取欧元区CPI年率报告, 数据区间从19910201-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_euro_cpi_yoy_se = PP.macro_euro_cpi_yoy()
print(macro_euro_cpi_yoy_se.name)
print(macro_euro_cpi_yoy_se)
```

数据示例

macro_euro_cpi_yoy_se.name

```
cpi_yoy
```

macro_euro_cpi_yoy_se: pandas.Series

```
1991-02-01    3.9
1991-03-01    4.1
1991-04-01    3.9
1991-05-01    3.9
1991-06-01    4.1
             ... 
2019-11-29    0.7
2019-12-18      1
2020-01-07    1.3
2020-01-17      0
2020-01-31      0
```

##### 欧元区PPI月率报告

接口: macro_euro_ppi_mom

目标地址: https://datacenter.jin10.com/reportType/dc_eurozone_ppi_mom

描述: 获取欧元区PPI月率报告, 数据区间从19810301-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_euro_ppi_mom_se = PP.macro_euro_ppi_mom()
print(macro_euro_ppi_mom_se.name)
print(macro_euro_ppi_mom_se)
```

数据示例

macro_euro_ppi_mom_se.name

```
ppi_mom
```

macro_euro_ppi_mom_se: pandas.Series

```
1981-03-01       1
1981-04-01     0.7
1981-05-01     1.5
1981-06-01     0.7
1981-07-01     0.6
              ... 
2019-09-03     0.1
2019-10-03    -0.5
2019-11-05     0.1
2019-12-03     0.1
2020-01-06     0.2
```

##### 欧元区零售销售月率报告

接口: macro_euro_retail_sales_mom

目标地址: https://datacenter.jin10.com/reportType/dc_eurozone_retail_sales_mom

描述: 获取欧元区零售销售月率报告, 数据区间从20000301-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_euro_retail_sales_mom_se = PP.macro_euro_retail_sales_mom()
print(macro_euro_retail_sales_mom_se.name)
print(macro_euro_retail_sales_mom_se)
```

数据示例

macro_euro_retail_sales_mom_se.name

```
retail_sales_mom
```

macro_euro_retail_sales_mom_se: pandas.Series

```
2000-03-01     0.7
2000-04-01    -0.3
2000-05-01     0.7
2000-06-01     0.3
2000-07-01     0.1
              ... 
2019-09-04    -0.5
2019-10-03     0.6
2019-11-06    -0.2
2019-12-05    -0.3
2020-01-07       1
```

#### 劳动力市场

##### 欧元区季调后就业人数季率报告

接口: macro_euro_employment_change_qoq

目标地址: https://datacenter.jin10.com/reportType/dc_eurozone_employment_change_qoq

描述: 获取欧元区季调后就业人数季率报告, 数据区间从20083017-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_euro_employment_change_qoq_se = PP.macro_euro_employment_change_qoq()
print(macro_euro_employment_change_qoq_se.name)
print(macro_euro_employment_change_qoq_se)
```

数据示例

macro_euro_employment_change_qoq_se.name

```
employment_change_qoq
```

macro_euro_employment_change_qoq_se: pandas.Series

```
2008-03-17    0.2
2008-06-13    0.3
2008-09-12    0.2
2008-12-16   -0.1
2009-03-16   -0.4
             ... 
2019-08-14    0.4
2019-09-06    0.2
2019-09-14      0
2019-11-14    0.2
2019-12-05    0.1
```

##### 欧元区失业率报告

接口: macro_euro_unemployment_rate_mom

目标地址: https://datacenter.jin10.com/reportType/dc_eurozone_unemployment_rate_mom

描述: 获取欧元区失业率报告, 数据区间从19980501-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_euro_unemployment_rate_mom_se = PP.macro_euro_unemployment_rate_mom()
print(macro_euro_unemployment_rate_mom_se.name)
print(macro_euro_unemployment_rate_mom_se)
```

数据示例

macro_euro_unemployment_rate_mom_se.name

```
unemployment_rate_mom
```

macro_euro_unemployment_rate_mom_se: pandas.Series

```
1998-05-01    10.6
1998-06-01    10.5
1998-07-01    10.5
1998-08-01    10.4
1998-09-01    10.4
              ... 
2019-09-30     7.5
2019-10-31     7.6
2019-11-29     7.5
2020-01-09     7.5
2020-01-30       0
```

### 贸易状况

#### 欧元区未季调贸易帐报告

接口: macro_euro_trade_balance

目标地址: https://datacenter.jin10.com/reportType/dc_eurozone_trade_balance_mom

描述: 获取欧元区未季调贸易帐报告, 数据区间从19990201-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_euro_trade_balance_se = PP.macro_euro_trade_balance()
print(macro_euro_trade_balance_se.name)
print(macro_euro_trade_balance_se)
```

数据示例

macro_euro_trade_balance_se.name

```
trade_balance
```

macro_euro_trade_balance_se: pandas.Series

```
1999-02-01    -27
1999-03-01     19
1999-04-01     27
1999-05-01     21
1999-06-01     -9
             ... 
2019-09-13    248
2019-10-16    147
2019-11-15    187
2019-12-17    280
2020-01-15      0
```

#### 欧元区经常帐报告

接口: macro_euro_current_account_mom

目标地址: https://datacenter.jin10.com/reportType/dc_eurozone_current_account_mom

描述: 获取欧元区经常帐报告, 数据区间从20080221-至今, 前两个值需要去掉

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_euro_current_account_mom_se = PP.macro_euro_current_account_mom()
print(macro_euro_current_account_mom_se.name)
print(macro_euro_current_account_mom_se)
```

数据示例

macro_euro_current_account_mom_se.name

```
current_account_mom
```

macro_euro_current_account_mom_se: pandas.Series

```
1999-02-01       0
2003-07-01       7
2008-02-21    -103
2008-03-26    -106
2008-04-24      43
              ... 
2019-09-19     216
2019-10-18     285
2019-11-19     282
2019-12-20     324
2020-01-17       0
```

### 产业指标

#### 欧元区工业产出月率报告

接口: macro_euro_industrial_production_mom

目标地址: https://datacenter.jin10.com/reportType/dc_eurozone_industrial_production_mom

描述: 获取欧元区工业产出月率报告, 数据区间从19910301-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_euro_industrial_production_mom_se = PP.macro_euro_industrial_production_mom()
print(macro_euro_industrial_production_mom_se.name)
print(macro_euro_industrial_production_mom_se)
```

数据示例

macro_euro_industrial_production_mom_se.name

```
industrial_production_mom
```

macro_euro_industrial_production_mom_se: pandas.Series

```
1991-03-01    -1.1
1991-04-01      -1
1991-05-01    -0.5
1991-06-01    -0.1
1991-07-01     1.9
              ... 
2019-09-12    -0.4
2019-10-14     0.4
2019-11-13    -0.1
2019-12-12    -0.5
2020-01-15       0
```

#### 欧元区制造业PMI初值报告

接口: macro_euro_manufacturing_pmi

目标地址: https://datacenter.jin10.com/reportType/dc_eurozone_manufacturing_pmi

描述: 获取欧元区制造业PMI初值报告, 数据区间从20080222-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_euro_manufacturing_pmi_se = PP.macro_euro_manufacturing_pmi()
print(macro_euro_manufacturing_pmi_se.name)
print(macro_euro_manufacturing_pmi_se)
```

数据示例

macro_euro_manufacturing_pmi_se.name

```
manufacturing_pmi
```

macro_euro_manufacturing_pmi_se: pandas.Series

```
2008-02-22    52.3
2008-03-03    52.3
2008-03-20      52
2008-04-01      52
2008-04-23    50.8
              ... 
2019-11-22    46.6
2019-12-02    46.9
2019-12-16    45.9
2020-01-02    46.3
2020-01-24       0
```

#### 欧元区服务业PMI终值报告

接口: macro_euro_services_pmi

目标地址: https://datacenter.jin10.com/reportType/dc_eurozone_services_pmi

描述: 获取欧元区服务业PMI终值报告, 数据区间从20080222-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_euro_services_pmi_se = PP.macro_euro_services_pmi()
print(macro_euro_services_pmi_se.name)
print(macro_euro_services_pmi_se)
```

数据示例

macro_euro_services_pmi_se.name

```
services_pmi
```

macro_euro_services_pmi_se: pandas.Series

```
2008-02-22    52.3
2008-03-05    51.7
2008-04-03    51.6
2008-04-23    51.8
2008-05-06      52
              ... 
2019-11-22    52.2
2019-12-04    51.9
2019-12-16    52.4
2020-01-06    52.8
2020-01-24       0
```

### 领先指标

#### 欧元区ZEW经济景气指数报告

接口: macro_euro_zew_economic_sentiment

目标地址: https://datacenter.jin10.com/reportType/dc_eurozone_zew_economic_sentiment

描述: 获取欧元区ZEW经济景气指数报告, 数据区间从20080212-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_euro_zew_economic_sentiment_se = PP.macro_euro_zew_economic_sentiment()
print(macro_euro_zew_economic_sentiment_se.name)
print(macro_euro_zew_economic_sentiment_se)
```

数据示例

macro_euro_zew_economic_sentiment_se.name

```
zew_economic_sentiment
```

macro_euro_zew_economic_sentiment_se: pandas.Series

```
2008-02-12    -41.4
2008-03-11      -35
2008-04-15    -44.8
2008-05-20    -43.6
2008-06-17    -52.7
              ...  
2019-09-17    -22.4
2019-10-15    -23.5
2019-11-12     -1.0
2019-12-10     11.2
2020-01-21        0
```

#### 欧元区Sentix投资者信心指数报告

接口: macro_euro_sentix_investor_confidence

目标地址: https://datacenter.jin10.com/reportType/dc_eurozone_sentix_investor_confidence

描述: 获取欧元区Sentix投资者信心指数报告, 数据区间从20020801-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_euro_sentix_investor_confidence_se = PP.macro_euro_sentix_investor_confidence()
print(macro_euro_sentix_investor_confidence_se.name)
print(macro_euro_sentix_investor_confidence_se)
```

数据示例

macro_euro_sentix_investor_confidence_se.name

```
sentix_investor_confidence
```

macro_euro_sentix_investor_confidence_se: pandas.Series

```
2002-08-01       13
2002-10-01     -8.5
2003-02-01    -21.8
2003-03-01    -22.8
2003-04-01    -19.4
              ...  
2019-09-09    -11.1
2019-10-07    -16.8
2019-11-04     -4.5
2019-12-09      0.7
2020-01-06      7.6
```

## 重要机构

### 全球最大黄金ETF—SPDR Gold Trust持仓报告

#### 总库存

接口: macro_cons_gold_volume

目标地址: https://datacenter.jin10.com/reportType/dc_eurozone_sentix_investor_confidence

描述: 获取全球最大黄金ETF—SPDR Gold Trust持仓报告-总库存(吨), 数据区间从20041118-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述       |
| :--- | :---- | :------- | :--------- |
| 日期 | str   | Y        | 日期-索引  |
| 值   | float | Y        | 总库存(吨) |

接口示例

```
import PPshare as PP
macro_cons_gold_volume_se = PP.macro_cons_gold_volume()
print(macro_cons_gold_volume_se.name)
print(macro_cons_gold_volume_se)
```

数据示例

macro_euro_sentix_investor_confidence_se.name

```
gold_volume
```

macro_euro_sentix_investor_confidence_se: pandas.Series

```
2004-11-18      8.09
2004-11-19     57.85
2004-11-22     87.09
2004-11-23     87.09
2004-11-24     96.42
               ...
2019-10-20    924.64
2019-10-21    924.64
2019-10-22    919.66
2019-10-23    918.48
2019-10-24    918.48
```

#### 增持-减持

接口: macro_cons_gold_change

目标地址: https://datacenter.jin10.com/reportType/dc_eurozone_sentix_investor_confidence

描述: 获取全球最大黄金ETF—SPDR Gold Trust持仓报告-增持-减持(吨), 数据区间从20041118-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述          |
| :--- | :---- | :------- | :------------ |
| 日期 | str   | Y        | 日期-索引     |
| 值   | float | Y        | 增持-减持(吨) |

接口示例

```
import PPshare as PP
macro_cons_gold_change_se = PP.macro_cons_gold_change()
print(macro_cons_gold_change_se.name)
print(macro_cons_gold_change_se)
```

数据示例

macro_cons_gold_change_se.name

```
gold_change
```

macro_cons_gold_change_se: pandas.Series

```
2004-11-18        0
2004-11-19    49.76
2004-11-22    29.24
2004-11-23     0.00
2004-11-24     9.33
              ...
2019-10-20     0.00
2019-10-21     0.00
2019-10-22    -4.98
2019-10-23    -1.18
2019-10-24     0.00
```

#### 总价值

接口: macro_cons_gold_amount

目标地址: https://datacenter.jin10.com/reportType/dc_eurozone_sentix_investor_confidence

描述: 获取全球最大黄金ETF—SPDR Gold Trust持仓报告-总价值(美元), 数据区间从20041118-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述         |
| :--- | :---- | :------- | :----------- |
| 日期 | str   | Y        | 日期-索引    |
| 值   | float | Y        | 总价值(美元) |

接口示例

```
import PPshare as PP
macro_cons_gold_amount_se = PP.macro_cons_gold_amount()
print(macro_cons_gold_amount_se.name)
print(macro_cons_gold_amount_se)
```

数据示例

macro_cons_gold_amount_se.name

```
gold_amount
```

macro_cons_gold_amount_se: pandas.Series

```
2004-11-18      114920000.00
2004-11-19      828806907.20
2004-11-22     1253785205.50
2004-11-23     1254751438.19
2004-11-24     1390568824.08
                   ...
2019-10-20    44286078486.23
2019-10-21    44333677232.68
2019-10-22    43907962483.56
2019-10-23    44120217405.82
2019-10-24    44120217405.82
```

### 全球最大白银ETF–iShares Silver Trust持仓报告

#### 总库存

接口: macro_cons_silver_volume

目标地址: https://datacenter.jin10.com/reportType/dc_eurozone_sentix_investor_confidence

描述: 获取全球最大白银ETF–iShares Silver Trust持仓报告-总库存(吨), 数据区间从20060429-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述       |
| :--- | :---- | :------- | :--------- |
| 日期 | str   | Y        | 日期-索引  |
| 值   | float | Y        | 总库存(吨) |

接口示例

```
import PPshare as PP
macro_cons_silver_volume_se = PP.macro_cons_silver_volume()
print(macro_cons_silver_volume_se.name)
print(macro_cons_silver_volume_se)
```

数据示例

macro_cons_silver_volume_se.name

```
silver_volume
```

macro_cons_silver_volume_se: pandas.Series

```
2006-04-29      653.17
2006-05-02      653.17
2006-05-03      995.28
2006-05-04     1197.43
2006-05-05     1306.29
                ...
2019-10-17    11847.91
2019-10-18    11847.91
2019-10-21    11813.02
2019-10-22    11751.96
2019-10-23    11751.96
```

#### 增持-减持

接口: macro_cons_silver_change

目标地址: https://datacenter.jin10.com/reportType/dc_eurozone_sentix_investor_confidence

描述: 获取全球最大白银ETF–iShares Silver Trust持仓报告-增持-减持(吨), 数据区间从20060429-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述          |
| :--- | :---- | :------- | :------------ |
| 日期 | str   | Y        | 日期-索引     |
| 值   | float | Y        | 增持-减持(吨) |

接口示例

```
import PPshare as PP
macro_cons_silver_change_se = PP.macro_cons_silver_change()
print(macro_cons_silver_change_se.name)
print(macro_cons_silver_change_se)
```

数据示例

macro_cons_silver_change_se.name

```
silver_change
```

macro_cons_silver_change_se: pandas.Series

```
2006-04-29          0
2006-05-02       0.00
2006-05-03     342.11
2006-05-04     202.15
2006-05-05     108.86
               ...   
2020-01-06       0.00
2020-01-07     -37.76
2020-01-08       0.00
2020-01-09    -101.66
2020-01-10       0.00
```

#### 总价值

接口: macro_cons_silver_amount

目标地址: https://datacenter.jin10.com/reportType/dc_eurozone_sentix_investor_confidence

描述: 获取全球最大白银ETF–iShares Silver Trust持仓报告-总价值(美元), 数据区间从20060429-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述         |
| :--- | :---- | :------- | :----------- |
| 日期 | str   | Y        | 日期-索引    |
| 值   | float | Y        | 总价值(美元) |

接口示例

```
import PPshare as PP
macro_cons_silver_amount_se = PP.macro_cons_silver_amount()
print(macro_cons_silver_amount_se.name)
print(macro_cons_silver_amount_se)
```

数据示例

macro_cons_silver_amount_se.name

```
silver_amount
```

macro_cons_silver_amount_se: pandas.Series

```
2006-04-29    263651152
2006-05-02    263651152
2006-05-03    445408550
2006-05-04    555123947
2006-05-05    574713264
                ...
2019-10-17     Show All
2019-10-18     Show All
2019-10-21     Show All
2019-10-22     Show All
2019-10-23     Show All
```

### 欧佩克报告

#### 欧佩克报告-变动

接口: macro_cons_opec_near_change, 此接口由于数据更新的缘故只能提取到 **20190613** 前数据, 可以自行使用 **macro_cons_opec_month** 提取后计算

目标地址: https://datacenter.jin10.com/reportType/dc_eurozone_sentix_investor_confidence

描述: 获取欧佩克报告, 数据区间从20170118-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_cons_opec_near_change_df = PP.macro_cons_opec_near_change()
print(macro_cons_opec_near_change_df)
```

数据示例

macro_cons_opec_near_change_df

```
            阿尔及利亚   安哥拉   厄瓜多尔    加蓬     伊朗     伊拉克    科威特    利比亚   尼日利亚  \
2017-01-18  -0.87  3.56  -0.25 -0.87   0.95    4.26   0.20   3.13 -11.35   
2017-02-13  -4.17 -2.32  -1.67 -1.00   5.02  -16.57 -14.12   6.47  10.18   
2017-03-14  -0.02 -1.82  -0.44 -0.69   3.61   -6.20  -0.93  -1.11   5.80   
2017-04-12   0.45 -1.87  -0.28  0.19  -2.87   -0.85  -0.95  -6.08  -2.98   
2017-05-11  -0.75  9.71  -0.06  0.88  -3.47   -3.91   0.03  -6.16   5.08   
           ...   ...    ...   ...    ...     ...    ...    ...    ...   
2018-11-13  -0.40  2.20  -0.30  0.30 -15.60  465.30  -3.30   6.00  -1.70   
2018-12-12  -0.50  0.30   0.10 -1.10 -38.00   -2.30   4.50  -1.10  -3.00   
2019-03-14   0.20  2.20   0.50  0.70   1.20   -7.00  -1.40   2.30   1.00   
2019-04-10  -0.70  0.70  52.40  0.90  -2.80  -12.60  -0.10  19.60   1.10   
2019-06-13   0.60  7.40  -0.10  2.30 -22.70    9.40   1.30  -0.30  -9.20   
               沙特    阿联酋   委内瑞拉  欧佩克产量  
2017-01-18 -14.93  -0.63  -4.52 -22.09  
2017-02-13 -49.62 -15.93  -3.05 -89.02  
2017-03-14  -6.81  -3.69  -1.60 -13.95  
2017-04-12   4.16  -3.27  -2.59 -15.27  
2017-05-11   4.92  -6.23  -2.60  -1.82  
           ...    ...    ...    ...  
2018-11-13  12.70  14.20  -4.00  12.70  
2018-12-12  37.70   7.10  -5.20  -1.10  
2019-03-14  -8.60  -0.40 -14.20 -22.10  
2019-04-10 -32.40  -0.90 -28.90 -53.40  
2019-06-13  -7.60   0.30  -3.50 -23.60  
```

#### 欧佩克报告-月度

接口: macro_cons_opec_month

目标地址: https://datacenter.jin10.com/reportType/dc_eurozone_sentix_investor_confidence

描述: 获取欧佩克报告, 数据区间从20170118-至今

限量: 单次返回所有历史数据, 以网页数据为准.

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| –    | –    | –    | –    |

输出参数

| 名称       | 类型  | 默认显示 | 描述      |
| :--------- | :---- | :------- | :-------- |
| 日期       | str   | Y        | 日期-索引 |
| 阿尔及利亚 | float | Y        | –         |
| 安哥拉     | float | Y        | –         |
| 厄瓜多尔   | float | Y        | –         |
| 加蓬       | float | Y        | –         |
| 伊朗       | float | Y        | –         |
| 伊拉克     | float | Y        | –         |
| 科威特     | float | Y        | –         |
| 利比亚     | float | Y        | –         |
| 尼日利亚   | float | Y        | –         |
| 沙特       | float | Y        | –         |
| 阿联酋     | float | Y        | –         |
| 委内瑞拉   | float | Y        | –         |
| 欧佩克产量 | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_cons_opec_month_df = PP.macro_cons_opec_month()
print(macro_cons_opec_month_df)
```

数据示例

macro_cons_opec_month_df

```
日期       阿尔及利亚    安哥拉  厄瓜多尔    加蓬     伊朗    伊拉克    科威特    利比亚   尼日利亚      沙特  \
2016/12  108.7  167.4  54.4  20.9  372.5  464.2  285.9     61  147.4  1044.3   
2017/01  105.3  165.8    53  20.3    378  447.5  272.2   67.8  153.3   980.9   
2017/02  105.7  163.9  52.9  19.8  381.9  441.4  271.2   68.1  156.4   995.2   
2017/03  105.1  159.9  52.5  20.2  379.2  442.5  270.2   61.2  145.6   990.5   
2017/04  105.6  166.7  52.6  20.5  379.2  438.1  270.5   55.2  149.6   993.4   
        ...    ...   ...   ...    ...    ...    ...    ...    ...     ...   
2019/08  101.6  138.5  54.3  20.4  219.3  478.1  263.8  107.4    187   985.1   
2019/09    102  140.4    55  19.7  216.3  473.2  265.8  116.2  185.1   879.6   
2019/10  101.9  135.8  45.9  20.7  214.7  469.3  264.8  116.6  180.9  1000.1   
2019/11  102.8  128.3  52.8  19.7  210.7  464.1  270.1  118.3  179.4   987.3   
2019/12  101.7  140.8  53.8  22.2  209.2  456.5  270.8  113.9    177   976.2   
日期         阿联酋   委内瑞拉   欧佩克产量  
2016/12    309  203.4  3302.9  
2017/01  295.8  200.7  3202.6  
2017/02  293.3  199.8  3208.6  
2017/03  290.9  198.2    3177  
2017/04  290.6  196.7  3197.4  
        ...    ...     ...  
2019/08  308.2   73.5  2980.9  
2019/09  308.3   64.4  2871.6  
2019/10  310.5   68.7  2975.3  
2019/11  310.8   71.7  2960.6  
2019/12  306.2   71.4  2944.4  
```

### 伦敦金属交易所

#### 持仓报告

接口: macro_euro_lme_holding

目标地址: https://datacenter.jin10.com/reportType/dc_lme_traders_report

描述: 获取伦敦金属交易所(LME)-持仓报告, 数据区间从 20151022-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型 | 默认显示 | 描述                                 |
| :--- | :--- | :------- | :----------------------------------- |
| –    | –    | –        | 不同品种的多头仓位、空头仓位和净仓位 |

接口示例

```
import PPshare as PP
macro_euro_lme_holding_df = PP.macro_euro_lme_holding()
print(macro_euro_lme_holding_df)
```

数据示例

```
               铝-多头仓位     铝-空头仓位      铝-净仓位  ...  锡-多头仓位  锡-空头仓位   锡-净仓位
2015-10-22  327120.00 -304606.00  631726.00  ...    5462 -2129.0  7591.0
2015-10-23  326996.00 -304797.00  631793.00  ...    5339 -2090.0  7429.0
2015-10-26  327814.00 -305974.00  633788.00  ...    5388 -2239.0  7627.0
2015-10-27  331239.00 -305348.00  636587.00  ...    5338 -2289.0  7627.0
2015-10-28  331586.00 -302432.00  634018.00  ...    5264 -2370.0  7634.0
               ...        ...        ...  ...     ...     ...     ...
2020-05-01  737311.18  546268.81  191042.37  ...   12044  8966.0  3078.0
2020-05-07  715146.83  525746.88  189399.95  ...   11919  9101.0  2818.0
2020-05-15  741948.06  552763.07  189184.99  ...   11977  9159.0  2818.0
2020-05-22  726923.87  551171.11  175752.76  ...   11234  8762.0  2472.0
2020-05-29  730646.63  552041.55  178605.08  ...   11648  9110.0  2538.0
```

#### 库存报告

接口: macro_euro_lme_stock

目标地址: https://datacenter.jin10.com/reportType/dc_lme_report

描述: 获取伦敦金属交易所(LME)-库存报告, 数据区间从 20140702-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型 | 默认显示 | 描述                               |
| :--- | :--- | :------- | :--------------------------------- |
| –    | –    | –        | 不同品种的库存、注册仓单和注销仓单 |

接口示例

```
import PPshare as PP
macro_euro_lme_stock_df = PP.macro_euro_lme_stock()
print(macro_euro_lme_stock_df)
```

数据示例

```
               铝-库存   铝-注册仓单   铝-注销仓单    铜-库存  ...  锡-注销仓单    锌-库存  锌-注册仓单  锌-注销仓单
2014-07-02  5066400  2075450  2990950  156775  ...    2470  666775  610175   56600
2014-07-03  5058325  2074950  2983375  157050  ...    2500  665600  610175   55425
2014-07-04  5049225  2074450  2974775  156500  ...    2500  664650  604050   60600
2014-07-07  5038525  2072925  2965600  159350  ...    2500  663650  603950   59700
2014-07-08  5034200  2070925  2963275  158050  ...    2470  663150  603950   59200
             ...      ...      ...     ...  ...     ...     ...     ...     ...
2020-06-01  1496050  1283000   213050  255725  ...     840   99575   80150   19425
2020-06-02  1505550  1295200   210350  254275  ...     910   97850   79650   18200
2020-06-03  1500900  1295200   205700  252375  ...    1005   97800   79650   18150
2020-06-04  1526250  1324400   201850  248275  ...    1030   96275   79475   16800
2020-06-05  1521325  1305725   215600  243750  ...     905   94675   79450   15225
```

### 美国商品期货交易委员会

#### 外汇类非商业持仓报告

接口: macro_usa_cftc_nc_holding

目标地址: https://datacenter.jin10.com/reportType/dc_cftc_nc_report

描述: 获取美国商品期货交易委员会CFTC外汇类非商业持仓报告, 数据区间从 19830107-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型 | 默认显示 | 描述                                 |
| :--- | :--- | :------- | :----------------------------------- |
| –    | –    | –        | 不同品种的多头仓位、空头仓位和净仓位 |

接口示例

```
import PPshare as PP
macro_usa_cftc_nc_holding_df = PP.macro_usa_cftc_nc_holding()
print(macro_usa_cftc_nc_holding_df)
```

数据示例

```
            美元-多头仓位  美元-空头仓位  美元-净仓位  瑞郎-多头仓位  ...  英镑-净仓位  澳元-多头仓位  澳元-空头仓位  澳元-净仓位
1986-01-15        0        0       0        0  ...       0        0        0       0
1986-01-31        0        0       0        0  ...       0        0        0       0
1986-02-14        0        0       0        0  ...       0        0        0       0
1986-02-28        0        0       0        0  ...       0        0        0       0
1986-03-14        0        0       0        0  ...       0        0        0       0
             ...      ...     ...      ...  ...     ...      ...      ...     ...
2020-05-05   324795   350743  -25948    12967  ...  -12005    23541    56996  -33455
2020-05-12   337226   347594  -10368    12624  ...  -13688    23719    59144  -35425
2020-05-19   359429   352735    6694    13678  ...  -18989    25301    64859  -39558
2020-05-26   376764   388231  -11467    13246  ...  -22257    25530    66068  -40538
2020-06-02   385801   394030   -8229    13364  ...  -36044    26571    67362  -40791
```

#### 商品类非商业持仓报告

接口: macro_usa_cftc_c_holding

目标地址: https://datacenter.jin10.com/reportType/dc_cftc_c_report

描述: 获取美国商品期货交易委员会CFTC商品类非商业持仓报告, 数据区间从 19830107-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型 | 默认显示 | 描述                                 |
| :--- | :--- | :------- | :----------------------------------- |
| –    | –    | –        | 不同品种的多头仓位、空头仓位和净仓位 |

接口示例

```
import PPshare as PP
macro_usa_cftc_c_holding_df = PP.macro_usa_cftc_c_holding()
print(macro_usa_cftc_c_holding_df)
```

数据示例

```
            原糖-多头仓位  原糖-空头仓位  原糖-净仓位  大豆-多头仓位  ...  棉花-净仓位  玉米-多头仓位  玉米-空头仓位  玉米-净仓位
1986-01-15        0        0       0    47835  ...       0    45615    16565   29050
1986-01-31        0        0       0    42610  ...       0    32135    34145   -2010
1986-02-14        0        0       0    24555  ...       0    14030    50275  -36245
1986-02-28        0        0       0    22805  ...       0    17735    59835  -42100
1986-03-14        0        0       0    43290  ...       0    18725    58090  -39365
             ...      ...     ...      ...  ...     ...      ...      ...     ...
2020-05-05   177939   145745   32194   173136  ...   -2633   213746   366836 -153090
2020-05-12   186688   142574   44114   188262  ...    1078   210833   388404 -177571
2020-05-19   208295   138673   69622   186743  ...    3320   218328   417374 -199046
2020-05-26   217461   130398   87063   182102  ...    3817   223361   443436 -220075
2020-06-02   221084   127678   93406   178933  ...    9596   235871   455309 -219438
```

#### 外汇类商业持仓报告

接口: macro_usa_cftc_merchant_currency_holding

目标地址: https://datacenter.jin10.com/reportType/dc_cftc_merchant_currency

描述: 获取美国商品期货交易委员会CFTC外汇类商业持仓报告, 数据区间从 19860115-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型 | 默认显示 | 描述                                 |
| :--- | :--- | :------- | :----------------------------------- |
| –    | –    | –        | 不同品种的多头仓位、空头仓位和净仓位 |

接口示例

```
import PPshare as PP
macro_usa_cftc_merchant_currency_holding_df = PP.macro_usa_cftc_merchant_currency_holding()
print(macro_usa_cftc_merchant_currency_holding_df)
```

数据示例

```
            美元-多头仓位  美元-空头仓位  美元-净仓位  瑞郎-多头仓位  ...  英镑-净仓位  澳元-多头仓位  澳元-空头仓位  澳元-净仓位
1986-01-15        0        0       0        0  ...       0        0        0       0
1986-01-31        0        0       0        0  ...       0        0        0       0
1986-02-14        0        0       0        0  ...       0        0        0       0
1986-02-28        0        0       0        0  ...       0        0        0       0
1986-03-14        0        0       0        0  ...       0        0        0       0
             ...      ...     ...      ...  ...     ...      ...      ...     ...
2020-05-05   761167   740678   20489    12783  ...   23207    90061    41987   48074
2020-05-12   764765   764586     179    16793  ...   28146    89686    39723   49963
2020-05-19   761649   773386  -11737    14422  ...   33299    91226    39980   51246
2020-05-26   790831   792542   -1711    14593  ...   35289    94516    40279   54237
2020-06-02   810672   794088   16584    14432  ...   44403    91638    37786   53852
```

#### 商品类商业持仓报告

接口: macro_usa_cftc_merchant_goods_holding

目标地址: https://datacenter.jin10.com/reportType/dc_cftc_merchant_goods

描述: 获取美国商品期货交易委员会CFTC商品类商业持仓报告, 数据区间从 19860115-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型 | 默认显示 | 描述                                 |
| :--- | :--- | :------- | :----------------------------------- |
| –    | –    | –        | 不同品种的多头仓位、空头仓位和净仓位 |

接口示例

```
import PPshare as PP
macro_usa_cftc_merchant_goods_holding_df = PP.macro_usa_cftc_merchant_goods_holding()
print(macro_usa_cftc_merchant_goods_holding_df)
```

数据示例

```python
原糖-多头仓位  原糖-空头仓位  原糖-净仓位  大豆-多头仓位  ...  棉花-净仓位  玉米-多头仓位  玉米-空头仓位  玉米-净仓位
1986-01-15        0        0       0   117120  ...       0   307790   307815     -25
1986-01-31        0        0       0   122430  ...       0   323200   247390   75810
1986-02-14        0        0       0   130140  ...       0   303885   205150   98735
1986-02-28        0        0       0   145015  ...       0   288625   204725   83900
1986-03-14        0        0       0   125300  ...       0   276865   220480   56385
             ...      ...     ...      ...  ...     ...      ...      ...     ...
2020-05-05   581116   619230  -38114   402631  ...    2543   749637   613914  135723
2020-05-12   586013   638394  -52381   423150  ...   -1981   758783   603070  155713
2020-05-19   588614   670244  -81630   431829  ...   -5068   764876   593689  171187
2020-05-26   589614   686994  -97380   440560  ...   -4773   773465   589063  184402
2020-06-02   593359   695146 -101787   446474  ...  -10899   787667   608847  178820
```

# PPshare 能源数据

## 碳排放权

接口: energy_carbon

目标地址: https://www.bjets.com.cn/jyxx/

描述: 获取北京市碳排放权电子交易平台-北京市碳排放权公开交易行情

限量: 全部历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| –    | –    | –    | –    |

输出参数

| 名称            | 类型  | 默认显示 | 描述     |
| :-------------- | :---- | :------- | :------- |
| 日期            | str   | –        |          |
| 成交量(吨)      | float | –        | 注意单位 |
| 成交均价(元/吨) | float | –        | 注意单位 |
| 成交额(元)      | str   | –        | 注意单位 |

接口示例

```
import PPshare as PP
energy_carbon_df = PP.energy_carbon()
print(energy_carbon_df)
```

数据示例

```
              日期  成交量(吨)  成交均价(元/吨)             成交额(元)
0     2019-12-13       1      60.00         60.00（BEA）
1     2019-12-12    9215      74.66    687,957.00（BEA）
2     2019-12-11   14315      76.48  1,094,789.50（BEA）
3     2019-12-10     780      75.38     58,800.00（BEA）
4     2019-12-03    9500      72.11    685,000.00(BEA)
          ...     ...        ...                ...
1065  2013-12-11     100      50.50               5050
1066  2013-12-06     100      50.00               5000
1067  2013-12-05     100      50.20               5020
1068  2013-12-02     300      55.10              16530
1069  2013-11-28     800      51.25              41000
```

## 中国油价

### 汽柴油历史调价信息

接口: energy_oil_hist

目标地址: http://data.eastmoney.com/cjsj/oil_default.html

描述: 获取东方财富-数据中心-中国油价-汽柴油历史调价信息

限量: 全部中国油价的所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| –    | –    | –    | –    |

输出参数

| 名称     | 类型  | 默认显示 | 描述           |
| :------- | :---- | :------- | :------------- |
| 日期     | str   | –        | 价格调整的日期 |
| 汽油价格 | float | –        | 价格(元/吨)    |
| 柴油价格 | float | –        | 价格(元/吨)    |
| 汽油涨幅 | str   | –        | 价格(元/吨)    |
| 柴油涨幅 | str   | –        | 价格(元/吨)    |

接口示例

```
import PPshare as PP
energy_oil_hist_df = PP.energy_oil_hist()
print(energy_oil_hist_df)
```

数据示例

```
             日期    汽油价格    柴油价格    汽油涨幅   柴油涨幅
0     2020/3/19  6090.0  5165.0 -1015.0 -975.0
1     2020/2/19  7105.0  6140.0  -415.0 -400.0
2      2020/2/5  7520.0  6540.0  -420.0 -405.0
3    2019/12/31  7940.0  6945.0   235.0  230.0
4     2019/12/3  7705.0  6715.0    55.0   50.0
..          ...     ...     ...     ...    ...
194  2000/10/20  3435.0  3440.0     NaN    NaN
195   2000/9/20  3615.0  3070.0     NaN    NaN
196   2000/8/18  3405.0  2770.0     NaN    NaN
197   2000/7/15  3135.0  2610.0     NaN    NaN
198    2000/6/6  2935.0  2430.0     NaN    NaN
```

### 地区油价

接口: energy_oil_detail

目标地址: http://data.eastmoney.com/cjsj/oil_default.html

描述: 获取东方财富-数据中心-中国油价-地区油价

限量: 指定调价日的地区油价历史数据

输入参数

| 名称 | 类型 | 必选 | 描述                                                         |
| :--- | :--- | :--- | :----------------------------------------------------------- |
| date | str  | Y    | date=”2020-03-19″; 此日期为调价日期, 通过调用 **energy_oil_hist** 可以获取历史调价日期 |

输出参数

| 名称     | 类型  | 默认显示 | 描述                                |
| :------- | :---- | :------- | :---------------------------------- |
| DIM_DATE | str   | –        | 价格调整的日期                      |
| V_0      | float | –        | 0#柴油价格(单位:元/升)              |
| V_92     | float | –        | 92#汽油价格(单位:元/升)             |
| V_95     | str   | –        | 95#汽油价格(单位:元/升)             |
| V_89     | str   | –        | 89#汽油价格(单位:元/升)             |
| CITYNAME | str   | –        | 地区                                |
| ZDE_0    | str   | –        | 0#柴油涨幅(单位:元/升)              |
| ZDE_92   | str   | –        | 92#汽油涨幅(单位:元/升)             |
| ZDE_95   | str   | –        | 95#汽油涨幅(单位:元/升)             |
| ZDE_89   | str   | –        | 89#汽油涨幅(单位:元/升)             |
| QE_0     | str   | –        | 上一次调整时0#柴油价格(单位:元/升)  |
| QE_92    | str   | –        | 上一次调整时92#汽油价格(单位:元/升) |
| QE_95    | str   | –        | 上一次调整时95#汽油价格(单位:元/升) |
| QE_89    | str   | –        | 上一次调整时89#汽油价格(单位:元/升) |

接口示例

```
import PPshare as PP
energy_oil_detail_df = PP.energy_oil_detail()
print(energy_oil_detail_df)
```

数据示例

```python
     DIM_DATE       V_0      V_92  ...     QE_92     QE_95    QE_89
0   2020/3/19  5.130000  5.490000  ...  6.620000  7.100000  6.20000
1   2020/3/19  5.130000  5.500000  ...  6.650000  7.080000  6.23000
2   2020/3/19  5.100000  5.490000  ...  6.630000  7.070000  6.17000
3   2020/3/19  5.021243  5.411418  ...  6.548571  6.997642  6.14084
4   2020/3/19  5.110000  5.530000  ...  6.670000  7.230000  6.20000
5   2020/3/19  5.170000  5.570000  ...  6.720000  7.260000  6.25000
6   2020/3/19  5.210000  5.630000  ...  6.780000  7.160000  6.40000
7   2020/3/19  5.190000  5.570000  ...  7.770000  8.240000  7.18000
8   2020/3/19  5.090000  5.490000  ...  6.640000  7.020000  6.16000
9   2020/3/19  5.090000  5.500000  ...  6.800000  7.270000      NaN
10  2020/3/19  5.090000  5.510000  ...  7.000000  7.490000      NaN
11  2020/3/19  5.159620  5.474944  ...  6.610000  7.030000  6.20000
12  2020/3/19  5.070000  5.490000  ...  6.630000  7.050000  6.21000
13  2020/3/19  5.140000  5.480000  ...  6.620000  7.110000  6.15000
14  2020/3/19  5.010000  5.430000  ...  6.560000  6.930000  6.19000
15  2020/3/19  5.050000  5.460000  ...  6.610000  7.080000  6.20000
16  2020/3/19  5.090000  5.480000  ...  6.970000  7.480000  6.48000
17  2020/3/19  5.150000  5.480000  ...  6.610000  7.140000  6.19000
18  2020/3/19  5.020000  5.410000  ...  6.550000  6.920000  6.18000
19  2020/3/19  5.080000  5.470000  ...  6.620000  7.040000  6.17000
20  2020/3/19  5.210000  5.560000  ...  6.690000  7.210000  6.27000
21  2020/3/19  5.090000  5.490000  ...  6.640000  7.020000  6.16000
22  2020/3/19  5.670000  6.410000  ...  7.690000  8.130000  7.25000
23  2020/3/19  5.190505  5.648464  ...  7.134902  7.658112  6.57120
24  2020/3/19  5.090000  5.490000  ...  6.630000  7.050000  6.15000
```



