from typing import Any

from ..sql.compiler import Compiled as Compiled, TypeCompiler as TypeCompiler

class Dialect:
    supports_statement_cache: bool
    def create_connect_args(self, url) -> None: ...
    @classmethod
    def type_descriptor(cls, typeobj) -> None: ...
    def initialize(self, connection) -> None: ...
    def get_columns(self, connection, table_name, schema: Any | None = ..., **kw) -> None: ...
    def get_pk_constraint(self, connection, table_name, schema: Any | None = ..., **kw) -> None: ...
    def get_foreign_keys(self, connection, table_name, schema: Any | None = ..., **kw) -> None: ...
    def get_table_names(self, connection, schema: Any | None = ..., **kw) -> None: ...
    def get_temp_table_names(self, connection, schema: Any | None = ..., **kw) -> None: ...
    def get_view_names(self, connection, schema: Any | None = ..., **kw) -> None: ...
    def get_sequence_names(self, connection, schema: Any | None = ..., **kw) -> None: ...
    def get_temp_view_names(self, connection, schema: Any | None = ..., **kw) -> None: ...
    def get_view_definition(self, connection, view_name, schema: Any | None = ..., **kw) -> None: ...
    def get_indexes(self, connection, table_name, schema: Any | None = ..., **kw) -> None: ...
    def get_unique_constraints(self, connection, table_name, schema: Any | None = ..., **kw) -> None: ...
    def get_check_constraints(self, connection, table_name, schema: Any | None = ..., **kw) -> None: ...
    def get_table_comment(self, connection, table_name, schema: Any | None = ..., **kw) -> None: ...
    def normalize_name(self, name) -> None: ...
    def denormalize_name(self, name) -> None: ...
    def has_table(self, connection, table_name, schema: Any | None = ..., **kw) -> None: ...
    def has_index(self, connection, table_name, index_name, schema: Any | None = ...) -> None: ...
    def has_sequence(self, connection, sequence_name, schema: Any | None = ..., **kw) -> None: ...
    def do_begin(self, dbapi_connection) -> None: ...
    def do_rollback(self, dbapi_connection) -> None: ...
    def do_commit(self, dbapi_connection) -> None: ...
    def do_close(self, dbapi_connection) -> None: ...
    def do_set_input_sizes(self, cursor, list_of_tuples, context) -> None: ...
    def create_xid(self) -> None: ...
    def do_savepoint(self, connection, name) -> None: ...
    def do_rollback_to_savepoint(self, connection, name) -> None: ...
    def do_release_savepoint(self, connection, name) -> None: ...
    def do_begin_twophase(self, connection, xid) -> None: ...
    def do_prepare_twophase(self, connection, xid) -> None: ...
    def do_rollback_twophase(self, connection, xid, is_prepared: bool = ..., recover: bool = ...) -> None: ...
    def do_commit_twophase(self, connection, xid, is_prepared: bool = ..., recover: bool = ...) -> None: ...
    def do_recover_twophase(self, connection) -> None: ...
    def do_executemany(self, cursor, statement, parameters, context: Any | None = ...) -> None: ...
    def do_execute(self, cursor, statement, parameters, context: Any | None = ...) -> None: ...
    def do_execute_no_params(self, cursor, statement, parameters, context: Any | None = ...) -> None: ...
    def is_disconnect(self, e, connection, cursor) -> None: ...
    def connect(self, *cargs, **cparams) -> None: ...
    def on_connect_url(self, url): ...
    def on_connect(self) -> None: ...
    def reset_isolation_level(self, dbapi_conn) -> None: ...
    def set_isolation_level(self, dbapi_conn, level) -> None: ...
    def get_isolation_level(self, dbapi_conn) -> None: ...
    def get_default_isolation_level(self, dbapi_conn) -> None: ...
    @classmethod
    def get_dialect_cls(cls, url): ...
    @classmethod
    def load_provisioning(cls) -> None: ...
    @classmethod
    def engine_created(cls, engine) -> None: ...
    def get_driver_connection(self, connection) -> None: ...

class CreateEnginePlugin:
    url: Any
    def __init__(self, url, kwargs) -> None: ...
    def update_url(self, url) -> None: ...
    def handle_dialect_kwargs(self, dialect_cls, dialect_args) -> None: ...
    def handle_pool_kwargs(self, pool_cls, pool_args) -> None: ...
    def engine_created(self, engine) -> None: ...

class ExecutionContext:
    def create_cursor(self) -> None: ...
    def pre_exec(self) -> None: ...
    def get_out_parameter_values(self, out_param_names) -> None: ...
    def post_exec(self) -> None: ...
    def get_result_cursor_strategy(self, result) -> None: ...
    def handle_dbapi_exception(self, e) -> None: ...
    def should_autocommit_text(self, statement) -> None: ...
    def lastrow_has_defaults(self) -> None: ...
    def get_rowcount(self) -> None: ...

class Connectable:
    def connect(self, **kwargs) -> None: ...
    engine: Any
    def execute(self, object_, *multiparams, **params) -> None: ...
    def scalar(self, object_, *multiparams, **params) -> None: ...

class ExceptionContext:
    connection: Any
    engine: Any
    cursor: Any
    statement: Any
    parameters: Any
    original_exception: Any
    sqlalchemy_exception: Any
    chained_exception: Any
    execution_context: Any
    is_disconnect: Any
    invalidate_pool_on_disconnect: bool

class AdaptedConnection:
    @property
    def driver_connection(self): ...
