/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.google.protobuf;

import ai.h2o.com.google.protobuf.Internal;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public final class MapFieldLite<K, V>
extends LinkedHashMap<K, V> {
    private boolean isMutable = true;
    private static final MapFieldLite EMPTY_MAP_FIELD = new MapFieldLite();

    private MapFieldLite() {
    }

    private MapFieldLite(Map<K, V> mapData) {
        super(mapData);
    }

    public static <K, V> MapFieldLite<K, V> emptyMapField() {
        return EMPTY_MAP_FIELD;
    }

    public final void mergeFrom(MapFieldLite<K, V> other) {
        this.ensureMutable();
        if (!other.isEmpty()) {
            this.putAll(other);
        }
    }

    @Override
    public final Set<Map.Entry<K, V>> entrySet() {
        if (this.isEmpty()) {
            return Collections.emptySet();
        }
        return super.entrySet();
    }

    @Override
    public final void clear() {
        this.ensureMutable();
        super.clear();
    }

    @Override
    public final V put(K key, V value) {
        this.ensureMutable();
        Internal.checkNotNull(key);
        Internal.checkNotNull(value);
        return super.put(key, value);
    }

    public final V put(Map.Entry<K, V> entry) {
        return this.put(entry.getKey(), entry.getValue());
    }

    @Override
    public final void putAll(Map<? extends K, ? extends V> m2) {
        this.ensureMutable();
        MapFieldLite.checkForNullKeysAndValues(m2);
        super.putAll(m2);
    }

    @Override
    public final V remove(Object key) {
        this.ensureMutable();
        return super.remove(key);
    }

    private static void checkForNullKeysAndValues(Map<?, ?> m2) {
        for (Object obj : m2.keySet()) {
            Internal.checkNotNull(obj);
            Internal.checkNotNull(m2.get(obj));
        }
    }

    private static boolean equals(Object a2, Object b2) {
        if (a2 instanceof byte[] && b2 instanceof byte[]) {
            return Arrays.equals((byte[])a2, (byte[])b2);
        }
        return a2.equals(b2);
    }

    static <K, V> boolean equals(Map<K, V> a2, Map<K, V> b2) {
        if (a2 == b2) {
            return true;
        }
        if (a2.size() != b2.size()) {
            return false;
        }
        for (Map.Entry<K, V> entry : a2.entrySet()) {
            if (!b2.containsKey(entry.getKey())) {
                return false;
            }
            if (MapFieldLite.equals(entry.getValue(), b2.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean equals(Object object) {
        return object instanceof Map && MapFieldLite.equals(this, (Map)object);
    }

    private static int calculateHashCodeForObject(Object a2) {
        if (a2 instanceof byte[]) {
            return Internal.hashCode((byte[])a2);
        }
        if (a2 instanceof Internal.EnumLite) {
            throw new UnsupportedOperationException();
        }
        return a2.hashCode();
    }

    static <K, V> int calculateHashCodeForMap(Map<K, V> a2) {
        int n2 = 0;
        for (Map.Entry<K, V> entry : a2.entrySet()) {
            n2 += MapFieldLite.calculateHashCodeForObject(entry.getKey()) ^ MapFieldLite.calculateHashCodeForObject(entry.getValue());
        }
        return n2;
    }

    @Override
    public final int hashCode() {
        return MapFieldLite.calculateHashCodeForMap(this);
    }

    private static Object copy(Object object) {
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            return Arrays.copyOf(byArray, byArray.length);
        }
        return object;
    }

    static <K, V> Map<K, V> copy(Map<K, V> map) {
        LinkedHashMap<K, Object> linkedHashMap = new LinkedHashMap<K, Object>();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            linkedHashMap.put(entry.getKey(), MapFieldLite.copy(entry.getValue()));
        }
        return linkedHashMap;
    }

    public final MapFieldLite<K, V> mutableCopy() {
        if (this.isEmpty()) {
            return new MapFieldLite<K, V>();
        }
        return new MapFieldLite<K, V>(this);
    }

    public final void makeImmutable() {
        this.isMutable = false;
    }

    public final boolean isMutable() {
        return this.isMutable;
    }

    private void ensureMutable() {
        if (!this.isMutable()) {
            throw new UnsupportedOperationException();
        }
    }

    static {
        EMPTY_MAP_FIELD.makeImmutable();
    }
}

