# -*- coding: utf-8 -*-
import unittest

from mx.DateTime import DateTime, RelativeDateTimeDiff


class DateTimeTests(unittest.TestCase):

    def testSettersNone(self):
        a = DateTime(2015, 1, 1)
        b = DateTime(2013, 12, 31)
        df = RelativeDateTimeDiff(a, b)
        self.assertIsNone(df.year)
        self.assertIsNone(df.month)
        self.assertIsNone(df.day)
        self.assertIsNone(df.hour)
        self.assertIsNone(df.minute)
        self.assertIsNone(df.second)

    def testYearsDiff(self):
        a = DateTime(2014, 1, 1)
        b = DateTime(2015, 1, 1)
        df = RelativeDateTimeDiff(a, b)
        self.assertEqual(df.years, -1)
        self.assertEqual(df.months, 0)
        self.assertEqual(df.days, 0)
        self.assertEqual(df.hours, 0)
        self.assertEqual(df.minutes, 0)
        self.assertEqual(df.seconds, 0)
        df = RelativeDateTimeDiff(b, a)
        self.assertEqual(df.years, 1)
        self.assertEqual(df.months, 0)
        self.assertEqual(df.days, 0)
        self.assertEqual(df.hours, 0)
        self.assertEqual(df.minutes, 0)
        self.assertEqual(df.seconds, 0)

    def testMonthsDiff(self):
        a = DateTime(2015, 1, 1)
        b = DateTime(2015, 2, 1)
        df = RelativeDateTimeDiff(a, b)
        self.assertEqual(df.years, 0)
        self.assertEqual(df.months, -1)
        self.assertEqual(df.days, 0)
        self.assertEqual(df.hours, 0)
        self.assertEqual(df.minutes, 0)
        self.assertEqual(df.seconds, 0)
        df = RelativeDateTimeDiff(b, a)
        self.assertEqual(df.years, 0)
        self.assertEqual(df.months, 1)
        self.assertEqual(df.days, 0)
        self.assertEqual(df.hours, 0)
        self.assertEqual(df.minutes, 0)
        self.assertEqual(df.seconds, 0)

    def testMonthsDiffBetweenYears(self):
        a = DateTime(2014, 12, 1)
        b = DateTime(2015, 2, 1)
        df = RelativeDateTimeDiff(a, b)
        self.assertEqual(df.years, 0)
        self.assertEqual(df.months, -2)
        self.assertEqual(df.days, 0)
        self.assertEqual(df.hours, 0)
        self.assertEqual(df.minutes, 0)
        self.assertEqual(df.seconds, 0)
        df = RelativeDateTimeDiff(b, a)
        self.assertEqual(df.years, 0)
        self.assertEqual(df.months, 2)
        self.assertEqual(df.days, 0)
        self.assertEqual(df.hours, 0)
        self.assertEqual(df.minutes, 0)
        self.assertEqual(df.seconds, 0)

    def testDaysDiff(self):
        a = DateTime(2015, 1, 1)
        b = DateTime(2015, 1, 2)
        df = RelativeDateTimeDiff(a, b)
        self.assertEqual(df.years, 0)
        self.assertEqual(df.months, 0)
        self.assertEqual(df.days, -1)
        self.assertEqual(df.hours, 0)
        self.assertEqual(df.minutes, 0)
        self.assertEqual(df.seconds, 0)
        df = RelativeDateTimeDiff(b, a)
        self.assertEqual(df.years, 0)
        self.assertEqual(df.months, 0)
        self.assertEqual(df.days, 1)
        self.assertEqual(df.hours, 0)
        self.assertEqual(df.minutes, 0)
        self.assertEqual(df.seconds, 0)

    def testHoursDiff(self):
        a = DateTime(2015, 1, 1, 13)
        b = DateTime(2015, 1, 1, 14)
        df = RelativeDateTimeDiff(a, b)
        self.assertEqual(df.years, 0)
        self.assertEqual(df.months, 0)
        self.assertEqual(df.days, 0)
        self.assertEqual(df.hours, -1)
        self.assertEqual(df.minutes, 0)
        self.assertEqual(df.seconds, 0)
        df = RelativeDateTimeDiff(b, a)
        self.assertEqual(df.years, 0)
        self.assertEqual(df.months, 0)
        self.assertEqual(df.days, 0)
        self.assertEqual(df.hours, 1)
        self.assertEqual(df.minutes, 0)
        self.assertEqual(df.seconds, 0)

    def testMinutesDiff(self):
        a = DateTime(2015, 1, 1, 13, 30)
        b = DateTime(2015, 1, 1, 13, 31)
        df = RelativeDateTimeDiff(a, b)
        self.assertEqual(df.years, 0)
        self.assertEqual(df.months, 0)
        self.assertEqual(df.days, 0)
        self.assertEqual(df.hours, 0)
        self.assertEqual(df.minutes, -1)
        self.assertEqual(df.seconds, 0)
        df = RelativeDateTimeDiff(b, a)
        self.assertEqual(df.years, 0)
        self.assertEqual(df.months, 0)
        self.assertEqual(df.days, 0)
        self.assertEqual(df.hours, 0)
        self.assertEqual(df.minutes, 1)
        self.assertEqual(df.seconds, 0)

    def testSecondsDiff(self):
        a = DateTime(2015, 1, 1, 13, 30, 7)
        b = DateTime(2015, 1, 1, 13, 30, 8)
        df = RelativeDateTimeDiff(a, b)
        self.assertEqual(df.years, 0)
        self.assertEqual(df.months, 0)
        self.assertEqual(df.days, 0)
        self.assertEqual(df.hours, 0)
        self.assertEqual(df.minutes, 0)
        self.assertEqual(df.seconds, -1)
        df = RelativeDateTimeDiff(b, a)
        self.assertEqual(df.years, 0)
        self.assertEqual(df.months, 0)
        self.assertEqual(df.days, 0)
        self.assertEqual(df.hours, 0)
        self.assertEqual(df.minutes, 0)
        self.assertEqual(df.seconds, 1)

    def testJustBelow(self):
        a = DateTime(2015, 1, 1)
        b = DateTime(2014, 1, 2)
        df = RelativeDateTimeDiff(a, b)
        self.assertEqual(df.years, 0)
