"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RestoreJob = exports.RestoreJobProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const hbr_generated_1 = require("./hbr.generated");
Object.defineProperty(exports, "RestoreJobProperty", { enumerable: true, get: function () { return hbr_generated_1.RosRestoreJob; } });
/**
 * A ROS resource type:  `ALIYUN::HBR::RestoreJob`
 */
class RestoreJob extends ros.Resource {
    /**
     * Create a new `ALIYUN::HBR::RestoreJob`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosRestoreJob = new hbr_generated_1.RosRestoreJob(this, id, {
            snapshotId: props.snapshotId,
            targetClientId: props.targetClientId,
            targetPath: props.targetPath,
            sourceType: props.sourceType,
            sourceClientId: props.sourceClientId,
            targetInstanceId: props.targetInstanceId,
            vaultId: props.vaultId,
            sourceInstanceId: props.sourceInstanceId,
            restoreType: props.restoreType,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosRestoreJob;
        this.attrErrorMessage = rosRestoreJob.attrErrorMessage;
        this.attrRestoreId = rosRestoreJob.attrRestoreId;
        this.attrRestoreType = rosRestoreJob.attrRestoreType;
        this.attrSourceType = rosRestoreJob.attrSourceType;
        this.attrStatus = rosRestoreJob.attrStatus;
    }
}
exports.RestoreJob = RestoreJob;
//# sourceMappingURL=data:application/json;base64,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