# ca be taken from this site:
# https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes

# we use this list to do the mapping from langdetect to tesseract languages

unmapped = ["so", "zh-cn", "zh-tw", ]

tesseract2langdetect = {
    "afr": "af",
    "amh": None,
    "ara": "ar",
    "asm": None,
    "aze": None,
    "aze_cyrl": None,
    "bel": None,
    "ben": "bn",
    "bod": None,
    "bos": None,
    "bre": None,
    "bul": "bg",
    "cat": "ca",
    "ceb": None,
    "ces": "cs",
    "chi_sim": None,
    "chi_tra": None,
    "chr": None,
    "cos": None,
    "cym": "cy",
    "dan": "da",
    "dan_frak": None,
    "deu": "de",
    "deu_frak": None,
    "dzo": None,
    "ell": "el",
    "eng": "en",
    "enm": None,
    "epo": None,
    "equ": None,
    "est": "et",
    "eus": None,
    "fao": None,
    "fas": "fa",
    "fil": None,
    "fin": "fi",
    "fra": "fr",
    "frk": None,
    "frm": None,
    "fry": None,
    "gla": None,
    "gle": None,
    "glg": None,
    "grc": None,
    "guj": "gu",
    "hat": None,
    "heb": "he",
    "hin": "hi",
    "hrv": "hr",
    "hun": "hu",
    "hye": None,
    "iku": None,
    "ind": "id",
    "isl": None,
    "ita": "it",
    "ita_old": None,
    "jav": None,
    "jpn": "ja",
    "kan": "kn",
    "kat": None,
    "kat_old": None,
    "kaz": None,
    "khm": None,
    "kir": None,
    "kmr": None,
    "kor": "ko",
    "kor_vert": None,
    "kur": None,
    "lao": None,
    "lat": None,
    "lav": "lv",
    "lit": "lt",
    "ltz": None,
    "mal": "ml",
    "mar": "mr",
    "mkd": "mk",
    "mlt": None,
    "mon": None,
    "mri": None,
    "msa": None,
    "mya": None,
    "nep": "ne",
    "nld": "nl",
    "nor": "no",
    "oci": None,
    "ori": None,
    "osd": None,
    "pan": "pa",
    "pol": "pl",
    "por": "pt",
    "pus": None,
    "que": None,
    "ron": "ro",
    "rus": "ru",
    "san": None,
    "sin": None,
    "slk": "sk",
    "slk_frak": None,
    "slv": "sl",
    "snd": None,
    "spa": "es",
    "spa_old": None,
    "sqi": "sq",
    "srp": None,
    "srp_latn": None,
    "sun": None,
    "swa": "sw",
    "swe": "sv",
    "syr": None,
    "tam": "ta",
    "tat": None,
    "tel": "te",
    "tgk": None,
    "tgl": "tl",
    "tha": "th",
    "tir": None,
    "ton": None,
    "tur": "tr",
    "uig": None,
    "ukr": "uk",
    "urd": "ur",
    "uzb": None,
    "uzb_cyrl": None,
    "vie": "vi",
    "yid": None,
    "yor": None,
}

langdetect2tesseract = {v: k for k, v in tesseract2langdetect.items() if v}
