"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Runtime = exports.RuntimeFamily = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
/**
 * @stability stable
 */
var RuntimeFamily;
(function (RuntimeFamily) {
    RuntimeFamily[RuntimeFamily["NODEJS"] = 0] = "NODEJS";
    RuntimeFamily[RuntimeFamily["JAVA"] = 1] = "JAVA";
    RuntimeFamily[RuntimeFamily["PYTHON"] = 2] = "PYTHON";
    RuntimeFamily[RuntimeFamily["DOTNET_CORE"] = 3] = "DOTNET_CORE";
    RuntimeFamily[RuntimeFamily["GO"] = 4] = "GO";
    RuntimeFamily[RuntimeFamily["RUBY"] = 5] = "RUBY";
    RuntimeFamily[RuntimeFamily["OTHER"] = 6] = "OTHER";
})(RuntimeFamily = exports.RuntimeFamily || (exports.RuntimeFamily = {}));
/**
 * Lambda function runtime environment.
 *
 * If you need to use a runtime name that doesn't exist as a static member, you
 * can instantiate a `Runtime` object, e.g: `new Runtime('nodejs99.99')`.
 *
 * @stability stable
 */
class Runtime {
    /**
     * @stability stable
     */
    constructor(name, family, props = {}) {
        var _b, _c;
        jsiiDeprecationWarnings._aws_cdk_aws_lambda_RuntimeFamily(family);
        jsiiDeprecationWarnings._aws_cdk_aws_lambda_LambdaRuntimeProps(props);
        this.name = name;
        this.supportsInlineCode = !!props.supportsInlineCode;
        this.family = family;
        const imageName = (_b = props.bundlingDockerImage) !== null && _b !== void 0 ? _b : `public.ecr.aws/sam/build-${name}`;
        this.bundlingDockerImage = core_1.DockerImage.fromRegistry(imageName);
        this.bundlingImage = this.bundlingDockerImage;
        this.supportsCodeGuruProfiling = (_c = props.supportsCodeGuruProfiling) !== null && _c !== void 0 ? _c : false;
        Runtime.ALL.push(this);
    }
    /**
     * @stability stable
     */
    toString() {
        return this.name;
    }
    /**
     * @stability stable
     */
    runtimeEquals(other) {
        jsiiDeprecationWarnings._aws_cdk_aws_lambda_Runtime(other);
        return other.name === this.name &&
            other.family === this.family &&
            other.supportsInlineCode === this.supportsInlineCode;
    }
}
exports.Runtime = Runtime;
_a = JSII_RTTI_SYMBOL_1;
Runtime[_a] = { fqn: "@aws-cdk/aws-lambda.Runtime", version: "1.135.0" };
/**
 * A list of all known `Runtime`'s.
 *
 * @stability stable
 */
Runtime.ALL = new Array();
/**
 * The NodeJS runtime (nodejs) Legacy runtime no longer supported by AWS Lambda.
 *
 * @stability stable
 */
Runtime.NODEJS = new Runtime('nodejs', RuntimeFamily.NODEJS, { supportsInlineCode: true });
/**
 * The NodeJS 4.3 runtime (nodejs4.3) Legacy runtime no longer supported by AWS Lambda.
 *
 * @stability stable
 */
Runtime.NODEJS_4_3 = new Runtime('nodejs4.3', RuntimeFamily.NODEJS, { supportsInlineCode: true });
/**
 * The NodeJS 6.10 runtime (nodejs6.10) Legacy runtime no longer supported by AWS Lambda.
 *
 * @stability stable
 */
Runtime.NODEJS_6_10 = new Runtime('nodejs6.10', RuntimeFamily.NODEJS, { supportsInlineCode: true });
/**
 * The NodeJS 8.10 runtime (nodejs8.10) Legacy runtime no longer supported by AWS Lambda.
 *
 * @stability stable
 */
Runtime.NODEJS_8_10 = new Runtime('nodejs8.10', RuntimeFamily.NODEJS, { supportsInlineCode: true });
/**
 * The NodeJS 10.x runtime (nodejs10.x).
 *
 * @stability stable
 */
Runtime.NODEJS_10_X = new Runtime('nodejs10.x', RuntimeFamily.NODEJS, { supportsInlineCode: true });
/**
 * The NodeJS 12.x runtime (nodejs12.x).
 *
 * @stability stable
 */
Runtime.NODEJS_12_X = new Runtime('nodejs12.x', RuntimeFamily.NODEJS, { supportsInlineCode: true });
/**
 * The NodeJS 14.x runtime (nodejs14.x).
 *
 * @stability stable
 */
Runtime.NODEJS_14_X = new Runtime('nodejs14.x', RuntimeFamily.NODEJS, { supportsInlineCode: true });
/**
 * The Python 2.7 runtime (python2.7).
 *
 * @stability stable
 */
Runtime.PYTHON_2_7 = new Runtime('python2.7', RuntimeFamily.PYTHON, { supportsInlineCode: true });
/**
 * The Python 3.6 runtime (python3.6).
 *
 * @stability stable
 */
Runtime.PYTHON_3_6 = new Runtime('python3.6', RuntimeFamily.PYTHON, {
    supportsInlineCode: true,
    supportsCodeGuruProfiling: true,
});
/**
 * The Python 3.7 runtime (python3.7).
 *
 * @stability stable
 */
Runtime.PYTHON_3_7 = new Runtime('python3.7', RuntimeFamily.PYTHON, {
    supportsInlineCode: true,
    supportsCodeGuruProfiling: true,
});
/**
 * The Python 3.8 runtime (python3.8).
 *
 * @stability stable
 */
Runtime.PYTHON_3_8 = new Runtime('python3.8', RuntimeFamily.PYTHON, {
    supportsInlineCode: true,
    supportsCodeGuruProfiling: true,
});
/**
 * The Python 3.9 runtime (python3.9).
 *
 * @stability stable
 */
Runtime.PYTHON_3_9 = new Runtime('python3.9', RuntimeFamily.PYTHON, {
    supportsInlineCode: true,
    supportsCodeGuruProfiling: true,
});
/**
 * The Java 8 runtime (java8).
 *
 * @stability stable
 */
Runtime.JAVA_8 = new Runtime('java8', RuntimeFamily.JAVA, {
    supportsCodeGuruProfiling: true,
});
/**
 * The Java 8 Corretto runtime (java8.al2).
 *
 * @stability stable
 */
Runtime.JAVA_8_CORRETTO = new Runtime('java8.al2', RuntimeFamily.JAVA, {
    supportsCodeGuruProfiling: true,
});
/**
 * The Java 11 runtime (java11).
 *
 * @stability stable
 */
Runtime.JAVA_11 = new Runtime('java11', RuntimeFamily.JAVA, {
    supportsCodeGuruProfiling: true,
});
/**
 * The .NET Core 1.0 runtime (dotnetcore1.0) Legacy runtime no longer supported by AWS Lambda.
 *
 * @stability stable
 */
Runtime.DOTNET_CORE_1 = new Runtime('dotnetcore1.0', RuntimeFamily.DOTNET_CORE);
/**
 * The .NET Core 2.0 runtime (dotnetcore2.0) Legacy runtime no longer supported by AWS Lambda.
 *
 * @stability stable
 */
Runtime.DOTNET_CORE_2 = new Runtime('dotnetcore2.0', RuntimeFamily.DOTNET_CORE);
/**
 * The .NET Core 2.1 runtime (dotnetcore2.1).
 *
 * @stability stable
 */
Runtime.DOTNET_CORE_2_1 = new Runtime('dotnetcore2.1', RuntimeFamily.DOTNET_CORE);
/**
 * The .NET Core 3.1 runtime (dotnetcore3.1).
 *
 * @stability stable
 */
Runtime.DOTNET_CORE_3_1 = new Runtime('dotnetcore3.1', RuntimeFamily.DOTNET_CORE);
/**
 * The Go 1.x runtime (go1.x).
 *
 * @stability stable
 */
Runtime.GO_1_X = new Runtime('go1.x', RuntimeFamily.GO);
/**
 * The Ruby 2.5 runtime (ruby2.5).
 *
 * @stability stable
 */
Runtime.RUBY_2_5 = new Runtime('ruby2.5', RuntimeFamily.RUBY);
/**
 * The Ruby 2.7 runtime (ruby2.7).
 *
 * @stability stable
 */
Runtime.RUBY_2_7 = new Runtime('ruby2.7', RuntimeFamily.RUBY);
/**
 * The custom provided runtime (provided).
 *
 * @stability stable
 */
Runtime.PROVIDED = new Runtime('provided', RuntimeFamily.OTHER);
/**
 * The custom provided runtime (provided).
 *
 * @stability stable
 */
Runtime.PROVIDED_AL2 = new Runtime('provided.al2', RuntimeFamily.OTHER);
/**
 * A special runtime entry to be used when function is using a docker image.
 *
 * @stability stable
 */
Runtime.FROM_IMAGE = new Runtime('FROM_IMAGE');
//# sourceMappingURL=data:application/json;base64,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