"use strict";
// Copyright 2012-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaMetrics = void 0;
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
class LambdaMetrics {
    static durationp90(dimensions) {
        return {
            namespace: 'AWS/Lambda',
            metricName: 'Duration',
            dimensionsMap: dimensions,
            statistic: 'p90',
        };
    }
    static errorsSum(dimensions) {
        return {
            namespace: 'AWS/Lambda',
            metricName: 'Errors',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static invocationsSum(dimensions) {
        return {
            namespace: 'AWS/Lambda',
            metricName: 'Invocations',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static throttlesSum(dimensions) {
        return {
            namespace: 'AWS/Lambda',
            metricName: 'Throttles',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
}
exports.LambdaMetrics = LambdaMetrics;
//# sourceMappingURL=data:application/json;base64,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