import {
  _InstanceType,
  AddedPrincipal,
  AddIpamOperatingRegion,
  AddPrefixListEntry,
  AddressAttribute,
  AddressAttributeName,
  Affinity,
  ApplianceModeSupportValue,
  ByoipCidr,
  ClientVpnAuthorizationRuleStatus,
  CurrencyCodeValues,
  DnsSupportValue,
  EnaSrdSpecification,
  IamInstanceProfileAssociation,
  IamInstanceProfileSpecification,
  InstanceEventWindow,
  IpPermission,
  Ipv6SupportValue,
  PortRange,
  RouteTableAssociationState,
  TagSpecification,
  TransitGatewayAttachmentResourceType,
  TransitGatewayMulticastDomainAssociations,
  TransitGatewayPeeringAttachment,
  TransitGatewayVpcAttachment,
  UnsuccessfulItem,
  VerifiedAccessInstance,
  VerifiedAccessTrustProvider,
} from "./models_0";
import {
  AttributeValue,
  BlockDeviceMapping,
  CreditSpecificationRequest,
  ElasticGpuSpecification,
  HostnameType,
  IcmpTypeCode,
  InstanceEventWindowTimeRangeRequest,
  InstanceInterruptionBehavior,
  InstanceIpv6Address,
  Ipam,
  IpamPool,
  IpamScope,
  LaunchTemplate,
  LocalGatewayRoute,
  ManagedPrefixList,
  MarketType,
  Placement,
  RequestIpamResourceTag,
  RuleAction,
  ShutdownBehavior,
  SnapshotState,
  SpotInstanceType,
  VolumeType,
} from "./models_1";
import {
  AutoAcceptSharedAttachmentsValue,
  DefaultRouteTableAssociationValue,
  DefaultRouteTablePropagationValue,
  DnsOptionsSpecification,
  IKEVersionsRequestListValue,
  IpAddressType,
  PayerResponsibility,
  Phase1DHGroupNumbersRequestListValue,
  Phase1EncryptionAlgorithmsRequestListValue,
  Phase1IntegrityAlgorithmsRequestListValue,
  Phase2DHGroupNumbersRequestListValue,
  Phase2EncryptionAlgorithmsRequestListValue,
  Phase2IntegrityAlgorithmsRequestListValue,
  TrafficDirection,
  TrafficMirrorFilter,
  TrafficMirrorFilterRule,
  TrafficMirrorNetworkService,
  TrafficMirrorPortRangeRequest,
  TrafficMirrorRuleAction,
  TrafficMirrorSession,
  TransitGateway,
  TransitGatewayPrefixListReference,
  TransitGatewayRoute,
  VerifiedAccessEndpoint,
  VerifiedAccessEndpointProtocol,
  VerifiedAccessGroup,
  VpnConnection,
  VpnEcmpSupportValue,
  VpnTunnelLogOptionsSpecification,
} from "./models_2";
import {
  ArchitectureValues,
  AttributeBooleanValue,
  BootModeValues,
  ClientVpnConnectionStatus,
  Filter,
  HttpTokensState,
  ImdsSupportValues,
  InstanceAttributeName,
  InstanceAutoRecoveryState,
  InstanceMetadataEndpointState,
  InstanceMetadataOptionsResponse,
  InstanceMetadataProtocolState,
  InstanceMetadataTagsState,
  InstanceState,
  InstanceStatusEvent,
  InstanceTagNotificationAttribute,
  IpamPoolCidr,
  Monitoring,
  TpmSupportValues,
} from "./models_3";
import {
  CreateVolumePermission,
  ExcessCapacityTerminationPolicy,
  InstanceNetworkInterfaceSpecification,
  LaunchTemplateConfig,
  NetworkInsightsAccessScopeAnalysis,
  NetworkInsightsAnalysis,
  PublicIpv4PoolRange,
  ReservedInstancesConfiguration,
  RunInstancesMonitoringEnabled,
  ScheduledInstance,
  SnapshotAttributeName,
  SpotFleetRequestConfigData,
  SpotInstanceRequest,
  SpotPlacement,
  VerifiedAccessInstanceLoggingConfiguration,
  VolumeModification,
} from "./models_4";
import {
  CapacityReservationSpecification,
  IpamResourceCidr,
  OperationType,
  Purchase,
} from "./models_5";
export interface InstanceCreditSpecificationRequest {
  InstanceId?: string;
  CpuCredits?: string;
}
export interface ModifyInstanceCreditSpecificationRequest {
  DryRun?: boolean;
  ClientToken?: string;
  InstanceCreditSpecifications:
    | InstanceCreditSpecificationRequest[]
    | undefined;
}
export interface SuccessfulInstanceCreditSpecificationItem {
  InstanceId?: string;
}
export declare enum UnsuccessfulInstanceCreditSpecificationErrorCode {
  INCORRECT_INSTANCE_STATE = "IncorrectInstanceState",
  INSTANCE_CREDIT_SPECIFICATION_NOT_SUPPORTED = "InstanceCreditSpecification.NotSupported",
  INSTANCE_NOT_FOUND = "InvalidInstanceID.NotFound",
  INVALID_INSTANCE_ID = "InvalidInstanceID.Malformed",
}
export interface UnsuccessfulInstanceCreditSpecificationItemError {
  Code?: UnsuccessfulInstanceCreditSpecificationErrorCode | string;
  Message?: string;
}
export interface UnsuccessfulInstanceCreditSpecificationItem {
  InstanceId?: string;
  Error?: UnsuccessfulInstanceCreditSpecificationItemError;
}
export interface ModifyInstanceCreditSpecificationResult {
  SuccessfulInstanceCreditSpecifications?: SuccessfulInstanceCreditSpecificationItem[];
  UnsuccessfulInstanceCreditSpecifications?: UnsuccessfulInstanceCreditSpecificationItem[];
}
export interface ModifyInstanceEventStartTimeRequest {
  DryRun?: boolean;
  InstanceId: string | undefined;
  InstanceEventId: string | undefined;
  NotBefore: Date | undefined;
}
export interface ModifyInstanceEventStartTimeResult {
  Event?: InstanceStatusEvent;
}
export interface ModifyInstanceEventWindowRequest {
  DryRun?: boolean;
  Name?: string;
  InstanceEventWindowId: string | undefined;
  TimeRanges?: InstanceEventWindowTimeRangeRequest[];
  CronExpression?: string;
}
export interface ModifyInstanceEventWindowResult {
  InstanceEventWindow?: InstanceEventWindow;
}
export interface ModifyInstanceMaintenanceOptionsRequest {
  InstanceId: string | undefined;
  AutoRecovery?: InstanceAutoRecoveryState | string;
  DryRun?: boolean;
}
export interface ModifyInstanceMaintenanceOptionsResult {
  InstanceId?: string;
  AutoRecovery?: InstanceAutoRecoveryState | string;
}
export interface ModifyInstanceMetadataOptionsRequest {
  InstanceId: string | undefined;
  HttpTokens?: HttpTokensState | string;
  HttpPutResponseHopLimit?: number;
  HttpEndpoint?: InstanceMetadataEndpointState | string;
  DryRun?: boolean;
  HttpProtocolIpv6?: InstanceMetadataProtocolState | string;
  InstanceMetadataTags?: InstanceMetadataTagsState | string;
}
export interface ModifyInstanceMetadataOptionsResult {
  InstanceId?: string;
  InstanceMetadataOptions?: InstanceMetadataOptionsResponse;
}
export declare enum HostTenancy {
  dedicated = "dedicated",
  host = "host",
}
export interface ModifyInstancePlacementRequest {
  Affinity?: Affinity | string;
  GroupName?: string;
  HostId?: string;
  InstanceId: string | undefined;
  Tenancy?: HostTenancy | string;
  PartitionNumber?: number;
  HostResourceGroupArn?: string;
  GroupId?: string;
}
export interface ModifyInstancePlacementResult {
  Return?: boolean;
}
export interface RemoveIpamOperatingRegion {
  RegionName?: string;
}
export interface ModifyIpamRequest {
  DryRun?: boolean;
  IpamId: string | undefined;
  Description?: string;
  AddOperatingRegions?: AddIpamOperatingRegion[];
  RemoveOperatingRegions?: RemoveIpamOperatingRegion[];
}
export interface ModifyIpamResult {
  Ipam?: Ipam;
}
export interface ModifyIpamPoolRequest {
  DryRun?: boolean;
  IpamPoolId: string | undefined;
  Description?: string;
  AutoImport?: boolean;
  AllocationMinNetmaskLength?: number;
  AllocationMaxNetmaskLength?: number;
  AllocationDefaultNetmaskLength?: number;
  ClearAllocationDefaultNetmaskLength?: boolean;
  AddAllocationResourceTags?: RequestIpamResourceTag[];
  RemoveAllocationResourceTags?: RequestIpamResourceTag[];
}
export interface ModifyIpamPoolResult {
  IpamPool?: IpamPool;
}
export interface ModifyIpamResourceCidrRequest {
  DryRun?: boolean;
  ResourceId: string | undefined;
  ResourceCidr: string | undefined;
  ResourceRegion: string | undefined;
  CurrentIpamScopeId: string | undefined;
  DestinationIpamScopeId?: string;
  Monitored: boolean | undefined;
}
export interface ModifyIpamResourceCidrResult {
  IpamResourceCidr?: IpamResourceCidr;
}
export interface ModifyIpamScopeRequest {
  DryRun?: boolean;
  IpamScopeId: string | undefined;
  Description?: string;
}
export interface ModifyIpamScopeResult {
  IpamScope?: IpamScope;
}
export interface ModifyLaunchTemplateRequest {
  DryRun?: boolean;
  ClientToken?: string;
  LaunchTemplateId?: string;
  LaunchTemplateName?: string;
  DefaultVersion?: string;
}
export interface ModifyLaunchTemplateResult {
  LaunchTemplate?: LaunchTemplate;
}
export interface ModifyLocalGatewayRouteRequest {
  DestinationCidrBlock: string | undefined;
  LocalGatewayRouteTableId: string | undefined;
  LocalGatewayVirtualInterfaceGroupId?: string;
  NetworkInterfaceId?: string;
  DryRun?: boolean;
}
export interface ModifyLocalGatewayRouteResult {
  Route?: LocalGatewayRoute;
}
export interface RemovePrefixListEntry {
  Cidr: string | undefined;
}
export interface ModifyManagedPrefixListRequest {
  DryRun?: boolean;
  PrefixListId: string | undefined;
  CurrentVersion?: number;
  PrefixListName?: string;
  AddEntries?: AddPrefixListEntry[];
  RemoveEntries?: RemovePrefixListEntry[];
  MaxEntries?: number;
}
export interface ModifyManagedPrefixListResult {
  PrefixList?: ManagedPrefixList;
}
export interface NetworkInterfaceAttachmentChanges {
  AttachmentId?: string;
  DeleteOnTermination?: boolean;
}
export interface ModifyNetworkInterfaceAttributeRequest {
  Attachment?: NetworkInterfaceAttachmentChanges;
  Description?: AttributeValue;
  DryRun?: boolean;
  Groups?: string[];
  NetworkInterfaceId: string | undefined;
  SourceDestCheck?: AttributeBooleanValue;
  EnaSrdSpecification?: EnaSrdSpecification;
}
export interface ModifyPrivateDnsNameOptionsRequest {
  DryRun?: boolean;
  InstanceId?: string;
  PrivateDnsHostnameType?: HostnameType | string;
  EnableResourceNameDnsARecord?: boolean;
  EnableResourceNameDnsAAAARecord?: boolean;
}
export interface ModifyPrivateDnsNameOptionsResult {
  Return?: boolean;
}
export interface ModifyReservedInstancesRequest {
  ReservedInstancesIds: string[] | undefined;
  ClientToken?: string;
  TargetConfigurations: ReservedInstancesConfiguration[] | undefined;
}
export interface ModifyReservedInstancesResult {
  ReservedInstancesModificationId?: string;
}
export interface SecurityGroupRuleRequest {
  IpProtocol?: string;
  FromPort?: number;
  ToPort?: number;
  CidrIpv4?: string;
  CidrIpv6?: string;
  PrefixListId?: string;
  ReferencedGroupId?: string;
  Description?: string;
}
export interface SecurityGroupRuleUpdate {
  SecurityGroupRuleId?: string;
  SecurityGroupRule?: SecurityGroupRuleRequest;
}
export interface ModifySecurityGroupRulesRequest {
  GroupId: string | undefined;
  SecurityGroupRules: SecurityGroupRuleUpdate[] | undefined;
  DryRun?: boolean;
}
export interface ModifySecurityGroupRulesResult {
  Return?: boolean;
}
export interface CreateVolumePermissionModifications {
  Add?: CreateVolumePermission[];
  Remove?: CreateVolumePermission[];
}
export interface ModifySnapshotAttributeRequest {
  Attribute?: SnapshotAttributeName | string;
  CreateVolumePermission?: CreateVolumePermissionModifications;
  GroupNames?: string[];
  OperationType?: OperationType | string;
  SnapshotId: string | undefined;
  UserIds?: string[];
  DryRun?: boolean;
}
export declare enum TargetStorageTier {
  archive = "archive",
}
export interface ModifySnapshotTierRequest {
  SnapshotId: string | undefined;
  StorageTier?: TargetStorageTier | string;
  DryRun?: boolean;
}
export interface ModifySnapshotTierResult {
  SnapshotId?: string;
  TieringStartTime?: Date;
}
export interface ModifySpotFleetRequestRequest {
  ExcessCapacityTerminationPolicy?: ExcessCapacityTerminationPolicy | string;
  LaunchTemplateConfigs?: LaunchTemplateConfig[];
  SpotFleetRequestId: string | undefined;
  TargetCapacity?: number;
  OnDemandTargetCapacity?: number;
  Context?: string;
}
export interface ModifySpotFleetRequestResponse {
  Return?: boolean;
}
export interface ModifySubnetAttributeRequest {
  AssignIpv6AddressOnCreation?: AttributeBooleanValue;
  MapPublicIpOnLaunch?: AttributeBooleanValue;
  SubnetId: string | undefined;
  MapCustomerOwnedIpOnLaunch?: AttributeBooleanValue;
  CustomerOwnedIpv4Pool?: string;
  EnableDns64?: AttributeBooleanValue;
  PrivateDnsHostnameTypeOnLaunch?: HostnameType | string;
  EnableResourceNameDnsARecordOnLaunch?: AttributeBooleanValue;
  EnableResourceNameDnsAAAARecordOnLaunch?: AttributeBooleanValue;
  EnableLniAtDeviceIndex?: number;
  DisableLniAtDeviceIndex?: AttributeBooleanValue;
}
export interface ModifyTrafficMirrorFilterNetworkServicesRequest {
  TrafficMirrorFilterId: string | undefined;
  AddNetworkServices?: (TrafficMirrorNetworkService | string)[];
  RemoveNetworkServices?: (TrafficMirrorNetworkService | string)[];
  DryRun?: boolean;
}
export interface ModifyTrafficMirrorFilterNetworkServicesResult {
  TrafficMirrorFilter?: TrafficMirrorFilter;
}
export declare enum TrafficMirrorFilterRuleField {
  description = "description",
  destination_port_range = "destination-port-range",
  protocol = "protocol",
  source_port_range = "source-port-range",
}
export interface ModifyTrafficMirrorFilterRuleRequest {
  TrafficMirrorFilterRuleId: string | undefined;
  TrafficDirection?: TrafficDirection | string;
  RuleNumber?: number;
  RuleAction?: TrafficMirrorRuleAction | string;
  DestinationPortRange?: TrafficMirrorPortRangeRequest;
  SourcePortRange?: TrafficMirrorPortRangeRequest;
  Protocol?: number;
  DestinationCidrBlock?: string;
  SourceCidrBlock?: string;
  Description?: string;
  RemoveFields?: (TrafficMirrorFilterRuleField | string)[];
  DryRun?: boolean;
}
export interface ModifyTrafficMirrorFilterRuleResult {
  TrafficMirrorFilterRule?: TrafficMirrorFilterRule;
}
export declare enum TrafficMirrorSessionField {
  description = "description",
  packet_length = "packet-length",
  virtual_network_id = "virtual-network-id",
}
export interface ModifyTrafficMirrorSessionRequest {
  TrafficMirrorSessionId: string | undefined;
  TrafficMirrorTargetId?: string;
  TrafficMirrorFilterId?: string;
  PacketLength?: number;
  SessionNumber?: number;
  VirtualNetworkId?: number;
  Description?: string;
  RemoveFields?: (TrafficMirrorSessionField | string)[];
  DryRun?: boolean;
}
export interface ModifyTrafficMirrorSessionResult {
  TrafficMirrorSession?: TrafficMirrorSession;
}
export interface ModifyTransitGatewayOptions {
  AddTransitGatewayCidrBlocks?: string[];
  RemoveTransitGatewayCidrBlocks?: string[];
  VpnEcmpSupport?: VpnEcmpSupportValue | string;
  DnsSupport?: DnsSupportValue | string;
  AutoAcceptSharedAttachments?: AutoAcceptSharedAttachmentsValue | string;
  DefaultRouteTableAssociation?: DefaultRouteTableAssociationValue | string;
  AssociationDefaultRouteTableId?: string;
  DefaultRouteTablePropagation?: DefaultRouteTablePropagationValue | string;
  PropagationDefaultRouteTableId?: string;
  AmazonSideAsn?: number;
}
export interface ModifyTransitGatewayRequest {
  TransitGatewayId: string | undefined;
  Description?: string;
  Options?: ModifyTransitGatewayOptions;
  DryRun?: boolean;
}
export interface ModifyTransitGatewayResult {
  TransitGateway?: TransitGateway;
}
export interface ModifyTransitGatewayPrefixListReferenceRequest {
  TransitGatewayRouteTableId: string | undefined;
  PrefixListId: string | undefined;
  TransitGatewayAttachmentId?: string;
  Blackhole?: boolean;
  DryRun?: boolean;
}
export interface ModifyTransitGatewayPrefixListReferenceResult {
  TransitGatewayPrefixListReference?: TransitGatewayPrefixListReference;
}
export interface ModifyTransitGatewayVpcAttachmentRequestOptions {
  DnsSupport?: DnsSupportValue | string;
  Ipv6Support?: Ipv6SupportValue | string;
  ApplianceModeSupport?: ApplianceModeSupportValue | string;
}
export interface ModifyTransitGatewayVpcAttachmentRequest {
  TransitGatewayAttachmentId: string | undefined;
  AddSubnetIds?: string[];
  RemoveSubnetIds?: string[];
  Options?: ModifyTransitGatewayVpcAttachmentRequestOptions;
  DryRun?: boolean;
}
export interface ModifyTransitGatewayVpcAttachmentResult {
  TransitGatewayVpcAttachment?: TransitGatewayVpcAttachment;
}
export interface ModifyVerifiedAccessEndpointLoadBalancerOptions {
  SubnetIds?: string[];
  Protocol?: VerifiedAccessEndpointProtocol | string;
  Port?: number;
}
export interface ModifyVerifiedAccessEndpointEniOptions {
  Protocol?: VerifiedAccessEndpointProtocol | string;
  Port?: number;
}
export interface ModifyVerifiedAccessEndpointRequest {
  VerifiedAccessEndpointId: string | undefined;
  VerifiedAccessGroupId?: string;
  LoadBalancerOptions?: ModifyVerifiedAccessEndpointLoadBalancerOptions;
  NetworkInterfaceOptions?: ModifyVerifiedAccessEndpointEniOptions;
  Description?: string;
  ClientToken?: string;
  DryRun?: boolean;
}
export interface ModifyVerifiedAccessEndpointResult {
  VerifiedAccessEndpoint?: VerifiedAccessEndpoint;
}
export interface ModifyVerifiedAccessEndpointPolicyRequest {
  VerifiedAccessEndpointId: string | undefined;
  PolicyEnabled: boolean | undefined;
  PolicyDocument?: string;
  ClientToken?: string;
  DryRun?: boolean;
}
export interface ModifyVerifiedAccessEndpointPolicyResult {
  PolicyEnabled?: boolean;
  PolicyDocument?: string;
}
export interface ModifyVerifiedAccessGroupRequest {
  VerifiedAccessGroupId: string | undefined;
  VerifiedAccessInstanceId?: string;
  Description?: string;
  ClientToken?: string;
  DryRun?: boolean;
}
export interface ModifyVerifiedAccessGroupResult {
  VerifiedAccessGroup?: VerifiedAccessGroup;
}
export interface ModifyVerifiedAccessGroupPolicyRequest {
  VerifiedAccessGroupId: string | undefined;
  PolicyEnabled: boolean | undefined;
  PolicyDocument?: string;
  ClientToken?: string;
  DryRun?: boolean;
}
export interface ModifyVerifiedAccessGroupPolicyResult {
  PolicyEnabled?: boolean;
  PolicyDocument?: string;
}
export interface ModifyVerifiedAccessInstanceRequest {
  VerifiedAccessInstanceId: string | undefined;
  Description?: string;
  DryRun?: boolean;
  ClientToken?: string;
}
export interface ModifyVerifiedAccessInstanceResult {
  VerifiedAccessInstance?: VerifiedAccessInstance;
}
export interface VerifiedAccessLogCloudWatchLogsDestinationOptions {
  Enabled: boolean | undefined;
  LogGroup?: string;
}
export interface VerifiedAccessLogKinesisDataFirehoseDestinationOptions {
  Enabled: boolean | undefined;
  DeliveryStream?: string;
}
export interface VerifiedAccessLogS3DestinationOptions {
  Enabled: boolean | undefined;
  BucketName?: string;
  Prefix?: string;
  BucketOwner?: string;
}
export interface VerifiedAccessLogOptions {
  S3?: VerifiedAccessLogS3DestinationOptions;
  CloudWatchLogs?: VerifiedAccessLogCloudWatchLogsDestinationOptions;
  KinesisDataFirehose?: VerifiedAccessLogKinesisDataFirehoseDestinationOptions;
}
export interface ModifyVerifiedAccessInstanceLoggingConfigurationRequest {
  VerifiedAccessInstanceId: string | undefined;
  AccessLogs: VerifiedAccessLogOptions | undefined;
  DryRun?: boolean;
  ClientToken?: string;
}
export interface ModifyVerifiedAccessInstanceLoggingConfigurationResult {
  LoggingConfiguration?: VerifiedAccessInstanceLoggingConfiguration;
}
export interface ModifyVerifiedAccessTrustProviderOidcOptions {
  Scope?: string;
}
export interface ModifyVerifiedAccessTrustProviderRequest {
  VerifiedAccessTrustProviderId: string | undefined;
  OidcOptions?: ModifyVerifiedAccessTrustProviderOidcOptions;
  Description?: string;
  DryRun?: boolean;
  ClientToken?: string;
}
export interface ModifyVerifiedAccessTrustProviderResult {
  VerifiedAccessTrustProvider?: VerifiedAccessTrustProvider;
}
export interface ModifyVolumeRequest {
  DryRun?: boolean;
  VolumeId: string | undefined;
  Size?: number;
  VolumeType?: VolumeType | string;
  Iops?: number;
  Throughput?: number;
  MultiAttachEnabled?: boolean;
}
export interface ModifyVolumeResult {
  VolumeModification?: VolumeModification;
}
export interface ModifyVolumeAttributeRequest {
  AutoEnableIO?: AttributeBooleanValue;
  VolumeId: string | undefined;
  DryRun?: boolean;
}
export interface ModifyVpcAttributeRequest {
  EnableDnsHostnames?: AttributeBooleanValue;
  EnableDnsSupport?: AttributeBooleanValue;
  VpcId: string | undefined;
  EnableNetworkAddressUsageMetrics?: AttributeBooleanValue;
}
export interface ModifyVpcEndpointRequest {
  DryRun?: boolean;
  VpcEndpointId: string | undefined;
  ResetPolicy?: boolean;
  PolicyDocument?: string;
  AddRouteTableIds?: string[];
  RemoveRouteTableIds?: string[];
  AddSubnetIds?: string[];
  RemoveSubnetIds?: string[];
  AddSecurityGroupIds?: string[];
  RemoveSecurityGroupIds?: string[];
  IpAddressType?: IpAddressType | string;
  DnsOptions?: DnsOptionsSpecification;
  PrivateDnsEnabled?: boolean;
}
export interface ModifyVpcEndpointResult {
  Return?: boolean;
}
export interface ModifyVpcEndpointConnectionNotificationRequest {
  DryRun?: boolean;
  ConnectionNotificationId: string | undefined;
  ConnectionNotificationArn?: string;
  ConnectionEvents?: string[];
}
export interface ModifyVpcEndpointConnectionNotificationResult {
  ReturnValue?: boolean;
}
export interface ModifyVpcEndpointServiceConfigurationRequest {
  DryRun?: boolean;
  ServiceId: string | undefined;
  PrivateDnsName?: string;
  RemovePrivateDnsName?: boolean;
  AcceptanceRequired?: boolean;
  AddNetworkLoadBalancerArns?: string[];
  RemoveNetworkLoadBalancerArns?: string[];
  AddGatewayLoadBalancerArns?: string[];
  RemoveGatewayLoadBalancerArns?: string[];
  AddSupportedIpAddressTypes?: string[];
  RemoveSupportedIpAddressTypes?: string[];
}
export interface ModifyVpcEndpointServiceConfigurationResult {
  Return?: boolean;
}
export interface ModifyVpcEndpointServicePayerResponsibilityRequest {
  DryRun?: boolean;
  ServiceId: string | undefined;
  PayerResponsibility: PayerResponsibility | string | undefined;
}
export interface ModifyVpcEndpointServicePayerResponsibilityResult {
  ReturnValue?: boolean;
}
export interface ModifyVpcEndpointServicePermissionsRequest {
  DryRun?: boolean;
  ServiceId: string | undefined;
  AddAllowedPrincipals?: string[];
  RemoveAllowedPrincipals?: string[];
}
export interface ModifyVpcEndpointServicePermissionsResult {
  AddedPrincipals?: AddedPrincipal[];
  ReturnValue?: boolean;
}
export interface PeeringConnectionOptionsRequest {
  AllowDnsResolutionFromRemoteVpc?: boolean;
  AllowEgressFromLocalClassicLinkToRemoteVpc?: boolean;
  AllowEgressFromLocalVpcToRemoteClassicLink?: boolean;
}
export interface ModifyVpcPeeringConnectionOptionsRequest {
  AccepterPeeringConnectionOptions?: PeeringConnectionOptionsRequest;
  DryRun?: boolean;
  RequesterPeeringConnectionOptions?: PeeringConnectionOptionsRequest;
  VpcPeeringConnectionId: string | undefined;
}
export interface PeeringConnectionOptions {
  AllowDnsResolutionFromRemoteVpc?: boolean;
  AllowEgressFromLocalClassicLinkToRemoteVpc?: boolean;
  AllowEgressFromLocalVpcToRemoteClassicLink?: boolean;
}
export interface ModifyVpcPeeringConnectionOptionsResult {
  AccepterPeeringConnectionOptions?: PeeringConnectionOptions;
  RequesterPeeringConnectionOptions?: PeeringConnectionOptions;
}
export declare enum VpcTenancy {
  default = "default",
}
export interface ModifyVpcTenancyRequest {
  VpcId: string | undefined;
  InstanceTenancy: VpcTenancy | string | undefined;
  DryRun?: boolean;
}
export interface ModifyVpcTenancyResult {
  ReturnValue?: boolean;
}
export interface ModifyVpnConnectionRequest {
  VpnConnectionId: string | undefined;
  TransitGatewayId?: string;
  CustomerGatewayId?: string;
  VpnGatewayId?: string;
  DryRun?: boolean;
}
export interface ModifyVpnConnectionResult {
  VpnConnection?: VpnConnection;
}
export interface ModifyVpnConnectionOptionsRequest {
  VpnConnectionId: string | undefined;
  LocalIpv4NetworkCidr?: string;
  RemoteIpv4NetworkCidr?: string;
  LocalIpv6NetworkCidr?: string;
  RemoteIpv6NetworkCidr?: string;
  DryRun?: boolean;
}
export interface ModifyVpnConnectionOptionsResult {
  VpnConnection?: VpnConnection;
}
export interface ModifyVpnTunnelCertificateRequest {
  VpnConnectionId: string | undefined;
  VpnTunnelOutsideIpAddress: string | undefined;
  DryRun?: boolean;
}
export interface ModifyVpnTunnelCertificateResult {
  VpnConnection?: VpnConnection;
}
export interface ModifyVpnTunnelOptionsSpecification {
  TunnelInsideCidr?: string;
  TunnelInsideIpv6Cidr?: string;
  PreSharedKey?: string;
  Phase1LifetimeSeconds?: number;
  Phase2LifetimeSeconds?: number;
  RekeyMarginTimeSeconds?: number;
  RekeyFuzzPercentage?: number;
  ReplayWindowSize?: number;
  DPDTimeoutSeconds?: number;
  DPDTimeoutAction?: string;
  Phase1EncryptionAlgorithms?: Phase1EncryptionAlgorithmsRequestListValue[];
  Phase2EncryptionAlgorithms?: Phase2EncryptionAlgorithmsRequestListValue[];
  Phase1IntegrityAlgorithms?: Phase1IntegrityAlgorithmsRequestListValue[];
  Phase2IntegrityAlgorithms?: Phase2IntegrityAlgorithmsRequestListValue[];
  Phase1DHGroupNumbers?: Phase1DHGroupNumbersRequestListValue[];
  Phase2DHGroupNumbers?: Phase2DHGroupNumbersRequestListValue[];
  IKEVersions?: IKEVersionsRequestListValue[];
  StartupAction?: string;
  LogOptions?: VpnTunnelLogOptionsSpecification;
}
export interface ModifyVpnTunnelOptionsRequest {
  VpnConnectionId: string | undefined;
  VpnTunnelOutsideIpAddress: string | undefined;
  TunnelOptions: ModifyVpnTunnelOptionsSpecification | undefined;
  DryRun?: boolean;
}
export interface ModifyVpnTunnelOptionsResult {
  VpnConnection?: VpnConnection;
}
export interface MonitorInstancesRequest {
  InstanceIds: string[] | undefined;
  DryRun?: boolean;
}
export interface InstanceMonitoring {
  InstanceId?: string;
  Monitoring?: Monitoring;
}
export interface MonitorInstancesResult {
  InstanceMonitorings?: InstanceMonitoring[];
}
export interface MoveAddressToVpcRequest {
  DryRun?: boolean;
  PublicIp: string | undefined;
}
export declare enum Status {
  inClassic = "InClassic",
  inVpc = "InVpc",
  moveInProgress = "MoveInProgress",
}
export interface MoveAddressToVpcResult {
  AllocationId?: string;
  Status?: Status | string;
}
export interface MoveByoipCidrToIpamRequest {
  DryRun?: boolean;
  Cidr: string | undefined;
  IpamPoolId: string | undefined;
  IpamPoolOwner: string | undefined;
}
export interface MoveByoipCidrToIpamResult {
  ByoipCidr?: ByoipCidr;
}
export interface CidrAuthorizationContext {
  Message: string | undefined;
  Signature: string | undefined;
}
export interface ProvisionByoipCidrRequest {
  Cidr: string | undefined;
  CidrAuthorizationContext?: CidrAuthorizationContext;
  PubliclyAdvertisable?: boolean;
  Description?: string;
  DryRun?: boolean;
  PoolTagSpecifications?: TagSpecification[];
  MultiRegion?: boolean;
}
export interface ProvisionByoipCidrResult {
  ByoipCidr?: ByoipCidr;
}
export interface IpamCidrAuthorizationContext {
  Message?: string;
  Signature?: string;
}
export interface ProvisionIpamPoolCidrRequest {
  DryRun?: boolean;
  IpamPoolId: string | undefined;
  Cidr?: string;
  CidrAuthorizationContext?: IpamCidrAuthorizationContext;
}
export interface ProvisionIpamPoolCidrResult {
  IpamPoolCidr?: IpamPoolCidr;
}
export interface ProvisionPublicIpv4PoolCidrRequest {
  DryRun?: boolean;
  IpamPoolId: string | undefined;
  PoolId: string | undefined;
  NetmaskLength: number | undefined;
}
export interface ProvisionPublicIpv4PoolCidrResult {
  PoolId?: string;
  PoolAddressRange?: PublicIpv4PoolRange;
}
export interface PurchaseHostReservationRequest {
  ClientToken?: string;
  CurrencyCode?: CurrencyCodeValues | string;
  HostIdSet: string[] | undefined;
  LimitPrice?: string;
  OfferingId: string | undefined;
  TagSpecifications?: TagSpecification[];
}
export interface PurchaseHostReservationResult {
  ClientToken?: string;
  CurrencyCode?: CurrencyCodeValues | string;
  Purchase?: Purchase[];
  TotalHourlyPrice?: string;
  TotalUpfrontPrice?: string;
}
export interface ReservedInstanceLimitPrice {
  Amount?: number;
  CurrencyCode?: CurrencyCodeValues | string;
}
export interface PurchaseReservedInstancesOfferingRequest {
  InstanceCount: number | undefined;
  ReservedInstancesOfferingId: string | undefined;
  DryRun?: boolean;
  LimitPrice?: ReservedInstanceLimitPrice;
  PurchaseTime?: Date;
}
export interface PurchaseReservedInstancesOfferingResult {
  ReservedInstancesId?: string;
}
export interface PurchaseRequest {
  InstanceCount: number | undefined;
  PurchaseToken: string | undefined;
}
export interface PurchaseScheduledInstancesRequest {
  ClientToken?: string;
  DryRun?: boolean;
  PurchaseRequests: PurchaseRequest[] | undefined;
}
export interface PurchaseScheduledInstancesResult {
  ScheduledInstanceSet?: ScheduledInstance[];
}
export interface RebootInstancesRequest {
  InstanceIds: string[] | undefined;
  DryRun?: boolean;
}
export interface RegisterImageRequest {
  ImageLocation?: string;
  Architecture?: ArchitectureValues | string;
  BlockDeviceMappings?: BlockDeviceMapping[];
  Description?: string;
  DryRun?: boolean;
  EnaSupport?: boolean;
  KernelId?: string;
  Name: string | undefined;
  BillingProducts?: string[];
  RamdiskId?: string;
  RootDeviceName?: string;
  SriovNetSupport?: string;
  VirtualizationType?: string;
  BootMode?: BootModeValues | string;
  TpmSupport?: TpmSupportValues | string;
  UefiData?: string;
  ImdsSupport?: ImdsSupportValues | string;
}
export interface RegisterImageResult {
  ImageId?: string;
}
export interface RegisterInstanceTagAttributeRequest {
  IncludeAllTagsOfInstance?: boolean;
  InstanceTagKeys?: string[];
}
export interface RegisterInstanceEventNotificationAttributesRequest {
  DryRun?: boolean;
  InstanceTagAttribute?: RegisterInstanceTagAttributeRequest;
}
export interface RegisterInstanceEventNotificationAttributesResult {
  InstanceTagAttribute?: InstanceTagNotificationAttribute;
}
export interface RegisterTransitGatewayMulticastGroupMembersRequest {
  TransitGatewayMulticastDomainId?: string;
  GroupIpAddress?: string;
  NetworkInterfaceIds?: string[];
  DryRun?: boolean;
}
export interface TransitGatewayMulticastRegisteredGroupMembers {
  TransitGatewayMulticastDomainId?: string;
  RegisteredNetworkInterfaceIds?: string[];
  GroupIpAddress?: string;
}
export interface RegisterTransitGatewayMulticastGroupMembersResult {
  RegisteredMulticastGroupMembers?: TransitGatewayMulticastRegisteredGroupMembers;
}
export interface RegisterTransitGatewayMulticastGroupSourcesRequest {
  TransitGatewayMulticastDomainId?: string;
  GroupIpAddress?: string;
  NetworkInterfaceIds?: string[];
  DryRun?: boolean;
}
export interface TransitGatewayMulticastRegisteredGroupSources {
  TransitGatewayMulticastDomainId?: string;
  RegisteredNetworkInterfaceIds?: string[];
  GroupIpAddress?: string;
}
export interface RegisterTransitGatewayMulticastGroupSourcesResult {
  RegisteredMulticastGroupSources?: TransitGatewayMulticastRegisteredGroupSources;
}
export interface RejectTransitGatewayMulticastDomainAssociationsRequest {
  TransitGatewayMulticastDomainId?: string;
  TransitGatewayAttachmentId?: string;
  SubnetIds?: string[];
  DryRun?: boolean;
}
export interface RejectTransitGatewayMulticastDomainAssociationsResult {
  Associations?: TransitGatewayMulticastDomainAssociations;
}
export interface RejectTransitGatewayPeeringAttachmentRequest {
  TransitGatewayAttachmentId: string | undefined;
  DryRun?: boolean;
}
export interface RejectTransitGatewayPeeringAttachmentResult {
  TransitGatewayPeeringAttachment?: TransitGatewayPeeringAttachment;
}
export interface RejectTransitGatewayVpcAttachmentRequest {
  TransitGatewayAttachmentId: string | undefined;
  DryRun?: boolean;
}
export interface RejectTransitGatewayVpcAttachmentResult {
  TransitGatewayVpcAttachment?: TransitGatewayVpcAttachment;
}
export interface RejectVpcEndpointConnectionsRequest {
  DryRun?: boolean;
  ServiceId: string | undefined;
  VpcEndpointIds: string[] | undefined;
}
export interface RejectVpcEndpointConnectionsResult {
  Unsuccessful?: UnsuccessfulItem[];
}
export interface RejectVpcPeeringConnectionRequest {
  DryRun?: boolean;
  VpcPeeringConnectionId: string | undefined;
}
export interface RejectVpcPeeringConnectionResult {
  Return?: boolean;
}
export interface ReleaseAddressRequest {
  AllocationId?: string;
  PublicIp?: string;
  NetworkBorderGroup?: string;
  DryRun?: boolean;
}
export interface ReleaseHostsRequest {
  HostIds: string[] | undefined;
}
export interface ReleaseHostsResult {
  Successful?: string[];
  Unsuccessful?: UnsuccessfulItem[];
}
export interface ReleaseIpamPoolAllocationRequest {
  DryRun?: boolean;
  IpamPoolId: string | undefined;
  Cidr: string | undefined;
  IpamPoolAllocationId: string | undefined;
}
export interface ReleaseIpamPoolAllocationResult {
  Success?: boolean;
}
export interface ReplaceIamInstanceProfileAssociationRequest {
  IamInstanceProfile: IamInstanceProfileSpecification | undefined;
  AssociationId: string | undefined;
}
export interface ReplaceIamInstanceProfileAssociationResult {
  IamInstanceProfileAssociation?: IamInstanceProfileAssociation;
}
export interface ReplaceNetworkAclAssociationRequest {
  AssociationId: string | undefined;
  DryRun?: boolean;
  NetworkAclId: string | undefined;
}
export interface ReplaceNetworkAclAssociationResult {
  NewAssociationId?: string;
}
export interface ReplaceNetworkAclEntryRequest {
  CidrBlock?: string;
  DryRun?: boolean;
  Egress: boolean | undefined;
  IcmpTypeCode?: IcmpTypeCode;
  Ipv6CidrBlock?: string;
  NetworkAclId: string | undefined;
  PortRange?: PortRange;
  Protocol: string | undefined;
  RuleAction: RuleAction | string | undefined;
  RuleNumber: number | undefined;
}
export interface ReplaceRouteRequest {
  DestinationCidrBlock?: string;
  DestinationIpv6CidrBlock?: string;
  DestinationPrefixListId?: string;
  DryRun?: boolean;
  VpcEndpointId?: string;
  EgressOnlyInternetGatewayId?: string;
  GatewayId?: string;
  InstanceId?: string;
  LocalTarget?: boolean;
  NatGatewayId?: string;
  TransitGatewayId?: string;
  LocalGatewayId?: string;
  CarrierGatewayId?: string;
  NetworkInterfaceId?: string;
  RouteTableId: string | undefined;
  VpcPeeringConnectionId?: string;
  CoreNetworkArn?: string;
}
export interface ReplaceRouteTableAssociationRequest {
  AssociationId: string | undefined;
  DryRun?: boolean;
  RouteTableId: string | undefined;
}
export interface ReplaceRouteTableAssociationResult {
  NewAssociationId?: string;
  AssociationState?: RouteTableAssociationState;
}
export interface ReplaceTransitGatewayRouteRequest {
  DestinationCidrBlock: string | undefined;
  TransitGatewayRouteTableId: string | undefined;
  TransitGatewayAttachmentId?: string;
  Blackhole?: boolean;
  DryRun?: boolean;
}
export interface ReplaceTransitGatewayRouteResult {
  Route?: TransitGatewayRoute;
}
export declare enum ReportInstanceReasonCodes {
  instance_stuck_in_state = "instance-stuck-in-state",
  not_accepting_credentials = "not-accepting-credentials",
  other = "other",
  password_not_available = "password-not-available",
  performance_ebs_volume = "performance-ebs-volume",
  performance_instance_store = "performance-instance-store",
  performance_network = "performance-network",
  performance_other = "performance-other",
  unresponsive = "unresponsive",
}
export declare enum ReportStatusType {
  impaired = "impaired",
  ok = "ok",
}
export interface ReportInstanceStatusRequest {
  Description?: string;
  DryRun?: boolean;
  EndTime?: Date;
  Instances: string[] | undefined;
  ReasonCodes: (ReportInstanceReasonCodes | string)[] | undefined;
  StartTime?: Date;
  Status: ReportStatusType | string | undefined;
}
export interface RequestSpotFleetRequest {
  DryRun?: boolean;
  SpotFleetRequestConfig: SpotFleetRequestConfigData | undefined;
}
export interface RequestSpotFleetResponse {
  SpotFleetRequestId?: string;
}
export interface RequestSpotLaunchSpecification {
  SecurityGroupIds?: string[];
  SecurityGroups?: string[];
  AddressingType?: string;
  BlockDeviceMappings?: BlockDeviceMapping[];
  EbsOptimized?: boolean;
  IamInstanceProfile?: IamInstanceProfileSpecification;
  ImageId?: string;
  InstanceType?: _InstanceType | string;
  KernelId?: string;
  KeyName?: string;
  Monitoring?: RunInstancesMonitoringEnabled;
  NetworkInterfaces?: InstanceNetworkInterfaceSpecification[];
  Placement?: SpotPlacement;
  RamdiskId?: string;
  SubnetId?: string;
  UserData?: string;
}
export interface RequestSpotInstancesRequest {
  AvailabilityZoneGroup?: string;
  BlockDurationMinutes?: number;
  ClientToken?: string;
  DryRun?: boolean;
  InstanceCount?: number;
  LaunchGroup?: string;
  LaunchSpecification?: RequestSpotLaunchSpecification;
  SpotPrice?: string;
  Type?: SpotInstanceType | string;
  ValidFrom?: Date;
  ValidUntil?: Date;
  TagSpecifications?: TagSpecification[];
  InstanceInterruptionBehavior?: InstanceInterruptionBehavior | string;
}
export interface RequestSpotInstancesResult {
  SpotInstanceRequests?: SpotInstanceRequest[];
}
export interface ResetAddressAttributeRequest {
  AllocationId: string | undefined;
  Attribute: AddressAttributeName | string | undefined;
  DryRun?: boolean;
}
export interface ResetAddressAttributeResult {
  Address?: AddressAttribute;
}
export interface ResetEbsDefaultKmsKeyIdRequest {
  DryRun?: boolean;
}
export interface ResetEbsDefaultKmsKeyIdResult {
  KmsKeyId?: string;
}
export declare enum ResetFpgaImageAttributeName {
  loadPermission = "loadPermission",
}
export interface ResetFpgaImageAttributeRequest {
  DryRun?: boolean;
  FpgaImageId: string | undefined;
  Attribute?: ResetFpgaImageAttributeName | string;
}
export interface ResetFpgaImageAttributeResult {
  Return?: boolean;
}
export declare enum ResetImageAttributeName {
  launchPermission = "launchPermission",
}
export interface ResetImageAttributeRequest {
  Attribute: ResetImageAttributeName | string | undefined;
  ImageId: string | undefined;
  DryRun?: boolean;
}
export interface ResetInstanceAttributeRequest {
  Attribute: InstanceAttributeName | string | undefined;
  DryRun?: boolean;
  InstanceId: string | undefined;
}
export interface ResetNetworkInterfaceAttributeRequest {
  DryRun?: boolean;
  NetworkInterfaceId: string | undefined;
  SourceDestCheck?: string;
}
export interface ResetSnapshotAttributeRequest {
  Attribute: SnapshotAttributeName | string | undefined;
  SnapshotId: string | undefined;
  DryRun?: boolean;
}
export interface RestoreAddressToClassicRequest {
  DryRun?: boolean;
  PublicIp: string | undefined;
}
export interface RestoreAddressToClassicResult {
  PublicIp?: string;
  Status?: Status | string;
}
export interface RestoreImageFromRecycleBinRequest {
  ImageId: string | undefined;
  DryRun?: boolean;
}
export interface RestoreImageFromRecycleBinResult {
  Return?: boolean;
}
export interface RestoreManagedPrefixListVersionRequest {
  DryRun?: boolean;
  PrefixListId: string | undefined;
  PreviousVersion: number | undefined;
  CurrentVersion: number | undefined;
}
export interface RestoreManagedPrefixListVersionResult {
  PrefixList?: ManagedPrefixList;
}
export interface RestoreSnapshotFromRecycleBinRequest {
  SnapshotId: string | undefined;
  DryRun?: boolean;
}
export interface RestoreSnapshotFromRecycleBinResult {
  SnapshotId?: string;
  OutpostArn?: string;
  Description?: string;
  Encrypted?: boolean;
  OwnerId?: string;
  Progress?: string;
  StartTime?: Date;
  State?: SnapshotState | string;
  VolumeId?: string;
  VolumeSize?: number;
}
export interface RestoreSnapshotTierRequest {
  SnapshotId: string | undefined;
  TemporaryRestoreDays?: number;
  PermanentRestore?: boolean;
  DryRun?: boolean;
}
export interface RestoreSnapshotTierResult {
  SnapshotId?: string;
  RestoreStartTime?: Date;
  RestoreDuration?: number;
  IsPermanentRestore?: boolean;
}
export interface RevokeClientVpnIngressRequest {
  ClientVpnEndpointId: string | undefined;
  TargetNetworkCidr: string | undefined;
  AccessGroupId?: string;
  RevokeAllGroups?: boolean;
  DryRun?: boolean;
}
export interface RevokeClientVpnIngressResult {
  Status?: ClientVpnAuthorizationRuleStatus;
}
export interface RevokeSecurityGroupEgressRequest {
  DryRun?: boolean;
  GroupId: string | undefined;
  IpPermissions?: IpPermission[];
  SecurityGroupRuleIds?: string[];
  CidrIp?: string;
  FromPort?: number;
  IpProtocol?: string;
  ToPort?: number;
  SourceSecurityGroupName?: string;
  SourceSecurityGroupOwnerId?: string;
}
export interface RevokeSecurityGroupEgressResult {
  Return?: boolean;
  UnknownIpPermissions?: IpPermission[];
}
export interface RevokeSecurityGroupIngressRequest {
  CidrIp?: string;
  FromPort?: number;
  GroupId?: string;
  GroupName?: string;
  IpPermissions?: IpPermission[];
  IpProtocol?: string;
  SourceSecurityGroupName?: string;
  SourceSecurityGroupOwnerId?: string;
  ToPort?: number;
  DryRun?: boolean;
  SecurityGroupRuleIds?: string[];
}
export interface RevokeSecurityGroupIngressResult {
  Return?: boolean;
  UnknownIpPermissions?: IpPermission[];
}
export interface CpuOptionsRequest {
  CoreCount?: number;
  ThreadsPerCore?: number;
}
export interface ElasticInferenceAccelerator {
  Type: string | undefined;
  Count?: number;
}
export interface EnclaveOptionsRequest {
  Enabled?: boolean;
}
export interface HibernationOptionsRequest {
  Configured?: boolean;
}
export interface SpotMarketOptions {
  MaxPrice?: string;
  SpotInstanceType?: SpotInstanceType | string;
  BlockDurationMinutes?: number;
  ValidUntil?: Date;
  InstanceInterruptionBehavior?: InstanceInterruptionBehavior | string;
}
export interface InstanceMarketOptionsRequest {
  MarketType?: MarketType | string;
  SpotOptions?: SpotMarketOptions;
}
export interface LaunchTemplateSpecification {
  LaunchTemplateId?: string;
  LaunchTemplateName?: string;
  Version?: string;
}
export interface LicenseConfigurationRequest {
  LicenseConfigurationArn?: string;
}
export interface InstanceMaintenanceOptionsRequest {
  AutoRecovery?: InstanceAutoRecoveryState | string;
}
export interface InstanceMetadataOptionsRequest {
  HttpTokens?: HttpTokensState | string;
  HttpPutResponseHopLimit?: number;
  HttpEndpoint?: InstanceMetadataEndpointState | string;
  HttpProtocolIpv6?: InstanceMetadataProtocolState | string;
  InstanceMetadataTags?: InstanceMetadataTagsState | string;
}
export interface PrivateDnsNameOptionsRequest {
  HostnameType?: HostnameType | string;
  EnableResourceNameDnsARecord?: boolean;
  EnableResourceNameDnsAAAARecord?: boolean;
}
export interface RunInstancesRequest {
  BlockDeviceMappings?: BlockDeviceMapping[];
  ImageId?: string;
  InstanceType?: _InstanceType | string;
  Ipv6AddressCount?: number;
  Ipv6Addresses?: InstanceIpv6Address[];
  KernelId?: string;
  KeyName?: string;
  MaxCount: number | undefined;
  MinCount: number | undefined;
  Monitoring?: RunInstancesMonitoringEnabled;
  Placement?: Placement;
  RamdiskId?: string;
  SecurityGroupIds?: string[];
  SecurityGroups?: string[];
  SubnetId?: string;
  UserData?: string;
  AdditionalInfo?: string;
  ClientToken?: string;
  DisableApiTermination?: boolean;
  DryRun?: boolean;
  EbsOptimized?: boolean;
  IamInstanceProfile?: IamInstanceProfileSpecification;
  InstanceInitiatedShutdownBehavior?: ShutdownBehavior | string;
  NetworkInterfaces?: InstanceNetworkInterfaceSpecification[];
  PrivateIpAddress?: string;
  ElasticGpuSpecification?: ElasticGpuSpecification[];
  ElasticInferenceAccelerators?: ElasticInferenceAccelerator[];
  TagSpecifications?: TagSpecification[];
  LaunchTemplate?: LaunchTemplateSpecification;
  InstanceMarketOptions?: InstanceMarketOptionsRequest;
  CreditSpecification?: CreditSpecificationRequest;
  CpuOptions?: CpuOptionsRequest;
  CapacityReservationSpecification?: CapacityReservationSpecification;
  HibernationOptions?: HibernationOptionsRequest;
  LicenseSpecifications?: LicenseConfigurationRequest[];
  MetadataOptions?: InstanceMetadataOptionsRequest;
  EnclaveOptions?: EnclaveOptionsRequest;
  PrivateDnsNameOptions?: PrivateDnsNameOptionsRequest;
  MaintenanceOptions?: InstanceMaintenanceOptionsRequest;
  DisableApiStop?: boolean;
}
export interface ScheduledInstancesEbs {
  DeleteOnTermination?: boolean;
  Encrypted?: boolean;
  Iops?: number;
  SnapshotId?: string;
  VolumeSize?: number;
  VolumeType?: string;
}
export interface ScheduledInstancesBlockDeviceMapping {
  DeviceName?: string;
  Ebs?: ScheduledInstancesEbs;
  NoDevice?: string;
  VirtualName?: string;
}
export interface ScheduledInstancesIamInstanceProfile {
  Arn?: string;
  Name?: string;
}
export interface ScheduledInstancesMonitoring {
  Enabled?: boolean;
}
export interface ScheduledInstancesIpv6Address {
  Ipv6Address?: string;
}
export interface ScheduledInstancesPrivateIpAddressConfig {
  Primary?: boolean;
  PrivateIpAddress?: string;
}
export interface ScheduledInstancesNetworkInterface {
  AssociatePublicIpAddress?: boolean;
  DeleteOnTermination?: boolean;
  Description?: string;
  DeviceIndex?: number;
  Groups?: string[];
  Ipv6AddressCount?: number;
  Ipv6Addresses?: ScheduledInstancesIpv6Address[];
  NetworkInterfaceId?: string;
  PrivateIpAddress?: string;
  PrivateIpAddressConfigs?: ScheduledInstancesPrivateIpAddressConfig[];
  SecondaryPrivateIpAddressCount?: number;
  SubnetId?: string;
}
export interface ScheduledInstancesPlacement {
  AvailabilityZone?: string;
  GroupName?: string;
}
export interface ScheduledInstancesLaunchSpecification {
  BlockDeviceMappings?: ScheduledInstancesBlockDeviceMapping[];
  EbsOptimized?: boolean;
  IamInstanceProfile?: ScheduledInstancesIamInstanceProfile;
  ImageId: string | undefined;
  InstanceType?: string;
  KernelId?: string;
  KeyName?: string;
  Monitoring?: ScheduledInstancesMonitoring;
  NetworkInterfaces?: ScheduledInstancesNetworkInterface[];
  Placement?: ScheduledInstancesPlacement;
  RamdiskId?: string;
  SecurityGroupIds?: string[];
  SubnetId?: string;
  UserData?: string;
}
export interface RunScheduledInstancesRequest {
  ClientToken?: string;
  DryRun?: boolean;
  InstanceCount?: number;
  LaunchSpecification: ScheduledInstancesLaunchSpecification | undefined;
  ScheduledInstanceId: string | undefined;
}
export interface RunScheduledInstancesResult {
  InstanceIdSet?: string[];
}
export interface SearchLocalGatewayRoutesRequest {
  LocalGatewayRouteTableId: string | undefined;
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
}
export interface SearchLocalGatewayRoutesResult {
  Routes?: LocalGatewayRoute[];
  NextToken?: string;
}
export interface SearchTransitGatewayMulticastGroupsRequest {
  TransitGatewayMulticastDomainId?: string;
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
}
export declare enum MembershipType {
  igmp = "igmp",
  static = "static",
}
export interface TransitGatewayMulticastGroup {
  GroupIpAddress?: string;
  TransitGatewayAttachmentId?: string;
  SubnetId?: string;
  ResourceId?: string;
  ResourceType?: TransitGatewayAttachmentResourceType | string;
  ResourceOwnerId?: string;
  NetworkInterfaceId?: string;
  GroupMember?: boolean;
  GroupSource?: boolean;
  MemberType?: MembershipType | string;
  SourceType?: MembershipType | string;
}
export interface SearchTransitGatewayMulticastGroupsResult {
  MulticastGroups?: TransitGatewayMulticastGroup[];
  NextToken?: string;
}
export interface SearchTransitGatewayRoutesRequest {
  TransitGatewayRouteTableId: string | undefined;
  Filters: Filter[] | undefined;
  MaxResults?: number;
  DryRun?: boolean;
}
export interface SearchTransitGatewayRoutesResult {
  Routes?: TransitGatewayRoute[];
  AdditionalRoutesAvailable?: boolean;
}
export interface SendDiagnosticInterruptRequest {
  InstanceId: string | undefined;
  DryRun?: boolean;
}
export interface StartInstancesRequest {
  InstanceIds: string[] | undefined;
  AdditionalInfo?: string;
  DryRun?: boolean;
}
export interface InstanceStateChange {
  CurrentState?: InstanceState;
  InstanceId?: string;
  PreviousState?: InstanceState;
}
export interface StartInstancesResult {
  StartingInstances?: InstanceStateChange[];
}
export interface StartNetworkInsightsAccessScopeAnalysisRequest {
  NetworkInsightsAccessScopeId: string | undefined;
  DryRun?: boolean;
  TagSpecifications?: TagSpecification[];
  ClientToken?: string;
}
export interface StartNetworkInsightsAccessScopeAnalysisResult {
  NetworkInsightsAccessScopeAnalysis?: NetworkInsightsAccessScopeAnalysis;
}
export interface StartNetworkInsightsAnalysisRequest {
  NetworkInsightsPathId: string | undefined;
  AdditionalAccounts?: string[];
  FilterInArns?: string[];
  DryRun?: boolean;
  TagSpecifications?: TagSpecification[];
  ClientToken?: string;
}
export interface StartNetworkInsightsAnalysisResult {
  NetworkInsightsAnalysis?: NetworkInsightsAnalysis;
}
export interface StartVpcEndpointServicePrivateDnsVerificationRequest {
  DryRun?: boolean;
  ServiceId: string | undefined;
}
export interface StartVpcEndpointServicePrivateDnsVerificationResult {
  ReturnValue?: boolean;
}
export interface StopInstancesRequest {
  InstanceIds: string[] | undefined;
  Hibernate?: boolean;
  DryRun?: boolean;
  Force?: boolean;
}
export interface StopInstancesResult {
  StoppingInstances?: InstanceStateChange[];
}
export interface TerminateClientVpnConnectionsRequest {
  ClientVpnEndpointId: string | undefined;
  ConnectionId?: string;
  Username?: string;
  DryRun?: boolean;
}
export interface TerminateConnectionStatus {
  ConnectionId?: string;
  PreviousStatus?: ClientVpnConnectionStatus;
  CurrentStatus?: ClientVpnConnectionStatus;
}
export interface TerminateClientVpnConnectionsResult {
  ClientVpnEndpointId?: string;
  Username?: string;
  ConnectionStatuses?: TerminateConnectionStatus[];
}
export interface TerminateInstancesRequest {
  InstanceIds: string[] | undefined;
  DryRun?: boolean;
}
export interface TerminateInstancesResult {
  TerminatingInstances?: InstanceStateChange[];
}
export interface UnassignIpv6AddressesRequest {
  Ipv6Addresses?: string[];
  Ipv6Prefixes?: string[];
  NetworkInterfaceId: string | undefined;
}
export interface UnassignIpv6AddressesResult {
  NetworkInterfaceId?: string;
  UnassignedIpv6Addresses?: string[];
  UnassignedIpv6Prefixes?: string[];
}
export interface UnassignPrivateIpAddressesRequest {
  NetworkInterfaceId: string | undefined;
  PrivateIpAddresses?: string[];
  Ipv4Prefixes?: string[];
}
export interface UnmonitorInstancesRequest {
  InstanceIds: string[] | undefined;
  DryRun?: boolean;
}
export interface UnmonitorInstancesResult {
  InstanceMonitorings?: InstanceMonitoring[];
}
export interface SecurityGroupRuleDescription {
  SecurityGroupRuleId?: string;
  Description?: string;
}
export interface UpdateSecurityGroupRuleDescriptionsEgressRequest {
  DryRun?: boolean;
  GroupId?: string;
  GroupName?: string;
  IpPermissions?: IpPermission[];
  SecurityGroupRuleDescriptions?: SecurityGroupRuleDescription[];
}
export interface UpdateSecurityGroupRuleDescriptionsEgressResult {
  Return?: boolean;
}
export interface UpdateSecurityGroupRuleDescriptionsIngressRequest {
  DryRun?: boolean;
  GroupId?: string;
  GroupName?: string;
  IpPermissions?: IpPermission[];
  SecurityGroupRuleDescriptions?: SecurityGroupRuleDescription[];
}
export interface UpdateSecurityGroupRuleDescriptionsIngressResult {
  Return?: boolean;
}
export interface WithdrawByoipCidrRequest {
  Cidr: string | undefined;
  DryRun?: boolean;
}
export interface WithdrawByoipCidrResult {
  ByoipCidr?: ByoipCidr;
}
export declare const InstanceCreditSpecificationRequestFilterSensitiveLog: (
  obj: InstanceCreditSpecificationRequest
) => any;
export declare const ModifyInstanceCreditSpecificationRequestFilterSensitiveLog: (
  obj: ModifyInstanceCreditSpecificationRequest
) => any;
export declare const SuccessfulInstanceCreditSpecificationItemFilterSensitiveLog: (
  obj: SuccessfulInstanceCreditSpecificationItem
) => any;
export declare const UnsuccessfulInstanceCreditSpecificationItemErrorFilterSensitiveLog: (
  obj: UnsuccessfulInstanceCreditSpecificationItemError
) => any;
export declare const UnsuccessfulInstanceCreditSpecificationItemFilterSensitiveLog: (
  obj: UnsuccessfulInstanceCreditSpecificationItem
) => any;
export declare const ModifyInstanceCreditSpecificationResultFilterSensitiveLog: (
  obj: ModifyInstanceCreditSpecificationResult
) => any;
export declare const ModifyInstanceEventStartTimeRequestFilterSensitiveLog: (
  obj: ModifyInstanceEventStartTimeRequest
) => any;
export declare const ModifyInstanceEventStartTimeResultFilterSensitiveLog: (
  obj: ModifyInstanceEventStartTimeResult
) => any;
export declare const ModifyInstanceEventWindowRequestFilterSensitiveLog: (
  obj: ModifyInstanceEventWindowRequest
) => any;
export declare const ModifyInstanceEventWindowResultFilterSensitiveLog: (
  obj: ModifyInstanceEventWindowResult
) => any;
export declare const ModifyInstanceMaintenanceOptionsRequestFilterSensitiveLog: (
  obj: ModifyInstanceMaintenanceOptionsRequest
) => any;
export declare const ModifyInstanceMaintenanceOptionsResultFilterSensitiveLog: (
  obj: ModifyInstanceMaintenanceOptionsResult
) => any;
export declare const ModifyInstanceMetadataOptionsRequestFilterSensitiveLog: (
  obj: ModifyInstanceMetadataOptionsRequest
) => any;
export declare const ModifyInstanceMetadataOptionsResultFilterSensitiveLog: (
  obj: ModifyInstanceMetadataOptionsResult
) => any;
export declare const ModifyInstancePlacementRequestFilterSensitiveLog: (
  obj: ModifyInstancePlacementRequest
) => any;
export declare const ModifyInstancePlacementResultFilterSensitiveLog: (
  obj: ModifyInstancePlacementResult
) => any;
export declare const RemoveIpamOperatingRegionFilterSensitiveLog: (
  obj: RemoveIpamOperatingRegion
) => any;
export declare const ModifyIpamRequestFilterSensitiveLog: (
  obj: ModifyIpamRequest
) => any;
export declare const ModifyIpamResultFilterSensitiveLog: (
  obj: ModifyIpamResult
) => any;
export declare const ModifyIpamPoolRequestFilterSensitiveLog: (
  obj: ModifyIpamPoolRequest
) => any;
export declare const ModifyIpamPoolResultFilterSensitiveLog: (
  obj: ModifyIpamPoolResult
) => any;
export declare const ModifyIpamResourceCidrRequestFilterSensitiveLog: (
  obj: ModifyIpamResourceCidrRequest
) => any;
export declare const ModifyIpamResourceCidrResultFilterSensitiveLog: (
  obj: ModifyIpamResourceCidrResult
) => any;
export declare const ModifyIpamScopeRequestFilterSensitiveLog: (
  obj: ModifyIpamScopeRequest
) => any;
export declare const ModifyIpamScopeResultFilterSensitiveLog: (
  obj: ModifyIpamScopeResult
) => any;
export declare const ModifyLaunchTemplateRequestFilterSensitiveLog: (
  obj: ModifyLaunchTemplateRequest
) => any;
export declare const ModifyLaunchTemplateResultFilterSensitiveLog: (
  obj: ModifyLaunchTemplateResult
) => any;
export declare const ModifyLocalGatewayRouteRequestFilterSensitiveLog: (
  obj: ModifyLocalGatewayRouteRequest
) => any;
export declare const ModifyLocalGatewayRouteResultFilterSensitiveLog: (
  obj: ModifyLocalGatewayRouteResult
) => any;
export declare const RemovePrefixListEntryFilterSensitiveLog: (
  obj: RemovePrefixListEntry
) => any;
export declare const ModifyManagedPrefixListRequestFilterSensitiveLog: (
  obj: ModifyManagedPrefixListRequest
) => any;
export declare const ModifyManagedPrefixListResultFilterSensitiveLog: (
  obj: ModifyManagedPrefixListResult
) => any;
export declare const NetworkInterfaceAttachmentChangesFilterSensitiveLog: (
  obj: NetworkInterfaceAttachmentChanges
) => any;
export declare const ModifyNetworkInterfaceAttributeRequestFilterSensitiveLog: (
  obj: ModifyNetworkInterfaceAttributeRequest
) => any;
export declare const ModifyPrivateDnsNameOptionsRequestFilterSensitiveLog: (
  obj: ModifyPrivateDnsNameOptionsRequest
) => any;
export declare const ModifyPrivateDnsNameOptionsResultFilterSensitiveLog: (
  obj: ModifyPrivateDnsNameOptionsResult
) => any;
export declare const ModifyReservedInstancesRequestFilterSensitiveLog: (
  obj: ModifyReservedInstancesRequest
) => any;
export declare const ModifyReservedInstancesResultFilterSensitiveLog: (
  obj: ModifyReservedInstancesResult
) => any;
export declare const SecurityGroupRuleRequestFilterSensitiveLog: (
  obj: SecurityGroupRuleRequest
) => any;
export declare const SecurityGroupRuleUpdateFilterSensitiveLog: (
  obj: SecurityGroupRuleUpdate
) => any;
export declare const ModifySecurityGroupRulesRequestFilterSensitiveLog: (
  obj: ModifySecurityGroupRulesRequest
) => any;
export declare const ModifySecurityGroupRulesResultFilterSensitiveLog: (
  obj: ModifySecurityGroupRulesResult
) => any;
export declare const CreateVolumePermissionModificationsFilterSensitiveLog: (
  obj: CreateVolumePermissionModifications
) => any;
export declare const ModifySnapshotAttributeRequestFilterSensitiveLog: (
  obj: ModifySnapshotAttributeRequest
) => any;
export declare const ModifySnapshotTierRequestFilterSensitiveLog: (
  obj: ModifySnapshotTierRequest
) => any;
export declare const ModifySnapshotTierResultFilterSensitiveLog: (
  obj: ModifySnapshotTierResult
) => any;
export declare const ModifySpotFleetRequestRequestFilterSensitiveLog: (
  obj: ModifySpotFleetRequestRequest
) => any;
export declare const ModifySpotFleetRequestResponseFilterSensitiveLog: (
  obj: ModifySpotFleetRequestResponse
) => any;
export declare const ModifySubnetAttributeRequestFilterSensitiveLog: (
  obj: ModifySubnetAttributeRequest
) => any;
export declare const ModifyTrafficMirrorFilterNetworkServicesRequestFilterSensitiveLog: (
  obj: ModifyTrafficMirrorFilterNetworkServicesRequest
) => any;
export declare const ModifyTrafficMirrorFilterNetworkServicesResultFilterSensitiveLog: (
  obj: ModifyTrafficMirrorFilterNetworkServicesResult
) => any;
export declare const ModifyTrafficMirrorFilterRuleRequestFilterSensitiveLog: (
  obj: ModifyTrafficMirrorFilterRuleRequest
) => any;
export declare const ModifyTrafficMirrorFilterRuleResultFilterSensitiveLog: (
  obj: ModifyTrafficMirrorFilterRuleResult
) => any;
export declare const ModifyTrafficMirrorSessionRequestFilterSensitiveLog: (
  obj: ModifyTrafficMirrorSessionRequest
) => any;
export declare const ModifyTrafficMirrorSessionResultFilterSensitiveLog: (
  obj: ModifyTrafficMirrorSessionResult
) => any;
export declare const ModifyTransitGatewayOptionsFilterSensitiveLog: (
  obj: ModifyTransitGatewayOptions
) => any;
export declare const ModifyTransitGatewayRequestFilterSensitiveLog: (
  obj: ModifyTransitGatewayRequest
) => any;
export declare const ModifyTransitGatewayResultFilterSensitiveLog: (
  obj: ModifyTransitGatewayResult
) => any;
export declare const ModifyTransitGatewayPrefixListReferenceRequestFilterSensitiveLog: (
  obj: ModifyTransitGatewayPrefixListReferenceRequest
) => any;
export declare const ModifyTransitGatewayPrefixListReferenceResultFilterSensitiveLog: (
  obj: ModifyTransitGatewayPrefixListReferenceResult
) => any;
export declare const ModifyTransitGatewayVpcAttachmentRequestOptionsFilterSensitiveLog: (
  obj: ModifyTransitGatewayVpcAttachmentRequestOptions
) => any;
export declare const ModifyTransitGatewayVpcAttachmentRequestFilterSensitiveLog: (
  obj: ModifyTransitGatewayVpcAttachmentRequest
) => any;
export declare const ModifyTransitGatewayVpcAttachmentResultFilterSensitiveLog: (
  obj: ModifyTransitGatewayVpcAttachmentResult
) => any;
export declare const ModifyVerifiedAccessEndpointLoadBalancerOptionsFilterSensitiveLog: (
  obj: ModifyVerifiedAccessEndpointLoadBalancerOptions
) => any;
export declare const ModifyVerifiedAccessEndpointEniOptionsFilterSensitiveLog: (
  obj: ModifyVerifiedAccessEndpointEniOptions
) => any;
export declare const ModifyVerifiedAccessEndpointRequestFilterSensitiveLog: (
  obj: ModifyVerifiedAccessEndpointRequest
) => any;
export declare const ModifyVerifiedAccessEndpointResultFilterSensitiveLog: (
  obj: ModifyVerifiedAccessEndpointResult
) => any;
export declare const ModifyVerifiedAccessEndpointPolicyRequestFilterSensitiveLog: (
  obj: ModifyVerifiedAccessEndpointPolicyRequest
) => any;
export declare const ModifyVerifiedAccessEndpointPolicyResultFilterSensitiveLog: (
  obj: ModifyVerifiedAccessEndpointPolicyResult
) => any;
export declare const ModifyVerifiedAccessGroupRequestFilterSensitiveLog: (
  obj: ModifyVerifiedAccessGroupRequest
) => any;
export declare const ModifyVerifiedAccessGroupResultFilterSensitiveLog: (
  obj: ModifyVerifiedAccessGroupResult
) => any;
export declare const ModifyVerifiedAccessGroupPolicyRequestFilterSensitiveLog: (
  obj: ModifyVerifiedAccessGroupPolicyRequest
) => any;
export declare const ModifyVerifiedAccessGroupPolicyResultFilterSensitiveLog: (
  obj: ModifyVerifiedAccessGroupPolicyResult
) => any;
export declare const ModifyVerifiedAccessInstanceRequestFilterSensitiveLog: (
  obj: ModifyVerifiedAccessInstanceRequest
) => any;
export declare const ModifyVerifiedAccessInstanceResultFilterSensitiveLog: (
  obj: ModifyVerifiedAccessInstanceResult
) => any;
export declare const VerifiedAccessLogCloudWatchLogsDestinationOptionsFilterSensitiveLog: (
  obj: VerifiedAccessLogCloudWatchLogsDestinationOptions
) => any;
export declare const VerifiedAccessLogKinesisDataFirehoseDestinationOptionsFilterSensitiveLog: (
  obj: VerifiedAccessLogKinesisDataFirehoseDestinationOptions
) => any;
export declare const VerifiedAccessLogS3DestinationOptionsFilterSensitiveLog: (
  obj: VerifiedAccessLogS3DestinationOptions
) => any;
export declare const VerifiedAccessLogOptionsFilterSensitiveLog: (
  obj: VerifiedAccessLogOptions
) => any;
export declare const ModifyVerifiedAccessInstanceLoggingConfigurationRequestFilterSensitiveLog: (
  obj: ModifyVerifiedAccessInstanceLoggingConfigurationRequest
) => any;
export declare const ModifyVerifiedAccessInstanceLoggingConfigurationResultFilterSensitiveLog: (
  obj: ModifyVerifiedAccessInstanceLoggingConfigurationResult
) => any;
export declare const ModifyVerifiedAccessTrustProviderOidcOptionsFilterSensitiveLog: (
  obj: ModifyVerifiedAccessTrustProviderOidcOptions
) => any;
export declare const ModifyVerifiedAccessTrustProviderRequestFilterSensitiveLog: (
  obj: ModifyVerifiedAccessTrustProviderRequest
) => any;
export declare const ModifyVerifiedAccessTrustProviderResultFilterSensitiveLog: (
  obj: ModifyVerifiedAccessTrustProviderResult
) => any;
export declare const ModifyVolumeRequestFilterSensitiveLog: (
  obj: ModifyVolumeRequest
) => any;
export declare const ModifyVolumeResultFilterSensitiveLog: (
  obj: ModifyVolumeResult
) => any;
export declare const ModifyVolumeAttributeRequestFilterSensitiveLog: (
  obj: ModifyVolumeAttributeRequest
) => any;
export declare const ModifyVpcAttributeRequestFilterSensitiveLog: (
  obj: ModifyVpcAttributeRequest
) => any;
export declare const ModifyVpcEndpointRequestFilterSensitiveLog: (
  obj: ModifyVpcEndpointRequest
) => any;
export declare const ModifyVpcEndpointResultFilterSensitiveLog: (
  obj: ModifyVpcEndpointResult
) => any;
export declare const ModifyVpcEndpointConnectionNotificationRequestFilterSensitiveLog: (
  obj: ModifyVpcEndpointConnectionNotificationRequest
) => any;
export declare const ModifyVpcEndpointConnectionNotificationResultFilterSensitiveLog: (
  obj: ModifyVpcEndpointConnectionNotificationResult
) => any;
export declare const ModifyVpcEndpointServiceConfigurationRequestFilterSensitiveLog: (
  obj: ModifyVpcEndpointServiceConfigurationRequest
) => any;
export declare const ModifyVpcEndpointServiceConfigurationResultFilterSensitiveLog: (
  obj: ModifyVpcEndpointServiceConfigurationResult
) => any;
export declare const ModifyVpcEndpointServicePayerResponsibilityRequestFilterSensitiveLog: (
  obj: ModifyVpcEndpointServicePayerResponsibilityRequest
) => any;
export declare const ModifyVpcEndpointServicePayerResponsibilityResultFilterSensitiveLog: (
  obj: ModifyVpcEndpointServicePayerResponsibilityResult
) => any;
export declare const ModifyVpcEndpointServicePermissionsRequestFilterSensitiveLog: (
  obj: ModifyVpcEndpointServicePermissionsRequest
) => any;
export declare const ModifyVpcEndpointServicePermissionsResultFilterSensitiveLog: (
  obj: ModifyVpcEndpointServicePermissionsResult
) => any;
export declare const PeeringConnectionOptionsRequestFilterSensitiveLog: (
  obj: PeeringConnectionOptionsRequest
) => any;
export declare const ModifyVpcPeeringConnectionOptionsRequestFilterSensitiveLog: (
  obj: ModifyVpcPeeringConnectionOptionsRequest
) => any;
export declare const PeeringConnectionOptionsFilterSensitiveLog: (
  obj: PeeringConnectionOptions
) => any;
export declare const ModifyVpcPeeringConnectionOptionsResultFilterSensitiveLog: (
  obj: ModifyVpcPeeringConnectionOptionsResult
) => any;
export declare const ModifyVpcTenancyRequestFilterSensitiveLog: (
  obj: ModifyVpcTenancyRequest
) => any;
export declare const ModifyVpcTenancyResultFilterSensitiveLog: (
  obj: ModifyVpcTenancyResult
) => any;
export declare const ModifyVpnConnectionRequestFilterSensitiveLog: (
  obj: ModifyVpnConnectionRequest
) => any;
export declare const ModifyVpnConnectionResultFilterSensitiveLog: (
  obj: ModifyVpnConnectionResult
) => any;
export declare const ModifyVpnConnectionOptionsRequestFilterSensitiveLog: (
  obj: ModifyVpnConnectionOptionsRequest
) => any;
export declare const ModifyVpnConnectionOptionsResultFilterSensitiveLog: (
  obj: ModifyVpnConnectionOptionsResult
) => any;
export declare const ModifyVpnTunnelCertificateRequestFilterSensitiveLog: (
  obj: ModifyVpnTunnelCertificateRequest
) => any;
export declare const ModifyVpnTunnelCertificateResultFilterSensitiveLog: (
  obj: ModifyVpnTunnelCertificateResult
) => any;
export declare const ModifyVpnTunnelOptionsSpecificationFilterSensitiveLog: (
  obj: ModifyVpnTunnelOptionsSpecification
) => any;
export declare const ModifyVpnTunnelOptionsRequestFilterSensitiveLog: (
  obj: ModifyVpnTunnelOptionsRequest
) => any;
export declare const ModifyVpnTunnelOptionsResultFilterSensitiveLog: (
  obj: ModifyVpnTunnelOptionsResult
) => any;
export declare const MonitorInstancesRequestFilterSensitiveLog: (
  obj: MonitorInstancesRequest
) => any;
export declare const InstanceMonitoringFilterSensitiveLog: (
  obj: InstanceMonitoring
) => any;
export declare const MonitorInstancesResultFilterSensitiveLog: (
  obj: MonitorInstancesResult
) => any;
export declare const MoveAddressToVpcRequestFilterSensitiveLog: (
  obj: MoveAddressToVpcRequest
) => any;
export declare const MoveAddressToVpcResultFilterSensitiveLog: (
  obj: MoveAddressToVpcResult
) => any;
export declare const MoveByoipCidrToIpamRequestFilterSensitiveLog: (
  obj: MoveByoipCidrToIpamRequest
) => any;
export declare const MoveByoipCidrToIpamResultFilterSensitiveLog: (
  obj: MoveByoipCidrToIpamResult
) => any;
export declare const CidrAuthorizationContextFilterSensitiveLog: (
  obj: CidrAuthorizationContext
) => any;
export declare const ProvisionByoipCidrRequestFilterSensitiveLog: (
  obj: ProvisionByoipCidrRequest
) => any;
export declare const ProvisionByoipCidrResultFilterSensitiveLog: (
  obj: ProvisionByoipCidrResult
) => any;
export declare const IpamCidrAuthorizationContextFilterSensitiveLog: (
  obj: IpamCidrAuthorizationContext
) => any;
export declare const ProvisionIpamPoolCidrRequestFilterSensitiveLog: (
  obj: ProvisionIpamPoolCidrRequest
) => any;
export declare const ProvisionIpamPoolCidrResultFilterSensitiveLog: (
  obj: ProvisionIpamPoolCidrResult
) => any;
export declare const ProvisionPublicIpv4PoolCidrRequestFilterSensitiveLog: (
  obj: ProvisionPublicIpv4PoolCidrRequest
) => any;
export declare const ProvisionPublicIpv4PoolCidrResultFilterSensitiveLog: (
  obj: ProvisionPublicIpv4PoolCidrResult
) => any;
export declare const PurchaseHostReservationRequestFilterSensitiveLog: (
  obj: PurchaseHostReservationRequest
) => any;
export declare const PurchaseHostReservationResultFilterSensitiveLog: (
  obj: PurchaseHostReservationResult
) => any;
export declare const ReservedInstanceLimitPriceFilterSensitiveLog: (
  obj: ReservedInstanceLimitPrice
) => any;
export declare const PurchaseReservedInstancesOfferingRequestFilterSensitiveLog: (
  obj: PurchaseReservedInstancesOfferingRequest
) => any;
export declare const PurchaseReservedInstancesOfferingResultFilterSensitiveLog: (
  obj: PurchaseReservedInstancesOfferingResult
) => any;
export declare const PurchaseRequestFilterSensitiveLog: (
  obj: PurchaseRequest
) => any;
export declare const PurchaseScheduledInstancesRequestFilterSensitiveLog: (
  obj: PurchaseScheduledInstancesRequest
) => any;
export declare const PurchaseScheduledInstancesResultFilterSensitiveLog: (
  obj: PurchaseScheduledInstancesResult
) => any;
export declare const RebootInstancesRequestFilterSensitiveLog: (
  obj: RebootInstancesRequest
) => any;
export declare const RegisterImageRequestFilterSensitiveLog: (
  obj: RegisterImageRequest
) => any;
export declare const RegisterImageResultFilterSensitiveLog: (
  obj: RegisterImageResult
) => any;
export declare const RegisterInstanceTagAttributeRequestFilterSensitiveLog: (
  obj: RegisterInstanceTagAttributeRequest
) => any;
export declare const RegisterInstanceEventNotificationAttributesRequestFilterSensitiveLog: (
  obj: RegisterInstanceEventNotificationAttributesRequest
) => any;
export declare const RegisterInstanceEventNotificationAttributesResultFilterSensitiveLog: (
  obj: RegisterInstanceEventNotificationAttributesResult
) => any;
export declare const RegisterTransitGatewayMulticastGroupMembersRequestFilterSensitiveLog: (
  obj: RegisterTransitGatewayMulticastGroupMembersRequest
) => any;
export declare const TransitGatewayMulticastRegisteredGroupMembersFilterSensitiveLog: (
  obj: TransitGatewayMulticastRegisteredGroupMembers
) => any;
export declare const RegisterTransitGatewayMulticastGroupMembersResultFilterSensitiveLog: (
  obj: RegisterTransitGatewayMulticastGroupMembersResult
) => any;
export declare const RegisterTransitGatewayMulticastGroupSourcesRequestFilterSensitiveLog: (
  obj: RegisterTransitGatewayMulticastGroupSourcesRequest
) => any;
export declare const TransitGatewayMulticastRegisteredGroupSourcesFilterSensitiveLog: (
  obj: TransitGatewayMulticastRegisteredGroupSources
) => any;
export declare const RegisterTransitGatewayMulticastGroupSourcesResultFilterSensitiveLog: (
  obj: RegisterTransitGatewayMulticastGroupSourcesResult
) => any;
export declare const RejectTransitGatewayMulticastDomainAssociationsRequestFilterSensitiveLog: (
  obj: RejectTransitGatewayMulticastDomainAssociationsRequest
) => any;
export declare const RejectTransitGatewayMulticastDomainAssociationsResultFilterSensitiveLog: (
  obj: RejectTransitGatewayMulticastDomainAssociationsResult
) => any;
export declare const RejectTransitGatewayPeeringAttachmentRequestFilterSensitiveLog: (
  obj: RejectTransitGatewayPeeringAttachmentRequest
) => any;
export declare const RejectTransitGatewayPeeringAttachmentResultFilterSensitiveLog: (
  obj: RejectTransitGatewayPeeringAttachmentResult
) => any;
export declare const RejectTransitGatewayVpcAttachmentRequestFilterSensitiveLog: (
  obj: RejectTransitGatewayVpcAttachmentRequest
) => any;
export declare const RejectTransitGatewayVpcAttachmentResultFilterSensitiveLog: (
  obj: RejectTransitGatewayVpcAttachmentResult
) => any;
export declare const RejectVpcEndpointConnectionsRequestFilterSensitiveLog: (
  obj: RejectVpcEndpointConnectionsRequest
) => any;
export declare const RejectVpcEndpointConnectionsResultFilterSensitiveLog: (
  obj: RejectVpcEndpointConnectionsResult
) => any;
export declare const RejectVpcPeeringConnectionRequestFilterSensitiveLog: (
  obj: RejectVpcPeeringConnectionRequest
) => any;
export declare const RejectVpcPeeringConnectionResultFilterSensitiveLog: (
  obj: RejectVpcPeeringConnectionResult
) => any;
export declare const ReleaseAddressRequestFilterSensitiveLog: (
  obj: ReleaseAddressRequest
) => any;
export declare const ReleaseHostsRequestFilterSensitiveLog: (
  obj: ReleaseHostsRequest
) => any;
export declare const ReleaseHostsResultFilterSensitiveLog: (
  obj: ReleaseHostsResult
) => any;
export declare const ReleaseIpamPoolAllocationRequestFilterSensitiveLog: (
  obj: ReleaseIpamPoolAllocationRequest
) => any;
export declare const ReleaseIpamPoolAllocationResultFilterSensitiveLog: (
  obj: ReleaseIpamPoolAllocationResult
) => any;
export declare const ReplaceIamInstanceProfileAssociationRequestFilterSensitiveLog: (
  obj: ReplaceIamInstanceProfileAssociationRequest
) => any;
export declare const ReplaceIamInstanceProfileAssociationResultFilterSensitiveLog: (
  obj: ReplaceIamInstanceProfileAssociationResult
) => any;
export declare const ReplaceNetworkAclAssociationRequestFilterSensitiveLog: (
  obj: ReplaceNetworkAclAssociationRequest
) => any;
export declare const ReplaceNetworkAclAssociationResultFilterSensitiveLog: (
  obj: ReplaceNetworkAclAssociationResult
) => any;
export declare const ReplaceNetworkAclEntryRequestFilterSensitiveLog: (
  obj: ReplaceNetworkAclEntryRequest
) => any;
export declare const ReplaceRouteRequestFilterSensitiveLog: (
  obj: ReplaceRouteRequest
) => any;
export declare const ReplaceRouteTableAssociationRequestFilterSensitiveLog: (
  obj: ReplaceRouteTableAssociationRequest
) => any;
export declare const ReplaceRouteTableAssociationResultFilterSensitiveLog: (
  obj: ReplaceRouteTableAssociationResult
) => any;
export declare const ReplaceTransitGatewayRouteRequestFilterSensitiveLog: (
  obj: ReplaceTransitGatewayRouteRequest
) => any;
export declare const ReplaceTransitGatewayRouteResultFilterSensitiveLog: (
  obj: ReplaceTransitGatewayRouteResult
) => any;
export declare const ReportInstanceStatusRequestFilterSensitiveLog: (
  obj: ReportInstanceStatusRequest
) => any;
export declare const RequestSpotFleetRequestFilterSensitiveLog: (
  obj: RequestSpotFleetRequest
) => any;
export declare const RequestSpotFleetResponseFilterSensitiveLog: (
  obj: RequestSpotFleetResponse
) => any;
export declare const RequestSpotLaunchSpecificationFilterSensitiveLog: (
  obj: RequestSpotLaunchSpecification
) => any;
export declare const RequestSpotInstancesRequestFilterSensitiveLog: (
  obj: RequestSpotInstancesRequest
) => any;
export declare const RequestSpotInstancesResultFilterSensitiveLog: (
  obj: RequestSpotInstancesResult
) => any;
export declare const ResetAddressAttributeRequestFilterSensitiveLog: (
  obj: ResetAddressAttributeRequest
) => any;
export declare const ResetAddressAttributeResultFilterSensitiveLog: (
  obj: ResetAddressAttributeResult
) => any;
export declare const ResetEbsDefaultKmsKeyIdRequestFilterSensitiveLog: (
  obj: ResetEbsDefaultKmsKeyIdRequest
) => any;
export declare const ResetEbsDefaultKmsKeyIdResultFilterSensitiveLog: (
  obj: ResetEbsDefaultKmsKeyIdResult
) => any;
export declare const ResetFpgaImageAttributeRequestFilterSensitiveLog: (
  obj: ResetFpgaImageAttributeRequest
) => any;
export declare const ResetFpgaImageAttributeResultFilterSensitiveLog: (
  obj: ResetFpgaImageAttributeResult
) => any;
export declare const ResetImageAttributeRequestFilterSensitiveLog: (
  obj: ResetImageAttributeRequest
) => any;
export declare const ResetInstanceAttributeRequestFilterSensitiveLog: (
  obj: ResetInstanceAttributeRequest
) => any;
export declare const ResetNetworkInterfaceAttributeRequestFilterSensitiveLog: (
  obj: ResetNetworkInterfaceAttributeRequest
) => any;
export declare const ResetSnapshotAttributeRequestFilterSensitiveLog: (
  obj: ResetSnapshotAttributeRequest
) => any;
export declare const RestoreAddressToClassicRequestFilterSensitiveLog: (
  obj: RestoreAddressToClassicRequest
) => any;
export declare const RestoreAddressToClassicResultFilterSensitiveLog: (
  obj: RestoreAddressToClassicResult
) => any;
export declare const RestoreImageFromRecycleBinRequestFilterSensitiveLog: (
  obj: RestoreImageFromRecycleBinRequest
) => any;
export declare const RestoreImageFromRecycleBinResultFilterSensitiveLog: (
  obj: RestoreImageFromRecycleBinResult
) => any;
export declare const RestoreManagedPrefixListVersionRequestFilterSensitiveLog: (
  obj: RestoreManagedPrefixListVersionRequest
) => any;
export declare const RestoreManagedPrefixListVersionResultFilterSensitiveLog: (
  obj: RestoreManagedPrefixListVersionResult
) => any;
export declare const RestoreSnapshotFromRecycleBinRequestFilterSensitiveLog: (
  obj: RestoreSnapshotFromRecycleBinRequest
) => any;
export declare const RestoreSnapshotFromRecycleBinResultFilterSensitiveLog: (
  obj: RestoreSnapshotFromRecycleBinResult
) => any;
export declare const RestoreSnapshotTierRequestFilterSensitiveLog: (
  obj: RestoreSnapshotTierRequest
) => any;
export declare const RestoreSnapshotTierResultFilterSensitiveLog: (
  obj: RestoreSnapshotTierResult
) => any;
export declare const RevokeClientVpnIngressRequestFilterSensitiveLog: (
  obj: RevokeClientVpnIngressRequest
) => any;
export declare const RevokeClientVpnIngressResultFilterSensitiveLog: (
  obj: RevokeClientVpnIngressResult
) => any;
export declare const RevokeSecurityGroupEgressRequestFilterSensitiveLog: (
  obj: RevokeSecurityGroupEgressRequest
) => any;
export declare const RevokeSecurityGroupEgressResultFilterSensitiveLog: (
  obj: RevokeSecurityGroupEgressResult
) => any;
export declare const RevokeSecurityGroupIngressRequestFilterSensitiveLog: (
  obj: RevokeSecurityGroupIngressRequest
) => any;
export declare const RevokeSecurityGroupIngressResultFilterSensitiveLog: (
  obj: RevokeSecurityGroupIngressResult
) => any;
export declare const CpuOptionsRequestFilterSensitiveLog: (
  obj: CpuOptionsRequest
) => any;
export declare const ElasticInferenceAcceleratorFilterSensitiveLog: (
  obj: ElasticInferenceAccelerator
) => any;
export declare const EnclaveOptionsRequestFilterSensitiveLog: (
  obj: EnclaveOptionsRequest
) => any;
export declare const HibernationOptionsRequestFilterSensitiveLog: (
  obj: HibernationOptionsRequest
) => any;
export declare const SpotMarketOptionsFilterSensitiveLog: (
  obj: SpotMarketOptions
) => any;
export declare const InstanceMarketOptionsRequestFilterSensitiveLog: (
  obj: InstanceMarketOptionsRequest
) => any;
export declare const LaunchTemplateSpecificationFilterSensitiveLog: (
  obj: LaunchTemplateSpecification
) => any;
export declare const LicenseConfigurationRequestFilterSensitiveLog: (
  obj: LicenseConfigurationRequest
) => any;
export declare const InstanceMaintenanceOptionsRequestFilterSensitiveLog: (
  obj: InstanceMaintenanceOptionsRequest
) => any;
export declare const InstanceMetadataOptionsRequestFilterSensitiveLog: (
  obj: InstanceMetadataOptionsRequest
) => any;
export declare const PrivateDnsNameOptionsRequestFilterSensitiveLog: (
  obj: PrivateDnsNameOptionsRequest
) => any;
export declare const RunInstancesRequestFilterSensitiveLog: (
  obj: RunInstancesRequest
) => any;
export declare const ScheduledInstancesEbsFilterSensitiveLog: (
  obj: ScheduledInstancesEbs
) => any;
export declare const ScheduledInstancesBlockDeviceMappingFilterSensitiveLog: (
  obj: ScheduledInstancesBlockDeviceMapping
) => any;
export declare const ScheduledInstancesIamInstanceProfileFilterSensitiveLog: (
  obj: ScheduledInstancesIamInstanceProfile
) => any;
export declare const ScheduledInstancesMonitoringFilterSensitiveLog: (
  obj: ScheduledInstancesMonitoring
) => any;
export declare const ScheduledInstancesIpv6AddressFilterSensitiveLog: (
  obj: ScheduledInstancesIpv6Address
) => any;
export declare const ScheduledInstancesPrivateIpAddressConfigFilterSensitiveLog: (
  obj: ScheduledInstancesPrivateIpAddressConfig
) => any;
export declare const ScheduledInstancesNetworkInterfaceFilterSensitiveLog: (
  obj: ScheduledInstancesNetworkInterface
) => any;
export declare const ScheduledInstancesPlacementFilterSensitiveLog: (
  obj: ScheduledInstancesPlacement
) => any;
export declare const ScheduledInstancesLaunchSpecificationFilterSensitiveLog: (
  obj: ScheduledInstancesLaunchSpecification
) => any;
export declare const RunScheduledInstancesRequestFilterSensitiveLog: (
  obj: RunScheduledInstancesRequest
) => any;
export declare const RunScheduledInstancesResultFilterSensitiveLog: (
  obj: RunScheduledInstancesResult
) => any;
export declare const SearchLocalGatewayRoutesRequestFilterSensitiveLog: (
  obj: SearchLocalGatewayRoutesRequest
) => any;
export declare const SearchLocalGatewayRoutesResultFilterSensitiveLog: (
  obj: SearchLocalGatewayRoutesResult
) => any;
export declare const SearchTransitGatewayMulticastGroupsRequestFilterSensitiveLog: (
  obj: SearchTransitGatewayMulticastGroupsRequest
) => any;
export declare const TransitGatewayMulticastGroupFilterSensitiveLog: (
  obj: TransitGatewayMulticastGroup
) => any;
export declare const SearchTransitGatewayMulticastGroupsResultFilterSensitiveLog: (
  obj: SearchTransitGatewayMulticastGroupsResult
) => any;
export declare const SearchTransitGatewayRoutesRequestFilterSensitiveLog: (
  obj: SearchTransitGatewayRoutesRequest
) => any;
export declare const SearchTransitGatewayRoutesResultFilterSensitiveLog: (
  obj: SearchTransitGatewayRoutesResult
) => any;
export declare const SendDiagnosticInterruptRequestFilterSensitiveLog: (
  obj: SendDiagnosticInterruptRequest
) => any;
export declare const StartInstancesRequestFilterSensitiveLog: (
  obj: StartInstancesRequest
) => any;
export declare const InstanceStateChangeFilterSensitiveLog: (
  obj: InstanceStateChange
) => any;
export declare const StartInstancesResultFilterSensitiveLog: (
  obj: StartInstancesResult
) => any;
export declare const StartNetworkInsightsAccessScopeAnalysisRequestFilterSensitiveLog: (
  obj: StartNetworkInsightsAccessScopeAnalysisRequest
) => any;
export declare const StartNetworkInsightsAccessScopeAnalysisResultFilterSensitiveLog: (
  obj: StartNetworkInsightsAccessScopeAnalysisResult
) => any;
export declare const StartNetworkInsightsAnalysisRequestFilterSensitiveLog: (
  obj: StartNetworkInsightsAnalysisRequest
) => any;
export declare const StartNetworkInsightsAnalysisResultFilterSensitiveLog: (
  obj: StartNetworkInsightsAnalysisResult
) => any;
export declare const StartVpcEndpointServicePrivateDnsVerificationRequestFilterSensitiveLog: (
  obj: StartVpcEndpointServicePrivateDnsVerificationRequest
) => any;
export declare const StartVpcEndpointServicePrivateDnsVerificationResultFilterSensitiveLog: (
  obj: StartVpcEndpointServicePrivateDnsVerificationResult
) => any;
export declare const StopInstancesRequestFilterSensitiveLog: (
  obj: StopInstancesRequest
) => any;
export declare const StopInstancesResultFilterSensitiveLog: (
  obj: StopInstancesResult
) => any;
export declare const TerminateClientVpnConnectionsRequestFilterSensitiveLog: (
  obj: TerminateClientVpnConnectionsRequest
) => any;
export declare const TerminateConnectionStatusFilterSensitiveLog: (
  obj: TerminateConnectionStatus
) => any;
export declare const TerminateClientVpnConnectionsResultFilterSensitiveLog: (
  obj: TerminateClientVpnConnectionsResult
) => any;
export declare const TerminateInstancesRequestFilterSensitiveLog: (
  obj: TerminateInstancesRequest
) => any;
export declare const TerminateInstancesResultFilterSensitiveLog: (
  obj: TerminateInstancesResult
) => any;
export declare const UnassignIpv6AddressesRequestFilterSensitiveLog: (
  obj: UnassignIpv6AddressesRequest
) => any;
export declare const UnassignIpv6AddressesResultFilterSensitiveLog: (
  obj: UnassignIpv6AddressesResult
) => any;
export declare const UnassignPrivateIpAddressesRequestFilterSensitiveLog: (
  obj: UnassignPrivateIpAddressesRequest
) => any;
export declare const UnmonitorInstancesRequestFilterSensitiveLog: (
  obj: UnmonitorInstancesRequest
) => any;
export declare const UnmonitorInstancesResultFilterSensitiveLog: (
  obj: UnmonitorInstancesResult
) => any;
export declare const SecurityGroupRuleDescriptionFilterSensitiveLog: (
  obj: SecurityGroupRuleDescription
) => any;
export declare const UpdateSecurityGroupRuleDescriptionsEgressRequestFilterSensitiveLog: (
  obj: UpdateSecurityGroupRuleDescriptionsEgressRequest
) => any;
export declare const UpdateSecurityGroupRuleDescriptionsEgressResultFilterSensitiveLog: (
  obj: UpdateSecurityGroupRuleDescriptionsEgressResult
) => any;
export declare const UpdateSecurityGroupRuleDescriptionsIngressRequestFilterSensitiveLog: (
  obj: UpdateSecurityGroupRuleDescriptionsIngressRequest
) => any;
export declare const UpdateSecurityGroupRuleDescriptionsIngressResultFilterSensitiveLog: (
  obj: UpdateSecurityGroupRuleDescriptionsIngressResult
) => any;
export declare const WithdrawByoipCidrRequestFilterSensitiveLog: (
  obj: WithdrawByoipCidrRequest
) => any;
export declare const WithdrawByoipCidrResultFilterSensitiveLog: (
  obj: WithdrawByoipCidrResult
) => any;
