export interface AcceleratorCount {
  Min?: number;
  Max?: number;
}
export interface AcceleratorCountRequest {
  Min?: number;
  Max?: number;
}
export declare enum AcceleratorManufacturer {
  AMAZON_WEB_SERVICES = "amazon-web-services",
  AMD = "amd",
  NVIDIA = "nvidia",
  XILINX = "xilinx",
}
export declare enum AcceleratorName {
  A100 = "a100",
  INFERENTIA = "inferentia",
  K520 = "k520",
  K80 = "k80",
  M60 = "m60",
  RADEON_PRO_V520 = "radeon-pro-v520",
  T4 = "t4",
  V100 = "v100",
  VU9P = "vu9p",
}
export interface AcceleratorTotalMemoryMiB {
  Min?: number;
  Max?: number;
}
export interface AcceleratorTotalMemoryMiBRequest {
  Min?: number;
  Max?: number;
}
export declare enum AcceleratorType {
  FPGA = "fpga",
  GPU = "gpu",
  INFERENCE = "inference",
}
export declare enum ResourceType {
  capacity_reservation = "capacity-reservation",
  capacity_reservation_fleet = "capacity-reservation-fleet",
  carrier_gateway = "carrier-gateway",
  client_vpn_endpoint = "client-vpn-endpoint",
  coip_pool = "coip-pool",
  customer_gateway = "customer-gateway",
  dedicated_host = "dedicated-host",
  dhcp_options = "dhcp-options",
  egress_only_internet_gateway = "egress-only-internet-gateway",
  elastic_gpu = "elastic-gpu",
  elastic_ip = "elastic-ip",
  export_image_task = "export-image-task",
  export_instance_task = "export-instance-task",
  fleet = "fleet",
  fpga_image = "fpga-image",
  host_reservation = "host-reservation",
  image = "image",
  import_image_task = "import-image-task",
  import_snapshot_task = "import-snapshot-task",
  instance = "instance",
  instance_event_window = "instance-event-window",
  internet_gateway = "internet-gateway",
  ipam = "ipam",
  ipam_pool = "ipam-pool",
  ipam_scope = "ipam-scope",
  ipv4pool_ec2 = "ipv4pool-ec2",
  ipv6pool_ec2 = "ipv6pool-ec2",
  key_pair = "key-pair",
  launch_template = "launch-template",
  local_gateway = "local-gateway",
  local_gateway_route_table = "local-gateway-route-table",
  local_gateway_route_table_virtual_interface_group_association = "local-gateway-route-table-virtual-interface-group-association",
  local_gateway_route_table_vpc_association = "local-gateway-route-table-vpc-association",
  local_gateway_virtual_interface = "local-gateway-virtual-interface",
  local_gateway_virtual_interface_group = "local-gateway-virtual-interface-group",
  natgateway = "natgateway",
  network_acl = "network-acl",
  network_insights_access_scope = "network-insights-access-scope",
  network_insights_access_scope_analysis = "network-insights-access-scope-analysis",
  network_insights_analysis = "network-insights-analysis",
  network_insights_path = "network-insights-path",
  network_interface = "network-interface",
  placement_group = "placement-group",
  prefix_list = "prefix-list",
  replace_root_volume_task = "replace-root-volume-task",
  reserved_instances = "reserved-instances",
  route_table = "route-table",
  security_group = "security-group",
  security_group_rule = "security-group-rule",
  snapshot = "snapshot",
  spot_fleet_request = "spot-fleet-request",
  spot_instances_request = "spot-instances-request",
  subnet = "subnet",
  subnet_cidr_reservation = "subnet-cidr-reservation",
  traffic_mirror_filter = "traffic-mirror-filter",
  traffic_mirror_filter_rule = "traffic-mirror-filter-rule",
  traffic_mirror_session = "traffic-mirror-session",
  traffic_mirror_target = "traffic-mirror-target",
  transit_gateway = "transit-gateway",
  transit_gateway_attachment = "transit-gateway-attachment",
  transit_gateway_connect_peer = "transit-gateway-connect-peer",
  transit_gateway_multicast_domain = "transit-gateway-multicast-domain",
  transit_gateway_policy_table = "transit-gateway-policy-table",
  transit_gateway_route_table = "transit-gateway-route-table",
  transit_gateway_route_table_announcement = "transit-gateway-route-table-announcement",
  verified_access_endpoint = "verified-access-endpoint",
  verified_access_group = "verified-access-group",
  verified_access_instance = "verified-access-instance",
  verified_access_policy = "verified-access-policy",
  verified_access_trust_provider = "verified-access-trust-provider",
  volume = "volume",
  vpc = "vpc",
  vpc_block_public_access_exclusion = "vpc-block-public-access-exclusion",
  vpc_endpoint = "vpc-endpoint",
  vpc_endpoint_connection = "vpc-endpoint-connection",
  vpc_endpoint_connection_device_type = "vpc-endpoint-connection-device-type",
  vpc_endpoint_service = "vpc-endpoint-service",
  vpc_endpoint_service_permission = "vpc-endpoint-service-permission",
  vpc_flow_log = "vpc-flow-log",
  vpc_peering_connection = "vpc-peering-connection",
  vpn_connection = "vpn-connection",
  vpn_connection_device_type = "vpn-connection-device-type",
  vpn_gateway = "vpn-gateway",
}
export interface Tag {
  Key?: string;
  Value?: string;
}
export interface TagSpecification {
  ResourceType?: ResourceType | string;
  Tags?: Tag[];
}
export interface AcceptAddressTransferRequest {
  Address: string | undefined;
  TagSpecifications?: TagSpecification[];
  DryRun?: boolean;
}
export declare enum AddressTransferStatus {
  accepted = "accepted",
  disabled = "disabled",
  pending = "pending",
}
export interface AddressTransfer {
  PublicIp?: string;
  AllocationId?: string;
  TransferAccountId?: string;
  TransferOfferExpirationTimestamp?: Date;
  TransferOfferAcceptedTimestamp?: Date;
  AddressTransferStatus?: AddressTransferStatus | string;
}
export interface AcceptAddressTransferResult {
  AddressTransfer?: AddressTransfer;
}
export interface TargetConfigurationRequest {
  InstanceCount?: number;
  OfferingId: string | undefined;
}
export interface AcceptReservedInstancesExchangeQuoteRequest {
  DryRun?: boolean;
  ReservedInstanceIds: string[] | undefined;
  TargetConfigurations?: TargetConfigurationRequest[];
}
export interface AcceptReservedInstancesExchangeQuoteResult {
  ExchangeId?: string;
}
export interface AcceptTransitGatewayMulticastDomainAssociationsRequest {
  TransitGatewayMulticastDomainId?: string;
  TransitGatewayAttachmentId?: string;
  SubnetIds?: string[];
  DryRun?: boolean;
}
export declare enum TransitGatewayAttachmentResourceType {
  connect = "connect",
  direct_connect_gateway = "direct-connect-gateway",
  peering = "peering",
  tgw_peering = "tgw-peering",
  vpc = "vpc",
  vpn = "vpn",
}
export declare enum TransitGatewayMulitcastDomainAssociationState {
  associated = "associated",
  associating = "associating",
  disassociated = "disassociated",
  disassociating = "disassociating",
  failed = "failed",
  pendingAcceptance = "pendingAcceptance",
  rejected = "rejected",
}
export interface SubnetAssociation {
  SubnetId?: string;
  State?: TransitGatewayMulitcastDomainAssociationState | string;
}
export interface TransitGatewayMulticastDomainAssociations {
  TransitGatewayMulticastDomainId?: string;
  TransitGatewayAttachmentId?: string;
  ResourceId?: string;
  ResourceType?: TransitGatewayAttachmentResourceType | string;
  ResourceOwnerId?: string;
  Subnets?: SubnetAssociation[];
}
export interface AcceptTransitGatewayMulticastDomainAssociationsResult {
  Associations?: TransitGatewayMulticastDomainAssociations;
}
export interface AcceptTransitGatewayPeeringAttachmentRequest {
  TransitGatewayAttachmentId: string | undefined;
  DryRun?: boolean;
}
export interface PeeringTgwInfo {
  TransitGatewayId?: string;
  CoreNetworkId?: string;
  OwnerId?: string;
  Region?: string;
}
export declare enum DynamicRoutingValue {
  disable = "disable",
  enable = "enable",
}
export interface TransitGatewayPeeringAttachmentOptions {
  DynamicRouting?: DynamicRoutingValue | string;
}
export declare enum TransitGatewayAttachmentState {
  available = "available",
  deleted = "deleted",
  deleting = "deleting",
  failed = "failed",
  failing = "failing",
  initiating = "initiating",
  initiatingRequest = "initiatingRequest",
  modifying = "modifying",
  pending = "pending",
  pendingAcceptance = "pendingAcceptance",
  rejected = "rejected",
  rejecting = "rejecting",
  rollingBack = "rollingBack",
}
export interface PeeringAttachmentStatus {
  Code?: string;
  Message?: string;
}
export interface TransitGatewayPeeringAttachment {
  TransitGatewayAttachmentId?: string;
  AccepterTransitGatewayAttachmentId?: string;
  RequesterTgwInfo?: PeeringTgwInfo;
  AccepterTgwInfo?: PeeringTgwInfo;
  Options?: TransitGatewayPeeringAttachmentOptions;
  Status?: PeeringAttachmentStatus;
  State?: TransitGatewayAttachmentState | string;
  CreationTime?: Date;
  Tags?: Tag[];
}
export interface AcceptTransitGatewayPeeringAttachmentResult {
  TransitGatewayPeeringAttachment?: TransitGatewayPeeringAttachment;
}
export interface AcceptTransitGatewayVpcAttachmentRequest {
  TransitGatewayAttachmentId: string | undefined;
  DryRun?: boolean;
}
export declare enum ApplianceModeSupportValue {
  disable = "disable",
  enable = "enable",
}
export declare enum DnsSupportValue {
  disable = "disable",
  enable = "enable",
}
export declare enum Ipv6SupportValue {
  disable = "disable",
  enable = "enable",
}
export interface TransitGatewayVpcAttachmentOptions {
  DnsSupport?: DnsSupportValue | string;
  Ipv6Support?: Ipv6SupportValue | string;
  ApplianceModeSupport?: ApplianceModeSupportValue | string;
}
export interface TransitGatewayVpcAttachment {
  TransitGatewayAttachmentId?: string;
  TransitGatewayId?: string;
  VpcId?: string;
  VpcOwnerId?: string;
  State?: TransitGatewayAttachmentState | string;
  SubnetIds?: string[];
  CreationTime?: Date;
  Options?: TransitGatewayVpcAttachmentOptions;
  Tags?: Tag[];
}
export interface AcceptTransitGatewayVpcAttachmentResult {
  TransitGatewayVpcAttachment?: TransitGatewayVpcAttachment;
}
export interface AcceptVpcEndpointConnectionsRequest {
  DryRun?: boolean;
  ServiceId: string | undefined;
  VpcEndpointIds: string[] | undefined;
}
export interface UnsuccessfulItemError {
  Code?: string;
  Message?: string;
}
export interface UnsuccessfulItem {
  Error?: UnsuccessfulItemError;
  ResourceId?: string;
}
export interface AcceptVpcEndpointConnectionsResult {
  Unsuccessful?: UnsuccessfulItem[];
}
export interface AcceptVpcPeeringConnectionRequest {
  DryRun?: boolean;
  VpcPeeringConnectionId?: string;
}
export interface CidrBlock {
  CidrBlock?: string;
}
export interface Ipv6CidrBlock {
  Ipv6CidrBlock?: string;
}
export interface VpcPeeringConnectionOptionsDescription {
  AllowDnsResolutionFromRemoteVpc?: boolean;
  AllowEgressFromLocalClassicLinkToRemoteVpc?: boolean;
  AllowEgressFromLocalVpcToRemoteClassicLink?: boolean;
}
export interface VpcPeeringConnectionVpcInfo {
  CidrBlock?: string;
  Ipv6CidrBlockSet?: Ipv6CidrBlock[];
  CidrBlockSet?: CidrBlock[];
  OwnerId?: string;
  PeeringOptions?: VpcPeeringConnectionOptionsDescription;
  VpcId?: string;
  Region?: string;
}
export declare enum VpcPeeringConnectionStateReasonCode {
  active = "active",
  deleted = "deleted",
  deleting = "deleting",
  expired = "expired",
  failed = "failed",
  initiating_request = "initiating-request",
  pending_acceptance = "pending-acceptance",
  provisioning = "provisioning",
  rejected = "rejected",
}
export interface VpcPeeringConnectionStateReason {
  Code?: VpcPeeringConnectionStateReasonCode | string;
  Message?: string;
}
export interface VpcPeeringConnection {
  AccepterVpcInfo?: VpcPeeringConnectionVpcInfo;
  ExpirationTime?: Date;
  RequesterVpcInfo?: VpcPeeringConnectionVpcInfo;
  Status?: VpcPeeringConnectionStateReason;
  Tags?: Tag[];
  VpcPeeringConnectionId?: string;
}
export interface AcceptVpcPeeringConnectionResult {
  VpcPeeringConnection?: VpcPeeringConnection;
}
export interface PortRange {
  From?: number;
  To?: number;
}
export interface AnalysisAclRule {
  Cidr?: string;
  Egress?: boolean;
  PortRange?: PortRange;
  Protocol?: string;
  RuleAction?: string;
  RuleNumber?: number;
}
export interface AnalysisComponent {
  Id?: string;
  Arn?: string;
  Name?: string;
}
export interface AdditionalDetail {
  AdditionalDetailType?: string;
  Component?: AnalysisComponent;
}
export interface AnalysisLoadBalancerListener {
  LoadBalancerPort?: number;
  InstancePort?: number;
}
export interface AnalysisLoadBalancerTarget {
  Address?: string;
  AvailabilityZone?: string;
  Instance?: AnalysisComponent;
  Port?: number;
}
export interface AnalysisRouteTableRoute {
  DestinationCidr?: string;
  DestinationPrefixListId?: string;
  EgressOnlyInternetGatewayId?: string;
  GatewayId?: string;
  InstanceId?: string;
  NatGatewayId?: string;
  NetworkInterfaceId?: string;
  Origin?: string;
  TransitGatewayId?: string;
  VpcPeeringConnectionId?: string;
  State?: string;
}
export interface AnalysisSecurityGroupRule {
  Cidr?: string;
  Direction?: string;
  SecurityGroupId?: string;
  PortRange?: PortRange;
  PrefixListId?: string;
  Protocol?: string;
}
export interface TransitGatewayRouteTableRoute {
  DestinationCidr?: string;
  State?: string;
  RouteOrigin?: string;
  PrefixListId?: string;
  AttachmentId?: string;
  ResourceId?: string;
  ResourceType?: string;
}
export interface Explanation {
  Acl?: AnalysisComponent;
  AclRule?: AnalysisAclRule;
  Address?: string;
  Addresses?: string[];
  AttachedTo?: AnalysisComponent;
  AvailabilityZones?: string[];
  Cidrs?: string[];
  Component?: AnalysisComponent;
  CustomerGateway?: AnalysisComponent;
  Destination?: AnalysisComponent;
  DestinationVpc?: AnalysisComponent;
  Direction?: string;
  ExplanationCode?: string;
  IngressRouteTable?: AnalysisComponent;
  InternetGateway?: AnalysisComponent;
  LoadBalancerArn?: string;
  ClassicLoadBalancerListener?: AnalysisLoadBalancerListener;
  LoadBalancerListenerPort?: number;
  LoadBalancerTarget?: AnalysisLoadBalancerTarget;
  LoadBalancerTargetGroup?: AnalysisComponent;
  LoadBalancerTargetGroups?: AnalysisComponent[];
  LoadBalancerTargetPort?: number;
  ElasticLoadBalancerListener?: AnalysisComponent;
  MissingComponent?: string;
  NatGateway?: AnalysisComponent;
  NetworkInterface?: AnalysisComponent;
  PacketField?: string;
  VpcPeeringConnection?: AnalysisComponent;
  Port?: number;
  PortRanges?: PortRange[];
  PrefixList?: AnalysisComponent;
  Protocols?: string[];
  RouteTableRoute?: AnalysisRouteTableRoute;
  RouteTable?: AnalysisComponent;
  SecurityGroup?: AnalysisComponent;
  SecurityGroupRule?: AnalysisSecurityGroupRule;
  SecurityGroups?: AnalysisComponent[];
  SourceVpc?: AnalysisComponent;
  State?: string;
  Subnet?: AnalysisComponent;
  SubnetRouteTable?: AnalysisComponent;
  Vpc?: AnalysisComponent;
  VpcEndpoint?: AnalysisComponent;
  VpnConnection?: AnalysisComponent;
  VpnGateway?: AnalysisComponent;
  TransitGateway?: AnalysisComponent;
  TransitGatewayRouteTable?: AnalysisComponent;
  TransitGatewayRouteTableRoute?: TransitGatewayRouteTableRoute;
  TransitGatewayAttachment?: AnalysisComponent;
  ComponentAccount?: string;
  ComponentRegion?: string;
}
export interface AnalysisPacketHeader {
  DestinationAddresses?: string[];
  DestinationPortRanges?: PortRange[];
  Protocol?: string;
  SourceAddresses?: string[];
  SourcePortRanges?: PortRange[];
}
export interface PathComponent {
  SequenceNumber?: number;
  AclRule?: AnalysisAclRule;
  AttachedTo?: AnalysisComponent;
  Component?: AnalysisComponent;
  DestinationVpc?: AnalysisComponent;
  OutboundHeader?: AnalysisPacketHeader;
  InboundHeader?: AnalysisPacketHeader;
  RouteTableRoute?: AnalysisRouteTableRoute;
  SecurityGroupRule?: AnalysisSecurityGroupRule;
  SourceVpc?: AnalysisComponent;
  Subnet?: AnalysisComponent;
  Vpc?: AnalysisComponent;
  AdditionalDetails?: AdditionalDetail[];
  TransitGateway?: AnalysisComponent;
  TransitGatewayRouteTableRoute?: TransitGatewayRouteTableRoute;
  Explanations?: Explanation[];
  ElasticLoadBalancerListener?: AnalysisComponent;
}
export interface AccessScopeAnalysisFinding {
  NetworkInsightsAccessScopeAnalysisId?: string;
  NetworkInsightsAccessScopeId?: string;
  FindingId?: string;
  FindingComponents?: PathComponent[];
}
export declare enum Protocol {
  tcp = "tcp",
  udp = "udp",
}
export interface PacketHeaderStatement {
  SourceAddresses?: string[];
  DestinationAddresses?: string[];
  SourcePorts?: string[];
  DestinationPorts?: string[];
  SourcePrefixLists?: string[];
  DestinationPrefixLists?: string[];
  Protocols?: (Protocol | string)[];
}
export interface ResourceStatement {
  Resources?: string[];
  ResourceTypes?: string[];
}
export interface PathStatement {
  PacketHeaderStatement?: PacketHeaderStatement;
  ResourceStatement?: ResourceStatement;
}
export interface ThroughResourcesStatement {
  ResourceStatement?: ResourceStatement;
}
export interface AccessScopePath {
  Source?: PathStatement;
  Destination?: PathStatement;
  ThroughResources?: ThroughResourcesStatement[];
}
export interface PacketHeaderStatementRequest {
  SourceAddresses?: string[];
  DestinationAddresses?: string[];
  SourcePorts?: string[];
  DestinationPorts?: string[];
  SourcePrefixLists?: string[];
  DestinationPrefixLists?: string[];
  Protocols?: (Protocol | string)[];
}
export interface ResourceStatementRequest {
  Resources?: string[];
  ResourceTypes?: string[];
}
export interface PathStatementRequest {
  PacketHeaderStatement?: PacketHeaderStatementRequest;
  ResourceStatement?: ResourceStatementRequest;
}
export interface ThroughResourcesStatementRequest {
  ResourceStatement?: ResourceStatementRequest;
}
export interface AccessScopePathRequest {
  Source?: PathStatementRequest;
  Destination?: PathStatementRequest;
  ThroughResources?: ThroughResourcesStatementRequest[];
}
export interface AccountAttributeValue {
  AttributeValue?: string;
}
export interface AccountAttribute {
  AttributeName?: string;
  AttributeValues?: AccountAttributeValue[];
}
export declare enum AccountAttributeName {
  default_vpc = "default-vpc",
  supported_platforms = "supported-platforms",
}
export declare enum InstanceHealthStatus {
  HEALTHY_STATUS = "healthy",
  UNHEALTHY_STATUS = "unhealthy",
}
export interface ActiveInstance {
  InstanceId?: string;
  InstanceType?: string;
  SpotInstanceRequestId?: string;
  InstanceHealth?: InstanceHealthStatus | string;
}
export declare enum ActivityStatus {
  ERROR = "error",
  FULFILLED = "fulfilled",
  PENDING_FULFILLMENT = "pending_fulfillment",
  PENDING_TERMINATION = "pending_termination",
}
export declare enum PrincipalType {
  Account = "Account",
  All = "All",
  OrganizationUnit = "OrganizationUnit",
  Role = "Role",
  Service = "Service",
  User = "User",
}
export interface AddedPrincipal {
  PrincipalType?: PrincipalType | string;
  Principal?: string;
  ServicePermissionId?: string;
  ServiceId?: string;
}
export interface AddIpamOperatingRegion {
  RegionName?: string;
}
export interface AddPrefixListEntry {
  Cidr: string | undefined;
  Description?: string;
}
export declare enum DomainType {
  standard = "standard",
  vpc = "vpc",
}
export interface Address {
  InstanceId?: string;
  PublicIp?: string;
  AllocationId?: string;
  AssociationId?: string;
  Domain?: DomainType | string;
  NetworkInterfaceId?: string;
  NetworkInterfaceOwnerId?: string;
  PrivateIpAddress?: string;
  Tags?: Tag[];
  PublicIpv4Pool?: string;
  NetworkBorderGroup?: string;
  CustomerOwnedIp?: string;
  CustomerOwnedIpv4Pool?: string;
  CarrierIp?: string;
}
export interface PtrUpdateStatus {
  Value?: string;
  Status?: string;
  Reason?: string;
}
export interface AddressAttribute {
  PublicIp?: string;
  AllocationId?: string;
  PtrRecord?: string;
  PtrRecordUpdate?: PtrUpdateStatus;
}
export declare enum AddressAttributeName {
  domain_name = "domain-name",
}
export declare enum AddressFamily {
  ipv4 = "ipv4",
  ipv6 = "ipv6",
}
export interface AdvertiseByoipCidrRequest {
  Cidr: string | undefined;
  DryRun?: boolean;
}
export declare enum ByoipCidrState {
  advertised = "advertised",
  deprovisioned = "deprovisioned",
  failed_deprovision = "failed-deprovision",
  failed_provision = "failed-provision",
  pending_deprovision = "pending-deprovision",
  pending_provision = "pending-provision",
  provisioned = "provisioned",
  provisioned_not_publicly_advertisable = "provisioned-not-publicly-advertisable",
}
export interface ByoipCidr {
  Cidr?: string;
  Description?: string;
  StatusMessage?: string;
  State?: ByoipCidrState | string;
}
export interface AdvertiseByoipCidrResult {
  ByoipCidr?: ByoipCidr;
}
export declare enum Affinity {
  default = "default",
  host = "host",
}
export interface AllocateAddressRequest {
  Domain?: DomainType | string;
  Address?: string;
  PublicIpv4Pool?: string;
  NetworkBorderGroup?: string;
  CustomerOwnedIpv4Pool?: string;
  DryRun?: boolean;
  TagSpecifications?: TagSpecification[];
}
export interface AllocateAddressResult {
  PublicIp?: string;
  AllocationId?: string;
  PublicIpv4Pool?: string;
  NetworkBorderGroup?: string;
  Domain?: DomainType | string;
  CustomerOwnedIp?: string;
  CustomerOwnedIpv4Pool?: string;
  CarrierIp?: string;
}
export declare enum AutoPlacement {
  off = "off",
  on = "on",
}
export declare enum HostRecovery {
  off = "off",
  on = "on",
}
export interface AllocateHostsRequest {
  AutoPlacement?: AutoPlacement | string;
  AvailabilityZone: string | undefined;
  ClientToken?: string;
  InstanceType?: string;
  InstanceFamily?: string;
  Quantity: number | undefined;
  TagSpecifications?: TagSpecification[];
  HostRecovery?: HostRecovery | string;
  OutpostArn?: string;
}
export interface AllocateHostsResult {
  HostIds?: string[];
}
export interface AllocateIpamPoolCidrRequest {
  DryRun?: boolean;
  IpamPoolId: string | undefined;
  Cidr?: string;
  NetmaskLength?: number;
  ClientToken?: string;
  Description?: string;
  PreviewNextCidr?: boolean;
  DisallowedCidrs?: string[];
}
export declare enum IpamPoolAllocationResourceType {
  custom = "custom",
  ec2_public_ipv4_pool = "ec2-public-ipv4-pool",
  ipam_pool = "ipam-pool",
  vpc = "vpc",
}
export interface IpamPoolAllocation {
  Cidr?: string;
  IpamPoolAllocationId?: string;
  Description?: string;
  ResourceId?: string;
  ResourceType?: IpamPoolAllocationResourceType | string;
  ResourceRegion?: string;
  ResourceOwner?: string;
}
export interface AllocateIpamPoolCidrResult {
  IpamPoolAllocation?: IpamPoolAllocation;
}
export declare enum AllocationState {
  available = "available",
  pending = "pending",
  permanent_failure = "permanent-failure",
  released = "released",
  released_permanent_failure = "released-permanent-failure",
  under_assessment = "under-assessment",
}
export declare enum AllocationStrategy {
  CAPACITY_OPTIMIZED = "capacityOptimized",
  CAPACITY_OPTIMIZED_PRIORITIZED = "capacityOptimizedPrioritized",
  DIVERSIFIED = "diversified",
  LOWEST_PRICE = "lowestPrice",
  PRICE_CAPACITY_OPTIMIZED = "priceCapacityOptimized",
}
export declare enum AllocationType {
  used = "used",
}
export interface AllowedPrincipal {
  PrincipalType?: PrincipalType | string;
  Principal?: string;
  ServicePermissionId?: string;
  Tags?: Tag[];
  ServiceId?: string;
}
export declare enum AllowsMultipleInstanceTypes {
  off = "off",
  on = "on",
}
export interface AlternatePathHint {
  ComponentId?: string;
  ComponentArn?: string;
}
export interface ApplySecurityGroupsToClientVpnTargetNetworkRequest {
  ClientVpnEndpointId: string | undefined;
  VpcId: string | undefined;
  SecurityGroupIds: string[] | undefined;
  DryRun?: boolean;
}
export interface ApplySecurityGroupsToClientVpnTargetNetworkResult {
  SecurityGroupIds?: string[];
}
export interface AssignIpv6AddressesRequest {
  Ipv6AddressCount?: number;
  Ipv6Addresses?: string[];
  Ipv6PrefixCount?: number;
  Ipv6Prefixes?: string[];
  NetworkInterfaceId: string | undefined;
}
export interface AssignIpv6AddressesResult {
  AssignedIpv6Addresses?: string[];
  AssignedIpv6Prefixes?: string[];
  NetworkInterfaceId?: string;
}
export interface AssignPrivateIpAddressesRequest {
  AllowReassignment?: boolean;
  NetworkInterfaceId: string | undefined;
  PrivateIpAddresses?: string[];
  SecondaryPrivateIpAddressCount?: number;
  Ipv4Prefixes?: string[];
  Ipv4PrefixCount?: number;
}
export interface Ipv4PrefixSpecification {
  Ipv4Prefix?: string;
}
export interface AssignedPrivateIpAddress {
  PrivateIpAddress?: string;
}
export interface AssignPrivateIpAddressesResult {
  NetworkInterfaceId?: string;
  AssignedPrivateIpAddresses?: AssignedPrivateIpAddress[];
  AssignedIpv4Prefixes?: Ipv4PrefixSpecification[];
}
export interface AssociateAddressRequest {
  AllocationId?: string;
  InstanceId?: string;
  PublicIp?: string;
  AllowReassociation?: boolean;
  DryRun?: boolean;
  NetworkInterfaceId?: string;
  PrivateIpAddress?: string;
}
export interface AssociateAddressResult {
  AssociationId?: string;
}
export interface AssociateClientVpnTargetNetworkRequest {
  ClientVpnEndpointId: string | undefined;
  SubnetId: string | undefined;
  ClientToken?: string;
  DryRun?: boolean;
}
export declare enum AssociationStatusCode {
  associated = "associated",
  associating = "associating",
  association_failed = "association-failed",
  disassociated = "disassociated",
  disassociating = "disassociating",
}
export interface AssociationStatus {
  Code?: AssociationStatusCode | string;
  Message?: string;
}
export interface AssociateClientVpnTargetNetworkResult {
  AssociationId?: string;
  Status?: AssociationStatus;
}
export interface AssociateDhcpOptionsRequest {
  DhcpOptionsId: string | undefined;
  VpcId: string | undefined;
  DryRun?: boolean;
}
export interface AssociateEnclaveCertificateIamRoleRequest {
  CertificateArn?: string;
  RoleArn?: string;
  DryRun?: boolean;
}
export interface AssociateEnclaveCertificateIamRoleResult {
  CertificateS3BucketName?: string;
  CertificateS3ObjectKey?: string;
  EncryptionKmsKeyId?: string;
}
export interface IamInstanceProfileSpecification {
  Arn?: string;
  Name?: string;
}
export interface AssociateIamInstanceProfileRequest {
  IamInstanceProfile: IamInstanceProfileSpecification | undefined;
  InstanceId: string | undefined;
}
export interface IamInstanceProfile {
  Arn?: string;
  Id?: string;
}
export declare enum IamInstanceProfileAssociationState {
  ASSOCIATED = "associated",
  ASSOCIATING = "associating",
  DISASSOCIATED = "disassociated",
  DISASSOCIATING = "disassociating",
}
export interface IamInstanceProfileAssociation {
  AssociationId?: string;
  InstanceId?: string;
  IamInstanceProfile?: IamInstanceProfile;
  State?: IamInstanceProfileAssociationState | string;
  Timestamp?: Date;
}
export interface AssociateIamInstanceProfileResult {
  IamInstanceProfileAssociation?: IamInstanceProfileAssociation;
}
export interface InstanceEventWindowAssociationRequest {
  InstanceIds?: string[];
  InstanceTags?: Tag[];
  DedicatedHostIds?: string[];
}
export interface AssociateInstanceEventWindowRequest {
  DryRun?: boolean;
  InstanceEventWindowId: string | undefined;
  AssociationTarget: InstanceEventWindowAssociationRequest | undefined;
}
export interface InstanceEventWindowAssociationTarget {
  InstanceIds?: string[];
  Tags?: Tag[];
  DedicatedHostIds?: string[];
}
export declare enum InstanceEventWindowState {
  active = "active",
  creating = "creating",
  deleted = "deleted",
  deleting = "deleting",
}
export declare enum WeekDay {
  friday = "friday",
  monday = "monday",
  saturday = "saturday",
  sunday = "sunday",
  thursday = "thursday",
  tuesday = "tuesday",
  wednesday = "wednesday",
}
export interface InstanceEventWindowTimeRange {
  StartWeekDay?: WeekDay | string;
  StartHour?: number;
  EndWeekDay?: WeekDay | string;
  EndHour?: number;
}
export interface InstanceEventWindow {
  InstanceEventWindowId?: string;
  TimeRanges?: InstanceEventWindowTimeRange[];
  Name?: string;
  CronExpression?: string;
  AssociationTarget?: InstanceEventWindowAssociationTarget;
  State?: InstanceEventWindowState | string;
  Tags?: Tag[];
}
export interface AssociateInstanceEventWindowResult {
  InstanceEventWindow?: InstanceEventWindow;
}
export interface AssociateRouteTableRequest {
  DryRun?: boolean;
  RouteTableId: string | undefined;
  SubnetId?: string;
  GatewayId?: string;
}
export declare enum RouteTableAssociationStateCode {
  associated = "associated",
  associating = "associating",
  disassociated = "disassociated",
  disassociating = "disassociating",
  failed = "failed",
}
export interface RouteTableAssociationState {
  State?: RouteTableAssociationStateCode | string;
  StatusMessage?: string;
}
export interface AssociateRouteTableResult {
  AssociationId?: string;
  AssociationState?: RouteTableAssociationState;
}
export interface AssociateSubnetCidrBlockRequest {
  Ipv6CidrBlock: string | undefined;
  SubnetId: string | undefined;
}
export declare enum SubnetCidrBlockStateCode {
  associated = "associated",
  associating = "associating",
  disassociated = "disassociated",
  disassociating = "disassociating",
  failed = "failed",
  failing = "failing",
}
export interface SubnetCidrBlockState {
  State?: SubnetCidrBlockStateCode | string;
  StatusMessage?: string;
}
export interface SubnetIpv6CidrBlockAssociation {
  AssociationId?: string;
  Ipv6CidrBlock?: string;
  Ipv6CidrBlockState?: SubnetCidrBlockState;
}
export interface AssociateSubnetCidrBlockResult {
  Ipv6CidrBlockAssociation?: SubnetIpv6CidrBlockAssociation;
  SubnetId?: string;
}
export interface AssociateTransitGatewayMulticastDomainRequest {
  TransitGatewayMulticastDomainId?: string;
  TransitGatewayAttachmentId?: string;
  SubnetIds?: string[];
  DryRun?: boolean;
}
export interface AssociateTransitGatewayMulticastDomainResult {
  Associations?: TransitGatewayMulticastDomainAssociations;
}
export interface AssociateTransitGatewayPolicyTableRequest {
  TransitGatewayPolicyTableId: string | undefined;
  TransitGatewayAttachmentId: string | undefined;
  DryRun?: boolean;
}
export declare enum TransitGatewayAssociationState {
  associated = "associated",
  associating = "associating",
  disassociated = "disassociated",
  disassociating = "disassociating",
}
export interface TransitGatewayPolicyTableAssociation {
  TransitGatewayPolicyTableId?: string;
  TransitGatewayAttachmentId?: string;
  ResourceId?: string;
  ResourceType?: TransitGatewayAttachmentResourceType | string;
  State?: TransitGatewayAssociationState | string;
}
export interface AssociateTransitGatewayPolicyTableResult {
  Association?: TransitGatewayPolicyTableAssociation;
}
export interface AssociateTransitGatewayRouteTableRequest {
  TransitGatewayRouteTableId: string | undefined;
  TransitGatewayAttachmentId: string | undefined;
  DryRun?: boolean;
}
export interface TransitGatewayAssociation {
  TransitGatewayRouteTableId?: string;
  TransitGatewayAttachmentId?: string;
  ResourceId?: string;
  ResourceType?: TransitGatewayAttachmentResourceType | string;
  State?: TransitGatewayAssociationState | string;
}
export interface AssociateTransitGatewayRouteTableResult {
  Association?: TransitGatewayAssociation;
}
export interface AssociateTrunkInterfaceRequest {
  BranchInterfaceId: string | undefined;
  TrunkInterfaceId: string | undefined;
  VlanId?: number;
  GreKey?: number;
  ClientToken?: string;
  DryRun?: boolean;
}
export declare enum InterfaceProtocolType {
  GRE = "GRE",
  VLAN = "VLAN",
}
export interface TrunkInterfaceAssociation {
  AssociationId?: string;
  BranchInterfaceId?: string;
  TrunkInterfaceId?: string;
  InterfaceProtocol?: InterfaceProtocolType | string;
  VlanId?: number;
  GreKey?: number;
  Tags?: Tag[];
}
export interface AssociateTrunkInterfaceResult {
  InterfaceAssociation?: TrunkInterfaceAssociation;
  ClientToken?: string;
}
export interface AssociateVpcCidrBlockRequest {
  AmazonProvidedIpv6CidrBlock?: boolean;
  CidrBlock?: string;
  VpcId: string | undefined;
  Ipv6CidrBlockNetworkBorderGroup?: string;
  Ipv6Pool?: string;
  Ipv6CidrBlock?: string;
  Ipv4IpamPoolId?: string;
  Ipv4NetmaskLength?: number;
  Ipv6IpamPoolId?: string;
  Ipv6NetmaskLength?: number;
}
export declare enum VpcCidrBlockStateCode {
  associated = "associated",
  associating = "associating",
  disassociated = "disassociated",
  disassociating = "disassociating",
  failed = "failed",
  failing = "failing",
}
export interface VpcCidrBlockState {
  State?: VpcCidrBlockStateCode | string;
  StatusMessage?: string;
}
export interface VpcCidrBlockAssociation {
  AssociationId?: string;
  CidrBlock?: string;
  CidrBlockState?: VpcCidrBlockState;
}
export interface VpcIpv6CidrBlockAssociation {
  AssociationId?: string;
  Ipv6CidrBlock?: string;
  Ipv6CidrBlockState?: VpcCidrBlockState;
  NetworkBorderGroup?: string;
  Ipv6Pool?: string;
}
export interface AssociateVpcCidrBlockResult {
  Ipv6CidrBlockAssociation?: VpcIpv6CidrBlockAssociation;
  CidrBlockAssociation?: VpcCidrBlockAssociation;
  VpcId?: string;
}
export interface AttachClassicLinkVpcRequest {
  DryRun?: boolean;
  Groups: string[] | undefined;
  InstanceId: string | undefined;
  VpcId: string | undefined;
}
export interface AttachClassicLinkVpcResult {
  Return?: boolean;
}
export interface AttachInternetGatewayRequest {
  DryRun?: boolean;
  InternetGatewayId: string | undefined;
  VpcId: string | undefined;
}
export interface EnaSrdUdpSpecification {
  EnaSrdUdpEnabled?: boolean;
}
export interface EnaSrdSpecification {
  EnaSrdEnabled?: boolean;
  EnaSrdUdpSpecification?: EnaSrdUdpSpecification;
}
export interface AttachNetworkInterfaceRequest {
  DeviceIndex: number | undefined;
  DryRun?: boolean;
  InstanceId: string | undefined;
  NetworkInterfaceId: string | undefined;
  NetworkCardIndex?: number;
  EnaSrdSpecification?: EnaSrdSpecification;
}
export interface AttachNetworkInterfaceResult {
  AttachmentId?: string;
  NetworkCardIndex?: number;
}
export interface AttachVerifiedAccessTrustProviderRequest {
  VerifiedAccessInstanceId: string | undefined;
  VerifiedAccessTrustProviderId: string | undefined;
  ClientToken?: string;
  DryRun?: boolean;
}
export declare enum DeviceTrustProviderType {
  crowdstrike = "crowdstrike",
  jamf = "jamf",
}
export declare enum TrustProviderType {
  device = "device",
  user = "user",
}
export declare enum UserTrustProviderType {
  iam_identity_center = "iam-identity-center",
  oidc = "oidc",
}
export interface VerifiedAccessTrustProviderCondensed {
  VerifiedAccessTrustProviderId?: string;
  Description?: string;
  TrustProviderType?: TrustProviderType | string;
  UserTrustProviderType?: UserTrustProviderType | string;
  DeviceTrustProviderType?: DeviceTrustProviderType | string;
}
export interface VerifiedAccessInstance {
  VerifiedAccessInstanceId?: string;
  Description?: string;
  VerifiedAccessTrustProviders?: VerifiedAccessTrustProviderCondensed[];
  CreationTime?: string;
  LastUpdatedTime?: string;
  Tags?: Tag[];
}
export interface DeviceOptions {
  TenantId?: string;
}
export interface OidcOptions {
  Issuer?: string;
  AuthorizationEndpoint?: string;
  TokenEndpoint?: string;
  UserInfoEndpoint?: string;
  ClientId?: string;
  ClientSecret?: string;
  Scope?: string;
}
export interface VerifiedAccessTrustProvider {
  VerifiedAccessTrustProviderId?: string;
  Description?: string;
  TrustProviderType?: TrustProviderType | string;
  UserTrustProviderType?: UserTrustProviderType | string;
  DeviceTrustProviderType?: DeviceTrustProviderType | string;
  OidcOptions?: OidcOptions;
  DeviceOptions?: DeviceOptions;
  PolicyReferenceName?: string;
  CreationTime?: string;
  LastUpdatedTime?: string;
  Tags?: Tag[];
}
export interface AttachVerifiedAccessTrustProviderResult {
  VerifiedAccessTrustProvider?: VerifiedAccessTrustProvider;
  VerifiedAccessInstance?: VerifiedAccessInstance;
}
export interface AttachVolumeRequest {
  Device: string | undefined;
  InstanceId: string | undefined;
  VolumeId: string | undefined;
  DryRun?: boolean;
}
export declare enum VolumeAttachmentState {
  attached = "attached",
  attaching = "attaching",
  busy = "busy",
  detached = "detached",
  detaching = "detaching",
}
export interface VolumeAttachment {
  AttachTime?: Date;
  Device?: string;
  InstanceId?: string;
  State?: VolumeAttachmentState | string;
  VolumeId?: string;
  DeleteOnTermination?: boolean;
}
export interface AttachVpnGatewayRequest {
  VpcId: string | undefined;
  VpnGatewayId: string | undefined;
  DryRun?: boolean;
}
export declare enum AttachmentStatus {
  attached = "attached",
  attaching = "attaching",
  detached = "detached",
  detaching = "detaching",
}
export interface VpcAttachment {
  State?: AttachmentStatus | string;
  VpcId?: string;
}
export interface AttachVpnGatewayResult {
  VpcAttachment?: VpcAttachment;
}
export interface AuthorizeClientVpnIngressRequest {
  ClientVpnEndpointId: string | undefined;
  TargetNetworkCidr: string | undefined;
  AccessGroupId?: string;
  AuthorizeAllGroups?: boolean;
  Description?: string;
  ClientToken?: string;
  DryRun?: boolean;
}
export declare enum ClientVpnAuthorizationRuleStatusCode {
  active = "active",
  authorizing = "authorizing",
  failed = "failed",
  revoking = "revoking",
}
export interface ClientVpnAuthorizationRuleStatus {
  Code?: ClientVpnAuthorizationRuleStatusCode | string;
  Message?: string;
}
export interface AuthorizeClientVpnIngressResult {
  Status?: ClientVpnAuthorizationRuleStatus;
}
export interface IpRange {
  CidrIp?: string;
  Description?: string;
}
export interface Ipv6Range {
  CidrIpv6?: string;
  Description?: string;
}
export interface PrefixListId {
  Description?: string;
  PrefixListId?: string;
}
export interface UserIdGroupPair {
  Description?: string;
  GroupId?: string;
  GroupName?: string;
  PeeringStatus?: string;
  UserId?: string;
  VpcId?: string;
  VpcPeeringConnectionId?: string;
}
export interface IpPermission {
  FromPort?: number;
  IpProtocol?: string;
  IpRanges?: IpRange[];
  Ipv6Ranges?: Ipv6Range[];
  PrefixListIds?: PrefixListId[];
  ToPort?: number;
  UserIdGroupPairs?: UserIdGroupPair[];
}
export interface AuthorizeSecurityGroupEgressRequest {
  DryRun?: boolean;
  GroupId: string | undefined;
  IpPermissions?: IpPermission[];
  TagSpecifications?: TagSpecification[];
  CidrIp?: string;
  FromPort?: number;
  IpProtocol?: string;
  ToPort?: number;
  SourceSecurityGroupName?: string;
  SourceSecurityGroupOwnerId?: string;
}
export interface ReferencedSecurityGroup {
  GroupId?: string;
  PeeringStatus?: string;
  UserId?: string;
  VpcId?: string;
  VpcPeeringConnectionId?: string;
}
export interface SecurityGroupRule {
  SecurityGroupRuleId?: string;
  GroupId?: string;
  GroupOwnerId?: string;
  IsEgress?: boolean;
  IpProtocol?: string;
  FromPort?: number;
  ToPort?: number;
  CidrIpv4?: string;
  CidrIpv6?: string;
  PrefixListId?: string;
  ReferencedGroupInfo?: ReferencedSecurityGroup;
  Description?: string;
  Tags?: Tag[];
}
export interface AuthorizeSecurityGroupEgressResult {
  Return?: boolean;
  SecurityGroupRules?: SecurityGroupRule[];
}
export interface AuthorizeSecurityGroupIngressRequest {
  CidrIp?: string;
  FromPort?: number;
  GroupId?: string;
  GroupName?: string;
  IpPermissions?: IpPermission[];
  IpProtocol?: string;
  SourceSecurityGroupName?: string;
  SourceSecurityGroupOwnerId?: string;
  ToPort?: number;
  DryRun?: boolean;
  TagSpecifications?: TagSpecification[];
}
export interface AuthorizeSecurityGroupIngressResult {
  Return?: boolean;
  SecurityGroupRules?: SecurityGroupRule[];
}
export interface S3Storage {
  AWSAccessKeyId?: string;
  Bucket?: string;
  Prefix?: string;
  UploadPolicy?: Uint8Array;
  UploadPolicySignature?: string;
}
export interface Storage {
  S3?: S3Storage;
}
export interface BundleInstanceRequest {
  InstanceId: string | undefined;
  Storage: Storage | undefined;
  DryRun?: boolean;
}
export interface BundleTaskError {
  Code?: string;
  Message?: string;
}
export declare enum BundleTaskState {
  bundling = "bundling",
  cancelling = "cancelling",
  complete = "complete",
  failed = "failed",
  pending = "pending",
  storing = "storing",
  waiting_for_shutdown = "waiting-for-shutdown",
}
export interface BundleTask {
  BundleId?: string;
  BundleTaskError?: BundleTaskError;
  InstanceId?: string;
  Progress?: string;
  StartTime?: Date;
  State?: BundleTaskState | string;
  Storage?: Storage;
  UpdateTime?: Date;
}
export interface BundleInstanceResult {
  BundleTask?: BundleTask;
}
export interface CancelBundleTaskRequest {
  BundleId: string | undefined;
  DryRun?: boolean;
}
export interface CancelBundleTaskResult {
  BundleTask?: BundleTask;
}
export interface CancelCapacityReservationRequest {
  CapacityReservationId: string | undefined;
  DryRun?: boolean;
}
export interface CancelCapacityReservationResult {
  Return?: boolean;
}
export interface CancelCapacityReservationFleetsRequest {
  DryRun?: boolean;
  CapacityReservationFleetIds: string[] | undefined;
}
export interface CancelCapacityReservationFleetError {
  Code?: string;
  Message?: string;
}
export interface FailedCapacityReservationFleetCancellationResult {
  CapacityReservationFleetId?: string;
  CancelCapacityReservationFleetError?: CancelCapacityReservationFleetError;
}
export declare enum CapacityReservationFleetState {
  ACTIVE = "active",
  CANCELLED = "cancelled",
  CANCELLING = "cancelling",
  EXPIRED = "expired",
  EXPIRING = "expiring",
  FAILED = "failed",
  MODIFYING = "modifying",
  PARTIALLY_FULFILLED = "partially_fulfilled",
  SUBMITTED = "submitted",
}
export interface CapacityReservationFleetCancellationState {
  CurrentFleetState?: CapacityReservationFleetState | string;
  PreviousFleetState?: CapacityReservationFleetState | string;
  CapacityReservationFleetId?: string;
}
export interface CancelCapacityReservationFleetsResult {
  SuccessfulFleetCancellations?: CapacityReservationFleetCancellationState[];
  FailedFleetCancellations?: FailedCapacityReservationFleetCancellationResult[];
}
export interface CancelConversionRequest {
  ConversionTaskId: string | undefined;
  DryRun?: boolean;
  ReasonMessage?: string;
}
export interface CancelExportTaskRequest {
  ExportTaskId: string | undefined;
}
export interface CancelImageLaunchPermissionRequest {
  ImageId: string | undefined;
  DryRun?: boolean;
}
export interface CancelImageLaunchPermissionResult {
  Return?: boolean;
}
export interface CancelImportTaskRequest {
  CancelReason?: string;
  DryRun?: boolean;
  ImportTaskId?: string;
}
export interface CancelImportTaskResult {
  ImportTaskId?: string;
  PreviousState?: string;
  State?: string;
}
export interface CancelReservedInstancesListingRequest {
  ReservedInstancesListingId: string | undefined;
}
export declare enum ListingState {
  available = "available",
  cancelled = "cancelled",
  pending = "pending",
  sold = "sold",
}
export interface InstanceCount {
  InstanceCount?: number;
  State?: ListingState | string;
}
export declare enum CurrencyCodeValues {
  USD = "USD",
}
export interface PriceSchedule {
  Active?: boolean;
  CurrencyCode?: CurrencyCodeValues | string;
  Price?: number;
  Term?: number;
}
export declare enum ListingStatus {
  active = "active",
  cancelled = "cancelled",
  closed = "closed",
  pending = "pending",
}
export interface ReservedInstancesListing {
  ClientToken?: string;
  CreateDate?: Date;
  InstanceCounts?: InstanceCount[];
  PriceSchedules?: PriceSchedule[];
  ReservedInstancesId?: string;
  ReservedInstancesListingId?: string;
  Status?: ListingStatus | string;
  StatusMessage?: string;
  Tags?: Tag[];
  UpdateDate?: Date;
}
export interface CancelReservedInstancesListingResult {
  ReservedInstancesListings?: ReservedInstancesListing[];
}
export interface CancelSpotFleetRequestsRequest {
  DryRun?: boolean;
  SpotFleetRequestIds: string[] | undefined;
  TerminateInstances: boolean | undefined;
}
export declare enum BatchState {
  ACTIVE = "active",
  CANCELLED = "cancelled",
  CANCELLED_RUNNING = "cancelled_running",
  CANCELLED_TERMINATING_INSTANCES = "cancelled_terminating",
  FAILED = "failed",
  MODIFYING = "modifying",
  SUBMITTED = "submitted",
}
export interface CancelSpotFleetRequestsSuccessItem {
  CurrentSpotFleetRequestState?: BatchState | string;
  PreviousSpotFleetRequestState?: BatchState | string;
  SpotFleetRequestId?: string;
}
export declare enum CancelBatchErrorCode {
  FLEET_REQUEST_ID_DOES_NOT_EXIST = "fleetRequestIdDoesNotExist",
  FLEET_REQUEST_ID_MALFORMED = "fleetRequestIdMalformed",
  FLEET_REQUEST_NOT_IN_CANCELLABLE_STATE = "fleetRequestNotInCancellableState",
  UNEXPECTED_ERROR = "unexpectedError",
}
export interface CancelSpotFleetRequestsError {
  Code?: CancelBatchErrorCode | string;
  Message?: string;
}
export interface CancelSpotFleetRequestsErrorItem {
  Error?: CancelSpotFleetRequestsError;
  SpotFleetRequestId?: string;
}
export interface CancelSpotFleetRequestsResponse {
  SuccessfulFleetRequests?: CancelSpotFleetRequestsSuccessItem[];
  UnsuccessfulFleetRequests?: CancelSpotFleetRequestsErrorItem[];
}
export interface CancelSpotInstanceRequestsRequest {
  DryRun?: boolean;
  SpotInstanceRequestIds: string[] | undefined;
}
export declare enum CancelSpotInstanceRequestState {
  active = "active",
  cancelled = "cancelled",
  closed = "closed",
  completed = "completed",
  open = "open",
}
export interface CancelledSpotInstanceRequest {
  SpotInstanceRequestId?: string;
  State?: CancelSpotInstanceRequestState | string;
}
export interface CancelSpotInstanceRequestsResult {
  CancelledSpotInstanceRequests?: CancelledSpotInstanceRequest[];
}
export interface ConfirmProductInstanceRequest {
  InstanceId: string | undefined;
  ProductCode: string | undefined;
  DryRun?: boolean;
}
export interface ConfirmProductInstanceResult {
  OwnerId?: string;
  Return?: boolean;
}
export interface CopyFpgaImageRequest {
  DryRun?: boolean;
  SourceFpgaImageId: string | undefined;
  Description?: string;
  Name?: string;
  SourceRegion: string | undefined;
  ClientToken?: string;
}
export interface CopyFpgaImageResult {
  FpgaImageId?: string;
}
export interface CopyImageRequest {
  ClientToken?: string;
  Description?: string;
  Encrypted?: boolean;
  KmsKeyId?: string;
  Name: string | undefined;
  SourceImageId: string | undefined;
  SourceRegion: string | undefined;
  DestinationOutpostArn?: string;
  DryRun?: boolean;
  CopyImageTags?: boolean;
}
export interface CopyImageResult {
  ImageId?: string;
}
export interface CopySnapshotRequest {
  Description?: string;
  DestinationOutpostArn?: string;
  DestinationRegion?: string;
  Encrypted?: boolean;
  KmsKeyId?: string;
  PresignedUrl?: string;
  SourceRegion: string | undefined;
  SourceSnapshotId: string | undefined;
  TagSpecifications?: TagSpecification[];
  DryRun?: boolean;
}
export interface CopySnapshotResult {
  SnapshotId?: string;
  Tags?: Tag[];
}
export declare enum EndDateType {
  limited = "limited",
  unlimited = "unlimited",
}
export declare enum InstanceMatchCriteria {
  open = "open",
  targeted = "targeted",
}
export declare enum CapacityReservationInstancePlatform {
  LINUX_UNIX = "Linux/UNIX",
  LINUX_WITH_SQL_SERVER_ENTERPRISE = "Linux with SQL Server Enterprise",
  LINUX_WITH_SQL_SERVER_STANDARD = "Linux with SQL Server Standard",
  LINUX_WITH_SQL_SERVER_WEB = "Linux with SQL Server Web",
  RED_HAT_ENTERPRISE_LINUX = "Red Hat Enterprise Linux",
  RHEL_WITH_HA = "RHEL with HA",
  RHEL_WITH_HA_AND_SQL_SERVER_ENTERPRISE = "RHEL with HA and SQL Server Enterprise",
  RHEL_WITH_HA_AND_SQL_SERVER_STANDARD = "RHEL with HA and SQL Server Standard",
  RHEL_WITH_SQL_SERVER_ENTERPRISE = "RHEL with SQL Server Enterprise",
  RHEL_WITH_SQL_SERVER_STANDARD = "RHEL with SQL Server Standard",
  RHEL_WITH_SQL_SERVER_WEB = "RHEL with SQL Server Web",
  SUSE_LINUX = "SUSE Linux",
  WINDOWS = "Windows",
  WINDOWS_WITH_SQL_SERVER = "Windows with SQL Server",
  WINDOWS_WITH_SQL_SERVER_ENTERPRISE = "Windows with SQL Server Enterprise",
  WINDOWS_WITH_SQL_SERVER_STANDARD = "Windows with SQL Server Standard",
  WINDOWS_WITH_SQL_SERVER_WEB = "Windows with SQL Server Web",
}
export declare enum CapacityReservationTenancy {
  dedicated = "dedicated",
  default = "default",
}
export interface CreateCapacityReservationRequest {
  ClientToken?: string;
  InstanceType: string | undefined;
  InstancePlatform: CapacityReservationInstancePlatform | string | undefined;
  AvailabilityZone?: string;
  AvailabilityZoneId?: string;
  Tenancy?: CapacityReservationTenancy | string;
  InstanceCount: number | undefined;
  EbsOptimized?: boolean;
  EphemeralStorage?: boolean;
  EndDate?: Date;
  EndDateType?: EndDateType | string;
  InstanceMatchCriteria?: InstanceMatchCriteria | string;
  TagSpecifications?: TagSpecification[];
  DryRun?: boolean;
  OutpostArn?: string;
  PlacementGroupArn?: string;
}
export interface CapacityAllocation {
  AllocationType?: AllocationType | string;
  Count?: number;
}
export declare enum CapacityReservationState {
  active = "active",
  cancelled = "cancelled",
  expired = "expired",
  failed = "failed",
  pending = "pending",
}
export interface CapacityReservation {
  CapacityReservationId?: string;
  OwnerId?: string;
  CapacityReservationArn?: string;
  AvailabilityZoneId?: string;
  InstanceType?: string;
  InstancePlatform?: CapacityReservationInstancePlatform | string;
  AvailabilityZone?: string;
  Tenancy?: CapacityReservationTenancy | string;
  TotalInstanceCount?: number;
  AvailableInstanceCount?: number;
  EbsOptimized?: boolean;
  EphemeralStorage?: boolean;
  State?: CapacityReservationState | string;
  StartDate?: Date;
  EndDate?: Date;
  EndDateType?: EndDateType | string;
  InstanceMatchCriteria?: InstanceMatchCriteria | string;
  CreateDate?: Date;
  Tags?: Tag[];
  OutpostArn?: string;
  CapacityReservationFleetId?: string;
  PlacementGroupArn?: string;
  CapacityAllocations?: CapacityAllocation[];
}
export interface CreateCapacityReservationResult {
  CapacityReservation?: CapacityReservation;
}
export declare enum FleetInstanceMatchCriteria {
  open = "open",
}
export declare enum _InstanceType {
  a1_2xlarge = "a1.2xlarge",
  a1_4xlarge = "a1.4xlarge",
  a1_large = "a1.large",
  a1_medium = "a1.medium",
  a1_metal = "a1.metal",
  a1_xlarge = "a1.xlarge",
  c1_medium = "c1.medium",
  c1_xlarge = "c1.xlarge",
  c3_2xlarge = "c3.2xlarge",
  c3_4xlarge = "c3.4xlarge",
  c3_8xlarge = "c3.8xlarge",
  c3_large = "c3.large",
  c3_xlarge = "c3.xlarge",
  c4_2xlarge = "c4.2xlarge",
  c4_4xlarge = "c4.4xlarge",
  c4_8xlarge = "c4.8xlarge",
  c4_large = "c4.large",
  c4_xlarge = "c4.xlarge",
  c5_12xlarge = "c5.12xlarge",
  c5_18xlarge = "c5.18xlarge",
  c5_24xlarge = "c5.24xlarge",
  c5_2xlarge = "c5.2xlarge",
  c5_4xlarge = "c5.4xlarge",
  c5_9xlarge = "c5.9xlarge",
  c5_large = "c5.large",
  c5_metal = "c5.metal",
  c5_xlarge = "c5.xlarge",
  c5a_12xlarge = "c5a.12xlarge",
  c5a_16xlarge = "c5a.16xlarge",
  c5a_24xlarge = "c5a.24xlarge",
  c5a_2xlarge = "c5a.2xlarge",
  c5a_4xlarge = "c5a.4xlarge",
  c5a_8xlarge = "c5a.8xlarge",
  c5a_large = "c5a.large",
  c5a_xlarge = "c5a.xlarge",
  c5ad_12xlarge = "c5ad.12xlarge",
  c5ad_16xlarge = "c5ad.16xlarge",
  c5ad_24xlarge = "c5ad.24xlarge",
  c5ad_2xlarge = "c5ad.2xlarge",
  c5ad_4xlarge = "c5ad.4xlarge",
  c5ad_8xlarge = "c5ad.8xlarge",
  c5ad_large = "c5ad.large",
  c5ad_xlarge = "c5ad.xlarge",
  c5d_12xlarge = "c5d.12xlarge",
  c5d_18xlarge = "c5d.18xlarge",
  c5d_24xlarge = "c5d.24xlarge",
  c5d_2xlarge = "c5d.2xlarge",
  c5d_4xlarge = "c5d.4xlarge",
  c5d_9xlarge = "c5d.9xlarge",
  c5d_large = "c5d.large",
  c5d_metal = "c5d.metal",
  c5d_xlarge = "c5d.xlarge",
  c5n_18xlarge = "c5n.18xlarge",
  c5n_2xlarge = "c5n.2xlarge",
  c5n_4xlarge = "c5n.4xlarge",
  c5n_9xlarge = "c5n.9xlarge",
  c5n_large = "c5n.large",
  c5n_metal = "c5n.metal",
  c5n_xlarge = "c5n.xlarge",
  c6a_12xlarge = "c6a.12xlarge",
  c6a_16xlarge = "c6a.16xlarge",
  c6a_24xlarge = "c6a.24xlarge",
  c6a_2xlarge = "c6a.2xlarge",
  c6a_32xlarge = "c6a.32xlarge",
  c6a_48xlarge = "c6a.48xlarge",
  c6a_4xlarge = "c6a.4xlarge",
  c6a_8xlarge = "c6a.8xlarge",
  c6a_large = "c6a.large",
  c6a_metal = "c6a.metal",
  c6a_xlarge = "c6a.xlarge",
  c6g_12xlarge = "c6g.12xlarge",
  c6g_16xlarge = "c6g.16xlarge",
  c6g_2xlarge = "c6g.2xlarge",
  c6g_4xlarge = "c6g.4xlarge",
  c6g_8xlarge = "c6g.8xlarge",
  c6g_large = "c6g.large",
  c6g_medium = "c6g.medium",
  c6g_metal = "c6g.metal",
  c6g_xlarge = "c6g.xlarge",
  c6gd_12xlarge = "c6gd.12xlarge",
  c6gd_16xlarge = "c6gd.16xlarge",
  c6gd_2xlarge = "c6gd.2xlarge",
  c6gd_4xlarge = "c6gd.4xlarge",
  c6gd_8xlarge = "c6gd.8xlarge",
  c6gd_large = "c6gd.large",
  c6gd_medium = "c6gd.medium",
  c6gd_metal = "c6gd.metal",
  c6gd_xlarge = "c6gd.xlarge",
  c6gn_12xlarge = "c6gn.12xlarge",
  c6gn_16xlarge = "c6gn.16xlarge",
  c6gn_2xlarge = "c6gn.2xlarge",
  c6gn_4xlarge = "c6gn.4xlarge",
  c6gn_8xlarge = "c6gn.8xlarge",
  c6gn_large = "c6gn.large",
  c6gn_medium = "c6gn.medium",
  c6gn_xlarge = "c6gn.xlarge",
  c6i_12xlarge = "c6i.12xlarge",
  c6i_16xlarge = "c6i.16xlarge",
  c6i_24xlarge = "c6i.24xlarge",
  c6i_2xlarge = "c6i.2xlarge",
  c6i_32xlarge = "c6i.32xlarge",
  c6i_4xlarge = "c6i.4xlarge",
  c6i_8xlarge = "c6i.8xlarge",
  c6i_large = "c6i.large",
  c6i_metal = "c6i.metal",
  c6i_xlarge = "c6i.xlarge",
  c6id_12xlarge = "c6id.12xlarge",
  c6id_16xlarge = "c6id.16xlarge",
  c6id_24xlarge = "c6id.24xlarge",
  c6id_2xlarge = "c6id.2xlarge",
  c6id_32xlarge = "c6id.32xlarge",
  c6id_4xlarge = "c6id.4xlarge",
  c6id_8xlarge = "c6id.8xlarge",
  c6id_large = "c6id.large",
  c6id_metal = "c6id.metal",
  c6id_xlarge = "c6id.xlarge",
  c7g_12xlarge = "c7g.12xlarge",
  c7g_16xlarge = "c7g.16xlarge",
  c7g_2xlarge = "c7g.2xlarge",
  c7g_4xlarge = "c7g.4xlarge",
  c7g_8xlarge = "c7g.8xlarge",
  c7g_large = "c7g.large",
  c7g_medium = "c7g.medium",
  c7g_xlarge = "c7g.xlarge",
  cc1_4xlarge = "cc1.4xlarge",
  cc2_8xlarge = "cc2.8xlarge",
  cg1_4xlarge = "cg1.4xlarge",
  cr1_8xlarge = "cr1.8xlarge",
  d2_2xlarge = "d2.2xlarge",
  d2_4xlarge = "d2.4xlarge",
  d2_8xlarge = "d2.8xlarge",
  d2_xlarge = "d2.xlarge",
  d3_2xlarge = "d3.2xlarge",
  d3_4xlarge = "d3.4xlarge",
  d3_8xlarge = "d3.8xlarge",
  d3_xlarge = "d3.xlarge",
  d3en_12xlarge = "d3en.12xlarge",
  d3en_2xlarge = "d3en.2xlarge",
  d3en_4xlarge = "d3en.4xlarge",
  d3en_6xlarge = "d3en.6xlarge",
  d3en_8xlarge = "d3en.8xlarge",
  d3en_xlarge = "d3en.xlarge",
  dl1_24xlarge = "dl1.24xlarge",
  f1_16xlarge = "f1.16xlarge",
  f1_2xlarge = "f1.2xlarge",
  f1_4xlarge = "f1.4xlarge",
  g2_2xlarge = "g2.2xlarge",
  g2_8xlarge = "g2.8xlarge",
  g3_16xlarge = "g3.16xlarge",
  g3_4xlarge = "g3.4xlarge",
  g3_8xlarge = "g3.8xlarge",
  g3s_xlarge = "g3s.xlarge",
  g4ad_16xlarge = "g4ad.16xlarge",
  g4ad_2xlarge = "g4ad.2xlarge",
  g4ad_4xlarge = "g4ad.4xlarge",
  g4ad_8xlarge = "g4ad.8xlarge",
  g4ad_xlarge = "g4ad.xlarge",
  g4dn_12xlarge = "g4dn.12xlarge",
  g4dn_16xlarge = "g4dn.16xlarge",
  g4dn_2xlarge = "g4dn.2xlarge",
  g4dn_4xlarge = "g4dn.4xlarge",
  g4dn_8xlarge = "g4dn.8xlarge",
  g4dn_metal = "g4dn.metal",
  g4dn_xlarge = "g4dn.xlarge",
  g5_12xlarge = "g5.12xlarge",
  g5_16xlarge = "g5.16xlarge",
  g5_24xlarge = "g5.24xlarge",
  g5_2xlarge = "g5.2xlarge",
  g5_48xlarge = "g5.48xlarge",
  g5_4xlarge = "g5.4xlarge",
  g5_8xlarge = "g5.8xlarge",
  g5_xlarge = "g5.xlarge",
  g5g_16xlarge = "g5g.16xlarge",
  g5g_2xlarge = "g5g.2xlarge",
  g5g_4xlarge = "g5g.4xlarge",
  g5g_8xlarge = "g5g.8xlarge",
  g5g_metal = "g5g.metal",
  g5g_xlarge = "g5g.xlarge",
  h1_16xlarge = "h1.16xlarge",
  h1_2xlarge = "h1.2xlarge",
  h1_4xlarge = "h1.4xlarge",
  h1_8xlarge = "h1.8xlarge",
  hi1_4xlarge = "hi1.4xlarge",
  hpc6a_48xlarge = "hpc6a.48xlarge",
  hpc6id_32xlarge = "hpc6id.32xlarge",
  hs1_8xlarge = "hs1.8xlarge",
  i2_2xlarge = "i2.2xlarge",
  i2_4xlarge = "i2.4xlarge",
  i2_8xlarge = "i2.8xlarge",
  i2_xlarge = "i2.xlarge",
  i3_16xlarge = "i3.16xlarge",
  i3_2xlarge = "i3.2xlarge",
  i3_4xlarge = "i3.4xlarge",
  i3_8xlarge = "i3.8xlarge",
  i3_large = "i3.large",
  i3_metal = "i3.metal",
  i3_xlarge = "i3.xlarge",
  i3en_12xlarge = "i3en.12xlarge",
  i3en_24xlarge = "i3en.24xlarge",
  i3en_2xlarge = "i3en.2xlarge",
  i3en_3xlarge = "i3en.3xlarge",
  i3en_6xlarge = "i3en.6xlarge",
  i3en_large = "i3en.large",
  i3en_metal = "i3en.metal",
  i3en_xlarge = "i3en.xlarge",
  i4i_16xlarge = "i4i.16xlarge",
  i4i_2xlarge = "i4i.2xlarge",
  i4i_32xlarge = "i4i.32xlarge",
  i4i_4xlarge = "i4i.4xlarge",
  i4i_8xlarge = "i4i.8xlarge",
  i4i_large = "i4i.large",
  i4i_metal = "i4i.metal",
  i4i_xlarge = "i4i.xlarge",
  im4gn_16xlarge = "im4gn.16xlarge",
  im4gn_2xlarge = "im4gn.2xlarge",
  im4gn_4xlarge = "im4gn.4xlarge",
  im4gn_8xlarge = "im4gn.8xlarge",
  im4gn_large = "im4gn.large",
  im4gn_xlarge = "im4gn.xlarge",
  inf1_24xlarge = "inf1.24xlarge",
  inf1_2xlarge = "inf1.2xlarge",
  inf1_6xlarge = "inf1.6xlarge",
  inf1_xlarge = "inf1.xlarge",
  is4gen_2xlarge = "is4gen.2xlarge",
  is4gen_4xlarge = "is4gen.4xlarge",
  is4gen_8xlarge = "is4gen.8xlarge",
  is4gen_large = "is4gen.large",
  is4gen_medium = "is4gen.medium",
  is4gen_xlarge = "is4gen.xlarge",
  m1_large = "m1.large",
  m1_medium = "m1.medium",
  m1_small = "m1.small",
  m1_xlarge = "m1.xlarge",
  m2_2xlarge = "m2.2xlarge",
  m2_4xlarge = "m2.4xlarge",
  m2_xlarge = "m2.xlarge",
  m3_2xlarge = "m3.2xlarge",
  m3_large = "m3.large",
  m3_medium = "m3.medium",
  m3_xlarge = "m3.xlarge",
  m4_10xlarge = "m4.10xlarge",
  m4_16xlarge = "m4.16xlarge",
  m4_2xlarge = "m4.2xlarge",
  m4_4xlarge = "m4.4xlarge",
  m4_large = "m4.large",
  m4_xlarge = "m4.xlarge",
  m5_12xlarge = "m5.12xlarge",
  m5_16xlarge = "m5.16xlarge",
  m5_24xlarge = "m5.24xlarge",
  m5_2xlarge = "m5.2xlarge",
  m5_4xlarge = "m5.4xlarge",
  m5_8xlarge = "m5.8xlarge",
  m5_large = "m5.large",
  m5_metal = "m5.metal",
  m5_xlarge = "m5.xlarge",
  m5a_12xlarge = "m5a.12xlarge",
  m5a_16xlarge = "m5a.16xlarge",
  m5a_24xlarge = "m5a.24xlarge",
  m5a_2xlarge = "m5a.2xlarge",
  m5a_4xlarge = "m5a.4xlarge",
  m5a_8xlarge = "m5a.8xlarge",
  m5a_large = "m5a.large",
  m5a_xlarge = "m5a.xlarge",
  m5ad_12xlarge = "m5ad.12xlarge",
  m5ad_16xlarge = "m5ad.16xlarge",
  m5ad_24xlarge = "m5ad.24xlarge",
  m5ad_2xlarge = "m5ad.2xlarge",
  m5ad_4xlarge = "m5ad.4xlarge",
  m5ad_8xlarge = "m5ad.8xlarge",
  m5ad_large = "m5ad.large",
  m5ad_xlarge = "m5ad.xlarge",
  m5d_12xlarge = "m5d.12xlarge",
  m5d_16xlarge = "m5d.16xlarge",
  m5d_24xlarge = "m5d.24xlarge",
  m5d_2xlarge = "m5d.2xlarge",
  m5d_4xlarge = "m5d.4xlarge",
  m5d_8xlarge = "m5d.8xlarge",
  m5d_large = "m5d.large",
  m5d_metal = "m5d.metal",
  m5d_xlarge = "m5d.xlarge",
  m5dn_12xlarge = "m5dn.12xlarge",
  m5dn_16xlarge = "m5dn.16xlarge",
  m5dn_24xlarge = "m5dn.24xlarge",
  m5dn_2xlarge = "m5dn.2xlarge",
  m5dn_4xlarge = "m5dn.4xlarge",
  m5dn_8xlarge = "m5dn.8xlarge",
  m5dn_large = "m5dn.large",
  m5dn_metal = "m5dn.metal",
  m5dn_xlarge = "m5dn.xlarge",
  m5n_12xlarge = "m5n.12xlarge",
  m5n_16xlarge = "m5n.16xlarge",
  m5n_24xlarge = "m5n.24xlarge",
  m5n_2xlarge = "m5n.2xlarge",
  m5n_4xlarge = "m5n.4xlarge",
  m5n_8xlarge = "m5n.8xlarge",
  m5n_large = "m5n.large",
  m5n_metal = "m5n.metal",
  m5n_xlarge = "m5n.xlarge",
  m5zn_12xlarge = "m5zn.12xlarge",
  m5zn_2xlarge = "m5zn.2xlarge",
  m5zn_3xlarge = "m5zn.3xlarge",
  m5zn_6xlarge = "m5zn.6xlarge",
  m5zn_large = "m5zn.large",
  m5zn_metal = "m5zn.metal",
  m5zn_xlarge = "m5zn.xlarge",
  m6a_12xlarge = "m6a.12xlarge",
  m6a_16xlarge = "m6a.16xlarge",
  m6a_24xlarge = "m6a.24xlarge",
  m6a_2xlarge = "m6a.2xlarge",
  m6a_32xlarge = "m6a.32xlarge",
  m6a_48xlarge = "m6a.48xlarge",
  m6a_4xlarge = "m6a.4xlarge",
  m6a_8xlarge = "m6a.8xlarge",
  m6a_large = "m6a.large",
  m6a_metal = "m6a.metal",
  m6a_xlarge = "m6a.xlarge",
  m6g_12xlarge = "m6g.12xlarge",
  m6g_16xlarge = "m6g.16xlarge",
  m6g_2xlarge = "m6g.2xlarge",
  m6g_4xlarge = "m6g.4xlarge",
  m6g_8xlarge = "m6g.8xlarge",
  m6g_large = "m6g.large",
  m6g_medium = "m6g.medium",
  m6g_metal = "m6g.metal",
  m6g_xlarge = "m6g.xlarge",
  m6gd_12xlarge = "m6gd.12xlarge",
  m6gd_16xlarge = "m6gd.16xlarge",
  m6gd_2xlarge = "m6gd.2xlarge",
  m6gd_4xlarge = "m6gd.4xlarge",
  m6gd_8xlarge = "m6gd.8xlarge",
  m6gd_large = "m6gd.large",
  m6gd_medium = "m6gd.medium",
  m6gd_metal = "m6gd.metal",
  m6gd_xlarge = "m6gd.xlarge",
  m6i_12xlarge = "m6i.12xlarge",
  m6i_16xlarge = "m6i.16xlarge",
  m6i_24xlarge = "m6i.24xlarge",
  m6i_2xlarge = "m6i.2xlarge",
  m6i_32xlarge = "m6i.32xlarge",
  m6i_4xlarge = "m6i.4xlarge",
  m6i_8xlarge = "m6i.8xlarge",
  m6i_large = "m6i.large",
  m6i_metal = "m6i.metal",
  m6i_xlarge = "m6i.xlarge",
  m6id_12xlarge = "m6id.12xlarge",
  m6id_16xlarge = "m6id.16xlarge",
  m6id_24xlarge = "m6id.24xlarge",
  m6id_2xlarge = "m6id.2xlarge",
  m6id_32xlarge = "m6id.32xlarge",
  m6id_4xlarge = "m6id.4xlarge",
  m6id_8xlarge = "m6id.8xlarge",
  m6id_large = "m6id.large",
  m6id_metal = "m6id.metal",
  m6id_xlarge = "m6id.xlarge",
  mac1_metal = "mac1.metal",
  mac2_metal = "mac2.metal",
  p2_16xlarge = "p2.16xlarge",
  p2_8xlarge = "p2.8xlarge",
  p2_xlarge = "p2.xlarge",
  p3_16xlarge = "p3.16xlarge",
  p3_2xlarge = "p3.2xlarge",
  p3_8xlarge = "p3.8xlarge",
  p3dn_24xlarge = "p3dn.24xlarge",
  p4d_24xlarge = "p4d.24xlarge",
  p4de_24xlarge = "p4de.24xlarge",
  r3_2xlarge = "r3.2xlarge",
  r3_4xlarge = "r3.4xlarge",
  r3_8xlarge = "r3.8xlarge",
  r3_large = "r3.large",
  r3_xlarge = "r3.xlarge",
  r4_16xlarge = "r4.16xlarge",
  r4_2xlarge = "r4.2xlarge",
  r4_4xlarge = "r4.4xlarge",
  r4_8xlarge = "r4.8xlarge",
  r4_large = "r4.large",
  r4_xlarge = "r4.xlarge",
  r5_12xlarge = "r5.12xlarge",
  r5_16xlarge = "r5.16xlarge",
  r5_24xlarge = "r5.24xlarge",
  r5_2xlarge = "r5.2xlarge",
  r5_4xlarge = "r5.4xlarge",
  r5_8xlarge = "r5.8xlarge",
  r5_large = "r5.large",
  r5_metal = "r5.metal",
  r5_xlarge = "r5.xlarge",
  r5a_12xlarge = "r5a.12xlarge",
  r5a_16xlarge = "r5a.16xlarge",
  r5a_24xlarge = "r5a.24xlarge",
  r5a_2xlarge = "r5a.2xlarge",
  r5a_4xlarge = "r5a.4xlarge",
  r5a_8xlarge = "r5a.8xlarge",
  r5a_large = "r5a.large",
  r5a_xlarge = "r5a.xlarge",
  r5ad_12xlarge = "r5ad.12xlarge",
  r5ad_16xlarge = "r5ad.16xlarge",
  r5ad_24xlarge = "r5ad.24xlarge",
  r5ad_2xlarge = "r5ad.2xlarge",
  r5ad_4xlarge = "r5ad.4xlarge",
  r5ad_8xlarge = "r5ad.8xlarge",
  r5ad_large = "r5ad.large",
  r5ad_xlarge = "r5ad.xlarge",
  r5b_12xlarge = "r5b.12xlarge",
  r5b_16xlarge = "r5b.16xlarge",
  r5b_24xlarge = "r5b.24xlarge",
  r5b_2xlarge = "r5b.2xlarge",
  r5b_4xlarge = "r5b.4xlarge",
  r5b_8xlarge = "r5b.8xlarge",
  r5b_large = "r5b.large",
  r5b_metal = "r5b.metal",
  r5b_xlarge = "r5b.xlarge",
  r5d_12xlarge = "r5d.12xlarge",
  r5d_16xlarge = "r5d.16xlarge",
  r5d_24xlarge = "r5d.24xlarge",
  r5d_2xlarge = "r5d.2xlarge",
  r5d_4xlarge = "r5d.4xlarge",
  r5d_8xlarge = "r5d.8xlarge",
  r5d_large = "r5d.large",
  r5d_metal = "r5d.metal",
  r5d_xlarge = "r5d.xlarge",
  r5dn_12xlarge = "r5dn.12xlarge",
  r5dn_16xlarge = "r5dn.16xlarge",
  r5dn_24xlarge = "r5dn.24xlarge",
  r5dn_2xlarge = "r5dn.2xlarge",
  r5dn_4xlarge = "r5dn.4xlarge",
  r5dn_8xlarge = "r5dn.8xlarge",
  r5dn_large = "r5dn.large",
  r5dn_metal = "r5dn.metal",
  r5dn_xlarge = "r5dn.xlarge",
  r5n_12xlarge = "r5n.12xlarge",
  r5n_16xlarge = "r5n.16xlarge",
  r5n_24xlarge = "r5n.24xlarge",
  r5n_2xlarge = "r5n.2xlarge",
  r5n_4xlarge = "r5n.4xlarge",
  r5n_8xlarge = "r5n.8xlarge",
  r5n_large = "r5n.large",
  r5n_metal = "r5n.metal",
  r5n_xlarge = "r5n.xlarge",
  r6a_12xlarge = "r6a.12xlarge",
  r6a_16xlarge = "r6a.16xlarge",
  r6a_24xlarge = "r6a.24xlarge",
  r6a_2xlarge = "r6a.2xlarge",
  r6a_32xlarge = "r6a.32xlarge",
  r6a_48xlarge = "r6a.48xlarge",
  r6a_4xlarge = "r6a.4xlarge",
  r6a_8xlarge = "r6a.8xlarge",
  r6a_large = "r6a.large",
  r6a_metal = "r6a.metal",
  r6a_xlarge = "r6a.xlarge",
  r6g_12xlarge = "r6g.12xlarge",
  r6g_16xlarge = "r6g.16xlarge",
  r6g_2xlarge = "r6g.2xlarge",
  r6g_4xlarge = "r6g.4xlarge",
  r6g_8xlarge = "r6g.8xlarge",
  r6g_large = "r6g.large",
  r6g_medium = "r6g.medium",
  r6g_metal = "r6g.metal",
  r6g_xlarge = "r6g.xlarge",
  r6gd_12xlarge = "r6gd.12xlarge",
  r6gd_16xlarge = "r6gd.16xlarge",
  r6gd_2xlarge = "r6gd.2xlarge",
  r6gd_4xlarge = "r6gd.4xlarge",
  r6gd_8xlarge = "r6gd.8xlarge",
  r6gd_large = "r6gd.large",
  r6gd_medium = "r6gd.medium",
  r6gd_metal = "r6gd.metal",
  r6gd_xlarge = "r6gd.xlarge",
  r6i_12xlarge = "r6i.12xlarge",
  r6i_16xlarge = "r6i.16xlarge",
  r6i_24xlarge = "r6i.24xlarge",
  r6i_2xlarge = "r6i.2xlarge",
  r6i_32xlarge = "r6i.32xlarge",
  r6i_4xlarge = "r6i.4xlarge",
  r6i_8xlarge = "r6i.8xlarge",
  r6i_large = "r6i.large",
  r6i_metal = "r6i.metal",
  r6i_xlarge = "r6i.xlarge",
  r6id_12xlarge = "r6id.12xlarge",
  r6id_16xlarge = "r6id.16xlarge",
  r6id_24xlarge = "r6id.24xlarge",
  r6id_2xlarge = "r6id.2xlarge",
  r6id_32xlarge = "r6id.32xlarge",
  r6id_4xlarge = "r6id.4xlarge",
  r6id_8xlarge = "r6id.8xlarge",
  r6id_large = "r6id.large",
  r6id_metal = "r6id.metal",
  r6id_xlarge = "r6id.xlarge",
  t1_micro = "t1.micro",
  t2_2xlarge = "t2.2xlarge",
  t2_large = "t2.large",
  t2_medium = "t2.medium",
  t2_micro = "t2.micro",
  t2_nano = "t2.nano",
  t2_small = "t2.small",
  t2_xlarge = "t2.xlarge",
  t3_2xlarge = "t3.2xlarge",
  t3_large = "t3.large",
  t3_medium = "t3.medium",
  t3_micro = "t3.micro",
  t3_nano = "t3.nano",
  t3_small = "t3.small",
  t3_xlarge = "t3.xlarge",
  t3a_2xlarge = "t3a.2xlarge",
  t3a_large = "t3a.large",
  t3a_medium = "t3a.medium",
  t3a_micro = "t3a.micro",
  t3a_nano = "t3a.nano",
  t3a_small = "t3a.small",
  t3a_xlarge = "t3a.xlarge",
  t4g_2xlarge = "t4g.2xlarge",
  t4g_large = "t4g.large",
  t4g_medium = "t4g.medium",
  t4g_micro = "t4g.micro",
  t4g_nano = "t4g.nano",
  t4g_small = "t4g.small",
  t4g_xlarge = "t4g.xlarge",
  trn1_2xlarge = "trn1.2xlarge",
  trn1_32xlarge = "trn1.32xlarge",
  u_12tb1_112xlarge = "u-12tb1.112xlarge",
  u_12tb1_metal = "u-12tb1.metal",
  u_18tb1_112xlarge = "u-18tb1.112xlarge",
  u_18tb1_metal = "u-18tb1.metal",
  u_24tb1_112xlarge = "u-24tb1.112xlarge",
  u_24tb1_metal = "u-24tb1.metal",
  u_3tb1_56xlarge = "u-3tb1.56xlarge",
  u_6tb1_112xlarge = "u-6tb1.112xlarge",
  u_6tb1_56xlarge = "u-6tb1.56xlarge",
  u_6tb1_metal = "u-6tb1.metal",
  u_9tb1_112xlarge = "u-9tb1.112xlarge",
  u_9tb1_metal = "u-9tb1.metal",
  vt1_24xlarge = "vt1.24xlarge",
  vt1_3xlarge = "vt1.3xlarge",
  vt1_6xlarge = "vt1.6xlarge",
  x1_16xlarge = "x1.16xlarge",
  x1_32xlarge = "x1.32xlarge",
  x1e_16xlarge = "x1e.16xlarge",
  x1e_2xlarge = "x1e.2xlarge",
  x1e_32xlarge = "x1e.32xlarge",
  x1e_4xlarge = "x1e.4xlarge",
  x1e_8xlarge = "x1e.8xlarge",
  x1e_xlarge = "x1e.xlarge",
  x2gd_12xlarge = "x2gd.12xlarge",
  x2gd_16xlarge = "x2gd.16xlarge",
  x2gd_2xlarge = "x2gd.2xlarge",
  x2gd_4xlarge = "x2gd.4xlarge",
  x2gd_8xlarge = "x2gd.8xlarge",
  x2gd_large = "x2gd.large",
  x2gd_medium = "x2gd.medium",
  x2gd_metal = "x2gd.metal",
  x2gd_xlarge = "x2gd.xlarge",
  x2idn_16xlarge = "x2idn.16xlarge",
  x2idn_24xlarge = "x2idn.24xlarge",
  x2idn_32xlarge = "x2idn.32xlarge",
  x2idn_metal = "x2idn.metal",
  x2iedn_16xlarge = "x2iedn.16xlarge",
  x2iedn_24xlarge = "x2iedn.24xlarge",
  x2iedn_2xlarge = "x2iedn.2xlarge",
  x2iedn_32xlarge = "x2iedn.32xlarge",
  x2iedn_4xlarge = "x2iedn.4xlarge",
  x2iedn_8xlarge = "x2iedn.8xlarge",
  x2iedn_metal = "x2iedn.metal",
  x2iedn_xlarge = "x2iedn.xlarge",
  x2iezn_12xlarge = "x2iezn.12xlarge",
  x2iezn_2xlarge = "x2iezn.2xlarge",
  x2iezn_4xlarge = "x2iezn.4xlarge",
  x2iezn_6xlarge = "x2iezn.6xlarge",
  x2iezn_8xlarge = "x2iezn.8xlarge",
  x2iezn_metal = "x2iezn.metal",
  z1d_12xlarge = "z1d.12xlarge",
  z1d_2xlarge = "z1d.2xlarge",
  z1d_3xlarge = "z1d.3xlarge",
  z1d_6xlarge = "z1d.6xlarge",
  z1d_large = "z1d.large",
  z1d_metal = "z1d.metal",
  z1d_xlarge = "z1d.xlarge",
}
export interface ReservationFleetInstanceSpecification {
  InstanceType?: _InstanceType | string;
  InstancePlatform?: CapacityReservationInstancePlatform | string;
  Weight?: number;
  AvailabilityZone?: string;
  AvailabilityZoneId?: string;
  EbsOptimized?: boolean;
  Priority?: number;
}
export declare enum FleetCapacityReservationTenancy {
  default = "default",
}
export interface CreateCapacityReservationFleetRequest {
  AllocationStrategy?: string;
  ClientToken?: string;
  InstanceTypeSpecifications:
    | ReservationFleetInstanceSpecification[]
    | undefined;
  Tenancy?: FleetCapacityReservationTenancy | string;
  TotalTargetCapacity: number | undefined;
  EndDate?: Date;
  InstanceMatchCriteria?: FleetInstanceMatchCriteria | string;
  TagSpecifications?: TagSpecification[];
  DryRun?: boolean;
}
export interface FleetCapacityReservation {
  CapacityReservationId?: string;
  AvailabilityZoneId?: string;
  InstanceType?: _InstanceType | string;
  InstancePlatform?: CapacityReservationInstancePlatform | string;
  AvailabilityZone?: string;
  TotalInstanceCount?: number;
  FulfilledCapacity?: number;
  EbsOptimized?: boolean;
  CreateDate?: Date;
  Weight?: number;
  Priority?: number;
}
export interface CreateCapacityReservationFleetResult {
  CapacityReservationFleetId?: string;
  State?: CapacityReservationFleetState | string;
  TotalTargetCapacity?: number;
  TotalFulfilledCapacity?: number;
  InstanceMatchCriteria?: FleetInstanceMatchCriteria | string;
  AllocationStrategy?: string;
  CreateTime?: Date;
  EndDate?: Date;
  Tenancy?: FleetCapacityReservationTenancy | string;
  FleetCapacityReservations?: FleetCapacityReservation[];
  Tags?: Tag[];
}
export interface CreateCarrierGatewayRequest {
  VpcId: string | undefined;
  TagSpecifications?: TagSpecification[];
  DryRun?: boolean;
  ClientToken?: string;
}
export declare enum CarrierGatewayState {
  available = "available",
  deleted = "deleted",
  deleting = "deleting",
  pending = "pending",
}
export interface CarrierGateway {
  CarrierGatewayId?: string;
  VpcId?: string;
  State?: CarrierGatewayState | string;
  OwnerId?: string;
  Tags?: Tag[];
}
export interface CreateCarrierGatewayResult {
  CarrierGateway?: CarrierGateway;
}
export interface DirectoryServiceAuthenticationRequest {
  DirectoryId?: string;
}
export interface FederatedAuthenticationRequest {
  SAMLProviderArn?: string;
  SelfServiceSAMLProviderArn?: string;
}
export interface CertificateAuthenticationRequest {
  ClientRootCertificateChainArn?: string;
}
export declare enum ClientVpnAuthenticationType {
  certificate_authentication = "certificate-authentication",
  directory_service_authentication = "directory-service-authentication",
  federated_authentication = "federated-authentication",
}
export interface ClientVpnAuthenticationRequest {
  Type?: ClientVpnAuthenticationType | string;
  ActiveDirectory?: DirectoryServiceAuthenticationRequest;
  MutualAuthentication?: CertificateAuthenticationRequest;
  FederatedAuthentication?: FederatedAuthenticationRequest;
}
export interface ClientConnectOptions {
  Enabled?: boolean;
  LambdaFunctionArn?: string;
}
export interface ClientLoginBannerOptions {
  Enabled?: boolean;
  BannerText?: string;
}
export interface ConnectionLogOptions {
  Enabled?: boolean;
  CloudwatchLogGroup?: string;
  CloudwatchLogStream?: string;
}
export declare enum SelfServicePortal {
  disabled = "disabled",
  enabled = "enabled",
}
export declare enum TransportProtocol {
  tcp = "tcp",
  udp = "udp",
}
export interface CreateClientVpnEndpointRequest {
  ClientCidrBlock: string | undefined;
  ServerCertificateArn: string | undefined;
  AuthenticationOptions: ClientVpnAuthenticationRequest[] | undefined;
  ConnectionLogOptions: ConnectionLogOptions | undefined;
  DnsServers?: string[];
  TransportProtocol?: TransportProtocol | string;
  VpnPort?: number;
  Description?: string;
  SplitTunnel?: boolean;
  DryRun?: boolean;
  ClientToken?: string;
  TagSpecifications?: TagSpecification[];
  SecurityGroupIds?: string[];
  VpcId?: string;
  SelfServicePortal?: SelfServicePortal | string;
  ClientConnectOptions?: ClientConnectOptions;
  SessionTimeoutHours?: number;
  ClientLoginBannerOptions?: ClientLoginBannerOptions;
}
export declare enum ClientVpnEndpointStatusCode {
  available = "available",
  deleted = "deleted",
  deleting = "deleting",
  pending_associate = "pending-associate",
}
export interface ClientVpnEndpointStatus {
  Code?: ClientVpnEndpointStatusCode | string;
  Message?: string;
}
export interface CreateClientVpnEndpointResult {
  ClientVpnEndpointId?: string;
  Status?: ClientVpnEndpointStatus;
  DnsName?: string;
}
export interface CreateClientVpnRouteRequest {
  ClientVpnEndpointId: string | undefined;
  DestinationCidrBlock: string | undefined;
  TargetVpcSubnetId: string | undefined;
  Description?: string;
  ClientToken?: string;
  DryRun?: boolean;
}
export declare enum ClientVpnRouteStatusCode {
  active = "active",
  creating = "creating",
  deleting = "deleting",
  failed = "failed",
}
export interface ClientVpnRouteStatus {
  Code?: ClientVpnRouteStatusCode | string;
  Message?: string;
}
export interface CreateClientVpnRouteResult {
  Status?: ClientVpnRouteStatus;
}
export interface CreateCoipCidrRequest {
  Cidr: string | undefined;
  CoipPoolId: string | undefined;
  DryRun?: boolean;
}
export interface CoipCidr {
  Cidr?: string;
  CoipPoolId?: string;
  LocalGatewayRouteTableId?: string;
}
export declare const AcceleratorCountFilterSensitiveLog: (
  obj: AcceleratorCount
) => any;
export declare const AcceleratorCountRequestFilterSensitiveLog: (
  obj: AcceleratorCountRequest
) => any;
export declare const AcceleratorTotalMemoryMiBFilterSensitiveLog: (
  obj: AcceleratorTotalMemoryMiB
) => any;
export declare const AcceleratorTotalMemoryMiBRequestFilterSensitiveLog: (
  obj: AcceleratorTotalMemoryMiBRequest
) => any;
export declare const TagFilterSensitiveLog: (obj: Tag) => any;
export declare const TagSpecificationFilterSensitiveLog: (
  obj: TagSpecification
) => any;
export declare const AcceptAddressTransferRequestFilterSensitiveLog: (
  obj: AcceptAddressTransferRequest
) => any;
export declare const AddressTransferFilterSensitiveLog: (
  obj: AddressTransfer
) => any;
export declare const AcceptAddressTransferResultFilterSensitiveLog: (
  obj: AcceptAddressTransferResult
) => any;
export declare const TargetConfigurationRequestFilterSensitiveLog: (
  obj: TargetConfigurationRequest
) => any;
export declare const AcceptReservedInstancesExchangeQuoteRequestFilterSensitiveLog: (
  obj: AcceptReservedInstancesExchangeQuoteRequest
) => any;
export declare const AcceptReservedInstancesExchangeQuoteResultFilterSensitiveLog: (
  obj: AcceptReservedInstancesExchangeQuoteResult
) => any;
export declare const AcceptTransitGatewayMulticastDomainAssociationsRequestFilterSensitiveLog: (
  obj: AcceptTransitGatewayMulticastDomainAssociationsRequest
) => any;
export declare const SubnetAssociationFilterSensitiveLog: (
  obj: SubnetAssociation
) => any;
export declare const TransitGatewayMulticastDomainAssociationsFilterSensitiveLog: (
  obj: TransitGatewayMulticastDomainAssociations
) => any;
export declare const AcceptTransitGatewayMulticastDomainAssociationsResultFilterSensitiveLog: (
  obj: AcceptTransitGatewayMulticastDomainAssociationsResult
) => any;
export declare const AcceptTransitGatewayPeeringAttachmentRequestFilterSensitiveLog: (
  obj: AcceptTransitGatewayPeeringAttachmentRequest
) => any;
export declare const PeeringTgwInfoFilterSensitiveLog: (
  obj: PeeringTgwInfo
) => any;
export declare const TransitGatewayPeeringAttachmentOptionsFilterSensitiveLog: (
  obj: TransitGatewayPeeringAttachmentOptions
) => any;
export declare const PeeringAttachmentStatusFilterSensitiveLog: (
  obj: PeeringAttachmentStatus
) => any;
export declare const TransitGatewayPeeringAttachmentFilterSensitiveLog: (
  obj: TransitGatewayPeeringAttachment
) => any;
export declare const AcceptTransitGatewayPeeringAttachmentResultFilterSensitiveLog: (
  obj: AcceptTransitGatewayPeeringAttachmentResult
) => any;
export declare const AcceptTransitGatewayVpcAttachmentRequestFilterSensitiveLog: (
  obj: AcceptTransitGatewayVpcAttachmentRequest
) => any;
export declare const TransitGatewayVpcAttachmentOptionsFilterSensitiveLog: (
  obj: TransitGatewayVpcAttachmentOptions
) => any;
export declare const TransitGatewayVpcAttachmentFilterSensitiveLog: (
  obj: TransitGatewayVpcAttachment
) => any;
export declare const AcceptTransitGatewayVpcAttachmentResultFilterSensitiveLog: (
  obj: AcceptTransitGatewayVpcAttachmentResult
) => any;
export declare const AcceptVpcEndpointConnectionsRequestFilterSensitiveLog: (
  obj: AcceptVpcEndpointConnectionsRequest
) => any;
export declare const UnsuccessfulItemErrorFilterSensitiveLog: (
  obj: UnsuccessfulItemError
) => any;
export declare const UnsuccessfulItemFilterSensitiveLog: (
  obj: UnsuccessfulItem
) => any;
export declare const AcceptVpcEndpointConnectionsResultFilterSensitiveLog: (
  obj: AcceptVpcEndpointConnectionsResult
) => any;
export declare const AcceptVpcPeeringConnectionRequestFilterSensitiveLog: (
  obj: AcceptVpcPeeringConnectionRequest
) => any;
export declare const CidrBlockFilterSensitiveLog: (obj: CidrBlock) => any;
export declare const Ipv6CidrBlockFilterSensitiveLog: (
  obj: Ipv6CidrBlock
) => any;
export declare const VpcPeeringConnectionOptionsDescriptionFilterSensitiveLog: (
  obj: VpcPeeringConnectionOptionsDescription
) => any;
export declare const VpcPeeringConnectionVpcInfoFilterSensitiveLog: (
  obj: VpcPeeringConnectionVpcInfo
) => any;
export declare const VpcPeeringConnectionStateReasonFilterSensitiveLog: (
  obj: VpcPeeringConnectionStateReason
) => any;
export declare const VpcPeeringConnectionFilterSensitiveLog: (
  obj: VpcPeeringConnection
) => any;
export declare const AcceptVpcPeeringConnectionResultFilterSensitiveLog: (
  obj: AcceptVpcPeeringConnectionResult
) => any;
export declare const PortRangeFilterSensitiveLog: (obj: PortRange) => any;
export declare const AnalysisAclRuleFilterSensitiveLog: (
  obj: AnalysisAclRule
) => any;
export declare const AnalysisComponentFilterSensitiveLog: (
  obj: AnalysisComponent
) => any;
export declare const AdditionalDetailFilterSensitiveLog: (
  obj: AdditionalDetail
) => any;
export declare const AnalysisLoadBalancerListenerFilterSensitiveLog: (
  obj: AnalysisLoadBalancerListener
) => any;
export declare const AnalysisLoadBalancerTargetFilterSensitiveLog: (
  obj: AnalysisLoadBalancerTarget
) => any;
export declare const AnalysisRouteTableRouteFilterSensitiveLog: (
  obj: AnalysisRouteTableRoute
) => any;
export declare const AnalysisSecurityGroupRuleFilterSensitiveLog: (
  obj: AnalysisSecurityGroupRule
) => any;
export declare const TransitGatewayRouteTableRouteFilterSensitiveLog: (
  obj: TransitGatewayRouteTableRoute
) => any;
export declare const ExplanationFilterSensitiveLog: (obj: Explanation) => any;
export declare const AnalysisPacketHeaderFilterSensitiveLog: (
  obj: AnalysisPacketHeader
) => any;
export declare const PathComponentFilterSensitiveLog: (
  obj: PathComponent
) => any;
export declare const AccessScopeAnalysisFindingFilterSensitiveLog: (
  obj: AccessScopeAnalysisFinding
) => any;
export declare const PacketHeaderStatementFilterSensitiveLog: (
  obj: PacketHeaderStatement
) => any;
export declare const ResourceStatementFilterSensitiveLog: (
  obj: ResourceStatement
) => any;
export declare const PathStatementFilterSensitiveLog: (
  obj: PathStatement
) => any;
export declare const ThroughResourcesStatementFilterSensitiveLog: (
  obj: ThroughResourcesStatement
) => any;
export declare const AccessScopePathFilterSensitiveLog: (
  obj: AccessScopePath
) => any;
export declare const PacketHeaderStatementRequestFilterSensitiveLog: (
  obj: PacketHeaderStatementRequest
) => any;
export declare const ResourceStatementRequestFilterSensitiveLog: (
  obj: ResourceStatementRequest
) => any;
export declare const PathStatementRequestFilterSensitiveLog: (
  obj: PathStatementRequest
) => any;
export declare const ThroughResourcesStatementRequestFilterSensitiveLog: (
  obj: ThroughResourcesStatementRequest
) => any;
export declare const AccessScopePathRequestFilterSensitiveLog: (
  obj: AccessScopePathRequest
) => any;
export declare const AccountAttributeValueFilterSensitiveLog: (
  obj: AccountAttributeValue
) => any;
export declare const AccountAttributeFilterSensitiveLog: (
  obj: AccountAttribute
) => any;
export declare const ActiveInstanceFilterSensitiveLog: (
  obj: ActiveInstance
) => any;
export declare const AddedPrincipalFilterSensitiveLog: (
  obj: AddedPrincipal
) => any;
export declare const AddIpamOperatingRegionFilterSensitiveLog: (
  obj: AddIpamOperatingRegion
) => any;
export declare const AddPrefixListEntryFilterSensitiveLog: (
  obj: AddPrefixListEntry
) => any;
export declare const AddressFilterSensitiveLog: (obj: Address) => any;
export declare const PtrUpdateStatusFilterSensitiveLog: (
  obj: PtrUpdateStatus
) => any;
export declare const AddressAttributeFilterSensitiveLog: (
  obj: AddressAttribute
) => any;
export declare const AdvertiseByoipCidrRequestFilterSensitiveLog: (
  obj: AdvertiseByoipCidrRequest
) => any;
export declare const ByoipCidrFilterSensitiveLog: (obj: ByoipCidr) => any;
export declare const AdvertiseByoipCidrResultFilterSensitiveLog: (
  obj: AdvertiseByoipCidrResult
) => any;
export declare const AllocateAddressRequestFilterSensitiveLog: (
  obj: AllocateAddressRequest
) => any;
export declare const AllocateAddressResultFilterSensitiveLog: (
  obj: AllocateAddressResult
) => any;
export declare const AllocateHostsRequestFilterSensitiveLog: (
  obj: AllocateHostsRequest
) => any;
export declare const AllocateHostsResultFilterSensitiveLog: (
  obj: AllocateHostsResult
) => any;
export declare const AllocateIpamPoolCidrRequestFilterSensitiveLog: (
  obj: AllocateIpamPoolCidrRequest
) => any;
export declare const IpamPoolAllocationFilterSensitiveLog: (
  obj: IpamPoolAllocation
) => any;
export declare const AllocateIpamPoolCidrResultFilterSensitiveLog: (
  obj: AllocateIpamPoolCidrResult
) => any;
export declare const AllowedPrincipalFilterSensitiveLog: (
  obj: AllowedPrincipal
) => any;
export declare const AlternatePathHintFilterSensitiveLog: (
  obj: AlternatePathHint
) => any;
export declare const ApplySecurityGroupsToClientVpnTargetNetworkRequestFilterSensitiveLog: (
  obj: ApplySecurityGroupsToClientVpnTargetNetworkRequest
) => any;
export declare const ApplySecurityGroupsToClientVpnTargetNetworkResultFilterSensitiveLog: (
  obj: ApplySecurityGroupsToClientVpnTargetNetworkResult
) => any;
export declare const AssignIpv6AddressesRequestFilterSensitiveLog: (
  obj: AssignIpv6AddressesRequest
) => any;
export declare const AssignIpv6AddressesResultFilterSensitiveLog: (
  obj: AssignIpv6AddressesResult
) => any;
export declare const AssignPrivateIpAddressesRequestFilterSensitiveLog: (
  obj: AssignPrivateIpAddressesRequest
) => any;
export declare const Ipv4PrefixSpecificationFilterSensitiveLog: (
  obj: Ipv4PrefixSpecification
) => any;
export declare const AssignedPrivateIpAddressFilterSensitiveLog: (
  obj: AssignedPrivateIpAddress
) => any;
export declare const AssignPrivateIpAddressesResultFilterSensitiveLog: (
  obj: AssignPrivateIpAddressesResult
) => any;
export declare const AssociateAddressRequestFilterSensitiveLog: (
  obj: AssociateAddressRequest
) => any;
export declare const AssociateAddressResultFilterSensitiveLog: (
  obj: AssociateAddressResult
) => any;
export declare const AssociateClientVpnTargetNetworkRequestFilterSensitiveLog: (
  obj: AssociateClientVpnTargetNetworkRequest
) => any;
export declare const AssociationStatusFilterSensitiveLog: (
  obj: AssociationStatus
) => any;
export declare const AssociateClientVpnTargetNetworkResultFilterSensitiveLog: (
  obj: AssociateClientVpnTargetNetworkResult
) => any;
export declare const AssociateDhcpOptionsRequestFilterSensitiveLog: (
  obj: AssociateDhcpOptionsRequest
) => any;
export declare const AssociateEnclaveCertificateIamRoleRequestFilterSensitiveLog: (
  obj: AssociateEnclaveCertificateIamRoleRequest
) => any;
export declare const AssociateEnclaveCertificateIamRoleResultFilterSensitiveLog: (
  obj: AssociateEnclaveCertificateIamRoleResult
) => any;
export declare const IamInstanceProfileSpecificationFilterSensitiveLog: (
  obj: IamInstanceProfileSpecification
) => any;
export declare const AssociateIamInstanceProfileRequestFilterSensitiveLog: (
  obj: AssociateIamInstanceProfileRequest
) => any;
export declare const IamInstanceProfileFilterSensitiveLog: (
  obj: IamInstanceProfile
) => any;
export declare const IamInstanceProfileAssociationFilterSensitiveLog: (
  obj: IamInstanceProfileAssociation
) => any;
export declare const AssociateIamInstanceProfileResultFilterSensitiveLog: (
  obj: AssociateIamInstanceProfileResult
) => any;
export declare const InstanceEventWindowAssociationRequestFilterSensitiveLog: (
  obj: InstanceEventWindowAssociationRequest
) => any;
export declare const AssociateInstanceEventWindowRequestFilterSensitiveLog: (
  obj: AssociateInstanceEventWindowRequest
) => any;
export declare const InstanceEventWindowAssociationTargetFilterSensitiveLog: (
  obj: InstanceEventWindowAssociationTarget
) => any;
export declare const InstanceEventWindowTimeRangeFilterSensitiveLog: (
  obj: InstanceEventWindowTimeRange
) => any;
export declare const InstanceEventWindowFilterSensitiveLog: (
  obj: InstanceEventWindow
) => any;
export declare const AssociateInstanceEventWindowResultFilterSensitiveLog: (
  obj: AssociateInstanceEventWindowResult
) => any;
export declare const AssociateRouteTableRequestFilterSensitiveLog: (
  obj: AssociateRouteTableRequest
) => any;
export declare const RouteTableAssociationStateFilterSensitiveLog: (
  obj: RouteTableAssociationState
) => any;
export declare const AssociateRouteTableResultFilterSensitiveLog: (
  obj: AssociateRouteTableResult
) => any;
export declare const AssociateSubnetCidrBlockRequestFilterSensitiveLog: (
  obj: AssociateSubnetCidrBlockRequest
) => any;
export declare const SubnetCidrBlockStateFilterSensitiveLog: (
  obj: SubnetCidrBlockState
) => any;
export declare const SubnetIpv6CidrBlockAssociationFilterSensitiveLog: (
  obj: SubnetIpv6CidrBlockAssociation
) => any;
export declare const AssociateSubnetCidrBlockResultFilterSensitiveLog: (
  obj: AssociateSubnetCidrBlockResult
) => any;
export declare const AssociateTransitGatewayMulticastDomainRequestFilterSensitiveLog: (
  obj: AssociateTransitGatewayMulticastDomainRequest
) => any;
export declare const AssociateTransitGatewayMulticastDomainResultFilterSensitiveLog: (
  obj: AssociateTransitGatewayMulticastDomainResult
) => any;
export declare const AssociateTransitGatewayPolicyTableRequestFilterSensitiveLog: (
  obj: AssociateTransitGatewayPolicyTableRequest
) => any;
export declare const TransitGatewayPolicyTableAssociationFilterSensitiveLog: (
  obj: TransitGatewayPolicyTableAssociation
) => any;
export declare const AssociateTransitGatewayPolicyTableResultFilterSensitiveLog: (
  obj: AssociateTransitGatewayPolicyTableResult
) => any;
export declare const AssociateTransitGatewayRouteTableRequestFilterSensitiveLog: (
  obj: AssociateTransitGatewayRouteTableRequest
) => any;
export declare const TransitGatewayAssociationFilterSensitiveLog: (
  obj: TransitGatewayAssociation
) => any;
export declare const AssociateTransitGatewayRouteTableResultFilterSensitiveLog: (
  obj: AssociateTransitGatewayRouteTableResult
) => any;
export declare const AssociateTrunkInterfaceRequestFilterSensitiveLog: (
  obj: AssociateTrunkInterfaceRequest
) => any;
export declare const TrunkInterfaceAssociationFilterSensitiveLog: (
  obj: TrunkInterfaceAssociation
) => any;
export declare const AssociateTrunkInterfaceResultFilterSensitiveLog: (
  obj: AssociateTrunkInterfaceResult
) => any;
export declare const AssociateVpcCidrBlockRequestFilterSensitiveLog: (
  obj: AssociateVpcCidrBlockRequest
) => any;
export declare const VpcCidrBlockStateFilterSensitiveLog: (
  obj: VpcCidrBlockState
) => any;
export declare const VpcCidrBlockAssociationFilterSensitiveLog: (
  obj: VpcCidrBlockAssociation
) => any;
export declare const VpcIpv6CidrBlockAssociationFilterSensitiveLog: (
  obj: VpcIpv6CidrBlockAssociation
) => any;
export declare const AssociateVpcCidrBlockResultFilterSensitiveLog: (
  obj: AssociateVpcCidrBlockResult
) => any;
export declare const AttachClassicLinkVpcRequestFilterSensitiveLog: (
  obj: AttachClassicLinkVpcRequest
) => any;
export declare const AttachClassicLinkVpcResultFilterSensitiveLog: (
  obj: AttachClassicLinkVpcResult
) => any;
export declare const AttachInternetGatewayRequestFilterSensitiveLog: (
  obj: AttachInternetGatewayRequest
) => any;
export declare const EnaSrdUdpSpecificationFilterSensitiveLog: (
  obj: EnaSrdUdpSpecification
) => any;
export declare const EnaSrdSpecificationFilterSensitiveLog: (
  obj: EnaSrdSpecification
) => any;
export declare const AttachNetworkInterfaceRequestFilterSensitiveLog: (
  obj: AttachNetworkInterfaceRequest
) => any;
export declare const AttachNetworkInterfaceResultFilterSensitiveLog: (
  obj: AttachNetworkInterfaceResult
) => any;
export declare const AttachVerifiedAccessTrustProviderRequestFilterSensitiveLog: (
  obj: AttachVerifiedAccessTrustProviderRequest
) => any;
export declare const VerifiedAccessTrustProviderCondensedFilterSensitiveLog: (
  obj: VerifiedAccessTrustProviderCondensed
) => any;
export declare const VerifiedAccessInstanceFilterSensitiveLog: (
  obj: VerifiedAccessInstance
) => any;
export declare const DeviceOptionsFilterSensitiveLog: (
  obj: DeviceOptions
) => any;
export declare const OidcOptionsFilterSensitiveLog: (obj: OidcOptions) => any;
export declare const VerifiedAccessTrustProviderFilterSensitiveLog: (
  obj: VerifiedAccessTrustProvider
) => any;
export declare const AttachVerifiedAccessTrustProviderResultFilterSensitiveLog: (
  obj: AttachVerifiedAccessTrustProviderResult
) => any;
export declare const AttachVolumeRequestFilterSensitiveLog: (
  obj: AttachVolumeRequest
) => any;
export declare const VolumeAttachmentFilterSensitiveLog: (
  obj: VolumeAttachment
) => any;
export declare const AttachVpnGatewayRequestFilterSensitiveLog: (
  obj: AttachVpnGatewayRequest
) => any;
export declare const VpcAttachmentFilterSensitiveLog: (
  obj: VpcAttachment
) => any;
export declare const AttachVpnGatewayResultFilterSensitiveLog: (
  obj: AttachVpnGatewayResult
) => any;
export declare const AuthorizeClientVpnIngressRequestFilterSensitiveLog: (
  obj: AuthorizeClientVpnIngressRequest
) => any;
export declare const ClientVpnAuthorizationRuleStatusFilterSensitiveLog: (
  obj: ClientVpnAuthorizationRuleStatus
) => any;
export declare const AuthorizeClientVpnIngressResultFilterSensitiveLog: (
  obj: AuthorizeClientVpnIngressResult
) => any;
export declare const IpRangeFilterSensitiveLog: (obj: IpRange) => any;
export declare const Ipv6RangeFilterSensitiveLog: (obj: Ipv6Range) => any;
export declare const PrefixListIdFilterSensitiveLog: (obj: PrefixListId) => any;
export declare const UserIdGroupPairFilterSensitiveLog: (
  obj: UserIdGroupPair
) => any;
export declare const IpPermissionFilterSensitiveLog: (obj: IpPermission) => any;
export declare const AuthorizeSecurityGroupEgressRequestFilterSensitiveLog: (
  obj: AuthorizeSecurityGroupEgressRequest
) => any;
export declare const ReferencedSecurityGroupFilterSensitiveLog: (
  obj: ReferencedSecurityGroup
) => any;
export declare const SecurityGroupRuleFilterSensitiveLog: (
  obj: SecurityGroupRule
) => any;
export declare const AuthorizeSecurityGroupEgressResultFilterSensitiveLog: (
  obj: AuthorizeSecurityGroupEgressResult
) => any;
export declare const AuthorizeSecurityGroupIngressRequestFilterSensitiveLog: (
  obj: AuthorizeSecurityGroupIngressRequest
) => any;
export declare const AuthorizeSecurityGroupIngressResultFilterSensitiveLog: (
  obj: AuthorizeSecurityGroupIngressResult
) => any;
export declare const S3StorageFilterSensitiveLog: (obj: S3Storage) => any;
export declare const StorageFilterSensitiveLog: (obj: Storage) => any;
export declare const BundleInstanceRequestFilterSensitiveLog: (
  obj: BundleInstanceRequest
) => any;
export declare const BundleTaskErrorFilterSensitiveLog: (
  obj: BundleTaskError
) => any;
export declare const BundleTaskFilterSensitiveLog: (obj: BundleTask) => any;
export declare const BundleInstanceResultFilterSensitiveLog: (
  obj: BundleInstanceResult
) => any;
export declare const CancelBundleTaskRequestFilterSensitiveLog: (
  obj: CancelBundleTaskRequest
) => any;
export declare const CancelBundleTaskResultFilterSensitiveLog: (
  obj: CancelBundleTaskResult
) => any;
export declare const CancelCapacityReservationRequestFilterSensitiveLog: (
  obj: CancelCapacityReservationRequest
) => any;
export declare const CancelCapacityReservationResultFilterSensitiveLog: (
  obj: CancelCapacityReservationResult
) => any;
export declare const CancelCapacityReservationFleetsRequestFilterSensitiveLog: (
  obj: CancelCapacityReservationFleetsRequest
) => any;
export declare const CancelCapacityReservationFleetErrorFilterSensitiveLog: (
  obj: CancelCapacityReservationFleetError
) => any;
export declare const FailedCapacityReservationFleetCancellationResultFilterSensitiveLog: (
  obj: FailedCapacityReservationFleetCancellationResult
) => any;
export declare const CapacityReservationFleetCancellationStateFilterSensitiveLog: (
  obj: CapacityReservationFleetCancellationState
) => any;
export declare const CancelCapacityReservationFleetsResultFilterSensitiveLog: (
  obj: CancelCapacityReservationFleetsResult
) => any;
export declare const CancelConversionRequestFilterSensitiveLog: (
  obj: CancelConversionRequest
) => any;
export declare const CancelExportTaskRequestFilterSensitiveLog: (
  obj: CancelExportTaskRequest
) => any;
export declare const CancelImageLaunchPermissionRequestFilterSensitiveLog: (
  obj: CancelImageLaunchPermissionRequest
) => any;
export declare const CancelImageLaunchPermissionResultFilterSensitiveLog: (
  obj: CancelImageLaunchPermissionResult
) => any;
export declare const CancelImportTaskRequestFilterSensitiveLog: (
  obj: CancelImportTaskRequest
) => any;
export declare const CancelImportTaskResultFilterSensitiveLog: (
  obj: CancelImportTaskResult
) => any;
export declare const CancelReservedInstancesListingRequestFilterSensitiveLog: (
  obj: CancelReservedInstancesListingRequest
) => any;
export declare const InstanceCountFilterSensitiveLog: (
  obj: InstanceCount
) => any;
export declare const PriceScheduleFilterSensitiveLog: (
  obj: PriceSchedule
) => any;
export declare const ReservedInstancesListingFilterSensitiveLog: (
  obj: ReservedInstancesListing
) => any;
export declare const CancelReservedInstancesListingResultFilterSensitiveLog: (
  obj: CancelReservedInstancesListingResult
) => any;
export declare const CancelSpotFleetRequestsRequestFilterSensitiveLog: (
  obj: CancelSpotFleetRequestsRequest
) => any;
export declare const CancelSpotFleetRequestsSuccessItemFilterSensitiveLog: (
  obj: CancelSpotFleetRequestsSuccessItem
) => any;
export declare const CancelSpotFleetRequestsErrorFilterSensitiveLog: (
  obj: CancelSpotFleetRequestsError
) => any;
export declare const CancelSpotFleetRequestsErrorItemFilterSensitiveLog: (
  obj: CancelSpotFleetRequestsErrorItem
) => any;
export declare const CancelSpotFleetRequestsResponseFilterSensitiveLog: (
  obj: CancelSpotFleetRequestsResponse
) => any;
export declare const CancelSpotInstanceRequestsRequestFilterSensitiveLog: (
  obj: CancelSpotInstanceRequestsRequest
) => any;
export declare const CancelledSpotInstanceRequestFilterSensitiveLog: (
  obj: CancelledSpotInstanceRequest
) => any;
export declare const CancelSpotInstanceRequestsResultFilterSensitiveLog: (
  obj: CancelSpotInstanceRequestsResult
) => any;
export declare const ConfirmProductInstanceRequestFilterSensitiveLog: (
  obj: ConfirmProductInstanceRequest
) => any;
export declare const ConfirmProductInstanceResultFilterSensitiveLog: (
  obj: ConfirmProductInstanceResult
) => any;
export declare const CopyFpgaImageRequestFilterSensitiveLog: (
  obj: CopyFpgaImageRequest
) => any;
export declare const CopyFpgaImageResultFilterSensitiveLog: (
  obj: CopyFpgaImageResult
) => any;
export declare const CopyImageRequestFilterSensitiveLog: (
  obj: CopyImageRequest
) => any;
export declare const CopyImageResultFilterSensitiveLog: (
  obj: CopyImageResult
) => any;
export declare const CopySnapshotRequestFilterSensitiveLog: (
  obj: CopySnapshotRequest
) => any;
export declare const CopySnapshotResultFilterSensitiveLog: (
  obj: CopySnapshotResult
) => any;
export declare const CreateCapacityReservationRequestFilterSensitiveLog: (
  obj: CreateCapacityReservationRequest
) => any;
export declare const CapacityAllocationFilterSensitiveLog: (
  obj: CapacityAllocation
) => any;
export declare const CapacityReservationFilterSensitiveLog: (
  obj: CapacityReservation
) => any;
export declare const CreateCapacityReservationResultFilterSensitiveLog: (
  obj: CreateCapacityReservationResult
) => any;
export declare const ReservationFleetInstanceSpecificationFilterSensitiveLog: (
  obj: ReservationFleetInstanceSpecification
) => any;
export declare const CreateCapacityReservationFleetRequestFilterSensitiveLog: (
  obj: CreateCapacityReservationFleetRequest
) => any;
export declare const FleetCapacityReservationFilterSensitiveLog: (
  obj: FleetCapacityReservation
) => any;
export declare const CreateCapacityReservationFleetResultFilterSensitiveLog: (
  obj: CreateCapacityReservationFleetResult
) => any;
export declare const CreateCarrierGatewayRequestFilterSensitiveLog: (
  obj: CreateCarrierGatewayRequest
) => any;
export declare const CarrierGatewayFilterSensitiveLog: (
  obj: CarrierGateway
) => any;
export declare const CreateCarrierGatewayResultFilterSensitiveLog: (
  obj: CreateCarrierGatewayResult
) => any;
export declare const DirectoryServiceAuthenticationRequestFilterSensitiveLog: (
  obj: DirectoryServiceAuthenticationRequest
) => any;
export declare const FederatedAuthenticationRequestFilterSensitiveLog: (
  obj: FederatedAuthenticationRequest
) => any;
export declare const CertificateAuthenticationRequestFilterSensitiveLog: (
  obj: CertificateAuthenticationRequest
) => any;
export declare const ClientVpnAuthenticationRequestFilterSensitiveLog: (
  obj: ClientVpnAuthenticationRequest
) => any;
export declare const ClientConnectOptionsFilterSensitiveLog: (
  obj: ClientConnectOptions
) => any;
export declare const ClientLoginBannerOptionsFilterSensitiveLog: (
  obj: ClientLoginBannerOptions
) => any;
export declare const ConnectionLogOptionsFilterSensitiveLog: (
  obj: ConnectionLogOptions
) => any;
export declare const CreateClientVpnEndpointRequestFilterSensitiveLog: (
  obj: CreateClientVpnEndpointRequest
) => any;
export declare const ClientVpnEndpointStatusFilterSensitiveLog: (
  obj: ClientVpnEndpointStatus
) => any;
export declare const CreateClientVpnEndpointResultFilterSensitiveLog: (
  obj: CreateClientVpnEndpointResult
) => any;
export declare const CreateClientVpnRouteRequestFilterSensitiveLog: (
  obj: CreateClientVpnRouteRequest
) => any;
export declare const ClientVpnRouteStatusFilterSensitiveLog: (
  obj: ClientVpnRouteStatus
) => any;
export declare const CreateClientVpnRouteResultFilterSensitiveLog: (
  obj: CreateClientVpnRouteResult
) => any;
export declare const CreateCoipCidrRequestFilterSensitiveLog: (
  obj: CreateCoipCidrRequest
) => any;
export declare const CoipCidrFilterSensitiveLog: (obj: CoipCidr) => any;
