import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  PurchaseHostReservationRequest,
  PurchaseHostReservationResult,
} from "../models/models_6";
export interface PurchaseHostReservationCommandInput
  extends PurchaseHostReservationRequest {}
export interface PurchaseHostReservationCommandOutput
  extends PurchaseHostReservationResult,
    __MetadataBearer {}
export declare class PurchaseHostReservationCommand extends $Command<
  PurchaseHostReservationCommandInput,
  PurchaseHostReservationCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: PurchaseHostReservationCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: PurchaseHostReservationCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    PurchaseHostReservationCommandInput,
    PurchaseHostReservationCommandOutput
  >;
  private serialize;
  private deserialize;
}
