import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  ModifyVpcPeeringConnectionOptionsRequest,
  ModifyVpcPeeringConnectionOptionsResult,
} from "../models/models_6";
export interface ModifyVpcPeeringConnectionOptionsCommandInput
  extends ModifyVpcPeeringConnectionOptionsRequest {}
export interface ModifyVpcPeeringConnectionOptionsCommandOutput
  extends ModifyVpcPeeringConnectionOptionsResult,
    __MetadataBearer {}
export declare class ModifyVpcPeeringConnectionOptionsCommand extends $Command<
  ModifyVpcPeeringConnectionOptionsCommandInput,
  ModifyVpcPeeringConnectionOptionsCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: ModifyVpcPeeringConnectionOptionsCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: ModifyVpcPeeringConnectionOptionsCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    ModifyVpcPeeringConnectionOptionsCommandInput,
    ModifyVpcPeeringConnectionOptionsCommandOutput
  >;
  private serialize;
  private deserialize;
}
