import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  GetInstanceUefiDataRequest,
  GetInstanceUefiDataResult,
} from "../models/models_5";
export interface GetInstanceUefiDataCommandInput
  extends GetInstanceUefiDataRequest {}
export interface GetInstanceUefiDataCommandOutput
  extends GetInstanceUefiDataResult,
    __MetadataBearer {}
export declare class GetInstanceUefiDataCommand extends $Command<
  GetInstanceUefiDataCommandInput,
  GetInstanceUefiDataCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: GetInstanceUefiDataCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: GetInstanceUefiDataCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<GetInstanceUefiDataCommandInput, GetInstanceUefiDataCommandOutput>;
  private serialize;
  private deserialize;
}
