import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  DisableImageDeprecationRequest,
  DisableImageDeprecationResult,
} from "../models/models_5";
export interface DisableImageDeprecationCommandInput
  extends DisableImageDeprecationRequest {}
export interface DisableImageDeprecationCommandOutput
  extends DisableImageDeprecationResult,
    __MetadataBearer {}
export declare class DisableImageDeprecationCommand extends $Command<
  DisableImageDeprecationCommandInput,
  DisableImageDeprecationCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: DisableImageDeprecationCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: DisableImageDeprecationCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    DisableImageDeprecationCommandInput,
    DisableImageDeprecationCommandOutput
  >;
  private serialize;
  private deserialize;
}
