import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  DescribeReservedInstancesOfferingsRequest,
  DescribeReservedInstancesOfferingsResult,
} from "../models/models_4";
export interface DescribeReservedInstancesOfferingsCommandInput
  extends DescribeReservedInstancesOfferingsRequest {}
export interface DescribeReservedInstancesOfferingsCommandOutput
  extends DescribeReservedInstancesOfferingsResult,
    __MetadataBearer {}
export declare class DescribeReservedInstancesOfferingsCommand extends $Command<
  DescribeReservedInstancesOfferingsCommandInput,
  DescribeReservedInstancesOfferingsCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: DescribeReservedInstancesOfferingsCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: DescribeReservedInstancesOfferingsCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    DescribeReservedInstancesOfferingsCommandInput,
    DescribeReservedInstancesOfferingsCommandOutput
  >;
  private serialize;
  private deserialize;
}
