import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  DescribeAddressTransfersRequest,
  DescribeAddressTransfersResult,
} from "../models/models_3";
export interface DescribeAddressTransfersCommandInput
  extends DescribeAddressTransfersRequest {}
export interface DescribeAddressTransfersCommandOutput
  extends DescribeAddressTransfersResult,
    __MetadataBearer {}
export declare class DescribeAddressTransfersCommand extends $Command<
  DescribeAddressTransfersCommandInput,
  DescribeAddressTransfersCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: DescribeAddressTransfersCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: DescribeAddressTransfersCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    DescribeAddressTransfersCommandInput,
    DescribeAddressTransfersCommandOutput
  >;
  private serialize;
  private deserialize;
}
