import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  DeleteVpcPeeringConnectionRequest,
  DeleteVpcPeeringConnectionResult,
} from "../models/models_3";
export interface DeleteVpcPeeringConnectionCommandInput
  extends DeleteVpcPeeringConnectionRequest {}
export interface DeleteVpcPeeringConnectionCommandOutput
  extends DeleteVpcPeeringConnectionResult,
    __MetadataBearer {}
export declare class DeleteVpcPeeringConnectionCommand extends $Command<
  DeleteVpcPeeringConnectionCommandInput,
  DeleteVpcPeeringConnectionCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: DeleteVpcPeeringConnectionCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: DeleteVpcPeeringConnectionCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    DeleteVpcPeeringConnectionCommandInput,
    DeleteVpcPeeringConnectionCommandOutput
  >;
  private serialize;
  private deserialize;
}
