import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  DeleteSubnetCidrReservationRequest,
  DeleteSubnetCidrReservationResult,
} from "../models/models_2";
export interface DeleteSubnetCidrReservationCommandInput
  extends DeleteSubnetCidrReservationRequest {}
export interface DeleteSubnetCidrReservationCommandOutput
  extends DeleteSubnetCidrReservationResult,
    __MetadataBearer {}
export declare class DeleteSubnetCidrReservationCommand extends $Command<
  DeleteSubnetCidrReservationCommandInput,
  DeleteSubnetCidrReservationCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: DeleteSubnetCidrReservationCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: DeleteSubnetCidrReservationCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    DeleteSubnetCidrReservationCommandInput,
    DeleteSubnetCidrReservationCommandOutput
  >;
  private serialize;
  private deserialize;
}
