import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  CreateVerifiedAccessEndpointRequest,
  CreateVerifiedAccessEndpointResult,
} from "../models/models_2";
export interface CreateVerifiedAccessEndpointCommandInput
  extends CreateVerifiedAccessEndpointRequest {}
export interface CreateVerifiedAccessEndpointCommandOutput
  extends CreateVerifiedAccessEndpointResult,
    __MetadataBearer {}
export declare class CreateVerifiedAccessEndpointCommand extends $Command<
  CreateVerifiedAccessEndpointCommandInput,
  CreateVerifiedAccessEndpointCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: CreateVerifiedAccessEndpointCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: CreateVerifiedAccessEndpointCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    CreateVerifiedAccessEndpointCommandInput,
    CreateVerifiedAccessEndpointCommandOutput
  >;
  private serialize;
  private deserialize;
}
