import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  CreateReservedInstancesListingRequest,
  CreateReservedInstancesListingResult,
} from "../models/models_1";
export interface CreateReservedInstancesListingCommandInput
  extends CreateReservedInstancesListingRequest {}
export interface CreateReservedInstancesListingCommandOutput
  extends CreateReservedInstancesListingResult,
    __MetadataBearer {}
export declare class CreateReservedInstancesListingCommand extends $Command<
  CreateReservedInstancesListingCommandInput,
  CreateReservedInstancesListingCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: CreateReservedInstancesListingCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: CreateReservedInstancesListingCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    CreateReservedInstancesListingCommandInput,
    CreateReservedInstancesListingCommandOutput
  >;
  private serialize;
  private deserialize;
}
